/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.SystemStatus;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class AS400PoolTest
extends GenericTest {
    private String system = null;
    private String userID = null;
    private String password = null;

    public AS400PoolTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        this.setMeasureCount(this.measureCount);
    }

    public static void main(String[] stringArray) {
        AS400PoolTest aS400PoolTest = new AS400PoolTest(stringArray);
        aS400PoolTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        block19: {
            double d = 0.0;
            ArrayList<Double> arrayList = null;
            AS400 aS400 = null;
            try {
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                if (aS400 == null) {
                    return;
                }
                SystemStatus systemStatus = new SystemStatus(aS400);
                systemStatus.setCaching(true);
                if (systemStatus.isCaching()) {
                    Enumeration enumeration = systemStatus.getSystemPools();
                    while (enumeration.hasMoreElements()) {
                        double d2;
                        double d3;
                        double d4;
                        double d5;
                        double d6;
                        SystemPool systemPool = (SystemPool)enumeration.nextElement();
                        systemPool.loadInformation();
                        String string = systemPool.getName();
                        if (string == null || string.trim().length() == 0) continue;
                        string = string.trim();
                        try {
                            d6 = systemPool.getSize() / 1024;
                        }
                        catch (Exception exception) {
                            d6 = 0.0;
                        }
                        try {
                            d5 = systemPool.getReservedSize() / 1024;
                        }
                        catch (Exception exception) {
                            d5 = 0.0;
                        }
                        try {
                            d4 = (int)systemPool.getDatabasePages();
                        }
                        catch (Exception exception) {
                            d4 = 0.0;
                        }
                        try {
                            d3 = (int)systemPool.getDatabaseFaults();
                        }
                        catch (Exception exception) {
                            d3 = 0.0;
                        }
                        try {
                            d2 = (int)systemPool.getNonDatabasePages();
                        }
                        catch (Exception exception) {
                            d2 = 0.0;
                        }
                        try {
                            d = (int)systemPool.getNonDatabaseFaults();
                        }
                        catch (Exception exception) {
                            d = 0.0;
                        }
                        arrayList = new ArrayList<Double>();
                        arrayList.add(new Double(d6));
                        arrayList.add(new Double(d5));
                        arrayList.add(new Double(-5.0));
                        if (this.measureCount > 3) {
                            arrayList.add(new Double(d4));
                            arrayList.add(new Double(d3));
                            arrayList.add(new Double(d2));
                            arrayList.add(new Double(d));
                        }
                        if (debug) {
                            System.out.println(" measures  =>" + arrayList + " for poolName =>" + string);
                        }
                        this.addNewMeasure(string, arrayList);
                    }
                }
                aS400.disconnectAllServices();
                aS400 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (aS400 == null) break block19;
                aS400.disconnectAllServices();
                aS400 = null;
            }
        }
    }
}

