/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgAgentInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMUtils;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.DataTransmitter;
import com.eg.apm.EgApmFilesSync;
import com.eg.jtm.BTMConstants;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class AgentDataContributor
extends Thread {
    private EgMainAgent parent = null;
    private static String primaryMgrIp;
    private static String primaryMgrPort;
    private static String thisMgrIp;
    private static String thisMgrPort;
    private boolean isSuccessfullSent = true;
    boolean natURLExists = false;
    String primaryNATUrl = "none";
    String sep = System.getProperty("file.separator");
    private HashMap<String, String> transmitCopyUniqueJvmGuidMap = new HashMap();
    private HashMap<String, String> transmitCopyAutoNamingMap = new HashMap();
    private HashMap<String, String> transmitCopyNodeOrderMap = new HashMap();
    private HashMap<String, String> transmitCopyAppNameMap = new HashMap();
    protected static final String loggerDispStr = "[AgentDataContributor]";
    private static final String APM_CONFIGS = "APM_CONFIGS";
    private static final String UPDATED_TIME = "UpdateTime";
    public static final long minSleep = 50L;
    public static final long longSleep = 300000L;
    public static long lastModifiedTime;
    private static long startTimeStamp;
    private static long executionTime;
    public static long lastUpdatedTime;

    public AgentDataContributor(EgMainAgent egMainAgent) {
        this.parent = egMainAgent;
        egMainAgent.getHostName();
        primaryMgrIp = EgMainAgent.mgrIp;
        primaryMgrPort = EgMainAgent.port;
        thisMgrIp = EgMainAgent.mgrIp;
        thisMgrPort = EgMainAgent.port;
    }

    private boolean isSubjectAvailable(IniFile iniFile, String string) {
        String[] stringArray = iniFile.getSubjects();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(string) <= -1) continue;
            return true;
        }
        return false;
    }

    public AgentDataContributor() {
    }

    public void run() {
        this.suspendThread(30000L);
        while (true) {
            boolean bl;
            if (!(bl = ApmConfigManager.getInstance().isAPMMonitoringEnabled())) {
                AgentStartupLogger.logger.debug("[AgentDataContributor] [AgentDiscovery] apmBtmMonitorFlag is disabled, so skipping Bulk guid download & Appflow data upload");
                this.suspendThread(300000L);
                continue;
            }
            this.clusterSupported();
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH);
            boolean bl2 = this.readAutoNamingData(iniFile);
            boolean bl3 = this.readNodeOrderData(iniFile);
            boolean bl4 = this.readIniFilesData(iniFile);
            boolean bl5 = this.agentsIniUpdated();
            if (bl5) {
                AgentStartupLogger.logger.trace("{} is eg_agents.ini Updated? {} ", (Object)loggerDispStr, (Object)bl5);
                this.getGUIDs();
            }
            if (startTimeStamp == -1L) {
                startTimeStamp = System.currentTimeMillis();
                this.getAPMConfigs(true);
            } else if (executionTime >= 60000L && this.apmConfigFileUpdated()) {
                startTimeStamp = System.currentTimeMillis();
                this.getAPMConfigs(false);
            }
            long l = System.currentTimeMillis();
            executionTime = l - startTimeStamp;
            boolean bl6 = this.readIniFilesData("NEW_APPLICATION_NAME_DETAILS", this.transmitCopyAppNameMap, " APPLICATION_NAME_DETAILS ");
            if (bl4 || bl2 || bl3 || bl6) {
                int n = this.uploadAgentIniData();
                AgentStartupLogger.logger.trace("{} Response Code : {} ,isSuccessfullSent : {} ", new Object[]{loggerDispStr, n, this.isSuccessfullSent});
                if (n == 200 && this.isSuccessfullSent) {
                    if (bl4) {
                        this.moveTransferedDetails();
                        this.transmitCopyUniqueJvmGuidMap.clear();
                    }
                    if (bl2) {
                        this.moveTransferedDetailsAppflow();
                        this.transmitCopyAutoNamingMap.clear();
                    }
                    if (bl3) {
                        this.moveTransferedDetailsNodeOrder();
                        this.transmitCopyNodeOrderMap.clear();
                    }
                    if (bl6) {
                        this.moveTransferedDetails("NEW_APPLICATION_NAME_DETAILS", "SEND_APPLICATION_NAME_DETAILS", " AppName data");
                        this.transmitCopyAppNameMap.clear();
                    }
                }
            }
            this.suspendThread(ApmConfigManager.getInstance().getAppflowDataContributorSleepTime());
        }
    }

    private boolean readIniFilesData(String string, HashMap hashMap, String string2) {
        boolean bl = false;
        try {
            String[] stringArray;
            AgentStartupLogger.logger.trace("{} Reading section : {} , Message : {}", new Object[]{loggerDispStr, string, string2});
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH, true);
            if (this.isSubjectAvailable(iniFile, string) && (stringArray = iniFile.getVariables(string)) != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string3 = iniFile.getValue(string, stringArray[n]);
                    hashMap.put(stringArray[n], string3);
                    ++n;
                }
                if (hashMap != null && hashMap.size() > 0) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data {} from {}", new Object[]{loggerDispStr, string2, exception});
        }
        return bl;
    }

    private boolean readIniFilesData(IniFile iniFile) {
        boolean bl = false;
        try {
            String[] stringArray = iniFile.getVariables("NEW_UNIQUE_JVM_DETAILS");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string = iniFile.getValue("NEW_UNIQUE_JVM_DETAILS", stringArray[n]);
                    this.transmitCopyUniqueJvmGuidMap.put(stringArray[n], string);
                    ++n;
                }
                if (this.transmitCopyUniqueJvmGuidMap != null && this.transmitCopyUniqueJvmGuidMap.size() > 0) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data from INI file {}", (Object)loggerDispStr, (Object)exception);
        }
        return bl;
    }

    private boolean readAutoNamingData(IniFile iniFile) {
        boolean bl = false;
        try {
            String[] stringArray = iniFile.getVariables("NEW_APPFLOW_AUTO_NAME_MAPPING");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string = iniFile.getValue("NEW_APPFLOW_AUTO_NAME_MAPPING", stringArray[n]);
                    this.transmitCopyAutoNamingMap.put(stringArray[n], string);
                    ++n;
                }
                if (this.transmitCopyAutoNamingMap != null && this.transmitCopyAutoNamingMap.size() > 0) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data from INI file {}", (Object)loggerDispStr, (Object)exception);
        }
        return bl;
    }

    private boolean readNodeOrderData(IniFile iniFile) {
        boolean bl = false;
        try {
            String[] stringArray = iniFile.getVariables("NEW_APPFLOW_NODE_ORDER_MAPPING");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string = iniFile.getValue("NEW_APPFLOW_NODE_ORDER_MAPPING", stringArray[n]);
                    this.transmitCopyNodeOrderMap.put(stringArray[n], string);
                    ++n;
                }
                if (this.transmitCopyNodeOrderMap != null && this.transmitCopyNodeOrderMap.size() > 0) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data from INI file {} ", (Object)loggerDispStr, (Object)exception);
        }
        return bl;
    }

    private int uploadAgentIniData() {
        URL uRL = null;
        try {
            thisMgrIp = EgMainAgent.mgrIp;
            thisMgrPort = EgMainAgent.port;
            uRL = primaryMgrIp.equalsIgnoreCase(thisMgrIp) ? new URL(EgInstallInfo.urlPrefix + "//" + primaryMgrIp + ":" + primaryMgrPort + "/final/servlet/com.eg.apm.APMUtilityControllerServlet") : new URL(EgInstallInfo.urlPrefix + "//" + thisMgrIp + ":" + thisMgrPort + "/final/servlet/com.eg.apm.APMUtilityControllerServlet");
        }
        catch (MalformedURLException malformedURLException) {
            AgentStartupLogger.logger.error("{} Exception while creating URL {} ", (Object)loggerDispStr, (Object)malformedURLException);
        }
        ArrayList arrayList = this.getUploadData();
        int n = this.uploadAgentIniData(uRL, "CreateNodeGUIDIniEntry", arrayList);
        if (!this.isSuccessfullSent && this.natURLExists) {
            try {
                uRL = new URL(this.primaryNATUrl + "com.eg.apm.APMUtilityControllerServlet");
            }
            catch (MalformedURLException malformedURLException) {
                AgentStartupLogger.logger.error("{} Exception occured while creating NAT URL {}", (Object)loggerDispStr, (Object)malformedURLException);
            }
            n = this.uploadAgentIniData(uRL, "CreateNodeGUIDIniEntry", arrayList);
        }
        return n;
    }

    private ArrayList getUploadData() {
        HashMap<String, HashMap<String, String>> hashMap = new HashMap<String, HashMap<String, String>>();
        if (this.transmitCopyAutoNamingMap != null && this.transmitCopyAutoNamingMap.size() > 0) {
            hashMap.put("CreateAutoNamingIniEntry", this.transmitCopyAutoNamingMap);
        }
        if (this.transmitCopyUniqueJvmGuidMap != null && this.transmitCopyUniqueJvmGuidMap.size() > 0) {
            hashMap.put("CreateNodeGUIDIniEntry", this.transmitCopyUniqueJvmGuidMap);
        }
        if (this.transmitCopyNodeOrderMap != null && this.transmitCopyNodeOrderMap.size() > 0) {
            hashMap.put("CreateNodeOrderIniEntry", this.transmitCopyNodeOrderMap);
        }
        if (this.transmitCopyAppNameMap != null && this.transmitCopyAppNameMap.size() > 0) {
            hashMap.put("CreateAppNameIniEntry", this.transmitCopyAppNameMap);
        }
        ArrayList<HashMap<String, HashMap<String, String>>> arrayList = new ArrayList<HashMap<String, HashMap<String, String>>>();
        if (hashMap.size() > 0) {
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private int uploadAgentIniData(URL uRL, String string, ArrayList arrayList) {
        HttpURLConnection httpURLConnection = null;
        int n = 0;
        AgentStartupLogger.logger.info("{} Uploading data to {} :", (Object)loggerDispStr, (Object)uRL);
        try {
            Object object;
            int n2;
            if (EgMainAgent.isProxySet) {
                n2 = 0;
                try {
                    if (EgMainAgent.proxyPort != null) {
                        n2 = Integer.parseInt(EgMainAgent.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = new InetSocketAddress(EgMainAgent.proxyHost, n2);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, (SocketAddress)object);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            n2 = 0;
            httpURLConnection.setRequestProperty("Content-length", "" + n2);
            object = new ConnectionThread(httpURLConnection, true, null, false, null, arrayList, true);
            boolean bl = this.checkForTimeout((ConnectionThread)object);
            if (bl) {
                n = ((ConnectionThread)object).code;
            }
            object = null;
            httpURLConnection = null;
            this.isSuccessfullSent = true;
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} eGManager could not be contacted due to  {}", (Object)loggerDispStr, (Object)exception);
            this.isSuccessfullSent = false;
        }
        return n;
    }

    private boolean agentsIniUpdated() {
        boolean bl = false;
        EgAgentInfo egAgentInfo = new EgAgentInfo("agent");
        long l = egAgentInfo.lastModified();
        if (lastModifiedTime > -1L) {
            if (l != lastModifiedTime) {
                bl = true;
                lastModifiedTime = l;
            }
        } else {
            lastModifiedTime = l;
            bl = true;
        }
        return bl;
    }

    private void getGUIDs() {
        String string = EgMainAgent.ipStr;
        if (string.startsWith(EgInstallInfo.ipV6Identifier)) {
            string = string.substring(2);
        }
        this.getGuidDetails(false, string);
    }

    public void getGUID(boolean bl, String string) {
        if (bl) {
            this.getGuidDetails(bl, string);
        } else {
            String string2 = EgMainAgent.ipStr;
            if (string2.startsWith(EgInstallInfo.ipV6Identifier)) {
                string2 = string2.substring(2);
            }
            this.getGuidDetails(bl, string2);
        }
    }

    private int getGuidDetails(boolean bl, String string) {
        URL uRL = null;
        try {
            thisMgrIp = EgMainAgent.mgrIp;
            thisMgrPort = EgMainAgent.port;
            uRL = primaryMgrIp.equalsIgnoreCase(thisMgrIp) ? new URL(EgInstallInfo.urlPrefix + "//" + primaryMgrIp + ":" + primaryMgrPort + "/final/servlet/com.eg.apm.APMGuidInfo") : new URL(EgInstallInfo.urlPrefix + "//" + thisMgrIp + ":" + thisMgrPort + "/final/servlet/com.eg.apm.APMGuidInfo");
        }
        catch (MalformedURLException malformedURLException) {
            AgentStartupLogger.logger.error("{} Exception while creating normal URL {} ", (Object)loggerDispStr, (Object)malformedURLException);
        }
        int n = this.getGUIDsFromManager(uRL, bl, string);
        if (!this.isSuccessfullSent && this.natURLExists) {
            try {
                uRL = new URL(this.primaryNATUrl + "com.eg.apm.APMGuidInfo");
            }
            catch (MalformedURLException malformedURLException) {
                AgentStartupLogger.logger.error("{} Exception while creating NAT URL {}", (Object)loggerDispStr, (Object)malformedURLException);
            }
            n = this.getGUIDsFromManager(uRL, bl, string);
        }
        return n;
    }

    private int getGUIDsFromManager(URL uRL, boolean bl, String string) {
        HttpURLConnection httpURLConnection = null;
        int n = 0;
        AgentStartupLogger.logger.info("{} Getting GUID information from the URL  {} ", (Object)loggerDispStr, (Object)uRL);
        try {
            Object object;
            Serializable serializable;
            int n2;
            if (EgMainAgent.isProxySet) {
                n2 = 0;
                try {
                    if (EgMainAgent.proxyPort != null) {
                        n2 = Integer.parseInt(EgMainAgent.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                serializable = new InetSocketAddress(EgMainAgent.proxyHost, n2);
                object = new Proxy(Proxy.Type.HTTP, (SocketAddress)serializable);
                httpURLConnection = (HttpURLConnection)uRL.openConnection((Proxy)object);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            n2 = 0;
            httpURLConnection.setRequestProperty("Content-length", "" + n2);
            serializable = new ArrayList();
            ((ArrayList)serializable).add(bl);
            ((ArrayList)serializable).add(string);
            AgentStartupLogger.logger.debug("{} Uploading data for GUID fetching {}", (Object)loggerDispStr, (Object)serializable);
            object = new ConnectionThread(httpURLConnection, true, null, false, null, (ArrayList)serializable, true);
            ArrayList arrayList = null;
            boolean bl2 = this.checkForTimeout((ConnectionThread)object);
            if (bl2) {
                n = ((ConnectionThread)object).code;
                if (((ConnectionThread)object).done && n == 200) {
                    arrayList = ((ConnectionThread)object).data;
                }
            }
            object = null;
            AgentStartupLogger.logger.debug("{} Data from eGManager {}", (Object)loggerDispStr, arrayList);
            if (arrayList != null && arrayList.size() > 0) {
                AgentDataContributor.storeGuidData(arrayList, bl, string);
            }
            httpURLConnection = null;
            this.isSuccessfullSent = true;
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} eGManager could not be contacted due to  {}", (Object)loggerDispStr, (Object)exception);
            this.isSuccessfullSent = false;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTransferedDetails() {
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH, true);
        try {
            String[] stringArray = iniFile.getVariables("NEW_UNIQUE_JVM_DETAILS");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string;
                    String string2 = iniFile.getValue("NEW_UNIQUE_JVM_DETAILS", stringArray[n]);
                    boolean bl = AgentDataContributor.isDetailsAvailableInFile(iniFile, stringArray[n], "SEND_UNIQUE_JVM_DETAILS");
                    if (bl && !string2.equalsIgnoreCase(string = iniFile.getValue("SEND_UNIQUE_JVM_DETAILS", stringArray[n]))) {
                        string2 = string2 + "," + string;
                        string2 = this.removeDuplicates(string2);
                    }
                    if (string2.length() > 0) {
                        iniFile.setValue("SEND_UNIQUE_JVM_DETAILS", stringArray[n], string2);
                        iniFile.deleteValue("NEW_UNIQUE_JVM_DETAILS", stringArray[n]);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data from INI file {} ", (Object)loggerDispStr, (Object)exception);
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTransferedDetails(String string, String string2, String string3) {
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH, true);
        try {
            AgentStartupLogger.logger.trace("[AgentDataContributor] Doing data sub swapping from {} to {}. Message : {} ", new Object[]{string, string2, string3});
            String[] stringArray = iniFile.getVariables(string);
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string4;
                    String string5 = iniFile.getValue(string, stringArray[n]);
                    boolean bl = AgentDataContributor.isDetailsAvailableInFile(iniFile, stringArray[n], string2);
                    if (bl && !string5.equalsIgnoreCase(string4 = iniFile.getValue(string2, stringArray[n]))) {
                        string5 = string5 + "," + string4;
                        string5 = this.removeDuplicates(string5);
                    }
                    iniFile.setValue(string2, stringArray[n], string5);
                    iniFile.deleteValue(string, stringArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while transfering data from INI file {} ", new Object[]{loggerDispStr, string3, exception});
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTransferedDetailsAppflow() {
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH, true);
        try {
            String[] stringArray = iniFile.getVariables("NEW_APPFLOW_AUTO_NAME_MAPPING");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string;
                    String string2 = iniFile.getValue("NEW_APPFLOW_AUTO_NAME_MAPPING", stringArray[n]);
                    boolean bl = AgentDataContributor.isDetailsAvailableInFile(iniFile, stringArray[n], "SEND_APPFLOW_AUTO_NAME_MAPPING");
                    if (bl && !string2.equalsIgnoreCase(string = iniFile.getValue("SEND_APPFLOW_AUTO_NAME_MAPPING", stringArray[n]))) {
                        string2 = string2 + "," + string;
                        string2 = this.removeDuplicates(string2);
                    }
                    iniFile.setValue("SEND_APPFLOW_AUTO_NAME_MAPPING", stringArray[n], string2);
                    iniFile.deleteValue("NEW_APPFLOW_AUTO_NAME_MAPPING", stringArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data from INI file {} ", (Object)loggerDispStr, (Object)exception);
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTransferedDetailsNodeOrder() {
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH, true);
        try {
            String[] stringArray = iniFile.getVariables("NEW_APPFLOW_NODE_ORDER_MAPPING");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string;
                    String string2 = iniFile.getValue("NEW_APPFLOW_NODE_ORDER_MAPPING", stringArray[n]);
                    boolean bl = AgentDataContributor.isDetailsAvailableInFile(iniFile, stringArray[n], "SEND_APPFLOW_NODE_ORDER_MAPPING");
                    if (bl && !string2.equalsIgnoreCase(string = iniFile.getValue("SEND_APPFLOW_NODE_ORDER_MAPPING", stringArray[n]))) {
                        string2 = string2 + "," + string;
                        string2 = this.removeDuplicates(string2);
                    }
                    iniFile.setValue("SEND_APPFLOW_NODE_ORDER_MAPPING", stringArray[n], string2);
                    iniFile.deleteValue("NEW_APPFLOW_NODE_ORDER_MAPPING", stringArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data from INI file {}", (Object)loggerDispStr, (Object)exception);
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTransferedDetailsAppName() {
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH, true);
        try {
            String[] stringArray = iniFile.getVariables("NEW_APPLICATION_NAME_DETAILS");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string;
                    String string2 = iniFile.getValue("NEW_APPLICATION_NAME_DETAILS", stringArray[n]);
                    boolean bl = AgentDataContributor.isDetailsAvailableInFile(iniFile, stringArray[n], "SEND_APPLICATION_NAME_DETAILS");
                    if (bl && !string2.equalsIgnoreCase(string = iniFile.getValue("SEND_APPLICATION_NAME_DETAILS", stringArray[n]))) {
                        string2 = string2 + "," + string;
                        string2 = this.removeDuplicates(string2);
                    }
                    iniFile.setValue("SEND_APPLICATION_NAME_DETAILS", stringArray[n], string2);
                    iniFile.deleteValue("NEW_APPLICATION_NAME_DETAILS", stringArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while reading data from {} {}   ", new Object[]{loggerDispStr, BTMConstants.UNIQUE_JVM_FILEPATH, exception});
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
        }
    }

    private String removeDuplicates(String string) {
        try {
            String[] stringArray = string.split(",");
            List<String> list = Arrays.asList(stringArray);
            TreeSet<String> treeSet = new TreeSet<String>(list);
            String string2 = treeSet.toString();
            string2 = string2.substring(1, string2.length() - 1);
            string = string2.replace(", ", ",");
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while sorting values {} ", (Object)loggerDispStr, (Object)exception);
        }
        return string;
    }

    private void clusterSupported() {
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_TEST_FILEPATH, false);
        if (new Boolean(iniFile.getValue("MANAGER_SETTINGS", "ClusterSupported")).booleanValue()) {
            primaryMgrIp = iniFile.getValue("PRIMARY", "Ip");
            primaryMgrPort = iniFile.getValue("PRIMARY", "Port");
            iniFile.getValue("PRIMARY", "urlPrefix");
            this.primaryNATUrl = iniFile.getValue("PRIMARY", "natUrl");
            this.natURLExists = this.primaryNATUrl != null && this.primaryNATUrl.length() > 0 && !this.primaryNATUrl.equalsIgnoreCase("none");
        }
    }

    private void suspendThread(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception while suspending Thread {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private static boolean isDetailsAvailableInFile(IniFile iniFile, String string, String string2) {
        String string3 = iniFile.getValue(string2, string);
        return string3.length() > 0;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout * 10L;
        long l3 = 0L;
        long l4 = 250L;
        do {
            long l5 = System.currentTimeMillis();
            if (l4 < EgAgentCommon.minimumSleep) {
                l4 = EgAgentCommon.minimumSleep;
            } else if (l4 > EgAgentCommon.maxSleep) {
                l4 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connectionThread.done) {
                return true;
            }
            long l6 = System.currentTimeMillis();
            long l7 = l6 - l5;
            if ((l3 += l7) >= l2 || l7 < 0L) {
                connectionThread.interrupt();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connectionThread.stop();
                return false;
            }
            l = l4;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        connectionThread.interrupt();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionThread.stop();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeGuidData(ArrayList arrayList, boolean bl, String string) {
        block11: {
            try {
                Object e = arrayList.get(0);
                if (e instanceof HashMap) {
                    HashMap hashMap = (HashMap)e;
                    if (!bl) {
                        // empty if block
                    }
                    Iterator iterator = hashMap.keySet().iterator();
                    IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_GUID_FILEPATH);
                    try {
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            String string3 = (String)hashMap.get(string2);
                            if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0) continue;
                            iniFile.setValue("APM_GUID_MAPPING_WITH_NICK", string2, string3);
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        AgentStartupLogger.logger.error("{} Exception due to {} ", (Object)loggerDispStr, (Object)exception);
                        break block11;
                    }
                    finally {
                        iniFile.saveFile();
                        EgApmFilesSync.releaseInstance(iniFile);
                    }
                }
                if (e instanceof String && e.toString().equalsIgnoreCase("Data_Not_Found")) {
                    AgentStartupLogger.logger.error("{} APM Offload GUID Data_Not_Found for {}", (Object)loggerDispStr, (Object)string);
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Exception due to {} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        AgentDataContributor.readOffloadGuidDetails();
    }

    private static void readOffloadGuidDetails() {
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_GUID_FILEPATH);
        String[] stringArray = iniFile.getLinesUnderSubject("APM_GUID_MAPPING_WITH_NICK");
        if (stringArray != null && stringArray.length > 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n = string.indexOf("=");
                if (n < 0) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "^");
                if (stringTokenizer.countTokens() != 4) continue;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string4 = "[" + stringTokenizer.nextToken() + ":" + stringTokenizer.nextToken() + "]";
                hashMap2.put(string4, string3);
                hashMap.put(string3, string4);
            }
            AgentStartupLogger.logger.trace("{} guidnick {}", (Object)loggerDispStr, hashMap);
            AgentStartupLogger.logger.trace("{} nickGuid {}", (Object)loggerDispStr, hashMap2);
            APMComponentIDRepository aPMComponentIDRepository = APMComponentIDRepository.getRepository();
            aPMComponentIDRepository.setGuidNickMap(hashMap);
            aPMComponentIDRepository.setNickguidMap(hashMap2);
        }
    }

    private boolean readApmBtmMonitorFlag() {
        String string = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
        IniFile iniFile = new IniFile(string);
        String string2 = iniFile.getValue("APM", "APM_Monitoring");
        return Boolean.parseBoolean(string2);
    }

    private boolean apmConfigFileUpdated() {
        boolean bl = false;
        try {
            EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
            IniFile iniFile = new IniFile(egConfigInfo.getApmFile());
            String string = iniFile.getValue(APM_CONFIGS, UPDATED_TIME);
            if (string != null && !string.equals("")) {
                long l = Long.parseLong(string);
                if (lastUpdatedTime > -1L) {
                    if (l != lastUpdatedTime) {
                        bl = true;
                        lastUpdatedTime = l;
                    }
                } else {
                    lastUpdatedTime = l;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception Occured Getting data from: {}", (Object)loggerDispStr, (Object)exception);
        }
        return bl;
    }

    private ArrayList readGuidDetails() {
        ArrayList arrayList = new ArrayList();
        try {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_GUID_FILEPATH);
            Vector vector = iniFile.getAllValues("APM_GUID_MAPPING_WITH_NICK", true);
            if (vector != null && vector.size() > 0) {
                arrayList = new ArrayList(vector);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception Occured Getting data from: {}", (Object)loggerDispStr, (Object)exception);
        }
        return arrayList;
    }

    private void getAPMConfigs(boolean bl) {
        try {
            String string = EgMainAgent.ipStr;
            ArrayList arrayList = new ArrayList();
            if (!bl) {
                arrayList = this.readGuidDetails();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("action", "eg_apmconfig.ini");
            hashMap.put("firstTimeAgentStart", bl);
            hashMap.put("requestedKey", arrayList);
            hashMap.put("IpString", string);
            HashMap<String, HashMap<String, Object>> hashMap2 = new HashMap<String, HashMap<String, Object>>();
            hashMap2.put("JavaBTMConfigsDownloadAction", hashMap);
            DataTransmitter dataTransmitter = DataTransmitter.getInstance();
            HashMap hashMap3 = null;
            hashMap3 = dataTransmitter.transmitDataToManager("/final/servlet/com.eg.apm.APMActionServlet", hashMap2);
            if (hashMap3 != null) {
                Object v;
                int n = (Integer)hashMap3.get("responseCode");
                AgentStartupLogger.logger.trace("{} httpResponseCode: {}", (Object)loggerDispStr, (Object)n);
                if (n == 200 && (v = hashMap3.get("results")) instanceof HashMap) {
                    HashMap hashMap4 = (HashMap)v;
                    HashMap hashMap5 = (HashMap)hashMap4.get("JavaBTMConfigsDownloadAction");
                    Object v2 = hashMap5.get("result");
                    HashMap hashMap6 = (HashMap)v2;
                    AgentStartupLogger.logger.trace("response received from JavaBTMConfigsDownloadAction :", (Object)hashMap6.size());
                    APMUtils.storeAPMConfigData(hashMap6, bl, AgentStartupLogger.logger);
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception Occured Getting data from: {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    static {
        lastModifiedTime = -1L;
        startTimeStamp = -1L;
        executionTime = -1L;
        lastUpdatedTime = -1L;
    }
}

