/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class AgentPackageInstaller {
    private File agentPackage = null;
    private String os = null;
    private String egInstallDir = null;
    public static String egAgentAutoUpgradeOut = null;
    private static String s_errorlog = "";
    private boolean isItAFullPackage = false;
    private boolean deletePackage = true;
    private String fileSeparator = System.getProperty("file.separator");
    private boolean isChmodDone = false;
    private boolean useHelper = true;
    private UpgradeHelper upgradeHelper = null;
    private boolean isUpgradeSuccessful = true;
    private HashMap mapFileCheckSum = new HashMap();

    public AgentPackageInstaller(String string, String string2, String string3) {
        this.os = string2;
        this.egInstallDir = string3;
        if (!this.egInstallDir.endsWith(this.fileSeparator)) {
            this.egInstallDir = this.egInstallDir + this.fileSeparator;
        }
        this.agentPackage = new File(string);
        this.isItAFullPackage = this.agentPackage.getName().endsWith("F.zip");
        egAgentAutoUpgradeOut = this.egInstallDir + "agent" + this.fileSeparator + "logs" + this.fileSeparator + "autoupgrade.log";
        s_errorlog = this.egInstallDir + "agent" + this.fileSeparator + "logs" + this.fileSeparator + "error_log";
    }

    public boolean installThePackage() {
        this.writeToAgentAutoUpgradeLog("", "", "==============================================================================");
        this.writeToAgentAutoUpgradeLog("", "", "Agent Auto Upgrade " + new EgDateInfo().egetDate());
        this.writeToAgentAutoUpgradeLog("", "", "==============================================================================");
        if (!(this.os.equalsIgnoreCase("Solaris") || this.os.equalsIgnoreCase("Linux") || this.os.equalsIgnoreCase("FreeBSD") || this.os.equalsIgnoreCase("HPUX") || this.os.equalsIgnoreCase("AIX") || this.os.equalsIgnoreCase("OSF1") || this.os.equalsIgnoreCase("windows2003") || this.os.equalsIgnoreCase("windows2008") || this.os.equalsIgnoreCase("windows2012") || this.os.equalsIgnoreCase("windows2016") || this.os.equalsIgnoreCase("windows2019") || this.os.equalsIgnoreCase("windows2022"))) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:installThePackage()", "Invalid OS   " + this.os);
            return false;
        }
        if (this.dummy()) {
            this.logToErrorFile("ERROR", "Agent auto upgrade", " Package is  corrupt");
            return false;
        }
        this.writeToAgentAutoUpgradeLog("", "", "************* Installation Process started  ***************");
        if (this.os.toLowerCase().startsWith("win") && !this.stopAgentOnWindows()) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:installThePackage()", "Could not stop the agent. Can't upgrade agent");
            this.logToErrorFile("ERROR", "AgentPackageInstaller", "Could not stop the agent. Can't upgrade agent");
            return false;
        }
        boolean bl = this.extractAllFiles();
        if (!bl) {
            this.writeToAgentAutoUpgradeLog("", "", "reuseBackupAgentJar()");
            this.reuseBackupAgentJar();
        } else {
            this.updateCounterIni(this.agentPackage.getName());
        }
        if (this.os.toLowerCase().startsWith("win")) {
            if (this.startAgentOnWindows()) {
                this.resetUpgradeNowFlag();
                if (this.isUpgradeSuccessful) {
                    this.updateCounterIni();
                }
                return this.isUpgradeSuccessful;
            }
        } else if ((this.os.equalsIgnoreCase("Solaris") || this.os.equalsIgnoreCase("Linux") || this.os.equalsIgnoreCase("FreeBSD") || this.os.equalsIgnoreCase("OSF1") || this.os.equalsIgnoreCase("HPUX") || this.os.equalsIgnoreCase("AIX")) && this.restartAgentOnUnix()) {
            this.resetUpgradeNowFlag();
            if (this.isUpgradeSuccessful) {
                this.updateCounterIni();
            }
            return this.isUpgradeSuccessful;
        }
        return this.isUpgradeSuccessful;
    }

    private void resetUpgradeNowFlag() {
        Properties properties = EgCheckAgent.loadEgCounterIniFile();
        String string = properties.getProperty("AgentID");
        if (string == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(":");
        while (n > -1) {
            vector.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(":");
        }
        vector.add(string);
        String string2 = EgInstallInfo.getInstallDir();
        string2 = string2 + (string2.endsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator"));
        String string3 = string2 + "agent" + System.getProperty("file.separator") + "config" + System.getProperty("file.separator");
        IniFile iniFile = new IniFile(string3 + "eg_tests.ini");
        boolean bl = true;
        IniFile iniFile2 = new IniFile(string3 + "eg_autoupgrade.ini");
        String[] stringArray = iniFile2.getVariables("UPGRADE_NOW");
        if (stringArray == null || stringArray.length <= 0) {
            stringArray = iniFile.getVariables("UPGRADE_NOW");
            bl = false;
        }
        if (stringArray == null) {
            return;
        }
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
            if (!vector.contains(stringArray[i])) continue;
            if (!bl) {
                iniFile.deleteValue("UPGRADE_NOW", stringArray[i]);
            } else {
                iniFile2.deleteValue("UPGRADE_NOW", stringArray[i]);
            }
            bl2 = false;
        }
        if (bl2) {
            if (!bl) {
                iniFile.saveFile();
            } else {
                iniFile2.saveFile();
            }
        }
    }

    private boolean updateCounterIni() {
        Properties properties = this.loadEgCounterIniFile();
        properties.setProperty("GenerateUpgradeCounter", "false");
        String string = properties.getProperty("StartUpgradeProcessAt");
        if (string != null && !string.equals("")) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Random random = new Random();
                n = random.nextInt(288);
                properties.setProperty("StartUpgradeProcessAt", new Integer(n).toString());
            }
            int n2 = n - 2;
            if (n2 >= 0) {
                properties.setProperty("UpgradeCounter", new Integer(n2).toString());
            } else {
                properties.setProperty("UpgradeCounter", new Integer(n2 += 288).toString());
            }
            this.storeEgCounterIniFile(properties);
            System.out.println("startCounter = " + n);
            System.out.println("UpgradeCounter = " + n2);
        }
        return true;
    }

    private boolean updateCounterIni(String string) {
        Properties properties = this.loadEgCounterIniFile();
        EgDateInfo egDateInfo = new EgDateInfo();
        long l = egDateInfo.egetUTCDate(false);
        properties.setProperty("LastUpgradedPackage", string);
        properties.setProperty("LastUpgradedTime", l + "");
        this.storeEgCounterIniFile(properties);
        return true;
    }

    public Properties loadEgCounterIniFile() {
        Properties properties;
        block6: {
            if (this.egInstallDir == null || this.egInstallDir.equals("")) {
                this.egInstallDir = EgInstallInfo.getInstallDir() + this.fileSeparator;
            }
            properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                File file = new File(this.egInstallDir + "agent" + this.fileSeparator + "config" + this.fileSeparator + "eg_counter.ini");
                if (!file.exists()) {
                    file.createNewFile();
                }
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                fileInputStream = null;
            }
            catch (IOException iOException) {
                if (fileInputStream == null) break block6;
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fileInputStream = null;
            }
        }
        return properties;
    }

    public void storeEgCounterIniFile(Properties properties) {
        block4: {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(new File(this.egInstallDir + "agent" + this.fileSeparator + "config" + this.fileSeparator + "eg_counter.ini"));
                properties.store(fileOutputStream, null);
                fileOutputStream.close();
                fileOutputStream = null;
            }
            catch (Exception exception) {
                if (fileOutputStream == null) break block4;
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                fileOutputStream = null;
            }
        }
    }

    private boolean isPackageCorrupted() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dummy() {
        boolean bl = false;
        this.writeToAgentAutoUpgradeLog("", "", "Checking the downloaded package");
        if (this.agentPackage.length() == 0L) {
            this.writeToAgentAutoUpgradeLog("", "", "Package size is 0 bytes. Can't install");
            return true;
        }
        try {
            String string;
            Object object;
            Object object2;
            Closeable closeable;
            String string2 = this.agentPackage.getName();
            string2 = string2.substring(0, string2.length() - 4);
            EgCrypt.setCryptMode(1);
            String string3 = EgCrypt.encrypt(string2);
            boolean bl2 = this.extractPackageChecksum(string3);
            if (bl2) {
                closeable = null;
                try {
                    closeable = new BufferedReader(new FileReader(this.egInstallDir + "/" + string3));
                    while ((object2 = ((BufferedReader)closeable).readLine()) != null) {
                        if (object2 == null || ((String)object2).length() <= 0 || ((String)(object2 = EgCrypt.decrypt((String)object2))).indexOf("=") <= -1) continue;
                        object = ((String)object2).substring(0, ((String)object2).indexOf("="));
                        string = ((String)object2).substring(((String)object2).indexOf("=") + 1);
                        object = this.recreateFileName((String)object);
                        this.mapFileCheckSum.put(object, string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    try {
                        if (closeable != null) {
                            ((BufferedReader)closeable).close();
                        }
                        closeable = null;
                    }
                    catch (Exception exception) {}
                }
            }
            closeable = new FileInputStream(this.agentPackage);
            object2 = new ZipInputStream((InputStream)closeable);
            while ((object = ((ZipInputStream)object2).getNextEntry()) != null) {
                string = this.recreateFileName(((ZipEntry)object).getName());
                if (string != null && string.length() > 0 && (string.equalsIgnoreCase(string3) || string.endsWith("_Manifest.xml"))) continue;
                String string4 = (String)this.mapFileCheckSum.get(string);
                String string5 = "";
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    DigestInputStream digestInputStream = new DigestInputStream((InputStream)object2, messageDigest);
                    while (digestInputStream.read() != -1) {
                    }
                    byte[] byArray = messageDigest.digest();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuilder.append(Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1));
                    }
                    string5 = stringBuilder.toString();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((ZipInputStream)object2).closeEntry();
                if (string4 != null && string5 != null && string4.equalsIgnoreCase(string5)) continue;
                bl = true;
                break;
            }
            ((ZipInputStream)object2).closeEntry();
            ((ZipInputStream)object2).close();
            ((FileInputStream)closeable).close();
            if (bl) {
                this.writeToAgentAutoUpgradeLog("", "", "Package is  corrupt");
            } else {
                this.writeToAgentAutoUpgradeLog("", "", "Package is not corrupt");
            }
            return bl;
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("", "", "Package is  corrupt    " + iOException.toString());
            return true;
        }
    }

    private boolean extractAllFiles() {
        Object object;
        Object object2;
        Class[] classArray;
        Object object3;
        Object object4;
        this.writeToAgentAutoUpgradeLog("", "", "Installing the package " + this.agentPackage);
        String string = this.agentPackage.getName();
        string = string.substring(0, string.length() - 4);
        boolean bl = this.extractHelperClass(string);
        String string2 = EgCrypt.encrypt(string);
        if (bl) {
            try {
                object4 = new EgClassLoader(this.egInstallDir);
                object3 = ((ClassLoader)object4).loadClass(string);
                classArray = new Class[]{Class.forName("java.lang.String")};
                object2 = ((Class)object3).getConstructor(classArray);
                object = new Object[]{this.egInstallDir};
                this.upgradeHelper = (UpgradeHelper)((Constructor)object2).newInstance(object);
                System.out.println("EgClassLoader has successfully loaded " + string + ".class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException.toString());
                bl = false;
            }
            catch (InstantiationException instantiationException) {
                System.out.println(instantiationException.toString());
                bl = false;
            }
            catch (ClassCastException classCastException) {
                System.out.println(classCastException.toString());
                bl = false;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                bl = false;
            }
        }
        try {
            object4 = new FileInputStream(this.agentPackage);
            object3 = new ZipInputStream((InputStream)object4);
            if (bl) {
                this.upgradeHelper.preInstallProcessing();
            }
            while ((classArray = ((ZipInputStream)object3).getNextEntry()) != null) {
                Serializable serializable;
                this.writeToAgentAutoUpgradeLog("", "", "--------------------");
                object2 = this.recreateFileName(classArray.getName());
                object = this.egInstallDir + (String)object2;
                this.writeToAgentAutoUpgradeLog("", "", (String)object);
                if (((String)object2).equalsIgnoreCase(this.os + "_manifest.xml")) continue;
                if (((String)object2).equalsIgnoreCase("eg_agentmon.jar")) {
                    object = this.egInstallDir + "eg_agentmon.jar";
                }
                if (bl) {
                    System.out.println("Going to call filePreProcessing on " + this.upgradeHelper.getClass().getName());
                    System.out.println("Calling the upgradeHelper for the file : " + (String)object2);
                    this.upgradeHelper.filePreProcessing((String)object2);
                } else {
                    this.preProcessing((String)object2);
                }
                try {
                    this.createDirIfNeeded((String)object);
                    serializable = new File((String)object);
                    if (!((File)serializable).exists()) {
                        ((File)serializable).createNewFile();
                    }
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)serializable));
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = ((ZipInputStream)object3).read(byArray, 0, byArray.length)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    ((ZipInputStream)object3).closeEntry();
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    this.writeToAgentAutoUpgradeLog("", "", (String)object + " has been copied");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.deletePackage = false;
                    this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractAllFiles()", fileNotFoundException.toString());
                }
                catch (IOException iOException) {
                    this.deletePackage = false;
                    this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractAllFiles()", iOException.toString());
                }
                if (bl) {
                    this.upgradeHelper.filePostProcessing((String)object2);
                } else {
                    this.postProcessing((String)object2);
                }
                if (!((String)object2).equalsIgnoreCase("eg_agentmon.jar")) continue;
                serializable = EgCheckAgent.loadEgCounterIniFile();
                ((Properties)serializable).setProperty("NeedToUpgradeAgentmon", "Yes");
                EgCheckAgent.storeEgCounterIniFile((Properties)serializable);
            }
            ((FileInputStream)object4).close();
            ((ZipInputStream)object3).close();
            if (bl) {
                this.upgradeHelper.postInstallProcessing();
                if (this.deletePackage && this.agentPackage.exists()) {
                    this.writeToAgentAutoUpgradeLog("", "", "Deleted the downloaded Package " + this.agentPackage.delete());
                }
            } else if (this.deletePackage && this.agentPackage.exists()) {
                this.writeToAgentAutoUpgradeLog("", "", "Deleted the downloaded Package " + this.agentPackage.delete());
            }
            if ((object2 = new File(this.egInstallDir + "/" + string2)) != null && ((File)object2).exists()) {
                ((File)object2).delete();
            }
            this.writeToAgentAutoUpgradeLog("", "", "Installed the package");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractAllFiles()", fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractAllFiles()", iOException.toString());
        }
        return this.isUpgradeSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractHelperClass(String string) {
        String string2 = string + ".class";
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            fileInputStream = new FileInputStream(this.agentPackage);
            zipInputStream = new ZipInputStream(fileInputStream);
            boolean bl = false;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(string2)) continue;
                String string3 = this.egInstallDir + string2;
                File file = new File(string3);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                zipInputStream.closeEntry();
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                this.writeToAgentAutoUpgradeLog("", "", "HelperClass, " + string3 + ", has been extracted");
                bl = true;
                break;
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractHelperClass", fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractHelperClass", iOException.toString());
        }
        finally {
            try {
                fileInputStream.close();
                zipInputStream.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void preProcessing(String string) {
        if (string.equalsIgnoreCase("lib" + this.fileSeparator + "eg_agent.jar")) {
            this.writeToAgentAutoUpgradeLog("", "", "File is eg_agent.jar. Doing pre-process");
            this.saveExistingAgentJar();
        }
    }

    private void postProcessing(String string) {
        if (string.equalsIgnoreCase("lib" + this.fileSeparator + "eg_agent.jar")) {
            this.writeToAgentAutoUpgradeLog("", "", "   File is eg_agent.jar. Doing post-process");
            this.addICTestsToAgentJar();
        }
    }

    private String recreateFileName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(this.fileSeparator);
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    private boolean reuseBackupAgentJar() {
        String string = this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar";
        String string2 = this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_old.jar";
        this.writeToAgentAutoUpgradeLog("", "", "Agent upgrade is failed ,use the backup eg_agent.jar ");
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = null;
        File file2 = null;
        int n = 0;
        try {
            fileInputStream = new FileInputStream(string2);
            file = new File(string);
            file2 = new File(string2);
            try {
                if (file2.exists() && file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            fileOutputStream = new FileOutputStream(string);
            while ((n = fileInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
            fileInputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return true;
        }
    }

    private boolean saveExistingAgentJar() {
        String string = this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar";
        String string2 = this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_old.jar";
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = null;
        int n = 0;
        try {
            fileInputStream = new FileInputStream(string);
            file = new File(string2);
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            fileOutputStream = new FileOutputStream(string2);
            while ((n = fileInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
            fileInputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:saveExistingAgentJar()", "      Could not rename the existing eg_agent.jar");
            this.logToErrorFile("ERROR", "AgentPackageInstaller:saveExistingAgentJar()", "      Could not rename the existing eg_agent.jar");
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:saveExistingAgentJar()", "All IC tests will be lost ");
            this.logToErrorFile("ERROR", "AgentPackageInstaller:saveExistingAgentJar()", "All IC tests will be lost ");
            this.isUpgradeSuccessful = false;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addICTestsToAgentJar() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            File file;
            File file2 = new File(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_tmp.jar");
            if (!file2.exists()) {
                file2.createNewFile();
            }
            if (!(file = new File(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_old.jar")).exists()) {
                this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", "  eg_agent.jar.old does not exist");
                this.logToErrorFile("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", "  eg_agent.jar.old does not exist");
                this.isUpgradeSuccessful = false;
                return false;
            }
            Manifest manifest = null;
            ZipFile zipFile = null;
            try {
                zipFile = new JarFile(new File(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_old.jar"));
                manifest = ((JarFile)zipFile).getManifest();
            }
            catch (Exception exception) {
                this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", "" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                        zipFile = null;
                    }
                }
                catch (Exception exception) {}
            }
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar"));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                object4 = jarEntry.getName();
                hashtable.put((String)object4, (String)object4);
                jarInputStream.closeEntry();
            }
            jarInputStream.close();
            jarInputStream = new JarInputStream(new FileInputStream(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_old.jar"));
            object4 = null;
            object4 = manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_tmp.jar"), manifest) : new JarOutputStream(new FileOutputStream(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_tmp.jar"));
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                object3 = jarEntry.getName();
                if ((!this.isItAFullPackage || !((String)object3).endsWith("_ex.class")) && (this.isItAFullPackage || hashtable.get(object3) != null)) continue;
                object2 = new JarEntry((String)object3);
                ((JarOutputStream)object4).putNextEntry((ZipEntry)object2);
                object = new byte[1024];
                int n = 0;
                while ((n = jarInputStream.read((byte[])object, 0, ((byte[])object).length)) != -1) {
                    ((ZipOutputStream)object4).write((byte[])object, 0, n);
                }
                jarInputStream.closeEntry();
                ((ZipOutputStream)object4).closeEntry();
            }
            jarInputStream.close();
            object3 = new File(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar");
            jarInputStream = new JarInputStream(new FileInputStream(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar"));
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                object2 = jarEntry.getName();
                object = new JarEntry((String)object2);
                ((JarOutputStream)object4).putNextEntry((ZipEntry)object);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = jarInputStream.read(byArray, 0, byArray.length)) != -1) {
                    ((ZipOutputStream)object4).write(byArray, 0, n);
                }
                jarInputStream.closeEntry();
                ((ZipOutputStream)object4).closeEntry();
            }
            jarInputStream.close();
            ((ZipOutputStream)object4).close();
            this.writeToAgentAutoUpgradeLog("", "", "deleting eg_agent_old.jar file....." + file.delete());
            boolean bl = this.atomicFileCopy(this.egInstallDir + "lib" + this.fileSeparator + "eg_agent_tmp.jar", this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar");
            if (bl) {
                System.out.println("atomicFileCopy --- condition.....");
                if (file2.exists()) {
                    file2.delete();
                }
                this.isUpgradeSuccessful = true;
                return true;
            }
            object = null;
            FileOutputStream fileOutputStream = null;
            File file3 = null;
            int n = 0;
            try {
                object = new FileInputStream(file2.toString());
                file3 = new File(((File)object3).toString());
                try {
                    if (file3.exists()) {
                        file3.delete();
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
                fileOutputStream = new FileOutputStream((File)object3);
                while ((n = ((FileInputStream)object).read()) != -1) {
                    fileOutputStream.write(n);
                }
                fileOutputStream.close();
                ((FileInputStream)object).close();
                if (file2.exists()) {
                    file2.delete();
                }
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (object != null) {
                        ((FileInputStream)object).close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:backupTheFile()", "Could not rename existing " + file2);
                this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:backupTheFile()", "Please manually update the file " + file2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", interruptedIOException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", interruptedIOException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", fileNotFoundException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", iOException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:addICTestsToAgentJar()", iOException.toString());
        }
        this.isUpgradeSuccessful = false;
        return false;
    }

    private boolean updateEgAgentJar() {
        try {
            Object object;
            String string = System.getProperty("java.version");
            String string2 = null;
            if (string != null) {
                if (string.compareTo("10.0") > 0) {
                    string2 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                    if (this.os != null && this.os.toLowerCase().indexOf("win") >= 0) {
                        string2 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                    }
                } else if (string.compareTo("1.7") > 0) {
                    string2 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
                    if (this.os != null && this.os.toLowerCase().indexOf("win") >= 0) {
                        string2 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                    }
                } else if (string.compareTo("1.6") > 0) {
                    string2 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null";
                    if (this.os != null && this.os.toLowerCase().indexOf("win") >= 0) {
                        string2 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL";
                    }
                }
            }
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            String string3 = null;
            boolean bl = false;
            Vector<Object> vector = new Vector<Object>();
            File file = new File(this.egInstallDir + "lib" + this.fileSeparator + "updateEgAgentJar.bat");
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            if (this.os.toLowerCase().startsWith("win")) {
                vector.addElement("cd " + this.egInstallDir + "lib");
                object = "for %%f in (*_ex.class) do " + this.egInstallDir + "JRE" + this.fileSeparator + "bin" + this.fileSeparator + "java.exe -cp " + this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar EgJar -uf " + this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar %%f";
                if (string2 != null) {
                    object = "for %%f in (*_ex.class) do " + this.egInstallDir + "JRE" + this.fileSeparator + "bin" + this.fileSeparator + "java.exe " + string2 + " -cp " + this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar EgJar -uf " + this.egInstallDir + "lib" + this.fileSeparator + "eg_agent.jar %%f";
                }
                vector.addElement(object);
                vector.addElement("del *_ex.class");
                vector.addElement("del eg_agent_old.jar");
                string3 = "cmd.exe /c ";
            } else if (this.os.equalsIgnoreCase("solaris")) {
                vector.addElement("#!/bin/sh");
                vector.addElement("cd $EG_HOME/lib");
                vector.addElement("classFiles='ls *_ex.class'");
                vector.addElement("for file in $classFiles");
                vector.addElement("do");
                object = "$JAVA_HOME/bin/java -classpath $EG_HOME/lib/eg_agent.jar EgJar -uf eg_agent.jar $file";
                if (string2 != null) {
                    object = "$JAVA_HOME/bin/java " + string2 + " -classpath $EG_HOME/lib/eg_agent.jar EgJar -uf eg_agent.jar $file";
                }
                vector.addElement(object);
                vector.addElement("done");
                vector.addElement("rm -f *_ex.class");
                string3 = "";
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                bufferedWriter.write((String)object.nextElement());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            this.writeToAgentAutoUpgradeLog("", "", "Going to execute API " + string3 + file.toString());
            process = runtime.exec(string3 + file.toString());
            if (process != null) {
                object = new BufferedReader(new InputStreamReader(process.getInputStream()));
                if (object != null) {
                    while (((BufferedReader)object).readLine() != null) {
                    }
                }
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:updateEgAgentJar()", iOException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:updateEgAgentJar()", iOException.toString());
            this.isUpgradeSuccessful = false;
        }
        return true;
    }

    private boolean createDirIfNeeded(String string) {
        String string2 = string.substring(0, string.lastIndexOf(this.fileSeparator));
        File file = new File(string2);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNonEnglishOs() {
        Runtime runtime = null;
        Process process = null;
        BufferedReader bufferedReader = null;
        boolean bl = false;
        try {
            String string;
            runtime = Runtime.getRuntime();
            String string2 = "cmd.exe /c " + EgInstallInfo.getInstallDir() + "/lib/eg_osinfo.exe";
            process = runtime.exec(string2);
            process.waitFor();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith("Primary Language Code") || (string = string3.substring(string3.indexOf("=") + 1)) == null || string.equalsIgnoreCase("ENU")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string = EgInstallInfo.getInstallDir();
                string = string + (string.endsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator"));
                String string4 = string + "lib" + System.getProperty("file.separator");
                IniFile iniFile = new IniFile(string4 + "eg_lang_info.ini");
                String string5 = iniFile.getValue("OS_INFO", "UI Language code");
                this.writeToAgentAutoUpgradeLog("", "AgentPackageInstaller:isNonEnglishOs()", string5);
                if (string5 != null && string5.trim().length() > 0 && !string5.equalsIgnoreCase("ENU")) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (process != null) {
                    process = null;
                }
                if (runtime != null) {
                    runtime = null;
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private boolean stopAgentOnWindows() {
        block29: {
            this.writeToAgentAutoUpgradeLog("", "", "stopAgentOnWindows");
            try {
                boolean bl;
                block28: {
                    String string;
                    String string2;
                    BufferedReader bufferedReader;
                    block27: {
                        Runtime runtime = Runtime.getRuntime();
                        String string3 = "cmd.exe /c net stop eGurkhaAgent";
                        Process process = runtime.exec(string3);
                        process.waitFor();
                        bl = true;
                        boolean bl2 = false;
                        String string4 = EgInstallInfo.getInstallDir() + "/agent/config/eg_lang.ini";
                        File file = new File(string4);
                        bl2 = file.exists() ? true : this.isNonEnglishOs();
                        if (bl2) {
                            this.writeToAgentAutoUpgradeLog("", "", "Non English OS ");
                            Thread.sleep(5000L);
                            bl = false;
                        } else {
                            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            string2 = bufferedReader.readLine();
                            if (string2 != null) {
                                while (string2 != null) {
                                    System.out.println(string2);
                                    if (string2.trim().indexOf("The eGurkhaAgent service was stopped successfully.") > -1) {
                                        bl = false;
                                    }
                                    string2 = bufferedReader.readLine();
                                }
                            } else {
                                bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                                while ((string2 = bufferedReader.readLine()) != null) {
                                    System.out.println(string2);
                                    if (string2.trim().indexOf("The eGurkhaAgent service is not started.") <= -1) continue;
                                    this.writeToAgentAutoUpgradeLog("", "", "The eGurkhaAgent service is not started");
                                    bl = false;
                                }
                            }
                            bufferedReader.close();
                        }
                        bufferedReader = null;
                        try {
                            string2 = EgInstallInfo.getInstallDir() + "/bin/KillAgentExecProcesses";
                            string = "cmd.exe /c " + string2;
                            bufferedReader = AgentPackageInstaller.executeProgram(string);
                            if (bufferedReader == null) break block27;
                            try {
                                while (bufferedReader.readLine() != null) {
                                }
                                bufferedReader.close();
                            }
                            catch (Exception exception) {
                                if (bufferedReader == null) break block27;
                                try {
                                    bufferedReader.close();
                                }
                                catch (Exception exception2) {}
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl) {
                        try {
                            string2 = "sc query eGurkhaAgent";
                            string = "cmd.exe /c " + string2;
                            String string5 = "";
                            bufferedReader = AgentPackageInstaller.executeProgram(string);
                            if (bufferedReader == null) break block28;
                            try {
                                while ((string5 = bufferedReader.readLine()) != null) {
                                    if (string5 == null || string5.trim().length() == 0 || !(string5 = string5.trim()).toUpperCase().startsWith("STATE") || string5.toUpperCase().indexOf("STOPPED") <= 0) continue;
                                    bl = false;
                                }
                                bufferedReader.close();
                            }
                            catch (Exception exception) {
                                if (bufferedReader == null) break block28;
                                try {
                                    bufferedReader.close();
                                }
                                catch (Exception exception3) {}
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (bl) break block29;
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.writeToAgentAutoUpgradeLog("", "", "Stopped the agent successfully");
                return true;
            }
            catch (IOException iOException) {
                this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:stopAgentOnWindows()", iOException.toString());
                this.logToErrorFile("ERROR", "AgentPackageInstaller:stopAgentOnWindows()", iOException.toString());
            }
            catch (InterruptedException interruptedException) {
                this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:stopAgentOnWindows()", interruptedException.toString());
                this.logToErrorFile("ERROR", "AgentPackageInstaller:stopAgentOnWindows()", interruptedException.toString());
            }
        }
        this.isUpgradeSuccessful = false;
        return false;
    }

    private static BufferedReader executeProgram(String string) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(string);
            if (process == null) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean startAgentOnWindows() {
        this.writeToAgentAutoUpgradeLog("", "", "Attempting to start the agent");
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cmd.exe /c net start eGurkhaAgent");
            process.waitFor();
            if (process.exitValue() == 0) {
                this.writeToAgentAutoUpgradeLog("", "", "Started the agent successfully");
                return true;
            }
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:startAgentOnWindows()", iOException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:startAgentOnWindows()", iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:startAgentOnWindows()", interruptedException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:startAgentOnWindows()", interruptedException.toString());
        }
        this.isUpgradeSuccessful = false;
        return false;
    }

    private boolean restartAgentOnUnix() {
        this.writeToAgentAutoUpgradeLog("", "", "Attempting to restart the agent");
        this.logToErrorFile("INFO", "AgentPackageInstaller", "Attempting to restart the agent");
        boolean bl = false;
        boolean bl2 = false;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(this.egInstallDir + "bin/stop_agent");
            process.waitFor();
            if (process.exitValue() == 0) {
                bl = true;
                this.writeToAgentAutoUpgradeLog("", "", "   Stopped the agent successfully");
                this.logToErrorFile("INFO", "AgentPackageInstaller", "Stopped the agent sucessfully");
            } else {
                this.writeToAgentAutoUpgradeLog("WARNING", "AgentPackageInstaller:restartAgentOnUnix()", "   Failed to stop the agent");
                this.logToErrorFile("WARNING", "AgentPackageInstaller:restartAgentOnUnix()", "   Failed to stop the agent");
            }
            String string = System.getProperty("os.name");
            String string2 = this.egInstallDir + "/bin/start_agent";
            String string3 = this.egInstallDir + "/bin/nohup_eGagent";
            File file = new File(string3);
            process = file != null && file.exists() && file.length() > 0L ? runtime.exec(string3) : runtime.exec(string2);
            process.waitFor();
            if (process.exitValue() == 0) {
                bl2 = true;
                this.writeToAgentAutoUpgradeLog("", "", "   Started the agent successfully");
                this.logToErrorFile("INFO", "AgentPackageInstaller", "   Started the agent successfully");
            } else {
                this.writeToAgentAutoUpgradeLog("WARNING", "AgentPackageInstaller:restartAgentOnUnix()", "   Failed to start the agent");
                this.logToErrorFile("WARNING", "AgentPackageInstaller:restartAgentOnUnix()", "   Failed to start the agent");
            }
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:restartAgentOnUnix()", iOException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:restartAgentOnUnix()", iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:restartAgentOnUnix()", interruptedException.toString());
            this.logToErrorFile("ERROR", "AgentPackageInstaller:restartAgentOnUnix()", interruptedException.toString());
        }
        if (!bl || !bl2) {
            this.isUpgradeSuccessful = false;
        }
        return bl && bl2;
    }

    public synchronized void writeToAgentAutoUpgradeLog(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate();
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        try {
            printWriter = new PrintWriter(new FileWriter(egAgentAutoUpgradeOut, true));
        }
        catch (Exception exception) {
            System.err.println("writeToAgentAutoUpgradeLog: Cannot open log file ");
            return;
        }
        String string5 = new String(string + " " + string2 + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    public void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate();
        try {
            printWriter = new PrintWriter(new FileWriter(s_errorlog, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    public boolean atomicFileCopy(String string, String string2) {
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            boolean bl = false;
            if (this.os != null && this.os.toLowerCase().startsWith("win")) {
                bl = true;
            }
            ArrayList arrayList = null;
            if (bl) {
                string = this.replace(string, "/", "\\");
                string2 = this.replace(string2, "/", "\\");
                this.writeToAgentAutoUpgradeLog("", "", "COPY cmd is copy /Y " + string + " " + string2);
                arrayList = egUtilities.getExecOutputLines("copy /Y " + string + " " + string2);
                System.out.println("AFTER COPY - al is " + arrayList);
                if (arrayList == null || arrayList.size() < 2) {
                    return false;
                }
                ArrayList arrayList2 = (ArrayList)arrayList.get(1);
                if (arrayList2 == null || arrayList2.size() > 0) {
                    return false;
                }
            } else {
                this.writeToAgentAutoUpgradeLog("", "", "nohup cp " + string + " " + string2);
                arrayList = egUtilities.getExecOutputLines("nohup cp " + string + " " + string2);
                System.out.println("AFTER COPY - al is " + arrayList);
                if (arrayList == null || arrayList.size() < 2) {
                    return false;
                }
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3 == null || arrayList3.size() > 0) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractPackageChecksum(String string) {
        String string2 = string;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            fileInputStream = new FileInputStream(this.agentPackage);
            zipInputStream = new ZipInputStream(fileInputStream);
            boolean bl = false;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(string2)) continue;
                String string3 = this.egInstallDir + string2;
                File file = new File(string3);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                zipInputStream.closeEntry();
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                this.writeToAgentAutoUpgradeLog("", "", "HelperClass, " + string3 + ", has been extracted");
                bl = true;
                break;
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractHelperClass", fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            this.writeToAgentAutoUpgradeLog("ERROR", "AgentPackageInstaller:extractHelperClass", iOException.toString());
        }
        finally {
            try {
                fileInputStream.close();
                zipInputStream.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

