/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class ApacheServerInfo_cf
extends GenericTest {
    String configFile = "";
    ApacheParser ap = null;

    public ApacheServerInfo_cf(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.configFile = this.getValueForParam("ApacheConfig_File");
        this.ap = new ApacheParser(this.configFile);
        this.setConfigInfoTestFlag(true);
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string = "-";
            Hashtable hashtable2 = new Hashtable();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!this.meAgentless) {
                hashtable2 = this.ap.parseConfig();
            } else if (this.isPerfmon) {
                this.ap = new ApacheParser(this.configFile, "perfmon", this.targetHost);
                hashtable2 = this.ap.parseConfig();
            } else if (this.isSSH || this.isRexec) {
                if (this.aluser.equalsIgnoreCase("NONE") || this.alpassword.equalsIgnoreCase("none")) {
                    this.errorMsg = "Apache Server info is configured in Agentless and os/aluser can't be NONE for " + this.targetHost;
                    this.logToErrorFile("ERROR", this.entity, this.errorMsg);
                    this.configError = true;
                    return;
                }
                Object object = "";
                if (this.isSSH) {
                    object = "ssh";
                } else if (this.isRexec) {
                    object = "rexec";
                }
                this.ap = new ApacheParser(this.configFile, (String)object, this.targetHost, this.sshPort, this.aluser, this.alpassword);
                hashtable2 = this.ap.parseConfig();
            }
            if (hashtable2 == null && hashtable2.isEmpty()) {
                this.configError = true;
                return;
            }
            for (String string2 : hashtable2.keySet()) {
                if (string2.startsWith("<") || string2.equals("LoadModule")) continue;
                ArrayList arrayList2 = (ArrayList)hashtable2.get(string2);
                string = this.getMeasureValue(arrayList2);
                arrayList = new ArrayList();
                arrayList.add(string);
                string2 = "##E##~M~" + string2.trim();
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.configError = true;
            exception.printStackTrace();
        }
    }

    public String getMeasureValue(ArrayList arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return "-";
        }
        String string = "-";
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            string = i == 0 ? string2 : string + "," + string2;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        ApacheServerInfo_cf apacheServerInfo_cf = new ApacheServerInfo_cf(stringArray);
        apacheServerInfo_cf.computeMeasures(new Hashtable());
    }
}

