/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class AzureKubernetesDiscovery {
    String tenant_id = "";
    String client_id = "";
    String client_pwd = "";
    String accessToken = "";
    boolean isDebugOn = false;
    public static Hashtable URL_percent_encoding = new Hashtable();
    public static Hashtable API_hash = new Hashtable();
    public Hashtable azrAccessTokenHash = new Hashtable();
    String subscriptionId = "";
    boolean isProxyEnabled = false;
    String strProxyHost = "";
    String strProxyPort = "";
    String strProxyUser = "";
    String strProxyPass = "";
    public static final String managementTargetIp = "management.azure.com";
    public static final String graphTargetIp = "graph.microsoft.com";
    public static final int sslPort = 443;
    public static final String sslProtocol = "https";
    public static final String nonSslProtocol = "http";
    private static final String authorityUrl = "https://login.microsoftonline.com/";
    private static final String resourceUrl = "https://graph.microsoft.com";
    public static String graphVersion = "beta";

    public AzureKubernetesDiscovery(String string, String string2, String string3, String string4) {
        this.tenant_id = string;
        this.client_id = string2;
        this.client_pwd = string3;
        this.subscriptionId = string4;
        this.isProxyEnabled = false;
    }

    public AzureKubernetesDiscovery(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.tenant_id = string;
        this.client_id = string2;
        this.client_pwd = string3;
        this.subscriptionId = string4;
        this.strProxyHost = string5;
        this.strProxyPort = string6;
        this.strProxyUser = string7;
        this.strProxyPass = string8;
        if (string5 != null && string5.trim().length() > 0 && !string5.trim().equalsIgnoreCase("none") && string6 != null && string6.trim().length() > 0 && !string6.trim().equalsIgnoreCase("none")) {
            this.isProxyEnabled = true;
        }
        URL_percent_encoding.put(" ", "%20");
        URL_percent_encoding.put("[", "%5B");
        URL_percent_encoding.put("]", "%5D");
        URL_percent_encoding.put("^", "%5E");
        URL_percent_encoding.put("<", "%3C");
        URL_percent_encoding.put(">", "%3E");
        URL_percent_encoding.put("{", "%7B");
        URL_percent_encoding.put("}", "%7D");
        URL_percent_encoding.put("`", "%80");
        URL_percent_encoding.put("|", "%7C");
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n < 4) {
            System.out.println("Please provide the valid credentials, java AzureKubernetesDiscovery <tenant_id> <client_id> <client_secret>");
            return;
        }
        String string = stringArray[0].trim();
        String string2 = stringArray[1].trim();
        String string3 = stringArray[2].trim();
        String string4 = stringArray[3].trim();
        String string5 = "none";
        String string6 = "none";
        String string7 = "none";
        String string8 = "none";
        if (n >= 9) {
            string5 = stringArray[4].trim();
            string6 = stringArray[5].trim();
            string7 = stringArray[6].trim();
            string8 = stringArray[7].trim();
        }
        AzureKubernetesDiscovery azureKubernetesDiscovery = new AzureKubernetesDiscovery(string, string2, string3, string4, string5, string6, string7, string8);
        System.out.println(azureKubernetesDiscovery.getHostpoolsDetail());
    }

    public ArrayList getHostpoolsDetail() {
        ArrayList arrayList = new ArrayList();
        try {
            if (this.subscriptionId == null || this.subscriptionId.trim().length() == 0) {
                return arrayList;
            }
            if (this.isDebugOn) {
                System.out.println("[AzureKubernetesDiscovery] subscriptionId " + this.subscriptionId);
            }
            String string = "subscriptions/" + this.subscriptionId + "/providers/Microsoft.ContainerService/managedClusters?api-version=2022-04-01";
            String string2 = this.executeHttpCmd(string, "GET");
            if (this.isDebugOn) {
                System.out.println("[AzureKubernetesDiscovery] outputString = " + string2);
            }
            if (string2 == null || string2.trim().length() == 0) {
                return arrayList;
            }
            arrayList = this.parseJsonOutput(string2.trim(), this.subscriptionId);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.isDebugOn) {
            System.out.println("[AzureKubernetesDiscovery] hostpoolsList--->" + arrayList);
        }
        return arrayList;
    }

    public JsonObject getParsedJsonObject(String string) {
        JsonObject jsonObject = null;
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));
            jsonReader.setLenient(true);
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse(jsonReader);
            if (jsonElement != null && jsonElement.isJsonObject()) {
                jsonObject = jsonElement.getAsJsonObject();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jsonObject;
    }

    private ArrayList parseJsonOutput(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string);
            if (jsonObject == null) {
                return null;
            }
            JsonArray jsonArray = (JsonArray)jsonObject.get("value");
            if (jsonArray == null || jsonArray.size() == 0) {
                return null;
            }
            int n = jsonArray.size();
            String string3 = "";
            String string4 = "";
            String string5 = "";
            for (int i = 0; i < n; ++i) {
                JsonObject jsonObject2;
                JsonObject jsonObject3 = (JsonObject)jsonArray.get(i);
                if (jsonObject3 == null) continue;
                string3 = "";
                string4 = "";
                if (jsonObject3.has("id")) {
                    string3 = AzureKubernetesDiscovery.replace(jsonObject3.get("id").toString(), "\"", "");
                }
                if (jsonObject3.has("name")) {
                    string4 = AzureKubernetesDiscovery.replace(jsonObject3.get("name").toString(), "\"", "");
                }
                if (jsonObject3.has("properties") && (jsonObject2 = (JsonObject)jsonObject3.get("properties")) != null && jsonObject2.has("fqdn")) {
                    string5 = AzureKubernetesDiscovery.replace(jsonObject2.get("fqdn").toString(), "\"", "");
                }
                arrayList.add(string4 + ":" + string5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.isDebugOn) {
            System.out.println("resourceList --->" + arrayList);
        }
        return arrayList;
    }

    private JsonObject getJsonObject(JsonElement jsonElement) {
        JsonObject jsonObject = null;
        try {
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return null;
            }
            jsonObject = jsonElement.getAsJsonObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jsonObject;
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String executeHttpCmd(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "/";
        try {
            X509HostnameVerifier x509HostnameVerifier;
            SSLContext sSLContext;
            HttpClientBuilder httpClientBuilder;
            String string6;
            int n;
            string4 = (String)this.azrAccessTokenHash.get("accessToken");
            if (string4 == null || string4.length() == 0) {
                string4 = this.getAccessToken();
            }
            if (string4 != null && string4.trim().length() > 0 && (n = (string6 = string4.trim()).indexOf("#~#")) > 0) {
                string4 = string6.substring(0, n);
            }
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            this.azrAccessTokenHash.put("accessToken", string4);
            string6 = string5 + string;
            string6 = this.validateURL(string6);
            CloseableHttpClient closeableHttpClient = null;
            HttpGet httpGet = null;
            if (this.isProxyEnabled) {
                httpClientBuilder = new SSLContextBuilder();
                httpClientBuilder.loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
                        return true;
                    }
                });
                sSLContext = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                x509HostnameVerifier = new SSLConnectionSocketFactory(httpClientBuilder.build(), (X509HostnameVerifier)sSLContext);
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(new AuthScope(this.strProxyHost, Integer.parseInt(this.strProxyPort)), (Credentials)new UsernamePasswordCredentials(this.strProxyUser, this.strProxyPass));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)x509HostnameVerifier).build();
                HttpHost httpHost = new HttpHost(this.strProxyHost, Integer.parseInt(this.strProxyPort));
                RequestConfig requestConfig = RequestConfig.custom().setProxy(httpHost).build();
                httpGet = new HttpGet(string6);
                httpGet.setConfig(requestConfig);
            } else {
                httpClientBuilder = HttpClientBuilder.create();
                sSLContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
                        return true;
                    }
                }).build();
                httpClientBuilder.setSslcontext(sSLContext);
                x509HostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, x509HostnameVerifier);
                Registry registry = RegistryBuilder.create().register(nonSslProtocol, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(sslProtocol, (Object)sSLConnectionSocketFactory).build();
                PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
                closeableHttpClient = httpClientBuilder.build();
                httpGet = new HttpGet(string6);
            }
            httpClientBuilder = new HttpHost(managementTargetIp, 443, sslProtocol);
            httpGet.setHeader("Authorization", "Bearer " + string4);
            httpGet.setHeader("Content-Type", "application/json");
            sSLContext = closeableHttpClient.execute((HttpHost)httpClientBuilder, (HttpRequest)httpGet);
            x509HostnameVerifier = sSLContext.getEntity();
            if (x509HostnameVerifier != null && (string3 = EntityUtils.toString((HttpEntity)x509HostnameVerifier)) == null) {
                string3 = "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public String validateURL(String string) {
        try {
            Enumeration enumeration = URL_percent_encoding.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2 == null || string.indexOf(string2) <= -1) continue;
                String string3 = (String)URL_percent_encoding.get(string2);
                string = AzureKubernetesDiscovery.replace(string, string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getAccessToken() throws Exception {
        String string;
        block12: {
            string = "";
            try {
                String string2;
                int n;
                int n2;
                String string3 = " -cp \"" + EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar;" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-httpclient.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-httpcore.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-logging.jar;" + EgInstallInfo.getInstallDir() + "/lib/mail.jar;" + EgInstallInfo.getInstallDir() + "/lib/gson.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/adal4j.jar;" + EgInstallInfo.getInstallDir() + "/agent/lib/commons-lang.jar;" + EgInstallInfo.getInstallDir() + "/agent/lib/json-smart.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/nimbus-jose-jwt.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/content-type.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/msal4j.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/oauth2-oidc-sdk.jar;" + EgInstallInfo.getInstallDir() + "/agent/lib/slf4j-api.jar\"";
                String string4 = System.getProperty("os.name");
                if (string4.equalsIgnoreCase("linux")) {
                    string3 = " -cp " + EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-httpclient.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-httpcore.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-logging.jar:" + EgInstallInfo.getInstallDir() + "/lib/mail.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/adal4j.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/commons-lang.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/nimbus-jose-jwt.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/content-type.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/msal4j.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/oauth2-oidc-sdk.jar";
                }
                String string5 = System.getProperty("java.version");
                String string6 = "";
                if (string5.compareTo("10.0") > 0) {
                    string6 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                    if (string4 != null && string4.toLowerCase().indexOf("win") >= 0) {
                        string6 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                    }
                } else if (string5.compareTo("1.7") > 0) {
                    string6 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
                String string7 = EgInstallInfo.getInstallDir() + "/jre/bin/java ";
                String string8 = "";
                string8 = this.isProxyEnabled ? string7 + string6 + string3 + " GetAccessToken  " + this.tenant_id + " " + this.client_id + " " + this.client_pwd + " " + this.strProxyHost + " " + this.strProxyPort + " " + this.strProxyUser + " " + this.strProxyPass : string7 + string6 + string3 + " GetAccessToken  " + this.tenant_id + " " + this.client_id + " " + this.client_pwd;
                EgUtilities egUtilities = EgUtilities.createInstance();
                if (this.isDebugOn) {
                    System.out.println("[getAccessToken] Get ExecOutputLine start time =>" + new Date());
                }
                ArrayList arrayList = egUtilities.getExecOutputLines(string8);
                if (this.isDebugOn) {
                    System.out.println("[getAccessToken] Get ExecOutputLine end time =>" + new Date());
                }
                if (arrayList == null || arrayList.size() < 2) break block12;
                ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    n2 = arrayList3.size();
                    for (n = 0; n < n2; ++n) {
                        string2 = (String)arrayList3.get(n);
                        if (string2 != null && string2.trim().length() != 0 && (string2 = string2.trim()).indexOf("SLF4J:") <= -1 && string2.indexOf("Instance discovery was successful") <= -1) continue;
                    }
                }
                n2 = arrayList2.size();
                for (n = 0; n < n2; ++n) {
                    string2 = (String)arrayList2.get(n);
                    if (string2 == null || string2.length() == 0 || !(string2 = string2.trim()).startsWith("AccessToken:")) continue;
                    string = string2.substring(string2.indexOf(":") + 1);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }
}

