/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

public class BBSysMdsTest
extends EgSnmpGenericTest {
    private static final String ServerHeathEntryOID = ".1.3.6.1.4.1.3530.5.25.1";
    private static final String ServerNameOID = ".1.3.6.1.4.1.3530.5.20.1.2";
    private static final String ServerInstanceOID = "1.";
    private static final String MdsDeviceConnectionsOID = "60.";
    private static final String MdsPushConnectionsOID = "61.";
    private static final String MdsAvgPacketSizeFromDeviceOID = "64.";
    private static final String MdsAvgPacketSizeToDeviceOID = "67.";
    private static final String MdsRefusedPacketsOID = "68.";
    private static final String MdsInvalidPacketsOID = "69.";
    private static final String MdsConnectionSuccessOID = "70.";
    private static final String MdsConnectionFailureOID = "71.";
    private static final String MdsConnectionTruncatedOID = "72.";
    private HashMap mdsRefusedPacketsMap = new HashMap();
    private HashMap mdsInvalidPacketsMap = new HashMap();
    private HashMap mdsConnectionSuccessMap = new HashMap();
    private HashMap mdsConnectionFailureMap = new HashMap();
    private HashMap mdsConnectionTruncatedMap = new HashMap();
    private static final int MEASURES_COUNT = 9;
    private static final double BYTE_TO_MB = 1048576.0;

    public BBSysMdsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(9);
        this.isDynamicInfoTest = true;
    }

    private void clearHashMaps() {
        this.mdsRefusedPacketsMap.clear();
        this.mdsInvalidPacketsMap.clear();
        this.mdsConnectionSuccessMap.clear();
        this.mdsConnectionFailureMap.clear();
        this.mdsConnectionTruncatedMap.clear();
    }

    public void computeMeasures(Hashtable hashtable) {
        HashMap hashMap = this.getStringMap(ServerNameOID);
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<Object, Double> hashMap3 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap4 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap5 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap6 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap7 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap8 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap9 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap10 = new HashMap<Object, Double>();
        HashMap<Object, Double> hashMap11 = new HashMap<Object, Double>();
        if (this.runSnmpCmdForOid(ServerHeathEntryOID)) {
            Object object;
            Object object2;
            Object object3;
            if (this.lhs == null) {
                this.clearHashMaps();
                return;
            }
            for (int i = 0; i < this.lhs.length; ++i) {
                object3 = this.lhs[i];
                int n = ((String)object3).indexOf(".");
                if (n < 0 || (object2 = ((String)object3).substring(n + 1)) == null || ((String)object2).trim().length() == 0) continue;
                if (this.lhs[i].startsWith(ServerInstanceOID)) {
                    object = this.rhs[i];
                    if (object == null || ((String)object).trim().length() == 0) continue;
                    hashMap2.put(object2, object);
                    continue;
                }
                if (this.lhs[i].startsWith(MdsDeviceConnectionsOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap3.put(object2, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith(MdsPushConnectionsOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap4.put(object2, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith(MdsAvgPacketSizeFromDeviceOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap5.put(object2, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith(MdsAvgPacketSizeToDeviceOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap6.put(object2, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith(MdsRefusedPacketsOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap7.put(object2, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith(MdsInvalidPacketsOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap8.put(object2, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith(MdsConnectionSuccessOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap9.put(object2, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith(MdsConnectionFailureOID)) {
                    double d = this.parseRHSValue(i);
                    hashMap10.put(object2, new Double(d));
                    continue;
                }
                if (!this.lhs[i].startsWith(MdsConnectionTruncatedOID)) continue;
                double d = this.parseRHSValue(i);
                hashMap11.put(object2, new Double(d));
            }
            HashMap hashMap12 = this.getRateMap(this.mdsRefusedPacketsMap, hashMap7);
            object3 = this.getRateMap(this.mdsInvalidPacketsMap, hashMap8);
            HashMap hashMap13 = this.getRateMap(this.mdsConnectionSuccessMap, hashMap9);
            object2 = this.getRateMap(this.mdsConnectionFailureMap, hashMap10);
            object = this.getRateMap(this.mdsConnectionTruncatedMap, hashMap11);
            Set set = hashMap2.keySet();
            if (set == null) {
                this.clearHashMaps();
                return;
            }
            for (String string : set) {
                String string2 = (String)hashMap2.get(string);
                String string3 = (String)hashMap.get(string2);
                ArrayList<Double> arrayList = new ArrayList<Double>(9);
                arrayList.add(this.getMapValue(hashMap3, string));
                arrayList.add(this.getMapValue(hashMap4, string));
                arrayList.add(this.getMapValue(hashMap5, string));
                arrayList.add(this.getMapValue(hashMap6, string));
                arrayList.add(this.getMapValue(hashMap12, string));
                arrayList.add(this.getMapValue((HashMap)object3, string));
                arrayList.add(this.getMapValue(hashMap13, string));
                arrayList.add(this.getMapValue((HashMap)object2, string));
                arrayList.add(this.getMapValue((HashMap)object, string));
                this.addNewMeasure(string3, arrayList);
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost);
            this.clearHashMaps();
        }
    }

    private Double getMapValue(HashMap hashMap, String string) {
        Double d = (Double)hashMap.get(string);
        if (d == null) {
            d = new Double(-5.0);
        }
        return d;
    }

    private HashMap getStringMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.rhs == null) continue;
                String string2 = this.rhs[i].trim();
                hashMap.put(this.lhs[i], string2);
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost + ", OID=" + string);
        }
        return hashMap;
    }

    private double parseRHSValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            return d;
        }
        return d;
    }

    private HashMap getRateMap(HashMap hashMap, HashMap hashMap2) {
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        HashMap<String, Double> hashMap4 = new HashMap<String, Double>();
        Set set = hashMap2.keySet();
        if (set == null) {
            return hashMap3;
        }
        for (String string : set) {
            double d = (Double)hashMap2.get(string);
            double d2 = -5.0;
            Double d3 = (Double)hashMap.get(string);
            if (d3 != null) {
                d2 = d3;
            }
            double d4 = -5.0;
            if (d2 >= 0.0 && d >= 0.0 && (d4 = d - d2) < 0.0) {
                d4 = -5.0;
            }
            hashMap3.put(string, new Double(d4));
            hashMap4.put(string, new Double(d));
        }
        BBSysMdsTest.replaceHash(hashMap, hashMap4);
        return hashMap3;
    }

    public static void replaceHash(HashMap hashMap, HashMap hashMap2) {
        hashMap.clear();
        Set set = hashMap2.keySet();
        if (set == null) {
            return;
        }
        for (String string : set) {
            Object v = hashMap2.get(string);
            hashMap.put(string, v);
        }
    }
}

