/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

public class BBSysMsgsTest
extends EgSnmpGenericTest {
    private static final String ServerInstanceOID = ".1.3.6.1.4.1.3530.5.25.1.1";
    private static final String ServerNameOID = ".1.3.6.1.4.1.3530.5.20.1.2";
    private static final String MsgTotalProcOID = ".1.3.6.1.4.1.3530.5.25.1.20";
    private static final String MsgToHandheldOID = ".1.3.6.1.4.1.3530.5.25.1.21";
    private static final String MsgFromHandheldOID = ".1.3.6.1.4.1.3530.5.25.1.22";
    private static final String MsgPendingOID = ".1.3.6.1.4.1.3530.5.25.1.25";
    private static final String MsgExpiredOID = ".1.3.6.1.4.1.3530.5.25.1.26";
    private static final String MsgErrorsOID = ".1.3.6.1.4.1.3530.5.25.1.27";
    private HashMap msgTotalProcMap = new HashMap();
    private HashMap msgToHandheldMap = new HashMap();
    private HashMap msgFromHandheldMap = new HashMap();
    private HashMap msgPendingMap = new HashMap();
    private HashMap msgExpiredMap = new HashMap();
    private HashMap msgErrorsMap = new HashMap();
    private HashMap msgFilteredMap = new HashMap();
    private HashMap serverInstanceMap = new HashMap();
    private static int MEASURES_COUNT = 7;

    public BBSysMsgsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(MEASURES_COUNT);
        this.isDynamicInfoTest = true;
    }

    private void clearHashMaps() {
        this.msgTotalProcMap.clear();
        this.msgToHandheldMap.clear();
        this.msgFromHandheldMap.clear();
        this.msgPendingMap.clear();
        this.msgExpiredMap.clear();
        this.msgErrorsMap.clear();
        this.msgFilteredMap.clear();
        this.serverInstanceMap.clear();
    }

    public void computeMeasures(Hashtable hashtable) {
        if (this.runSnmpCmdForOid(ServerInstanceOID)) {
            Object object;
            Object object2;
            if (this.lhs == null) {
                this.clearHashMaps();
                return;
            }
            for (int i = 0; i < this.lhs.length; ++i) {
                object2 = this.lhs[i];
                if (object2 == null || ((String)object2).trim().length() == 0 || (object = this.rhs[i]) == null || ((String)object).trim().length() == 0) continue;
                this.serverInstanceMap.put(object2, object);
            }
            if (this.serverInstanceMap.size() == 0) {
                this.clearHashMaps();
                return;
            }
            HashMap hashMap = this.getStringMap(ServerNameOID);
            object2 = this.getRateMap(MsgTotalProcOID, this.msgTotalProcMap);
            object = this.getRateMap(MsgToHandheldOID, this.msgToHandheldMap);
            HashMap hashMap2 = this.getRateMap(MsgFromHandheldOID, this.msgFromHandheldMap);
            HashMap hashMap3 = this.getRateMap(MsgPendingOID, this.msgPendingMap);
            HashMap hashMap4 = this.getRateMap(MsgExpiredOID, this.msgExpiredMap);
            HashMap hashMap5 = this.getRateMap(MsgErrorsOID, this.msgErrorsMap);
            HashMap hashMap6 = this.getFilteredMsgRateMap();
            Set set = this.serverInstanceMap.keySet();
            if (set == null) {
                this.clearHashMaps();
                return;
            }
            for (String string : set) {
                String string2 = (String)this.serverInstanceMap.get(string);
                String string3 = (String)hashMap.get(string2);
                ArrayList<Double> arrayList = new ArrayList<Double>(MEASURES_COUNT);
                arrayList.add(this.getMapValue((HashMap)object2, string));
                arrayList.add(this.getMapValue((HashMap)object, string));
                arrayList.add(this.getMapValue(hashMap2, string));
                arrayList.add(this.getMapValue(hashMap3, string));
                arrayList.add(this.getMapValue(hashMap4, string));
                arrayList.add(this.getMapValue(hashMap5, string));
                arrayList.add((Double)hashMap6.get(string));
                this.addNewMeasure(string3, arrayList);
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost);
            this.clearHashMaps();
        }
    }

    private void removeUnnecessary(HashMap hashMap, ArrayList arrayList) {
        Set set = hashMap.keySet();
        if (set == null) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : set) {
            if (arrayList.contains(string)) continue;
            arrayList2.add(string);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string;
            string = (String)arrayList2.get(i);
            hashMap.remove(string);
        }
    }

    private HashMap getFilteredMsgRateMap() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        Set set = this.serverInstanceMap.keySet();
        if (set == null) {
            return hashMap;
        }
        for (String string : set) {
            Double d = (Double)this.msgTotalProcMap.get(string);
            Double d2 = (Double)this.msgToHandheldMap.get(string);
            Double d3 = (Double)this.msgFromHandheldMap.get(string);
            double d4 = -5.0;
            if (d != null) {
                try {
                    d4 = d;
                }
                catch (Exception exception) {
                    d4 = -5.0;
                }
            }
            double d5 = -5.0;
            if (d2 != null) {
                try {
                    d5 = d2;
                }
                catch (Exception exception) {
                    d5 = -5.0;
                }
            }
            double d6 = -5.0;
            if (d3 != null) {
                try {
                    d6 = d3;
                }
                catch (Exception exception) {
                    d6 = -5.0;
                }
            }
            Double d7 = null;
            double d8 = -5.0;
            if (d4 < 0.0 && d5 < 0.0 && d6 < 0.0) {
                d7 = new Double(-5.0);
            } else {
                if (d4 > 0.0 && d5 > 0.0) {
                    d8 = d4 - d5;
                }
                if (d6 > 0.0 && d8 > 0.0) {
                    d8 -= d6;
                }
                if (d8 > 0.0) {
                    d8 /= this.timeSinceLastTest;
                }
                d7 = new Double(d8);
            }
            hashMap.put(string, d7);
        }
        return hashMap;
    }

    private HashMap getStringMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.rhs == null) continue;
                String string2 = this.rhs[i].trim();
                hashMap.put(this.lhs[i], string2);
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost + ", OID=" + string);
        }
        return hashMap;
    }

    private Double getMapValue(HashMap hashMap, String string) {
        Double d = (Double)hashMap.get(string);
        if (d == null) {
            d = new Double(-5.0);
        }
        return d;
    }

    private double parseRHSValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            return d;
        }
        return d;
    }

    private HashMap getResultMap(String string) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                double d = this.parseRHSValue(i);
                hashMap.put(this.lhs[i], new Double(d));
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost + ", OID=" + string);
        }
        return hashMap;
    }

    private HashMap getRateMap(String string, HashMap hashMap) {
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                double d = this.parseRHSValue(i);
                Double d2 = (Double)hashMap.get(this.lhs[i]);
                double d3 = -5.0;
                if (d2 != null) {
                    d3 = d2;
                }
                double d4 = -5.0;
                if (d3 >= 0.0 && d >= 0.0 && (d4 = d - d3) < 0.0) {
                    d4 = -5.0;
                }
                hashMap2.put(this.lhs[i], new Double(d4));
                hashMap3.put(this.lhs[i], new Double(d));
            }
        } else {
            this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for " + this.targetHost + ", OID=" + string);
        }
        BBSysMsgsTest.replaceHash(hashMap, hashMap3);
        return hashMap2;
    }

    public static void replaceHash(HashMap hashMap, HashMap hashMap2) {
        hashMap.clear();
        Set set = hashMap2.keySet();
        if (set == null) {
            return;
        }
        for (String string : set) {
            Object v = hashMap2.get(string);
            hashMap.put(string, v);
        }
    }
}

