/*
 * Decompiled with CFR 0.152.
 */
import com.eg.webservice.util.EgSOAPUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BODSJobExeTest
extends BODSWebServiceBase {
    public static final ArrayList MEASURE_ORDER_ARRAYLIST = new ArrayList();
    private static final int SAP_BODS_JOB_EXECUTION_MEASURE_COUNT = 6;
    private Hashtable jobHT = new Hashtable();
    public Hashtable succededDDHT = new Hashtable();
    public Hashtable errorDDHT = new Hashtable();
    public Hashtable recoveredDDHT = new Hashtable();
    public Hashtable maxExecutionDDHT = new Hashtable();
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final String SUCCEEDED = "succeeded";
    private static final String ERROR = "error";
    private static final String FAILED = "failed";
    private static final String RECOVERED = "recovered";
    private static final String RUNNING = "running";
    private static final String WARNING = "warning";
    private static final String MAX_EXECUTION_TIME = "maxElapsedTime";
    String scanPeriodInHours = "24";
    private static final String GET_ERROR_LOG_SOAP_ACTION_URL = "jobAdmin=Get_Error_Log";
    private static final String GET_MONITOR_LOG_SOAP_ACTION_URL = "jobAdmin=Get_Monitor_Log";
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private String maxRunJobId = "";
    private String maxRepoName = "";
    private String maxJobName = "";
    private String maxObjId = "";
    private double maxExectionTime = 0.0;
    private String lastExecuteTimeStamp = null;
    private static final double DEFAULT_LONG_RUNNING_CUT_OFF = 10.0;
    private double longRunningCutOff = 10.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BODSJobExeTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        String string = this.getValueForParam("long_running_cut_off");
        if (string != null && !string.equalsIgnoreCase("null") && !string.equalsIgnoreCase("none")) {
            try {
                this.longRunningCutOff = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.scanPeriodInHours = this.getValueForParam("scan_period(hrs)");
        if (fieldSep.length() == 0) {
            String string2 = sync0;
            synchronized (string2) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        String string = this.loginSession();
        Hashtable hashtable2 = this.getBatchJobList(string);
        if (hashtable2 != null && !hashtable2.isEmpty() && hashtable2.size() > 0) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (int i = 0; i < MEASURE_ORDER_ARRAYLIST.size(); ++i) {
                    String string3 = (String)MEASURE_ORDER_ARRAYLIST.get(i);
                    Double d = (Double)hashtable3.get(string3);
                    arrayList.add(d);
                }
                this.printOut("Info  :" + string2 + "  MeasureArrayList  :" + arrayList);
                if (bl) continue;
                this.addNewMeasure(string2, arrayList);
            }
        }
        this.logout(string);
        this.jobHT = new Hashtable();
        this.printOut("errorDDHT : " + this.errorDDHT, true);
        this.printOut("succededDDHT : " + this.succededDDHT, true);
        this.printOut("maxExecutionDDHT : " + this.maxExecutionDDHT, true);
        this.printOut("recoveredDDHT :" + this.recoveredDDHT, true);
    }

    public void freeTest() {
        this.errorDDHT = new Hashtable();
        this.succededDDHT = new Hashtable();
        this.maxExecutionDDHT = new Hashtable();
        this.recoveredDDHT = new Hashtable();
    }

    public static void main(String[] stringArray) {
        BODSJobExeTest bODSJobExeTest = new BODSJobExeTest(stringArray);
        bODSJobExeTest.printOut("Start time :" + new Date(), true);
        long l = System.currentTimeMillis();
        int n = 1;
        while (++n < 5) {
            bODSJobExeTest.debugComputeMeasures(new Hashtable(), true);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            bODSJobExeTest.printOut("End time :" + new Date(), true);
            long l2 = System.currentTimeMillis();
            bODSJobExeTest.printOut("Total execution time :" + (l2 - l), true);
        }
        bODSJobExeTest.printOut("errorDDHT : " + bODSJobExeTest.errorDDHT, true);
        bODSJobExeTest.printOut("succededDDHT : " + bODSJobExeTest.succededDDHT, true);
        bODSJobExeTest.printOut("maxExecutionDDHT : " + bODSJobExeTest.maxExecutionDDHT, true);
        bODSJobExeTest.printOut("recoveredDDHT :" + bODSJobExeTest.recoveredDDHT, true);
    }

    protected Hashtable getBatchJobList(String string) {
        Object object;
        Object object2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.lastExecuteTimeStamp == null || this.lastExecuteTimeStamp.trim().length() == 0) {
            long l = System.currentTimeMillis();
            long l2 = l - 300000L;
            this.lastExecuteTimeStamp = this.getDate(l2, new SimpleDateFormat(dateFormat));
        }
        String string2 = this.getBatchJobListSOAPRequest(string);
        String string3 = EgSOAPUtil.invokeOperation((String)string2, (String)"jobAdmin=Get_BatchJob_List", (String)this.targetURL, (String)"None", (String)"None");
        String string4 = EgSOAPUtil.formatXML((String)string3);
        Document document = this.getDocumentFromFormatString(string4);
        NodeList nodeList = document.getElementsByTagName("localtypes:ListOfBatchJobsResponse");
        int n = nodeList.getLength();
        if (nodeList != null) {
            for (int i = 0; i < n; ++i) {
                object2 = (Element)nodeList.item(i);
                object = object2.getElementsByTagName("jobName");
                for (int j = 0; j < object.getLength(); ++j) {
                    Element element = (Element)object.item(j);
                    String string5 = element.getAttribute("repo");
                    String string6 = this.getCharacterDataFromElement(element);
                    this.printOut("jobName :" + string6 + "  repoName :" + string5, true);
                    hashtable.put(string6, string5);
                }
            }
        }
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        this.printOut("jobHT    :" + this.jobHT, true);
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            String string7 = (String)hashtable.get(object);
            hashtable2 = (Hashtable<String, Double>)this.jobHT.get(string7 + "/" + (String)object);
            if (hashtable2 == null || hashtable2.size() == 0 || hashtable2.isEmpty()) {
                hashtable2 = new Hashtable<String, Double>();
                hashtable2.put(SUCCEEDED, new Double(0.0));
                hashtable2.put(ERROR, new Double(0.0));
                hashtable2.put(RECOVERED, new Double(0.0));
                double d = this.getBatchJobRunIDsCount(string, string7, (String)object, RUNNING, true);
                double d2 = this.getBatchJobRunIDsCount(string, string7, (String)object, WARNING, true);
                hashtable2.put(RUNNING, new Double(d));
                hashtable2.put(WARNING, new Double(d2));
                hashtable2.put(MAX_EXECUTION_TIME, new Double(-5.0));
                this.jobHT.put(string7 + "/" + (String)object, hashtable2);
                this.maxRunJobId = "";
                this.maxRepoName = "";
                this.maxJobName = "";
                this.maxObjId = "";
                this.maxExectionTime = -5.0;
            }
            this.getBatchJobExeDetail(string, (String)object, string7, hashtable2);
            if (!(this.maxExectionTime > this.longRunningCutOff)) continue;
            ArrayList arrayList = this.getMonitorLog(string, this.maxRunJobId, this.maxRepoName, this.maxJobName);
            int n2 = arrayList.size();
            String string8 = "";
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < n2; ++i) {
                String string9 = "";
                String string10 = (String)arrayList.get(i);
                string8 = this.getMonitorPartialDDStr(string10);
                string9 = this.maxObjId + fieldSep + this.maxRunJobId + fieldSep + string8;
                arrayList2.add(string9);
            }
            if (arrayList2 == null || arrayList2.isEmpty() || arrayList2.size() <= 0) continue;
            this.maxExecutionDDHT.put(this.maxRepoName + "/" + this.maxJobName, arrayList2);
        }
        this.lastExecuteTimeStamp = this.getDate(System.currentTimeMillis(), new SimpleDateFormat(dateFormat));
        return this.jobHT;
    }

    private String getMonitorPartialDDStr(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() > 4) {
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = stringTokenizer.nextToken().trim();
            String string5 = stringTokenizer.nextToken().trim();
            String string6 = stringTokenizer.nextToken().trim();
            String string7 = stringTokenizer.nextToken().trim();
            string2 = string3 + fieldSep + string4 + fieldSep + string5 + fieldSep + string6 + fieldSep + string7;
        }
        return string2;
    }

    private void getBatchJobExeDetail(String string, String string2, String string3, Hashtable hashtable) {
        String string4 = this.getScanDateTime(this.scanPeriodInHours);
        String string5 = "";
        String string6 = this.getBatchJobExeDetailsSOAPRequest(string, string2, string3, string4, "");
        String string7 = EgSOAPUtil.invokeOperation((String)string6, (String)"jobAdmin=Get_BatchJob_ExeDetail", (String)this.targetURL, (String)"None", (String)"None");
        String string8 = EgSOAPUtil.formatXML((String)string7);
        Document document = this.getDocumentFromFormatString(string8);
        NodeList nodeList = document.getElementsByTagName("jobDetail");
        int n = nodeList.getLength();
        this.printOut("Job name  :" + string2, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string9 = "";
        for (int i = 0; i < n; ++i) {
            double d;
            Double d2;
            Node node = nodeList.item(i);
            Element element = (Element)node;
            Node node2 = element.getElementsByTagName("EndTime").item(0);
            String string10 = "-";
            try {
                string10 = node2.getFirstChild().getNodeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Date date = null;
            long l = 0L;
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                date = simpleDateFormat.parse(string10);
                l = date.getTime();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            long l2 = System.currentTimeMillis() - (long)(this.timeSinceLastTest * 1000.0);
            this.printOut("EndTime : " + string10, true);
            if (l2 >= l) continue;
            this.printOut("Entered in endTimeBetweenLastMeasure<endMillis  ");
            Node node3 = element.getElementsByTagName("runID").item(0);
            String string11 = node3.getFirstChild().getNodeValue();
            this.printOut("runID : " + string11, true);
            Node node4 = element.getElementsByTagName("ObjID").item(0);
            String string12 = node4.getFirstChild().getNodeValue();
            this.printOut("objID : " + string12, true);
            Node node5 = element.getElementsByTagName("StartTime").item(0);
            String string13 = node5.getFirstChild().getNodeValue();
            this.printOut("StartTime : " + string13, true);
            Node node6 = element.getElementsByTagName("ExecutionTime").item(0);
            String string14 = node6.getFirstChild().getNodeValue();
            this.printOut("ExecutionTime : " + string14, true);
            double d3 = 0.0;
            try {
                d3 = Double.parseDouble(string14);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (d3 > this.maxExectionTime) {
                this.maxExectionTime = d3;
                hashtable.put(MAX_EXECUTION_TIME, new Double(this.maxExectionTime));
                this.maxRunJobId = string11;
                this.maxRepoName = string3;
                this.maxJobName = string2;
                this.maxObjId = string12;
            }
            Node node7 = element.getElementsByTagName("Status").item(0);
            String string15 = node7.getFirstChild().getNodeValue();
            this.printOut("Status from WSDL : " + string15, true);
            Node node8 = element.getElementsByTagName("JobServerUsed").item(0);
            String string16 = node8.getFirstChild().getNodeValue();
            this.printOut("JobServerUsed : " + string16, true);
            if (string15.equalsIgnoreCase(SUCCEEDED)) {
                d2 = (Double)hashtable.get(string15);
                d = d2;
                hashtable.put(string15, new Double(d += 1.0));
                string9 = string12 + fieldSep + string11 + fieldSep + string13 + fieldSep + string10 + fieldSep + d3 + fieldSep + string16;
                arrayList2 = (ArrayList<String>)this.succededDDHT.get(string3 + "/" + string2);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>();
                    arrayList2.add(string9);
                    this.succededDDHT.put(string3 + "/" + string2, arrayList2);
                    continue;
                }
                arrayList2.add(string9);
                this.succededDDHT.put(string3 + "/" + string2, arrayList2);
                continue;
            }
            if (string15.equalsIgnoreCase(ERROR) || string15.equalsIgnoreCase(FAILED)) {
                d2 = (Double)hashtable.get(string15);
                d = d2;
                hashtable.put(string15, new Double(d += 1.0));
                String string17 = this.getErrorLog(string, string11, string3, string2);
                if (string17 == null || string17.trim().length() == 0) {
                    string17 = "-";
                }
                string9 = string12 + fieldSep + string11 + fieldSep + string13 + fieldSep + string10 + fieldSep + d3 + fieldSep + string16 + fieldSep + string17;
                arrayList = (ArrayList<String>)this.errorDDHT.get(string3 + "/" + string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string9);
                    this.errorDDHT.put(string3 + "/" + string2, arrayList);
                    continue;
                }
                arrayList.add(string9);
                this.errorDDHT.put(string3 + "/" + string2, arrayList);
                continue;
            }
            if (!string15.equalsIgnoreCase(RECOVERED)) continue;
            d2 = (Double)hashtable.get(string15);
            d = d2;
            hashtable.put(string15, new Double(d += 1.0));
            string9 = string12 + fieldSep + string11 + fieldSep + string13 + fieldSep + string10 + fieldSep + d3 + fieldSep + string16;
            arrayList3 = (ArrayList<String>)this.recoveredDDHT.get(string3 + "/" + string2);
            if (arrayList == null) {
                arrayList3 = new ArrayList<String>();
                arrayList3.add(string9);
                this.recoveredDDHT.put(string3 + "/" + string2, arrayList3);
                continue;
            }
            arrayList3.add(string9);
            this.recoveredDDHT.put(string3 + "/" + string2, arrayList3);
        }
    }

    private String getScanDateTime(String string) {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = 24L;
        }
        long l2 = l * 60L * 60L * 1000L;
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        String string2 = this.getDate(l4, new SimpleDateFormat(dateFormat));
        return string2;
    }

    private double getBatchJobRunIDsCount(String string, String string2, String string3, String string4, boolean bl) {
        Document document = this.getBatchJobRunIDsDoc(string, string2, string3, string4);
        NodeList nodeList = document.getElementsByTagName("run");
        double d = nodeList.getLength();
        return d;
    }

    private String getErrorLog(String string, String string2, String string3, String string4) {
        String string5 = this.getErrorLogSOAPRequest(string, string2, string3, string4);
        String string6 = EgSOAPUtil.invokeOperation((String)string5, (String)GET_ERROR_LOG_SOAP_ACTION_URL, (String)this.targetURL, (String)"None", (String)"None");
        String string7 = EgSOAPUtil.formatXML((String)string6);
        String string8 = "";
        Document document = this.getDocumentFromFormatString(string7);
        NodeList nodeList = document.getElementsByTagName("localtypes:ErrorLogResponse");
        if (nodeList != null) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getElementsByTagName(ERROR);
            Element element2 = (Element)nodeList2.item(0);
            string8 = this.getCharacterDataFromElement(element2);
            this.printOut("error :" + string8, true);
        }
        return string8;
    }

    private ArrayList getMonitorLog(String string, String string2, String string3, String string4) {
        Object object;
        Object object2;
        Object object3;
        String string5 = this.getMonitorLogSOAPRequest(string, string2, string3, string4);
        String string6 = EgSOAPUtil.invokeOperation((String)string5, (String)GET_MONITOR_LOG_SOAP_ACTION_URL, (String)this.targetURL, (String)"None", (String)"None");
        String string7 = EgSOAPUtil.formatXML((String)string6);
        this.printOut("Max job name :" + this.maxJobName, true);
        Document document = this.getDocumentFromFormatString(string7);
        NodeList nodeList = document.getElementsByTagName("localtypes:MonitorLogResponse");
        int n = nodeList.getLength();
        String string8 = "";
        if (nodeList != null) {
            object3 = (Element)nodeList.item(0);
            object2 = object3.getElementsByTagName("monitor");
            object = (Element)object2.item(0);
            string8 = this.getCharacterDataFromElement((Element)object);
        }
        object3 = new StringTokenizer(string8, "+-");
        object2 = new ArrayList();
        while (((StringTokenizer)object3).hasMoreElements()) {
            object = ((StringTokenizer)object3).nextToken();
            this.printOut((String)object);
            ((ArrayList)object2).add(object);
        }
        return object2;
    }

    private String getMonitorLogSOAPRequest(String string, String string2, String string3, String string4) {
        String string5 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string5 = string5 + "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
        string5 = string5 + "<soap:Header>";
        string5 = string5 + "<session xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string5 = string5 + "<SessionID>" + string + "</SessionID>";
        string5 = string5 + "</session>";
        string5 = string5 + "</soap:Header>";
        string5 = string5 + "<soap:Body>";
        string5 = string5 + "<MonitorLogRequest xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string5 = string5 + "<runID xmlns=\"\">" + string2 + "</runID>";
        string5 = string5 + "<repoName xmlns=\"\">" + string3 + "</repoName>";
        string5 = string5 + "<page xmlns=\"\">0</page>";
        string5 = string5 + "</MonitorLogRequest>";
        string5 = string5 + "</soap:Body>";
        string5 = string5 + "</soap:Envelope>";
        return string5;
    }

    protected Document getBatchJobRunIDsDoc(String string, String string2, String string3, String string4) {
        this.printOut("Job Status :" + string4, true);
        String string5 = this.getBatchJobRunIDsDocSOAPRequest(string, string2, string3, string4);
        String string6 = EgSOAPUtil.invokeOperation((String)string5, (String)"jobAdmin=Get_BatchJob_RunIDs", (String)this.targetURL, (String)"None", (String)"None");
        String string7 = EgSOAPUtil.formatXML((String)string6);
        Document document = this.getDocumentFromFormatString(string7);
        return document;
    }

    private String getBatchJobExeDetailsSOAPRequest(String string, String string2, String string3, String string4, String string5) {
        String string6 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string6 = string6 + "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
        string6 = string6 + "<soap:Header>";
        string6 = string6 + "<session xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string6 = string6 + "<SessionID>" + string + "</SessionID>";
        string6 = string6 + "</session>";
        string6 = string6 + "</soap:Header>";
        string6 = string6 + "<soap:Body>";
        string6 = string6 + "<jobExcutionDetailsRequest xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string6 = string6 + "<jobName xmlns=\"\">" + string2 + "</jobName>";
        string6 = string6 + "<repoName xmlns=\"\">" + string3 + "</repoName>";
        string6 = string6 + "<startTime xmlns=\"\">" + string4 + "</startTime>";
        string6 = string6 + "<endTime xmlns=\"\">" + string5 + "</endTime>";
        string6 = string6 + "</jobExcutionDetailsRequest>";
        string6 = string6 + "</soap:Body>";
        string6 = string6 + "</soap:Envelope>";
        return string6;
    }

    private String getErrorLogSOAPRequest(String string, String string2, String string3, String string4) {
        String string5 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string5 = string5 + "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
        string5 = string5 + "<soap:Header>";
        string5 = string5 + "<session xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string5 = string5 + "<SessionID>" + string + "</SessionID>";
        string5 = string5 + "</session>";
        string5 = string5 + "</soap:Header>";
        string5 = string5 + "<soap:Body>";
        string5 = string5 + "<ErrorLogRequest xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string5 = string5 + "<runID xmlns=\"\">" + string2 + "</runID>";
        string5 = string5 + "<repoName xmlns=\"\">" + string3 + "</repoName>";
        string5 = string5 + "<page xmlns=\"\">1</page>";
        string5 = string5 + "</ErrorLogRequest>";
        string5 = string5 + "</soap:Body>";
        string5 = string5 + "</soap:Envelope>";
        return string5;
    }

    static {
        MEASURE_ORDER_ARRAYLIST.add(SUCCEEDED);
        MEASURE_ORDER_ARRAYLIST.add(ERROR);
        MEASURE_ORDER_ARRAYLIST.add(RECOVERED);
        MEASURE_ORDER_ARRAYLIST.add(RUNNING);
        MEASURE_ORDER_ARRAYLIST.add(WARNING);
        MEASURE_ORDER_ARRAYLIST.add(MAX_EXECUTION_TIME);
    }
}

