/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CBStatusTest
extends GenericTest {
    boolean isSsl = false;

    public CBStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        String string = this.getValueForParam("ssl");
        if (string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true"))) {
            this.isSsl = true;
        }
        if (this.isSsl) {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var5_5 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        CBStatusTest cBStatusTest = new CBStatusTest(stringArray);
        cBStatusTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList arrayList2 = new ArrayList();
        arrayList2 = this.returnMeasures();
        if (arrayList2 == null || arrayList2.size() < 3) {
            arrayList.add(new Double(0.0));
            arrayList.add(new Double(0.0));
            arrayList.add(new Double(-5.0));
            this.addNewMeasure(arrayList);
            return;
        }
        String string = (String)arrayList2.get(0);
        if (string != null && string.equalsIgnoreCase("CB_IS_OKAY")) {
            arrayList.add(new Double(100.0));
        } else {
            arrayList.add(new Double(0.0));
        }
        Double d = (Double)arrayList2.get(1);
        arrayList.add(d);
        Double d2 = (Double)arrayList2.get(2);
        arrayList.add(d2);
        this.addNewMeasure(arrayList);
    }

    private ArrayList returnMeasures() {
        HttpURLConnection httpURLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        ArrayList arrayList = new ArrayList();
        String string = "cb_status";
        String string2 = "index.pl";
        String string3 = "http://";
        if (this.isSsl) {
            string3 = "https://";
        }
        String string4 = string3 + this.targetHost + ":" + this.portNo + "/" + string2 + "?action=" + string;
        try {
            long l = System.currentTimeMillis();
            URL uRL = new URL(string4);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList2 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                arrayList2 = connectionThread.data;
            }
            long l2 = System.currentTimeMillis();
            connectionThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (arrayList2 == null || arrayList2.size() == 0) {
                return null;
            }
            String string5 = "";
            for (int i = 0; i < arrayList2.size(); ++i) {
                string5 = string5 + " " + (String)arrayList2.get(i);
            }
            long l3 = l2 - l;
            double d = (double)l3 / 1000.0;
            if (d < 0.0) {
                d = -5.0;
            }
            StringBuffer stringBuffer = this.stripHTMLTags(string5);
            String string6 = "Untitled Document";
            stringBuffer.delete(0, string6.length() + 3);
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            arrayList3.add(stringBuffer.toString());
            arrayList3.add(new Double(100.0));
            arrayList3.add(new Double(d));
            return arrayList3;
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private StringBuffer stripHTMLTags(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.indexOf("<");
        int n2 = string.indexOf(">");
        while (n != -1 && n2 >= 0) {
            int n3 = n2 + 1;
            stringBuffer.delete(n, n2 + 1);
            n = stringBuffer.toString().indexOf("<");
            n2 = stringBuffer.toString().indexOf(">");
        }
        return stringBuffer;
    }
}

