/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

public class CifsStatsTest
extends NAUSDBase {
    private static String[] counters = new String[]{"cifs_ops", "cifs_latency", "cifs_read_ops", "cifs_write_ops", "cifs_read_latency", "cifs_write_latency", "cifs_latency_base"};
    private static final int measureCount = 7;
    private boolean cifsstat = true;
    private ArrayList prevlist = new ArrayList();

    public CifsStatsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = this.getConnection();
        if (naServer == null) {
            return;
        }
        int n = this.getCifsStatus(naServer);
        this.closeConnection(naServer);
        Hashtable hashtable2 = this.getPerfInstance(naServer, counters, "cifs", null);
        ArrayList arrayList = (ArrayList)hashtable2.get("cifs");
        if (this.prevlist == null || this.prevlist.size() == 0) {
            if (arrayList != null && arrayList.size() > 0) {
                this.prevlist = arrayList;
            }
            this.printOut("INFO", "Returning after setting prevMeasList to " + this.prevlist);
            this.defaultMeasure();
            return;
        }
        if (arrayList == null || arrayList.size() == 0) {
            this.prevlist = null;
            this.closeConnection(naServer);
            return;
        }
        ArrayList arrayList2 = this.getDiffList(arrayList, this.prevlist);
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        Double d = this.divide(arrayList2.get(1), arrayList2.get(0));
        Double d2 = this.divide(arrayList2.get(2), arrayList2.get(7));
        Double d3 = this.divide(arrayList2.get(3), arrayList2.get(0));
        Double d4 = this.divide(arrayList2.get(4), arrayList2.get(0));
        Double d5 = this.divide(arrayList2.get(5), arrayList2.get(3));
        Double d6 = this.divide(arrayList2.get(6), arrayList2.get(4));
        arrayList3.add(new Double(n));
        arrayList3.add(d);
        arrayList3.add(d2);
        arrayList3.add(d3);
        arrayList3.add(d4);
        arrayList3.add(d5);
        arrayList3.add(d6);
        this.addNewMeasure(arrayList3);
        this.prevlist = arrayList;
    }

    private int getCifsStatus(NaServer naServer) {
        int n = -5;
        try {
            NaElement naElement = new NaElement("cifs-status");
            Object object = this.execONTAPIlog(naServer, naElement);
            NaAPIFailedException naAPIFailedException = null;
            NaElement naElement2 = null;
            if (object instanceof Exception) {
                if (object instanceof NaAPIFailedException) {
                    naAPIFailedException = (NaAPIFailedException)object;
                    int n2 = naAPIFailedException.getErrno();
                    if (13008 == n2) {
                        if (this.cifsstat) {
                            this.logToErrorFile("INFO", "CifsStatsTest", "NaAPIFailedException This test cannot be monitored without Cifs license");
                            this.cifsstat = false;
                        }
                    } else {
                        this.logToErrorFile("INFO", "CifsStatsTest", "NaAPIFailedException API is not Executing" + naAPIFailedException.toString());
                    }
                } else {
                    this.logToErrorFile("INFO", "CifsStatsTest", "Exception" + object.toString());
                }
            } else {
                naElement2 = (NaElement)object;
                String string = naElement2.getChildContent("status");
                if (string.equalsIgnoreCase("starting")) {
                    n = 1;
                } else if (string.equalsIgnoreCase("started")) {
                    n = 2;
                } else if (string.equalsIgnoreCase("stopping")) {
                    n = 3;
                } else if (string.equalsIgnoreCase("stopped")) {
                    n = 4;
                }
            }
        }
        catch (Exception exception) {
            n = -5;
        }
        return n;
    }

    private void defaultMeasure() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < 7; ++i) {
            arrayList.add(new Double(-5.0));
        }
        this.addNewMeasure(arrayList);
    }

    public static void main(String[] stringArray) {
        CifsStatsTest cifsStatsTest = new CifsStatsTest(stringArray);
        while (true) {
            try {
                while (true) {
                    cifsStatsTest.computeMeasures(new Hashtable());
                    Thread.sleep(10000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

