/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class CisRunSrvcTest
extends EgSnmpGenericTest {
    private boolean isFirst = true;

    public CisRunSrvcTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.isNewDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasures(".1.3.6.1.2.1.54.1.1.1.1.3");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info ", "CisRunSrvcTest No Cisco services available for ", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                string = string.trim();
                System.out.println("[" + this.entity + "] key ==>" + string);
                Hashtable hashtable3 = this.getMeasures1(".1.3.6.1.2.1.54.1.2.1.1.3." + string);
                if (hashtable3 == null && hashtable3.size() == 0) {
                    this.logToErrorFile("Info ", "CisRunSrvcTest State OID is retruning null value for ", this.targetHost);
                    return;
                }
                Enumeration enumeration2 = hashtable3.keys();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    String string4 = (String)hashtable3.get(string3);
                    double d = -5.0;
                    if (string4 != null && string4.trim().length() > 0) {
                        try {
                            d = Double.parseDouble(string4);
                        }
                        catch (Exception exception) {
                            this.logToErrorFile("Exception ", "CisRunSrvcTest Exception occured in double conversion for ", this.targetHost);
                            d = -5.0;
                        }
                    }
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(d));
                    System.out.println("[" + this.entity + "] Service Name ==>" + string2 + " MeasureList ==>" + arrayList);
                    this.addNewMeasure(string2, arrayList);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception ", "CisRunSrvcTest Exception occured in computeMeasures for ", this.targetHost);
            exception.printStackTrace();
        }
    }

    private Hashtable getMeasures(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string2 = this.lhs[i].trim();
                    if (this.rhs[i] != null && this.rhs[i].trim().length() > 0) {
                        string3 = this.rhs[i].trim();
                    }
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CisRunSrvcTest Exception occured in getMeasures() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    private Hashtable getMeasures1(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        String string3 = "";
        try {
            if (bl && this.lhs != null && this.lhs.length > 0) {
                string2 = this.lhs[0];
                string3 = this.rhs[0];
                hashtable.put(string2, string3);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CisRunSrvcTest Exception occured in getMeasures1() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        CisRunSrvcTest cisRunSrvcTest = new CisRunSrvcTest(stringArray);
        cisRunSrvcTest.computeMeasures(new Hashtable());
    }
}

