/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClusterHttpTest
extends EgSnmpGenericTest {
    private static final String OID_clusterName = ".1.3.6.1.4.1.6213.2.4.2.5.1.2";
    private static final String OID_clusterIndex = ".1.3.6.1.4.1.6213.2.4.2.5.1.1";
    private static final String OID_clusterTable = ".1.3.6.1.4.1.6213.2.4.2.2";
    private static int numMeasures = 4;
    private int numClusters;
    private int discCount = 12;
    private int count = 0;
    private Hashtable prevListenReqActiveMap = new Hashtable();
    private Hashtable prevTargetRespCode3xxMap = new Hashtable();
    private Hashtable prevTargetRespCode4xxMap = new Hashtable();
    private Hashtable prevTargetRespCode5xxMap = new Hashtable();
    private Hashtable indexToName = new Hashtable();

    public ClusterHttpTest(String[] stringArray) {
        super(stringArray);
        this.isSnmpV2 = true;
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
    }

    private double getValue(int n) {
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    private void discoverClusters() {
        this.indexToName = new Hashtable();
        boolean bl = this.runSnmpCmdForOid(OID_clusterName);
        if (bl && this.rhs != null && this.rhs.length > 0) {
            for (int i = 0; i < this.rhs.length; ++i) {
                this.rhs[i] = this.rhs[i].replace('\"', ' ').trim();
                this.rhs[i] = this.rhs[i].replace('\'', ' ').trim();
                this.indexToName.put(this.lhs[i], this.rhs[i]);
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable4 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable5 = new Hashtable<String, Double>();
        if (this.count == 0) {
            this.discoverClusters();
        }
        ++this.count;
        if (this.count == this.discCount) {
            this.count = 0;
        }
        if (this.indexToName.size() == 0) {
            this.prevListenReqActiveMap = new Hashtable();
            this.prevTargetRespCode3xxMap = new Hashtable();
            this.prevTargetRespCode4xxMap = new Hashtable();
            this.prevTargetRespCode5xxMap = new Hashtable();
            return;
        }
        if (this.runSnmpCmdForOid(OID_clusterTable)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                Double d9;
                double d10;
                int n = this.lhs[i].lastIndexOf(46);
                string = "";
                if (n > 0) {
                    string = this.lhs[i].substring(n + 1, this.lhs[i].length());
                }
                if (this.lhs[i].startsWith("1.2.")) {
                    d10 = this.getValue(i);
                    bl = true;
                    try {
                        d9 = (Double)this.prevListenReqActiveMap.get(this.lhs[i]);
                        d = d9 != null ? d9 : -5.0;
                    }
                    catch (Exception exception) {
                        d = -5.0;
                    }
                    if (d >= 0.0) {
                        d5 = d10 - d;
                        d5 = d5 < 0.0 ? -5.0 : d5;
                    }
                    d = d10;
                    this.prevListenReqActiveMap.put(this.lhs[i], new Double(d10));
                    hashtable2.put(string, new Double(d5));
                    continue;
                }
                if (this.lhs[i].startsWith("1.28.")) {
                    d10 = this.getValue(i);
                    bl2 = true;
                    try {
                        d9 = (Double)this.prevTargetRespCode3xxMap.get(this.lhs[i]);
                        d2 = d9 != null ? d9 : -5.0;
                    }
                    catch (Exception exception) {
                        d2 = -5.0;
                    }
                    if (d2 >= 0.0) {
                        d6 = d10 - d2;
                        d6 = d6 < 0.0 ? -5.0 : d6;
                    }
                    d2 = d10;
                    this.prevTargetRespCode3xxMap.put(this.lhs[i], new Double(d10));
                    hashtable3.put(string, new Double(d6));
                    continue;
                }
                if (this.lhs[i].startsWith("1.30.")) {
                    d10 = this.getValue(i);
                    bl3 = true;
                    try {
                        d9 = (Double)this.prevTargetRespCode4xxMap.get(this.lhs[i]);
                        d3 = d9 != null ? d9 : -5.0;
                    }
                    catch (Exception exception) {
                        d3 = -5.0;
                    }
                    if (d3 >= 0.0) {
                        d7 = d10 - d3;
                        d7 = d7 < 0.0 ? -5.0 : d7;
                    }
                    d3 = d10;
                    this.prevTargetRespCode4xxMap.put(this.lhs[i], new Double(d10));
                    hashtable4.put(string, new Double(d7));
                    continue;
                }
                if (!this.lhs[i].startsWith("1.31.")) continue;
                d10 = this.getValue(i);
                bl4 = true;
                try {
                    d9 = (Double)this.prevTargetRespCode5xxMap.get(this.lhs[i]);
                    d4 = d9 != null ? d9 : -5.0;
                }
                catch (Exception exception) {
                    d4 = -5.0;
                }
                if (d4 >= 0.0) {
                    d8 = d10 - d4;
                    d8 = d8 < 0.0 ? -5.0 : d7;
                }
                d4 = d10;
                this.prevTargetRespCode5xxMap.put(this.lhs[i], new Double(d10));
                hashtable5.put(string, new Double(d8));
            }
        }
        if (!bl) {
            this.prevListenReqActiveMap = new Hashtable();
        }
        if (!bl2) {
            this.prevTargetRespCode3xxMap = new Hashtable();
        }
        if (!bl3) {
            this.prevTargetRespCode4xxMap = new Hashtable();
        }
        if (!bl4) {
            this.prevTargetRespCode5xxMap = new Hashtable();
        }
        Enumeration enumeration = this.indexToName.keys();
        while (enumeration.hasMoreElements()) {
            Double d11 = null;
            string = (String)enumeration.nextElement();
            String string2 = (String)this.indexToName.get(string);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            d11 = (Double)hashtable2.get(string);
            if (d11 == null) {
                arrayList.add(new Double(-5.0));
            } else {
                arrayList.add(new Double(d11));
            }
            d11 = (Double)hashtable3.get(string);
            if (d11 == null) {
                arrayList.add(new Double(-5.0));
            } else {
                arrayList.add(new Double(d11));
            }
            d11 = (Double)hashtable4.get(string);
            if (d11 == null) {
                arrayList.add(new Double(-5.0));
            } else {
                arrayList.add(new Double(d11));
            }
            d11 = (Double)hashtable5.get(string);
            if (d11 == null) {
                arrayList.add(new Double(-5.0));
            } else {
                arrayList.add(new Double(d11));
            }
            this.addNewMeasure(string2, arrayList);
        }
    }

    public static void main(String[] stringArray) {
        ClusterHttpTest clusterHttpTest = new ClusterHttpTest(stringArray);
        while (true) {
            clusterHttpTest.computeMeasures(new Hashtable());
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
    }
}

