/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClusterStatusTest
extends EgSnmpGenericTest {
    private static final String OID_clusterName = ".1.3.6.1.4.1.6213.2.4.2.5.1.2";
    private static final String OID_clusterIndex = ".1.3.6.1.4.1.6213.2.4.2.5.1.1";
    private static final String OID_clusterTable = ".1.3.6.1.4.1.6213.2.4.2.5";
    private static int numMeasures = 1;
    private int numClusters;
    private int count = 0;
    private int discCount = 12;
    private Hashtable indexToName = new Hashtable();

    public ClusterStatusTest(String[] stringArray) {
        super(stringArray);
        this.isSnmpV2 = true;
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
    }

    private double getValue(int n) {
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    private void discoverClusters() {
        this.indexToName = new Hashtable();
        boolean bl = this.runSnmpCmdForOid(OID_clusterName);
        if (bl && this.rhs != null && this.rhs.length > 0) {
            for (int i = 0; i < this.rhs.length; ++i) {
                this.rhs[i] = this.rhs[i].replace('\"', ' ').trim();
                this.rhs[i] = this.rhs[i].replace('\'', ' ').trim();
                this.indexToName.put(this.lhs[i], this.rhs[i]);
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        double d = 0.0;
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        if (this.count == 0) {
            this.discoverClusters();
        }
        ++this.count;
        if (this.count == this.discCount) {
            this.count = 0;
        }
        if (this.indexToName.size() == 0) {
            return;
        }
        if (this.runSnmpCmdForOid(OID_clusterTable)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                int n = this.lhs[i].lastIndexOf(46);
                string = "";
                if (n > 0) {
                    string = this.lhs[i].substring(n + 1, this.lhs[i].length());
                }
                if (this.lhs[i].startsWith("1.4.")) {
                    d = this.getValue(i);
                    double d2 = d = d < 0.0 ? 0.0 : d;
                    if (d >= 1.0) {
                        d = 100.0;
                    }
                }
                hashtable2.put(string, new Double(d));
            }
        }
        Enumeration enumeration = this.indexToName.keys();
        while (enumeration.hasMoreElements()) {
            Double d3 = null;
            string = (String)enumeration.nextElement();
            String string2 = (String)this.indexToName.get(string);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            d3 = (Double)hashtable2.get(string);
            if (d3 == null) {
                arrayList.add(new Double(-5.0));
            } else {
                arrayList.add(new Double(d3));
            }
            this.addNewMeasure(string2, arrayList);
        }
    }

    public static void main(String[] stringArray) {
        ClusterStatusTest clusterStatusTest = new ClusterStatusTest(stringArray);
        clusterStatusTest.computeMeasures(new Hashtable());
    }
}

