/*
 * Decompiled with CFR 0.152.
 */
import com.citrix.mas.nitro.exception.nitro_exception;
import com.citrix.mas.nitro.resource.base.EmptyHostnameVerifier;
import com.citrix.mas.nitro.resource.base.EmptyTrustManager;
import com.citrix.mas.nitro.service.nitro_service;
import com.eg.EgSSL;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CtxNsIsValidator
extends EgServerValidator {
    private String host = "";
    private String insight_username = "";
    private String insight_password = "";
    private String ssl = "";
    private String message = "";
    private ArrayList validationMsgs = new ArrayList();

    public CtxNsIsValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-Insight_username")) {
                    this.insight_username = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-Insight_password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.insight_password = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                this.ssl = string3;
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public void validate() {
        try {
            if (!this.getConnection(this.host, this.insight_username, this.insight_password)) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Citrix NetScaler Insight Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                } else {
                    this.validationMsgs.add("Citrix NetScaler Insight Connectivity$#$Failed - " + this.message);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                }
                return;
            }
            this.validationMsgs.add("Citrix NetScaler Insight Connectivity$#$OK");
            this.validationMsgs.add("Host IP/Name$#$OK");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getConnection(String string, String string2, String string3) {
        boolean bl = false;
        nitro_service nitro_service2 = null;
        String string4 = "http";
        if (this.ssl != null && this.ssl.equalsIgnoreCase("true")) {
            string4 = "https";
            this.installSSL();
        }
        try {
            nitro_service2 = new nitro_service(string, string4);
            if (nitro_service2 != null) {
                nitro_service2.login(string2, string3, new Integer(120));
                bl = nitro_service2.isLogin();
                this.message = "Connected";
                nitro_service2.logout();
            }
        }
        catch (ConnectException connectException) {
            this.message = "Invalid ip address or hostname";
        }
        catch (SocketException socketException) {
            this.message = "Invalid protocol(HTTP/HTTPS)";
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            this.message = "SSL handshake exception";
        }
        catch (nitro_exception nitro_exception2) {
            this.message = "Invalid username or password";
        }
        catch (Exception exception) {
            this.message = this.getStackTraceAsString(exception);
        }
        return bl;
    }

    public void installSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_4 = null;
            EmptyTrustManager emptyTrustManager = new EmptyTrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{emptyTrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new EmptyHostnameVerifier());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        CtxNsIsValidator ctxNsIsValidator = new CtxNsIsValidator(stringArray, new Boolean(true));
        ctxNsIsValidator.getValidationMsgs();
    }
}

