/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Db2DPFAgentTest
extends GenericTest {
    private static final int MEASURES_COUNT = 5;
    private String user;
    private String password;
    private String dbName;
    private String dbInfo;
    private boolean isValid = false;
    private Hashtable lastValues;
    private ArrayList activeDatabases;

    public Db2DPFAgentTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        String string = this.getValueForParam("debug");
        if (string == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
        this.lastValues = new Hashtable();
    }

    public static void main(String[] stringArray) {
        Db2DPFAgentTest db2DPFAgentTest = new Db2DPFAgentTest(stringArray);
        db2DPFAgentTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getTransactionStats();
        if (debug) {
            System.out.println("[Db2DPFTransTest]measureDt=========>" + hashtable2);
        }
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (debug) {
                System.out.println("[Db2DPFAgentTest]strDbName======>" + string);
                System.out.println("[Db2DPFAgentTest]activeDatabases======>" + this.activeDatabases);
            }
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTransactionStats() {
        String string;
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        double d10 = -5.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        DB2JdbcHelper dB2JdbcHelper = null;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        if (!this.isValid) {
            try {
                this.isValid = true;
                string = "SELECT CURRENT SERVER FROM SYSIBM.SYSDUMMY1";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    this.dbInfo = resultSet.getString(1);
                }
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeResultSet(resultSet);
            }
            catch (Exception exception) {
                try {
                    System.out.println("Exception1 occured in Db2DPFAgentTest " + exception);
                    dB2JdbcHelper.closeStatement(statement);
                    dB2JdbcHelper.closeResultSet(resultSet);
                }
                catch (Throwable throwable) {
                    dB2JdbcHelper.closeStatement(statement);
                    dB2JdbcHelper.closeResultSet(resultSet);
                    throw throwable;
                }
            }
        }
        string = "SELECT DBPARTITIONNUM,AGENTS_REGISTERED,AGENTS_WAITING_ON_TOKEN,IDLE_AGENTS,AGENTS_FROM_POOL,AGENTS_CREATED_EMPTY_POOL,AGENTS_STOLEN FROM table(SNAP_GET_DBM()) DBM order by DBPARTITIONNUM";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (debug) {
                System.out.println("[Db2DPFAgentTest]query=======>" + string);
            }
            this.activeDatabases = new ArrayList();
            ArrayList<Double> arrayList = null;
            while (resultSet.next()) {
                String string2 = resultSet.getString("DBPARTITIONNUM");
                String string3 = this.dbInfo + "_" + string2;
                d = resultSet.getDouble("AGENTS_REGISTERED");
                d2 = resultSet.getDouble("AGENTS_WAITING_ON_TOKEN");
                d3 = resultSet.getDouble("IDLE_AGENTS");
                d4 = resultSet.getDouble("AGENTS_FROM_POOL");
                d5 = resultSet.getDouble("AGENTS_CREATED_EMPTY_POOL");
                d6 = resultSet.getDouble("AGENTS_STOLEN");
                d8 = d2 / d * 100.0;
                if (debug) {
                    System.out.println("[Db2DPFAgentTest]curr AGENTS_REGISTERED===>" + d + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]curr AGENTS_WAITING_ON_TOKEN===>" + d2 + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]curr IDLE_AGENTS===>" + d3 + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]curr AGENTS_FROM_POOL===>" + d4 + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]curr AGENTS_CREATED_EMPTY_POOL===>" + d5 + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]curr AGENTS_STOLEN===>" + d6 + "  info====>" + string3);
                }
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList2 = (ArrayList<Double>)this.lastValues.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Double>(3);
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d6));
                } else {
                    double d11 = (Double)arrayList2.get(0);
                    double d12 = (Double)arrayList2.get(1);
                    double d13 = (Double)arrayList2.get(2);
                    double d14 = d4 - d11;
                    double d15 = d5 - d12;
                    double d16 = d6 - d13;
                    double d17 = d14 + d15;
                    d9 = d17 > 0.0 ? d14 / d17 * 100.0 : 100.0;
                    if (d9 == 0.0) {
                        d9 = 100.0;
                    }
                    if (d16 >= 0.0 || this.timeSinceLastTest > 0.0) {
                        d7 = d16 / this.timeSinceLastTest;
                    }
                    if (debug) {
                        System.out.println("[Db2DPFAgentTest]prev AGENTS_FROM_POOL===>" + d11 + "  info====>" + string3);
                        System.out.println("[Db2DPFAgentTest]prev AGENTS_CREATED_EMPTY_POOL===>" + d12 + "  info====>" + string3);
                        System.out.println("[Db2DPFAgentTest]prev AGENTS_STOLEN===>" + d13 + "  info====>" + string3);
                    }
                    arrayList2.set(0, new Double(d4));
                    arrayList2.set(1, new Double(d5));
                    arrayList2.set(2, new Double(d6));
                }
                if (debug) {
                    System.out.println("[Db2DPFAgentTest]Total_agents===>" + d + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]Agents_idle===>" + d3 + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]Agents_waiting_on_token===>" + d8 + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]Agents_creation_ratio===>" + d9 + "  info====>" + string3);
                    System.out.println("[Db2DPFAgentTest]Agents_stolen===>" + d7 + "  info====>" + string3);
                }
                this.lastValues.put(string3, arrayList2);
                arrayList = new ArrayList<Double>(5);
                arrayList.add(new Double(d));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d8));
                arrayList.add(new Double(d9));
                arrayList.add(new Double(d7));
                hashtable.put(string3, arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured in Db2DPFAgentTest " + exception);
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        if (debug) {
            System.out.println("[Db2DPFAgentTest]getNotAvailableMeasures........");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(5);
        for (int i = 0; i < 5; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

