/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Db2DPFDbmTest
extends GenericTest {
    private static final int MEASURES_COUNT = 4;
    private String user;
    private String password;
    private String dbName;
    private String dbInfo;
    private boolean isValid = false;
    private Hashtable lastValues;
    private ArrayList activeDatabases;

    public Db2DPFDbmTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.setMeasureCount(4);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        String string = this.getValueForParam("debug");
        if (string == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
        this.lastValues = new Hashtable();
    }

    public static void main(String[] stringArray) {
        Db2DPFDbmTest db2DPFDbmTest = new Db2DPFDbmTest(stringArray);
        db2DPFDbmTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getTransactionStats();
        if (debug) {
            System.out.println("[Db2DPFDbmTEST]measureDt=====>" + hashtable2);
        }
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (debug) {
                System.out.println("[Db2DPFDbmtTest]strDbName======>" + string);
                System.out.println("[Db2DPFDbmTest]activeDatabases======>" + this.activeDatabases);
            }
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTransactionStats() {
        String string;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        DB2JdbcHelper dB2JdbcHelper = null;
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        if (!this.isValid) {
            try {
                this.isValid = true;
                string = "SELECT CURRENT SERVER FROM SYSIBM.SYSDUMMY1";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    this.dbInfo = resultSet.getString(1);
                }
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeResultSet(resultSet);
            }
            catch (Exception exception) {
                try {
                    System.out.println("Exception1 occured in Db2DbmTest " + exception);
                    dB2JdbcHelper.closeStatement(statement);
                    dB2JdbcHelper.closeResultSet(resultSet);
                }
                catch (Throwable throwable) {
                    dB2JdbcHelper.closeStatement(statement);
                    dB2JdbcHelper.closeResultSet(resultSet);
                    throw throwable;
                }
            }
        }
        string = "SELECT DBPARTITIONNUM,POST_THRESHOLD_SORTS,PIPED_SORTS_REQUESTED,PIPED_SORTS_ACCEPTED,POST_THRESHOLD_HASH_JOINS   FROM TABLE(SNAP_GET_DBM()) DBM order by DBPARTITIONNUM";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (debug) {
                System.out.println("[Db2DPFDbmTest]query=======>" + string);
            }
            this.activeDatabases = new ArrayList();
            ArrayList<Double> arrayList = null;
            while (resultSet.next()) {
                String string2 = resultSet.getString("DBPARTITIONNUM");
                String string3 = this.dbInfo + "_" + string2;
                d = resultSet.getDouble("POST_THRESHOLD_SORTS");
                d2 = resultSet.getDouble("PIPED_SORTS_REQUESTED");
                d3 = resultSet.getDouble("PIPED_SORTS_ACCEPTED");
                d4 = resultSet.getDouble("POST_THRESHOLD_HASH_JOINS");
                if (debug) {
                    System.out.println("[Db2DPFDbmTest]curr POST_THRESHOLD_SORTS======>" + d + "  info===>" + string3);
                    System.out.println("[Db2DPFDbmTest]curr PIPED_SORTS_REQUESTED======>" + d2 + "  info===>" + string3);
                    System.out.println("[Db2DPFDbmTest]PIPED_SORTS_ACCEPTED======>" + d3 + "  info===>" + string3);
                    System.out.println("[Db2DPFDbmTest]POST_THRESHOLD_HASH_JOINS======>" + d4 + "  info===>" + string3);
                }
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList2 = (ArrayList<Double>)this.lastValues.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Double>(4);
                    arrayList2.add(new Double(d));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d4));
                } else {
                    double d9 = (Double)arrayList2.get(0);
                    double d10 = (Double)arrayList2.get(1);
                    double d11 = (Double)arrayList2.get(2);
                    double d12 = (Double)arrayList2.get(3);
                    double d13 = d - d9;
                    double d14 = d2 - d10;
                    double d15 = d3 - d11;
                    double d16 = d4 - d12;
                    if (this.timeSinceLastTest > 0.0) {
                        if (d13 >= 0.0) {
                            d5 = d13 / this.timeSinceLastTest;
                        }
                        if (d14 >= 0.0) {
                            d6 = d14 / this.timeSinceLastTest;
                        }
                        if (d16 >= 0.0) {
                            d8 = d16 / this.timeSinceLastTest;
                        }
                    }
                    d7 = d14 > 0.0 ? (d14 - d15) * 100.0 / d14 : 0.0;
                    if (debug) {
                        System.out.println("[Db2DPFDbmTest]prev POST_THRESHOLD_SORTS======>" + d9 + "  info===>" + string3);
                        System.out.println("[Db2DPFDbmTest]prev PIPED_SORTS_REQUESTED======>" + d10 + "  info===>" + string3);
                        System.out.println("[Db2DPFDbmTest]prev PIPED_SORTS_ACCEPTED======>" + d11 + "  info===>" + string3);
                        System.out.println("[Db2DPFDbmTest]prev POST_THRESHOLD_HASH_JOINS======>" + d12 + "  info===>" + string3);
                    }
                    arrayList2.set(0, new Double(d));
                    arrayList2.set(1, new Double(d2));
                    arrayList2.set(2, new Double(d3));
                    arrayList2.set(3, new Double(d4));
                }
                if (debug) {
                    System.out.println("[Db2DPFDbmTest]Post_threshold_sorts======>" + d5 + "  info===>" + string3);
                    System.out.println("[Db2DPFDbmTest]Piped_sorts_requested======>" + d6 + "  info===>" + string3);
                    System.out.println("[Db2DPFDbmTest]Piped_sorts_rejected======>" + d7 + "  info===>" + string3);
                    System.out.println("[Db2DPFDbmTest]Post_threshold_hash_join======>" + d8 + "  info===>" + string3);
                }
                this.lastValues.put(string3, arrayList2);
                arrayList = new ArrayList<Double>(4);
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d8));
                hashtable.put(string3, arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured in Db2DPFDBMTest " + exception);
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        if (debug) {
            System.out.println("[Db2DPFDbmTest]getNotAvailableMeasures........");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(4);
        for (int i = 0; i < 4; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

