/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Db2DPFDirectIOTest
extends GenericTest {
    private static final int MEASURES_COUNT = 3;
    private String user;
    private String password;
    private String dbName;
    private Hashtable prevValues = null;
    private ArrayList activeDatabases;
    private double Db2Version = 0.0;
    private boolean validCheckDone = false;
    String query = "";

    public Db2DPFDirectIOTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.setMeasureCount(3);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        String string = this.getValueForParam("debug");
        if (string == null) {
            debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            debug = true;
        }
        this.prevValues = new Hashtable();
    }

    public static void main(String[] stringArray) {
        Db2DPFDirectIOTest db2DPFDirectIOTest = new Db2DPFDirectIOTest(stringArray);
        db2DPFDirectIOTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getIoStats();
        if (debug) {
            System.out.println("[Db2DPFDirectIOTest]measureDt=====>" + hashtable2);
        }
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (debug) {
                System.out.println("[Db2DPFDirectIoTest]strDbName======>" + string);
                System.out.println("[Db2DPFDirectTest]activeDatabases======>" + this.activeDatabases);
            }
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getIoStats() {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        if (!this.validCheckDone) {
            this.Db2Version = this.getVersion();
        }
        if (this.Db2Version >= 9.1 && this.Db2Version <= 9.4) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME, DIRECT_READS, DIRECT_WRITES, POOL_DATA_P_READS, POOL_DATA_WRITES,POOL_INDEX_P_READS, POOL_INDEX_WRITES FROM TABLE(SNAP_GET_DB_V91(CAST (NULL AS VARCHAR(128)))) AS T order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.5 && this.Db2Version <= 9.6) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME, DIRECT_READS, DIRECT_WRITES, POOL_DATA_P_READS, POOL_DATA_WRITES,POOL_INDEX_P_READS, POOL_INDEX_WRITES FROM TABLE(SNAP_GET_DB_V95(CAST (NULL AS VARCHAR(128)))) AS T order by DBPARTITIONNUM";
        } else if (this.Db2Version >= 9.7) {
            this.query = "SELECT DBPARTITIONNUM,DB_NAME, DIRECT_READS, DIRECT_WRITES, POOL_DATA_P_READS, POOL_DATA_WRITES,POOL_INDEX_P_READS, POOL_INDEX_WRITES FROM TABLE(SNAP_GET_DB_V97(CAST (NULL AS VARCHAR(128)))) AS T order by DBPARTITIONNUM";
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.query);
            if (debug) {
                System.out.println("[Db2DPFDirectIoTest]query=====>" + this.query);
            }
            this.activeDatabases = new ArrayList();
            ArrayList<Double> arrayList = null;
            while (resultSet.next()) {
                String string = resultSet.getString("DBPARTITIONNUM");
                String string2 = resultSet.getString("DB_NAME");
                String string3 = string2 + "_" + string;
                d4 = resultSet.getDouble("DIRECT_READS");
                d5 = resultSet.getDouble("DIRECT_WRITES");
                d6 = resultSet.getDouble("POOL_DATA_P_READS");
                d7 = resultSet.getDouble("POOL_DATA_WRITES");
                d8 = resultSet.getDouble("POOL_INDEX_P_READS");
                d9 = resultSet.getDouble("POOL_INDEX_WRITES");
                if (debug) {
                    System.out.println("[Db2DPFDirectIoTest]curr DIRECT_READS===>" + d4 + "  info====>" + string3);
                    System.out.println("[Db2DPFDirectIoTest]curr DIRECT_WRITES===>" + d5 + "  info====>" + string3);
                    System.out.println("[Db2DPFDirectIoTest]curr POOL_DATA_P_READS===>" + d6 + "  info====>" + string3);
                    System.out.println("[Db2DPFDirectIoTest]curr POOL_DATA_WRITES===>" + d7 + "  info====>" + string3);
                    System.out.println("[Db2DPFDirectIoTest]curr POOL_INDEX_P_READS===>" + d8 + "  info====>" + string3);
                    System.out.println("[Db2DPFDirectIoTest]curr POOL_INDEX_WRITES===>" + d9 + "  info====>" + string3);
                }
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList2 = (ArrayList<Double>)this.prevValues.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Double>(6);
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d8));
                    arrayList2.add(new Double(d9));
                } else {
                    double d10 = (Double)arrayList2.get(0);
                    double d11 = (Double)arrayList2.get(1);
                    double d12 = (Double)arrayList2.get(2);
                    double d13 = (Double)arrayList2.get(3);
                    double d14 = (Double)arrayList2.get(4);
                    double d15 = (Double)arrayList2.get(5);
                    double d16 = d6 - d12 + (d7 - d13) + (d8 - d14) + (d9 - d15);
                    if (this.timeSinceLastTest > 0.0) {
                        d = (d4 - d10) / this.timeSinceLastTest;
                        d2 = (d5 - d11) / this.timeSinceLastTest;
                        d3 = d16 / this.timeSinceLastTest;
                    } else {
                        d = 0.0;
                        d2 = 0.0;
                        d3 = 0.0;
                    }
                    if (debug) {
                        System.out.println("[Db2DPFDirectIoTest]prev DIRECT_READS===>" + d10 + "  info====>" + string3);
                        System.out.println("[Db2DPFDirectIoTest]prev DIRECT_WRITES===>" + d11 + "  info====>" + string3);
                        System.out.println("[Db2DPFDirectIoTest]prev POOL_DATA_P_READS===>" + d12 + "  info====>" + string3);
                        System.out.println("[Db2DPFDirectIoTest]prev POOL_DATA_WRITES===>" + d13 + "  info====>" + string3);
                        System.out.println("[Db2DPFDirectIoTest]prev POOL_INDEX_P_READS===>" + d14 + "  info====>" + string3);
                        System.out.println("[Db2DPFDirectIoTest]prev POOL_INDEX_WRITES===>" + d15 + "  info====>" + string3);
                    }
                    arrayList2.set(0, new Double(d4));
                    arrayList2.set(1, new Double(d5));
                    arrayList2.set(2, new Double(d6));
                    arrayList2.set(3, new Double(d7));
                    arrayList2.set(4, new Double(d8));
                    arrayList2.set(5, new Double(d9));
                }
                if (debug) {
                    System.out.println("[Db2DPFDirectIoTest]Direct_read_rate===>" + d + "  info====>" + string3);
                    System.out.println("[Db2DPFDirectIoTest]Direct_write_rate===>" + d2 + "  info====>" + string3);
                    System.out.println("[Db2DPFDirectIoTest]Buffer_pool_io_rate===>" + d3 + "  info====>" + string3);
                }
                this.prevValues.put(string3, arrayList2);
                arrayList = new ArrayList<Double>(3);
                arrayList.add(new Double(d >= 0.0 ? d : -5.0));
                arrayList.add(new Double(d2 >= 0.0 ? d2 : -5.0));
                arrayList.add(new Double(d3 >= 0.0 ? d3 : -5.0));
                hashtable.put(string3, arrayList);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            try {
                System.out.println("Exception occured in IBMDb2DirectIOTest " + exception);
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        if (debug) {
            System.out.println("[Db2DPFDirectIoTest]getNotAvailableMeasures........");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(3);
        for (int i = 0; i < 3; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getVersion() {
        DB2JdbcHelper dB2JdbcHelper;
        double d;
        String string;
        String string2;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block11: {
            connection = null;
            statement = null;
            resultSet = null;
            string2 = "";
            string = "";
            d = 9.1;
            dB2JdbcHelper = null;
            String string3 = "SELECT service_level FROM TABLE (sysproc.env_get_inst_info()) as INSTANCEINFO";
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
            connection = dB2JdbcHelper.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeConnection(connection);
            if (debug) {
                System.out.println("[DB2ActivityTest] querystring Version=====>" + string2);
            }
            if (string2 != null && string2.trim().length() != 0) break block11;
            this.logToErrorFile("DB22ActivityTest:", "Query  select @@version returning null ", "");
            this.validCheckDone = true;
            double d2 = d;
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            return d2;
        }
        try {
            this.validCheckDone = true;
            string2 = string2.toUpperCase().trim();
            String string4 = "";
            String string5 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            int n = stringTokenizer.countTokens();
            if (n > 2) {
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                if (string4.indexOf("DB2 V") > -1) {
                    string4 = string4.substring(string4.indexOf("DB2 V") + 5);
                }
                if ((string = string4 + "." + string5) != null && string.length() > 0) {
                    d = Double.parseDouble(string);
                }
            } else {
                this.logToErrorFile("DB22ActivityTest:", "Version of Db2 is ", string2);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                System.out.println("Exception occured in Db2DBFActivityTest " + exception);
                double d3 = d;
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                return d3;
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                throw throwable;
            }
        }
        dB2JdbcHelper.closeConnection(connection);
        return d;
    }
}

