/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;

public class Db2Workload_cf
extends IBMDb2ConfigBase {
    private double db2Version = 10.0;
    private boolean checkDB2Version = true;

    public Db2Workload_cf(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
        this.setConfigInfoTestFlag(false);
    }

    public void computeMeasures(Hashtable hashtable) {
        if (this.checkDB2Version) {
            this.db2Version = this.db2SSL.equalsIgnoreCase("true") ? Db2Workload_cf.getDb2Version(this.db2DbHost, this.db2DbPort, this.db2UserName, this.db2Password, this.db2DbName, this.index, this.db2SSL) : Db2Workload_cf.getDb2Version(this.db2DbHost, this.db2DbPort, this.db2UserName, this.db2Password, this.db2DbName, this.index);
            this.checkDB2Version = false;
        }
        if (this.db2Version < 10.5) {
            this.logToErrorFile("INFO", this.entity + " run from DB2 version 10.5 onwards", this.reportingName);
            return;
        }
        ArrayList<String> arrayList = null;
        if (!this.computeValues()) {
            this.configError = true;
            return;
        }
        if (!this.datacoll.isEmpty()) {
            arrayList = new ArrayList<String>();
            String string = (String)this.datacoll.get("comm_bandwidth");
            if (!(string = this.checkNull(string, null)).equalsIgnoreCase("-")) {
                string = this.removeExpAndRound(string);
            }
            arrayList.add(string);
            string = (String)this.datacoll.get("spm_log_file_sz");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("util_impact_lim");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("wlm_dispatcher");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("wlm_disp_concur");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("wlm_disp_cpu_shares");
            string = this.checkNull(string, null);
            arrayList.add(string);
            string = (String)this.datacoll.get("wlm_disp_min_util");
            string = this.checkNull(string, null);
            arrayList.add(string);
            this.addNewMeasure(arrayList);
        }
    }

    private String removeExpAndRound(String string) {
        String string2 = "0.0";
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            double d = bigDecimal.doubleValue();
            DecimalFormat decimalFormat = new DecimalFormat();
            string2 = decimalFormat.format(d).toString();
        }
        catch (Exception exception) {
            string2 = "0.0";
            return string2;
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        Hashtable hashtable = new Hashtable();
        Db2Workload_cf db2Workload_cf = new Db2Workload_cf(stringArray);
        db2Workload_cf.computeMeasures(hashtable);
    }
}

