/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class DbActivityTest
extends DbActBaseTest {
    private static String description = "DESCRIPTION";
    private static String descValue = "VALUE";
    private static String sqlComm = "SQL commands";
    private static String prepares = "PREPAREs";
    private static String executes = "EXECUTEs";
    private static String commits = "COMMITs";
    private static String rollbacks = "ROLLBACKs";
    private static String sorts = "Memory sorts / sort&merge";
    private static String tableScans = "Table scans";
    private static String indexScans = "Isolated index scans";
    double prevSqlComm = -5.0;
    double prevPrepares = -5.0;
    double prevExecutes = -5.0;
    double prevCommits = -5.0;
    double prevRollbacks = -5.0;
    double prevSorts = -5.0;
    double prevTableScans = -5.0;
    double prevIndexScans = -5.0;

    public DbActivityTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(9);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.executeTransQuery();
        ArrayList arrayList = this.getActivityData();
        ArrayList<Double> arrayList2 = this.parseOutput(arrayList);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < 9; ++i) {
                arrayList2.add(new Double(-5.0));
            }
        }
        this.addNewMeasure(arrayList2);
    }

    public static void main(String[] stringArray) {
        DbActivityTest dbActivityTest = new DbActivityTest(stringArray);
        dbActivityTest.computeMeasures(new Hashtable());
    }

    private ArrayList parseOutput(ArrayList arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        double d = -5.0;
        double d2 = -5.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            hashtable = (Hashtable)arrayList.get(i);
            if (hashtable == null || hashtable.size() <= 0) {
                return null;
            }
            double d3 = -5.0;
            Enumeration enumeration = hashtable.keys();
            if (enumeration.hasMoreElements() && (string3 = (String)enumeration.nextElement()) == null || (string = (String)hashtable.get(string3)) == null || string.length() <= 0 || enumeration.hasMoreElements() && (string3 = (String)enumeration.nextElement()) == null || (string2 = (String)hashtable.get(string3)) == null || string2.length() <= 0) continue;
            if (string.indexOf(sqlComm) >= 0) {
                d3 = this.getMeasurePrevValue(string2, sqlComm);
                if (d3 > 0.0) {
                    d3 /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d3));
            } else if (string.equalsIgnoreCase(prepares)) {
                d3 = this.getMeasurePrevValue(string2, prepares);
                if (d3 > 0.0) {
                    d3 /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d3));
            } else if (string.indexOf(executes) >= 0) {
                d3 = this.getMeasurePrevValue(string2, executes);
                if (d3 > 0.0) {
                    d3 /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d3));
            } else if (string.indexOf(commits) >= 0) {
                d = this.getMeasurePrevValue(string2, commits);
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d));
            }
            if (string.equalsIgnoreCase(rollbacks)) {
                d2 = this.getMeasurePrevValue(string2, rollbacks);
                if (d2 > 0.0) {
                    d2 /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d2));
                if (d2 > 0.0 || d > 0.0) {
                    arrayList2.add(new Double(d2 / (d2 + d) * 100.0));
                    continue;
                }
                arrayList2.add(new Double(0.0));
                continue;
            }
            if (string.equalsIgnoreCase(sorts)) {
                d3 = this.getMeasurePrevValue(string2, sorts);
                if (d3 > 0.0) {
                    d3 /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d3));
                continue;
            }
            if (string.equalsIgnoreCase(tableScans)) {
                d3 = this.getMeasurePrevValue(string2, tableScans);
                if (d3 > 0.0) {
                    d3 /= this.timeSinceLastTest;
                }
                arrayList2.add(new Double(d3));
                continue;
            }
            if (!string.equalsIgnoreCase(indexScans)) continue;
            d3 = this.getMeasurePrevValue(string2, indexScans);
            if (d3 > 0.0) {
                d3 /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d3));
        }
        return arrayList2;
    }

    private double getMeasurePrevValue(String string, String string2) {
        double d = -5.0;
        double d2 = this.getValue(string);
        if (d2 >= 0.0) {
            double d3 = -5.0;
            if (string2.indexOf(sqlComm) >= 0) {
                d3 = this.prevSqlComm;
            } else if (string2.equalsIgnoreCase(prepares)) {
                d3 = this.prevPrepares;
            } else if (string2.indexOf(executes) >= 0) {
                d3 = this.prevExecutes;
            } else if (string2.indexOf(commits) >= 0) {
                d3 = this.prevCommits;
            } else if (string2.equalsIgnoreCase(rollbacks)) {
                d3 = this.prevRollbacks;
            } else if (string2.equalsIgnoreCase(sorts)) {
                d3 = this.prevSorts;
            } else if (string2.equalsIgnoreCase(tableScans)) {
                d3 = this.prevTableScans;
            } else if (string2.equalsIgnoreCase(indexScans)) {
                d3 = this.prevIndexScans;
            }
            d = d3 >= 0.0 ? d2 - d3 : -5.0;
            double d4 = d = d >= 0.0 ? d : -5.0;
            double d5 = d3 < 0.0 ? d2 : (d3 = d >= 0.0 ? d2 : -5.0);
            if (string2.indexOf(sqlComm) >= 0) {
                this.prevSqlComm = d3;
            } else if (string2.equalsIgnoreCase(prepares)) {
                this.prevPrepares = d3;
            } else if (string2.indexOf(executes) >= 0) {
                this.prevExecutes = d3;
            } else if (string2.indexOf(commits) >= 0) {
                this.prevCommits = d3;
            } else if (string2.equalsIgnoreCase(rollbacks)) {
                this.prevRollbacks = d3;
            } else if (string2.equalsIgnoreCase(sorts)) {
                this.prevSorts = d3;
            } else if (string2.equalsIgnoreCase(tableScans)) {
                this.prevTableScans = d3;
            } else if (string2.equalsIgnoreCase(indexScans)) {
                this.prevIndexScans = d3;
            }
        }
        return d;
    }

    private double getValue(String string) {
        double d;
        if (string == null) {
            return -5.0;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = -5.0;
        }
        return d;
    }
}

