/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class DbBaseTest
extends GenericTest {
    protected static final double MB = 1024.0;
    protected static final double SECS = 1000.0;
    protected static String Db = "";
    protected static final String NA = "NA";
    Connection conn = null;
    Statement stmt = null;
    ResultSet rs = null;
    ResultSetMetaData rsmd = null;
    String dbName = this.getValueForParam("databasename");
    String username = this.getValueForParam("username");
    String password = this.getValueForParam("password");
    String host = this.targetHost;
    String port = this.portNo;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    double respTime = 0.0;

    public DbBaseTest(String[] stringArray) {
        super(stringArray);
        Db = this.reportingName + "-" + this.targetHost + ":" + this.portNo;
        this.printOut("synchronized arg name: " + Db);
    }

    private boolean dbConnect() {
        try {
            Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
            String string = "jdbc:sapdb://" + this.host + ":" + this.port + "/" + this.dbName;
            this.printOut(string + ",username:" + this.username);
            this.conn = DriverManager.getConnection(string, this.username, this.password);
            if (this.conn != null) {
                this.printOut("connection found");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printOut("class exception:" + classNotFoundException.getMessage());
            this.logToErrorFile("Error", this.entity + ":" + this.reportingName, "class exception:" + classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            this.printOut("SQL exception:" + sQLException.getMessage());
            this.logToErrorFile("Error", this.entity + ":" + this.reportingName, "SQL exception:" + sQLException.getMessage());
        }
        catch (Exception exception) {
            this.printOut("exception:" + exception.getMessage());
            this.logToErrorFile("Error", this.entity + ":" + this.reportingName, "exception:" + exception.getMessage());
        }
        this.printOut("connection not found");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public ArrayList getOutput(String string) {
        ArrayList arrayList = new ArrayList();
        Hashtable<String, String> hashtable = null;
        this.printOut("syncHash maxdB :" + this.entity);
        this.printOut("Before Syno block ");
        long l = 0L;
        String string2 = Db;
        synchronized (string2) {
            l = System.currentTimeMillis();
            try {
                if (!this.dbConnect()) {
                    this.printOut("disconnect true, so send -5 values ");
                    this.respTime = -5.0;
                    ArrayList arrayList2 = null;
                    return arrayList2;
                }
                this.stmt = this.conn.createStatement();
                long l2 = System.currentTimeMillis();
                this.rs = this.stmt.executeQuery(string);
                this.printOut("query: " + string);
                long l3 = System.currentTimeMillis();
                this.respTime = (double)(l3 - l2) / 1000.0;
                this.rsmd = this.rs.getMetaData();
                int n = this.rsmd.getColumnCount();
                String string3 = null;
                String string4 = null;
                while (this.rs.next()) {
                    hashtable = new Hashtable<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        string3 = this.rsmd.getColumnName(i);
                        string4 = this.rs.getString(string3);
                        this.printOut("name: " + string3);
                        this.printOut("value: " + string4);
                        if (string4 == null) {
                            string4 = NA;
                        }
                        hashtable.put(string3, string4);
                    }
                    arrayList.add(hashtable);
                }
                this.printOut("alresult: " + arrayList);
            }
            catch (Exception exception) {
                this.printOut("unable to run query :" + exception.getMessage());
                this.logToErrorFile("Error", this.entity + ":" + this.reportingName, "unable to run query :" + exception.getMessage());
            }
            finally {
                this.dbDisConnect();
            }
        }
        if (l > 0L) {
            this.printOut("After Syno block ");
            this.printOut("setData took with DbBaseTest " + (System.currentTimeMillis() - l) + "ms.");
        } else {
            this.printOut("Skip Syno block ");
        }
        return arrayList;
    }

    public void dbDisConnect() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            this.printOut("dbDisConnect () exception  :" + sQLException);
            this.logToErrorFile("Error", this.entity + ":" + this.reportingName, "dbDisConnect () exception  :" + sQLException);
        }
    }

    public void printOut(String string) {
        System.out.println(" >> " + this.reportingName + "." + this.entity + "  " + ": [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }
}

