/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class DbIOCacheTest
extends DbBaseTest {
    private static String totalSize = "TOTALSIZE";
    private static String dataCacheSize = "DATACACHEUSEDSIZE";
    private static String converterSize = "CONVERTERUSEDSIZE";
    private static String ioMgmtSize = "IOMANAGEMENTUSEDSIZE";
    private static String fileDirSize = "FILEDIRECTORYUSEDSIZE";
    private static String restartRecordSize = "RESTARTRECORDUSEDSIZE";
    private static String blockAllocatorSize = "BLOCKALLOCATORUSEDSIZE";
    private static String unusedSize = "UNUSEDSIZE";

    public DbIOCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(10);
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.getOutput("select totalsize, datacacheusedsize, converterusedsize, iomanagementusedsize, filedirectoryusedsize, restartrecordusedsize, blockallocatorusedsize, unusedsize from iobuffercaches");
        ArrayList<Double> arrayList2 = this.parseOutput(arrayList);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < 10; ++i) {
                arrayList2.add(new Double(-5.0));
            }
        }
        System.out.println("al:" + arrayList2);
        this.addNewMeasure(arrayList2);
    }

    public static void main(String[] stringArray) {
        DbIOCacheTest dbIOCacheTest = new DbIOCacheTest(stringArray);
        dbIOCacheTest.computeMeasures(new Hashtable());
    }

    private ArrayList parseOutput(ArrayList arrayList) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        Hashtable hashtable = new Hashtable();
        ArrayList<Double> arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable2 = new Hashtable();
        arrayList2 = new ArrayList<Double>();
        hashtable2 = (Hashtable)arrayList.get(0);
        if (hashtable2 == null || hashtable2.size() <= 0) {
            return null;
        }
        d = -5.0;
        d2 = this.getMeasureValue(hashtable2, totalSize);
        if (d2 > 0.0) {
            d2 /= 1024.0;
        }
        arrayList2.add(new Double(d2));
        d3 = this.getMeasureValue(hashtable2, dataCacheSize);
        if (d3 > 0.0) {
            d3 /= 1024.0;
        }
        arrayList2.add(new Double(d3));
        if (d2 > 0.0 && d3 >= 0.0) {
            arrayList2.add(new Double(d3 / d2 * 100.0));
        } else {
            arrayList2.add(new Double(-5.0));
        }
        d4 = this.getMeasureValue(hashtable2, converterSize);
        if (d4 > 0.0) {
            d4 /= 1024.0;
        }
        arrayList2.add(new Double(d4));
        if (d2 > 0.0 && d4 >= 0.0) {
            arrayList2.add(new Double(d4 / d2 * 100.0));
        } else {
            arrayList2.add(new Double(-5.0));
        }
        d = this.getMeasureValue(hashtable2, ioMgmtSize);
        if (d > 0.0) {
            d /= 1024.0;
        }
        arrayList2.add(new Double(d));
        d = this.getMeasureValue(hashtable2, fileDirSize);
        if (d > 0.0) {
            d /= 1024.0;
        }
        arrayList2.add(new Double(d));
        d = this.getMeasureValue(hashtable2, restartRecordSize);
        if (d > 0.0) {
            d /= 1024.0;
        }
        arrayList2.add(new Double(d));
        d = this.getMeasureValue(hashtable2, blockAllocatorSize);
        if (d > 0.0) {
            d /= 1024.0;
        }
        arrayList2.add(new Double(d));
        d = this.getMeasureValue(hashtable2, unusedSize);
        if (d > 0.0) {
            d /= 1024.0;
        }
        arrayList2.add(new Double(d));
        return arrayList2;
    }

    private double getMeasureValue(Hashtable hashtable, String string) {
        String string2 = null;
        double d = -5.0;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
            d = this.getValue(string2);
        }
        return d;
    }

    private double getValue(String string) {
        double d;
        if (string == null) {
            return -5.0;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = -5.0;
        }
        return d;
    }
}

