/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class DbLogQueueTest
extends DbLogBaseTest {
    private static String queueId = "QUEUEID";
    private static String queueMaxUsed = "QUEUEMAXUSED";
    private static String queueIns = "QUEUEINSERTCOUNT";
    private static String queueOverflow = "QUEUEOVERFLOWCOUNT";
    private static String grpCommits = "GROUPCOMMITCOUNT";
    private static String waits = "WAITCOUNT";
    private static String maxWaits = "MAXWAITCOUNTPERPAGE";
    private static String phyWrites = "PHYSICALWRITECOUNT";
    double prevInsert = -5.0;
    double prevOverflow = -5.0;
    double prevGrpCommits = -5.0;
    double prevWaits = -5.0;
    double prevWrites = -5.0;

    public DbLogQueueTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = "select queueid, queuemaxused, queueinsertcount, queueoverflowcount, groupcommitcount,waitcount, maxwaitcountperpage, physicalwritecount from logqueuestatistics";
        ArrayList arrayList = this.getOutput(string);
        Hashtable hashtable2 = this.parseOutput(arrayList);
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                this.addNewMeasure(string2, (ArrayList)hashtable2.get(string2));
            }
        }
    }

    public static void main(String[] stringArray) {
        DbLogQueueTest dbLogQueueTest = new DbLogQueueTest(stringArray);
        dbLogQueueTest.computeMeasures(new Hashtable());
    }

    private Hashtable parseOutput(ArrayList arrayList) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        String string = null;
        ArrayList<Double> arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        for (int i = 0; i < arrayList.size(); ++i) {
            hashtable = (Hashtable)arrayList.get(i);
            if (hashtable == null || hashtable.size() <= 0) {
                return null;
            }
            arrayList2 = new ArrayList<Double>();
            d = -5.0;
            string = (String)hashtable.get(queueId);
            if (string == null) continue;
            d = this.getMeasureValue(hashtable, queueMaxUsed);
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable, queueIns);
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable, queueOverflow);
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable, grpCommits);
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable, waits);
            arrayList2.add(new Double(d));
            d = this.getMeasureValue(hashtable, maxWaits);
            arrayList2.add(new Double(d));
            d = this.getMeasurePrevValue(hashtable, phyWrites);
            if (d > 0.0) {
                d /= this.timeSinceLastTest;
            }
            arrayList2.add(new Double(d));
            hashtable2.put(string, arrayList2);
        }
        return hashtable2;
    }

    private double getMeasurePrevValue(Hashtable hashtable, String string) {
        String string2 = null;
        double d = -5.0;
        double d2 = -5.0;
        Object var8_6 = null;
        if (hashtable.containsKey(string)) {
            string2 = (String)hashtable.get(string);
            d = this.getValue(string2);
            double d3 = -5.0;
            if (d >= 0.0) {
                if (string.equalsIgnoreCase(queueIns)) {
                    d3 = this.prevInsert;
                } else if (string.equalsIgnoreCase(queueOverflow)) {
                    d3 = this.prevOverflow;
                } else if (string.equalsIgnoreCase(grpCommits)) {
                    d3 = this.prevGrpCommits;
                } else if (string.equalsIgnoreCase(waits)) {
                    d3 = this.prevWaits;
                } else if (string.equalsIgnoreCase(phyWrites)) {
                    d3 = this.prevWrites;
                }
                d2 = d3 >= 0.0 ? d - d3 : -5.0;
                double d4 = d2 = d2 >= 0.0 ? d2 : -5.0;
                double d5 = d3 < 0.0 ? d : (d3 = d2 >= 0.0 ? d : -5.0);
            }
            if (string.equalsIgnoreCase(queueIns)) {
                this.prevInsert = d3;
            } else if (string.equalsIgnoreCase(queueOverflow)) {
                this.prevOverflow = d3;
            } else if (string.equalsIgnoreCase(grpCommits)) {
                this.prevGrpCommits = d3;
            } else if (string.equalsIgnoreCase(waits)) {
                this.prevWaits = d3;
            } else if (string.equalsIgnoreCase(phyWrites)) {
                this.prevWrites = d3;
            }
        }
        return d2;
    }
}

