/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;

class DiskSpaceTestAutomationCleanup
extends Thread {
    private static final String className = "DiskSpaceTestAutomationCleanup";
    private static String osNm = null;
    private static Map cnfgrdAutmnDetails = null;
    private List testMeasuresOutput = null;
    private static DiskSpaceTest diskSpaceTest = null;
    private static boolean isAboveJRE17 = false;
    private static boolean isDebug = false;
    private static boolean isDebug_methodEntryExit = false;
    private static boolean isWindows = true;
    String curThreadStatus = "NOT_STARTED";
    private static final String CONST_EXCEPTION = "EXCEPTION";
    private static final String CONST_DEBUG = "DEBUG";
    static final String CONST_NOT_STARTED = "NOT_STARTED";
    private static final String CONST_TEST_MSR_DELIMITER = "#~#";
    static final String CONST_FILES = "files";
    static final String CONST_FOLDERS = "folders";
    private static final String cleanupTimeDateFormat = "MMM dd, yyyy HH:mm:ss z";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss z");
    Map cleanedupDtls = null;

    public DiskSpaceTestAutomationCleanup(String osNm, Map cnfgrdAutmnDetails, List testMeasuresOutput, DiskSpaceTest diskSpaceTest, String reportingName, boolean isAboveJRE17, boolean isDebug, boolean isDebug_methodEntryExit) {
        String methodName = className;
        DiskSpaceTestAutomationCleanup.isDebug = isDebug;
        DiskSpaceTestAutomationCleanup.isDebug_methodEntryExit = isDebug_methodEntryExit;
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- osNm: " + osNm + ", cnfgrdAutmnDetails: " + cnfgrdAutmnDetails + ", testMeasuresOutput: " + testMeasuresOutput + ", diskSpaceTest: " + diskSpaceTest + ", reportingName: " + reportingName + ", isAboveJRE17: " + isAboveJRE17 + ", isDebug: " + isDebug + ", isDebug_methodEntryExit: " + isDebug_methodEntryExit, null);
        }
        this.setName("DiskSpaceTestAutomationCleanup:" + reportingName);
        DiskSpaceTestAutomationCleanup.osNm = osNm;
        DiskSpaceTestAutomationCleanup.cnfgrdAutmnDetails = cnfgrdAutmnDetails;
        this.testMeasuresOutput = testMeasuresOutput;
        DiskSpaceTestAutomationCleanup.diskSpaceTest = diskSpaceTest;
        DiskSpaceTestAutomationCleanup.isAboveJRE17 = isAboveJRE17;
        isWindows = osNm != null && osNm.toUpperCase().indexOf("WINDOWS") > -1;
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "isWindows: " + isWindows, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
    }

    public void run() {
        String methodName = "run";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        this.curThreadStatus = "RUNNING";
        this.cleanedupDtls = this.performCleanup(cnfgrdAutmnDetails, this.testMeasuresOutput);
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug("INFO", className, methodName, "Clean up details performed as part of DiskSpaceTest clean up automation: " + this.cleanedupDtls, null);
        }
        this.curThreadStatus = "COMPLETED";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
    }

    private Map performCleanup(Map cnfgrdAutmtnDetails, List testMeasuresOutput) {
        HashMap<String, Object> allCleanedupDtls;
        String methodName;
        block31: {
            methodName = "performCleanup";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
            }
            if (isDebug) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- cnfgrdAutmtnDetails: " + cnfgrdAutmtnDetails + ", testMeasuresOutput: " + testMeasuresOutput, null);
            }
            allCleanedupDtls = new HashMap<String, Object>();
            HashMap<String, Map> cleanedupDriveDtls = new HashMap<String, Map>();
            try {
                if (cnfgrdAutmtnDetails != null && cnfgrdAutmtnDetails.get("driveDetails") != null && ((HashMap)cnfgrdAutmtnDetails.get("driveDetails")).size() > 0 && testMeasuresOutput != null && testMeasuresOutput.size() > 0) {
                    Map curTstRunDrvUtlznDtls = this.extrctCurTstRunDrvUtlznDtls(testMeasuresOutput);
                    HashMap cnfgrdDriveDetails = (HashMap)cnfgrdAutmtnDetails.get("driveDetails");
                    for (String curCnfgrdDrvNm : cnfgrdDriveDetails.keySet()) {
                        Double cnfgrdUtlznPrcntForDrive = null;
                        Double curTstRunUtlznPrcntForDrive = null;
                        try {
                            HashMap curDriveDetails = (HashMap)cnfgrdDriveDetails.get(curCnfgrdDrvNm);
                            cnfgrdUtlznPrcntForDrive = new Double((String)curDriveDetails.get("utlznPrcnt"));
                            if (curTstRunDrvUtlznDtls.get(curCnfgrdDrvNm) != null) {
                                curTstRunUtlznPrcntForDrive = new Double((String)curTstRunDrvUtlznDtls.get(curCnfgrdDrvNm));
                                if (curTstRunUtlznPrcntForDrive.compareTo(cnfgrdUtlznPrcntForDrive) >= 0) {
                                    Map allFilesFolders = this.collectAllFilesFolders((ArrayList)curDriveDetails.get("filteredRules"));
                                    if (isDebug) {
                                        DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "allFilesFolders: " + allFilesFolders, null);
                                    }
                                    Map cleanedupDtlsForDrive = this.removeFilesAndFolders(allFilesFolders);
                                    if (isDebug) {
                                        DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "cleanedupDtlsForDrive: " + cleanedupDtlsForDrive, null);
                                    }
                                    if (cleanedupDtlsForDrive != null) {
                                        cleanedupDtlsForDrive.put("givenRules", (ArrayList)curDriveDetails.get("givenRules"));
                                        cleanedupDtlsForDrive.put("filteredRules", (ArrayList)curDriveDetails.get("filteredRules"));
                                        cleanedupDtlsForDrive.put("filteredOutRules", (ArrayList)curDriveDetails.get("filteredOutRules"));
                                        if (((List)cleanedupDtlsForDrive.get("UnableToRemovedFilesAndFolders")).size() > 0) {
                                            cleanedupDtlsForDrive.put("automationstatus", "FAILED");
                                        } else if (((List)cleanedupDtlsForDrive.get("RemovedFilesAndFolders")).size() > 0) {
                                            cleanedupDtlsForDrive.put("automationstatus", "Files and folders as per configured rule are deleted");
                                        } else {
                                            cleanedupDtlsForDrive.put("automationstatus", "No files and folders as per configured rule are deleted");
                                        }
                                    }
                                    if (isWindows) {
                                        List powerShlScrptOutput = null;
                                        if (DiskSpaceTest.rootDrvName.equalsIgnoreCase(curCnfgrdDrvNm)) {
                                            powerShlScrptOutput = this.executePowerShellScriptForCleanup();
                                            if (isDebug) {
                                                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "powerShlScrptOutput: " + powerShlScrptOutput, null);
                                            }
                                            HashMap parsedShlScrptOutput = this.parsePwrShlScrptOutput(powerShlScrptOutput);
                                            allCleanedupDtls.put("powerShellScriptOutput", parsedShlScrptOutput);
                                            if (((List)parsedShlScrptOutput.get("UnableToRemovedFilesAndFolders")).size() > 0) {
                                                cleanedupDtlsForDrive.put("automationstatus", "FAILED");
                                            } else if (((List)parsedShlScrptOutput.get("RemovedFilesAndFolders")).size() > 0 || ((List)cleanedupDtlsForDrive.get("RemovedFilesAndFolders")).size() > 0) {
                                                cleanedupDtlsForDrive.put("automationstatus", "Files and folders as per configured rule are deleted");
                                            } else {
                                                cleanedupDtlsForDrive.put("automationstatus", "No files and folders as per configured rule are deleted");
                                            }
                                        }
                                    }
                                    cleanedupDriveDtls.put(curCnfgrdDrvNm, cleanedupDtlsForDrive);
                                    continue;
                                }
                                HashMap<String, Object> crntDrvDtls = new HashMap<String, Object>();
                                crntDrvDtls.put("automationstatus", "NOT_REQUIRED");
                                crntDrvDtls.put("cleanedSpaceinBytes", "0");
                                crntDrvDtls.put("RemovedFilesAndFolders", new ArrayList());
                                crntDrvDtls.put("UnableToRemovedFilesAndFolders", new ArrayList());
                                cleanedupDriveDtls.put(curCnfgrdDrvNm, crntDrvDtls);
                                continue;
                            }
                            HashMap<String, Object> cleanedupDtlsForDrive = new HashMap<String, Object>();
                            cleanedupDtlsForDrive.put("RemovedFilesAndFolders", new ArrayList());
                            cleanedupDtlsForDrive.put("UnableToRemovedFilesAndFolders", new ArrayList());
                            cleanedupDtlsForDrive.put("cleanupTime in UTC", "");
                            cleanedupDtlsForDrive.put("givenRules", (ArrayList)curDriveDetails.get("givenRules"));
                            cleanedupDtlsForDrive.put("filteredRules", (ArrayList)curDriveDetails.get("filteredRules"));
                            cleanedupDtlsForDrive.put("filteredOutRules", (ArrayList)curDriveDetails.get("filteredOutRules"));
                            cleanedupDtlsForDrive.put("automationstatus", "-");
                            cleanedupDtlsForDrive.put("cleanedSpaceinBytes", "0");
                            cleanedupDriveDtls.put(curCnfgrdDrvNm, cleanedupDtlsForDrive);
                        }
                        catch (NumberFormatException nfe) {
                            if (!isDebug) continue;
                            DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, "Either the configured utilization percent is not a number OR the current utilization percent is not a number", nfe);
                        }
                        catch (Exception e) {
                            if (!isDebug) continue;
                            DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, "Some issue occured while cleaning up the files/forlders for the configured drive " + curCnfgrdDrvNm, e);
                        }
                    }
                    allCleanedupDtls.put("cleanedupDriveDtls", cleanedupDriveDtls);
                    if (cnfgrdAutmtnDetails.get("notToDeleteFromIni") != null) {
                        allCleanedupDtls.put("notToDeleteFromIni", Arrays.asList((String[])cnfgrdAutmtnDetails.get("notToDeleteFromIni")));
                    } else {
                        allCleanedupDtls.put("notToDeleteFromIni", new ArrayList());
                    }
                    if (cnfgrdAutmtnDetails.get("notToDeleteHardCoded") != null) {
                        allCleanedupDtls.put("notToDeleteHardCoded", Arrays.asList((String[])cnfgrdAutmtnDetails.get("notToDeleteHardCoded")));
                    } else {
                        allCleanedupDtls.put("notToDeleteHardCoded", new ArrayList());
                    }
                    allCleanedupDtls.put("cleanupTimeDateFormat", cleanupTimeDateFormat);
                    break block31;
                }
                throw new Exception("Issue in either the configured automation details OR issue in current test run output.");
            }
            catch (Exception e) {
                if (!isDebug) break block31;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "allCleanedupDtls: " + allCleanedupDtls, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return allCleanedupDtls;
    }

    private Map extrctCurTstRunDrvUtlznDtls(List testMeasuresOutput) throws Exception {
        String methodName = "extrctCurTstRunDrvUtlznDtls";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- testMeasuresOutput: " + testMeasuresOutput, null);
        }
        HashMap<String, String> curTstRunDrvUtlznDtls = new HashMap<String, String>();
        if (osNm != null && osNm.toUpperCase().indexOf("WINDOWS") > -1) {
            if (testMeasuresOutput != null && testMeasuresOutput.size() > 0) {
                int incr = 0;
                while (incr < testMeasuresOutput.size()) {
                    String[] curDriveDtls;
                    String curDriveDtlsAsStr = (String)testMeasuresOutput.get(incr);
                    if (curDriveDtlsAsStr != null && (curDriveDtls = curDriveDtlsAsStr.split(CONST_TEST_MSR_DELIMITER)) != null && curDriveDtls.length >= 5) {
                        int index;
                        String driveNm = curDriveDtls[0];
                        String utlznPrcntg = curDriveDtls[4];
                        int n = driveNm.lastIndexOf(":\\") > -1 ? driveNm.lastIndexOf(":\\") : (index = driveNm.lastIndexOf("\\") > -1 ? driveNm.lastIndexOf("\\") : -1);
                        if (index > -1) {
                            driveNm = driveNm.substring(0, index);
                        }
                        curTstRunDrvUtlznDtls.put(driveNm, utlznPrcntg);
                    }
                    ++incr;
                }
            }
        } else if (testMeasuresOutput != null && testMeasuresOutput.size() > 0) {
            int incr = 0;
            while (incr < testMeasuresOutput.size()) {
                ArrayList curDriveDtls = (ArrayList)testMeasuresOutput.get(incr);
                if (curDriveDtls != null && curDriveDtls.size() >= 5) {
                    int index;
                    String driveNm = (String)curDriveDtls.get(5);
                    Double utlznPrcntg = (Double)curDriveDtls.get(3);
                    int n = driveNm.lastIndexOf(":\\") > -1 ? driveNm.lastIndexOf(":\\") : (index = driveNm.lastIndexOf("\\") > -1 ? driveNm.lastIndexOf("\\") : -1);
                    if (index > -1) {
                        driveNm = driveNm.substring(0, index);
                    }
                    curTstRunDrvUtlznDtls.put(driveNm, utlznPrcntg.toString());
                }
                ++incr;
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "curTstRunDrvUtlznDtls: " + curTstRunDrvUtlznDtls, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return curTstRunDrvUtlznDtls;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getEnvSubstdCleanupRule(String cleanupRule) throws Exception {
        String methodName = "getEnvSubstdCleanupRule";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "cleanupRule: " + cleanupRule, null);
        }
        String envSubstdCleanupRule = null;
        String envVar = null;
        int beginIndex = -1;
        int endIndex = -1;
        if (isWindows) {
            if (cleanupRule.startsWith("%")) {
                beginIndex = cleanupRule.indexOf("%");
                endIndex = cleanupRule.indexOf("%", beginIndex + 1);
                if (beginIndex > -1 && endIndex > -1) {
                    envVar = cleanupRule.substring(beginIndex + 1, endIndex);
                    String envVarValue = System.getenv(envVar);
                    if (envVarValue == null) throw new Exception("Unable to get the value for the environment variable");
                    envSubstdCleanupRule = String.valueOf(envVarValue.toUpperCase()) + cleanupRule.substring(endIndex + 1);
                }
            }
        } else if (cleanupRule.startsWith("$")) {
            beginIndex = cleanupRule.indexOf("$");
            endIndex = cleanupRule.indexOf("/", beginIndex + 1);
            if (beginIndex > -1 && endIndex > -1) {
                envVar = cleanupRule.substring(beginIndex + 1, endIndex);
                String envVarValue = System.getenv(envVar);
                if (envVarValue == null) throw new Exception("Unable to get the value for the environment variable");
                envSubstdCleanupRule = String.valueOf(envVarValue.toUpperCase()) + cleanupRule.substring(endIndex);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "envSubstdCleanupRule: " + envSubstdCleanupRule, null);
        }
        if (!isDebug_methodEntryExit) return envSubstdCleanupRule;
        DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        return envSubstdCleanupRule;
    }

    private Map collectAllFilesFolders(List filteredCleanupRules) {
        HashMap<String, AbstractSet> allFilesFolders;
        String methodName;
        block21: {
            methodName = "collectAllFilesFolders";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
            }
            if (isDebug) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- filteredCleanupRules: " + filteredCleanupRules, null);
            }
            allFilesFolders = new HashMap<String, AbstractSet>();
            allFilesFolders.put(CONST_FILES, null);
            allFilesFolders.put(CONST_FOLDERS, null);
            try {
                if (filteredCleanupRules == null) break block21;
                HashSet<String> files = new HashSet<String>();
                TreeSet folders = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String s1 = String.valueOf(o1);
                        String s2 = String.valueOf(o2);
                        return s2.compareTo(s1);
                    }
                });
                filteredCleanupRules = this.checkAndExpandAllwdDblWldCrdPaths(filteredCleanupRules);
                int incr = 0;
                while (incr < filteredCleanupRules.size()) {
                    String curRule = (String)filteredCleanupRules.get(incr);
                    if (isDebug) {
                        DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "curRule: " + curRule, null);
                    }
                    String envSubstdCleanupRule = null;
                    try {
                        envSubstdCleanupRule = this.getEnvSubstdCleanupRule(curRule);
                        if (envSubstdCleanupRule == null) {
                            envSubstdCleanupRule = curRule;
                        }
                    }
                    catch (Exception e) {
                        envSubstdCleanupRule = curRule;
                    }
                    if (isDebug) {
                        DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "envSubstdCleanupRule: " + envSubstdCleanupRule, null);
                    }
                    if (envSubstdCleanupRule != null && !"".equals(envSubstdCleanupRule)) {
                        int wildCardIndex = envSubstdCleanupRule.indexOf("*");
                        Map filesAndFolders = null;
                        if (wildCardIndex > -1) {
                            filesAndFolders = isAboveJRE17 ? DiskSpaceTestAutmnClnupHelper.getSubObjectsForWildCard(envSubstdCleanupRule, isWindows, diskSpaceTest, isDebug_methodEntryExit, isDebug) : this.getSubObjectsForWildCard(envSubstdCleanupRule);
                        } else {
                            File file = new File(envSubstdCleanupRule);
                            if (file.isFile()) {
                                files.add(envSubstdCleanupRule);
                            } else if (file.isDirectory()) {
                                filesAndFolders = isAboveJRE17 ? DiskSpaceTestAutmnClnupHelper.getSubObjectsForDir(envSubstdCleanupRule, isWindows, diskSpaceTest, isDebug_methodEntryExit, isDebug) : this.getSubObjectsForDir(envSubstdCleanupRule);
                            }
                        }
                        if (filesAndFolders != null) {
                            if (filesAndFolders.get(CONST_FILES) != null) {
                                files.addAll((ArrayList)filesAndFolders.get(CONST_FILES));
                            }
                            if (filesAndFolders.get(CONST_FOLDERS) != null) {
                                folders.addAll((ArrayList)filesAndFolders.get(CONST_FOLDERS));
                            }
                        }
                    }
                    ++incr;
                }
                allFilesFolders.put(CONST_FILES, files);
                allFilesFolders.put(CONST_FOLDERS, folders);
            }
            catch (Exception e) {
                if (!isDebug) break block21;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "allFilesFolders: " + allFilesFolders, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return allFilesFolders;
    }

    private Map getSubObjectsForWildCard(String wildCardPath) {
        HashMap allSubFilesFolders;
        String methodName;
        block19: {
            methodName = "getSubObjectsForWildCard";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
            }
            if (isDebug) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- wildCardPath: " + wildCardPath, null);
            }
            allSubFilesFolders = new HashMap();
            allSubFilesFolders.put(CONST_FILES, null);
            allSubFilesFolders.put(CONST_FOLDERS, null);
            ArrayList<String> files = new ArrayList<String>();
            ArrayList folders = new ArrayList();
            try {
                if (wildCardPath != null) {
                    int starIndex = wildCardPath.indexOf("*");
                    if (starIndex > -1) {
                        int lastBckwdSlshIndex;
                        int lastSlashIndex;
                        String tempWildCardPathSegmnt = wildCardPath.substring(0, starIndex);
                        int lastFrwdSlshIndex = tempWildCardPathSegmnt.lastIndexOf("/");
                        int n = lastSlashIndex = lastFrwdSlshIndex > (lastBckwdSlshIndex = tempWildCardPathSegmnt.lastIndexOf("\\")) ? lastFrwdSlshIndex : lastBckwdSlshIndex;
                        if (lastSlashIndex > -1) {
                            String pathExcludeWildCard = wildCardPath.substring(0, lastSlashIndex + 1);
                            String wildCardSegment = wildCardPath.substring(lastSlashIndex + 1);
                            File directory = new File(pathExcludeWildCard);
                            File[] wildCardMtchdFlsFldrs = null;
                            wildCardMtchdFlsFldrs = isWindows ? directory.listFiles((FileFilter)new WildcardFileFilter(wildCardSegment, IOCase.INSENSITIVE)) : directory.listFiles((FileFilter)new WildcardFileFilter(wildCardSegment, IOCase.SENSITIVE));
                            if (wildCardMtchdFlsFldrs != null) {
                                int incr = 0;
                                while (incr < wildCardMtchdFlsFldrs.length) {
                                    File curWildCardMtchdFlFldr = wildCardMtchdFlsFldrs[incr];
                                    if (curWildCardMtchdFlFldr.isFile()) {
                                        if (isWindows) {
                                            files.add(curWildCardMtchdFlFldr.getAbsolutePath().toUpperCase());
                                        } else {
                                            files.add(curWildCardMtchdFlFldr.getAbsolutePath());
                                        }
                                    } else if (curWildCardMtchdFlFldr.isDirectory()) {
                                        Map temp = null;
                                        temp = isWindows ? this.getSubObjectsForDir(curWildCardMtchdFlFldr.getAbsolutePath().toUpperCase()) : this.getSubObjectsForDir(curWildCardMtchdFlFldr.getAbsolutePath());
                                        if (temp != null) {
                                            if (temp.get(CONST_FILES) != null && ((List)temp.get(CONST_FILES)).size() > 0) {
                                                files.addAll((List)temp.get(CONST_FILES));
                                            }
                                            if (temp.get(CONST_FOLDERS) != null && ((List)temp.get(CONST_FOLDERS)).size() > 0) {
                                                folders.addAll((List)temp.get(CONST_FOLDERS));
                                            }
                                        }
                                    }
                                    ++incr;
                                }
                            }
                        }
                    }
                    allSubFilesFolders.put(CONST_FILES, files);
                    allSubFilesFolders.put(CONST_FOLDERS, folders);
                }
            }
            catch (Exception e) {
                if (!isDebug) break block19;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "allSubFilesFolders: " + allSubFilesFolders, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return allSubFilesFolders;
    }

    private Map getSubObjectsForDir(String dirPath) {
        HashMap allSubFilesFolders;
        String methodName;
        block18: {
            methodName = "getSubObjectsForDir";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
            }
            if (isDebug) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- dirPath: " + dirPath, null);
            }
            allSubFilesFolders = new HashMap();
            allSubFilesFolders.put(CONST_FILES, null);
            allSubFilesFolders.put(CONST_FOLDERS, null);
            ArrayList<String> files = new ArrayList<String>();
            ArrayList<String> folders = new ArrayList<String>();
            try {
                if (dirPath != null && !"".equals(dirPath)) {
                    folders.add(dirPath);
                    File directory = new File(dirPath);
                    File[] subObjectsForDir = directory.listFiles();
                    if (subObjectsForDir != null && subObjectsForDir.length > 0) {
                        int incr = 0;
                        while (incr < subObjectsForDir.length) {
                            File curSubObj = subObjectsForDir[incr];
                            if (curSubObj != null) {
                                if (curSubObj.isDirectory()) {
                                    Map temp = null;
                                    temp = isWindows ? this.getSubObjectsForDir(curSubObj.getAbsolutePath().toUpperCase()) : this.getSubObjectsForDir(curSubObj.getAbsolutePath());
                                    if (temp != null) {
                                        if (temp.get(CONST_FILES) != null && ((List)temp.get(CONST_FILES)).size() > 0) {
                                            files.addAll((List)temp.get(CONST_FILES));
                                        }
                                        if (temp.get(CONST_FOLDERS) != null && ((List)temp.get(CONST_FOLDERS)).size() > 0) {
                                            folders.addAll((List)temp.get(CONST_FOLDERS));
                                        }
                                    }
                                } else if (curSubObj.isFile()) {
                                    if (isWindows) {
                                        files.add(curSubObj.getAbsolutePath().toUpperCase());
                                    } else {
                                        files.add(curSubObj.getAbsolutePath());
                                    }
                                }
                            }
                            ++incr;
                        }
                    }
                    allSubFilesFolders.put(CONST_FILES, files);
                    allSubFilesFolders.put(CONST_FOLDERS, folders);
                }
            }
            catch (Exception e) {
                if (!isDebug) break block18;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "allSubFilesFolders: " + allSubFilesFolders, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return allSubFilesFolders;
    }

    private Map removeFilesAndFolders(Map allFilesFolders) {
        HashMap<String, Object> cleanedUpDetails;
        String methodName;
        block17: {
            methodName = "removeFilesAndFolders";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
            }
            if (isDebug) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- allFilesFolders: " + allFilesFolders, null);
            }
            long cleanedSpaceinBytes = 0L;
            cleanedUpDetails = new HashMap<String, Object>();
            ArrayList<String> removedFilesAndFolders = new ArrayList<String>();
            ArrayList<String> unableToRemovedFilesAndFolders = new ArrayList<String>();
            Date cleanupTime = new Date();
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            cleanedUpDetails.put("RemovedFilesAndFolders", removedFilesAndFolders);
            cleanedUpDetails.put("UnableToRemovedFilesAndFolders", unableToRemovedFilesAndFolders);
            cleanedUpDetails.put("cleanupTime in UTC", dateFormat.format(cleanupTime));
            cleanedUpDetails.put("cleanedSpaceinBytes", "0");
            try {
                if (allFilesFolders != null && allFilesFolders.size() > 0) {
                    HashSet allFilePaths = (HashSet)allFilesFolders.get(CONST_FILES);
                    TreeSet allFolderPaths = (TreeSet)allFilesFolders.get(CONST_FOLDERS);
                    for (String curFilePath : allFilePaths) {
                        File curFile = new File(curFilePath);
                        if (curFile.exists()) {
                            try {
                                long crntFilSize = curFile.length();
                                if (curFile.delete()) {
                                    removedFilesAndFolders.add(curFilePath);
                                    cleanedSpaceinBytes += crntFilSize;
                                    continue;
                                }
                                unableToRemovedFilesAndFolders.add(curFilePath);
                            }
                            catch (Exception e) {
                                unableToRemovedFilesAndFolders.add(curFilePath);
                                if (!isDebug) continue;
                                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
                            }
                            continue;
                        }
                        unableToRemovedFilesAndFolders.add(curFilePath);
                    }
                    Iterator allFilePathsItr = null;
                    allFilePaths = null;
                    for (String curFolderPath : allFolderPaths) {
                        File curFolder = new File(curFolderPath);
                        if (curFolder.exists()) {
                            try {
                                if (curFolder.delete()) {
                                    removedFilesAndFolders.add(curFolderPath);
                                    continue;
                                }
                                unableToRemovedFilesAndFolders.add(curFolderPath);
                            }
                            catch (Exception e) {
                                unableToRemovedFilesAndFolders.add(curFolderPath);
                                if (!isDebug) continue;
                                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
                            }
                            continue;
                        }
                        unableToRemovedFilesAndFolders.add(curFolderPath);
                    }
                    Iterator allFolderPathsItr = null;
                    allFolderPaths = null;
                    cleanedUpDetails.put("cleanedSpaceinBytes", new Long(cleanedSpaceinBytes));
                    cleanedUpDetails.put("RemovedFilesAndFolders", removedFilesAndFolders);
                    cleanedUpDetails.put("UnableToRemovedFilesAndFolders", unableToRemovedFilesAndFolders);
                    cleanedUpDetails.put("cleanupTime in UTC", dateFormat.format(cleanupTime));
                }
            }
            catch (Exception e) {
                if (!isDebug) break block17;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "cleanedUpDetails: " + cleanedUpDetails, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return cleanedUpDetails;
    }

    private List executePowerShellScriptForCleanup() {
        ArrayList commandOutput;
        block8: {
            String methodName = "executePowerShellScriptForCleanup";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, "executePowerShellScriptForCleanup", "Entered", null);
            }
            commandOutput = null;
            try {
                boolean bCleanMgr = true;
                boolean bVolumeShadowCopy = true;
                String CONST_COMMAND = "powershell.exe";
                String CONST_PS_FILENAME = "AutomationDiskSpace.ps1";
                String CONST_SIGNED_PS_SCRIPT_LOCATION = String.valueOf(EgInstallInfo.getInstallDir()) + "\\bin\\PSSignedScripts\\lib\\" + CONST_PS_FILENAME;
                String CONST_PS_SCRIPT_LOCATION = String.valueOf(EgInstallInfo.getInstallDir()) + "\\lib\\" + CONST_PS_FILENAME;
                String cmdWithScriptLoc = String.valueOf(CONST_COMMAND) + " \"" + CONST_PS_SCRIPT_LOCATION + " " + bCleanMgr + " " + bVolumeShadowCopy + "\"";
                if (EgMainAgent.isPSSignedScriptEnabled) {
                    cmdWithScriptLoc = String.valueOf(CONST_COMMAND) + " \"" + CONST_SIGNED_PS_SCRIPT_LOCATION + " " + bCleanMgr + " " + bVolumeShadowCopy + "\"";
                }
                if (isDebug) {
                    DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, "executePowerShellScriptForCleanup", "cmdWithScriptLoc: " + cmdWithScriptLoc, null);
                }
                EgUtilities egutil = EgUtilities.createInstance();
                commandOutput = egutil.getExecOutputLinesForPSCommand(cmdWithScriptLoc);
                if (isDebug) {
                    DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, "executePowerShellScriptForCleanup", "commandOutput: " + commandOutput, null);
                }
            }
            catch (Exception e) {
                if (!isDebug) break block8;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, "executePowerShellScriptForCleanup", e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, "executePowerShellScriptForCleanup", "commandOutput: " + commandOutput, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, "executePowerShellScriptForCleanup", "Exited", null);
        }
        return commandOutput;
    }

    private HashMap parsePwrShlScrptOutput(List pwrShlScrptOutput) {
        HashMap<String, Object> parsedPwrShlScrptOutput;
        String methodName;
        block17: {
            methodName = "parsePwrShlScrptOutput";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
            }
            if (isDebug) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Given arguments:- pwrShlScrptOutput: " + pwrShlScrptOutput, null);
            }
            parsedPwrShlScrptOutput = new HashMap<String, Object>();
            parsedPwrShlScrptOutput.put("RemovedFilesAndFolders", new ArrayList());
            parsedPwrShlScrptOutput.put("UnableToRemovedFilesAndFolders", new ArrayList());
            parsedPwrShlScrptOutput.put("cleanedSpaceinBytes", "0");
            try {
                ArrayList outStream;
                ArrayList errStream = (ArrayList)pwrShlScrptOutput.get(1);
                if (errStream.size() == 0 && (outStream = (ArrayList)pwrShlScrptOutput.get(0)) != null && outStream.size() > 0) {
                    boolean fileDeletEnd = true;
                    ArrayList<String> cleanedFlsAndFldrs = null;
                    ArrayList<String> unbleToClnFls = null;
                    long cleanedSpace = 0L;
                    int incr = 0;
                    while (incr < outStream.size()) {
                        String crntLine = outStream.get(incr).toString();
                        if (isDebug) {
                            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "crntLine: " + crntLine, null);
                        }
                        if ("File deletion starts".equalsIgnoreCase(crntLine)) {
                            fileDeletEnd = false;
                            cleanedFlsAndFldrs = new ArrayList<String>();
                            unbleToClnFls = new ArrayList<String>();
                        } else if ("File deletion end".equalsIgnoreCase(crntLine)) {
                            fileDeletEnd = true;
                        } else {
                            if (crntLine.trim().startsWith("Disk Space Freed =")) {
                                int endIndx = crntLine.toLowerCase().indexOf("kb");
                                if (crntLine.indexOf("=") == -1 || endIndx == -1) break;
                                crntLine = crntLine.substring(crntLine.indexOf("=") + 1, endIndx);
                                cleanedSpace = Long.parseLong(crntLine.trim()) * 1000L;
                                break;
                            }
                            if (!fileDeletEnd) {
                                if (crntLine.startsWith("Unable to delete:")) {
                                    unbleToClnFls.add(crntLine.substring(crntLine.indexOf("Unable to delete:") + 17).trim());
                                } else {
                                    cleanedFlsAndFldrs.add(crntLine.trim());
                                }
                            }
                        }
                        ++incr;
                    }
                    parsedPwrShlScrptOutput = new HashMap();
                    parsedPwrShlScrptOutput.put("RemovedFilesAndFolders", cleanedFlsAndFldrs);
                    parsedPwrShlScrptOutput.put("UnableToRemovedFilesAndFolders", unbleToClnFls);
                    parsedPwrShlScrptOutput.put("cleanedSpaceinBytes", new Long(cleanedSpace));
                }
            }
            catch (Exception e) {
                if (!isDebug) break block17;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "pssClndDtls: " + parsedPwrShlScrptOutput, null);
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return parsedPwrShlScrptOutput;
    }

    private ArrayList checkAndExpandAllwdDblWldCrdPaths(List filteredCleanupRules) {
        String methodName = "checkAndExpandAllwdDblWldCrdPaths";
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- filteredCleanupRules: " + filteredCleanupRules, null);
        }
        ArrayList<String> expandedFilteredCleanupRules = new ArrayList<String>();
        if (filteredCleanupRules != null) {
            int incr = 0;
            while (incr < filteredCleanupRules.size()) {
                String curFilteredCleanupRule = (String)filteredCleanupRules.get(incr);
                if (DiskSpaceTest.allwdDblWldcrdPaths.get(curFilteredCleanupRule.toUpperCase()) != null) {
                    Map curFilesAndFolders = new HashMap();
                    String pathSgmntTillFrstWldCrd = curFilteredCleanupRule.substring(0, curFilteredCleanupRule.indexOf("\\*"));
                    String pathSgmntFromFrstWldCrd = curFilteredCleanupRule.substring(curFilteredCleanupRule.indexOf("\\*") + 2);
                    String envSubstdCleanupRule = null;
                    try {
                        envSubstdCleanupRule = this.getEnvSubstdCleanupRule(pathSgmntTillFrstWldCrd);
                        if (envSubstdCleanupRule == null) {
                            envSubstdCleanupRule = pathSgmntTillFrstWldCrd;
                        }
                    }
                    catch (Exception e) {
                        envSubstdCleanupRule = pathSgmntTillFrstWldCrd;
                    }
                    curFilesAndFolders = isAboveJRE17 ? DiskSpaceTestAutmnClnupHelper.getSubObjectsForDir(envSubstdCleanupRule, isWindows, diskSpaceTest, 2, isDebug_methodEntryExit, isDebug) : this.getFrstLvlFldrsInCrnDrctry(envSubstdCleanupRule);
                    if (isDebug) {
                        DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "curFilesAndFolders: " + curFilesAndFolders, null);
                    }
                    ArrayList foldersTmp = new ArrayList();
                    if (curFilesAndFolders.get(CONST_FOLDERS) != null) {
                        foldersTmp = (ArrayList)curFilesAndFolders.get(CONST_FOLDERS);
                    }
                    int incrmnt = 0;
                    while (incrmnt < foldersTmp.size()) {
                        String crntPath = foldersTmp.get(incrmnt).toString();
                        if (!crntPath.trim().toUpperCase().equals(pathSgmntTillFrstWldCrd.toUpperCase())) {
                            expandedFilteredCleanupRules.add(String.valueOf(crntPath) + pathSgmntFromFrstWldCrd);
                        }
                        ++incrmnt;
                    }
                } else {
                    expandedFilteredCleanupRules.add(curFilteredCleanupRule);
                }
                ++incr;
            }
        }
        return expandedFilteredCleanupRules;
    }

    private Map getFrstLvlFldrsInCrnDrctry(String dirPath) {
        HashMap allSubFilesFolders;
        String methodName;
        block12: {
            methodName = "getFrstLvlFldrsInCrnDrctry";
            if (isDebug_methodEntryExit) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Entered", null);
            }
            if (isDebug) {
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Parameters:- dirPath: " + dirPath, null);
            }
            allSubFilesFolders = new HashMap();
            allSubFilesFolders.put(CONST_FOLDERS, null);
            ArrayList<String> folders = new ArrayList<String>();
            try {
                if (dirPath != null && !"".equals(dirPath)) {
                    File directory = new File(dirPath);
                    File[] subObjectsForDir = directory.listFiles();
                    if (subObjectsForDir != null && subObjectsForDir.length > 0) {
                        int incr = 0;
                        while (incr < subObjectsForDir.length) {
                            File curSubObj = subObjectsForDir[incr];
                            if (curSubObj != null && curSubObj.isDirectory()) {
                                if (isWindows) {
                                    folders.add(curSubObj.getAbsolutePath().toUpperCase());
                                } else {
                                    folders.add(curSubObj.getAbsolutePath());
                                }
                            }
                            ++incr;
                        }
                    }
                    allSubFilesFolders.put(CONST_FOLDERS, folders);
                }
            }
            catch (Exception e) {
                if (!isDebug) break block12;
                DiskSpaceTestAutomationCleanup.logForDebug(CONST_EXCEPTION, className, methodName, e.getMessage(), e);
            }
        }
        if (isDebug) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "allSubFilesFolders: " + allSubFilesFolders, null);
        }
        if (isDebug_methodEntryExit) {
            DiskSpaceTestAutomationCleanup.logForDebug(CONST_DEBUG, className, methodName, "Exited", null);
        }
        return allSubFilesFolders;
    }

    private static void logForDebug(String level, String className, String methodName, String message, Throwable t) {
        try {
            String curDate = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss.SSS").format(new Date());
            if (t == null) {
                System.out.println(String.valueOf(curDate) + " : " + level + " : " + className + ": " + methodName + " : " + message);
            } else {
                System.out.println(String.valueOf(curDate) + " : " + CONST_EXCEPTION + " : " + className + ": " + methodName + " : " + t.getMessage());
                t.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

