/*
 * Decompiled with CFR 0.152.
 */
public class DominoDbTest
extends EgSnmpTest {
    public static final boolean verbose = false;
    private static int cacheCurrEntriesIndex = 0;
    private static int cacheMaxEntriesIndex = 1;
    private static int cacheHitRatioIndex = 2;
    private long cacheCurrEntries = -1L;
    private double cacheHitRatio = 0.0;
    private long cacheLookups = -1L;
    private long cacheMaxEntries = -1L;
    private long cacheInitialDbOpens = 0L;
    private long cacheHits = 0L;
    private static String cacheCurrEntriesOid = ".1.3.6.1.4.1.334.72.1.1.10.15";
    private static String cacheInitialDbOpensOid = ".1.3.6.1.4.1.334.72.1.1.10.18";
    private static String cacheHitsOid = ".1.3.6.1.4.1.334.72.1.1.10.17";
    private static String cacheMaxEntriesOid = ".1.3.6.1.4.1.334.72.1.1.10.20";

    public DominoDbTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 3;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: DominoDbTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-port")) {
                    if (++i < stringArray.length) {
                        this.portNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoDbTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-snmpPort")) {
                    if (++i < stringArray.length) {
                        this.snmpPortNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: DominoDbTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (!stringArray[i].equalsIgnoreCase("-snmpCommunity")) continue;
                if (++i < stringArray.length) {
                    this.community = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: DominoDbTest -host <targetHost> -port <port>-snmpPort <snmpPort> -snmpCommunity <community>");
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.40", "-snmpPort", "161", "-port", "25", "-snmpCommunity", "public"};
        DominoDbTest dominoDbTest = new DominoDbTest(stringArray2);
        try {
            for (int i = 0; i < 2; ++i) {
                dominoDbTest.executeTest();
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean executeTest() {
        this.initTest();
        String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        this.cacheCurrEntries = this.getMeasure(cacheCurrEntriesOid);
        this.cacheHits = this.getMeasure(cacheHitsOid);
        this.cacheInitialDbOpens = this.getMeasure(cacheInitialDbOpensOid);
        this.cacheMaxEntries = this.getMeasure(cacheMaxEntriesOid);
        this.cacheHitRatio = this.cacheInitialDbOpens > 0L ? 100.0 * (1.0 * (double)this.cacheHits / (double)this.cacheInitialDbOpens) : 100.0;
        double d = this.cacheHitRatio = this.cacheHitRatio >= 0.0 ? this.cacheHitRatio : -1.0;
        if (this.timeSinceLastTest < 0.0) {
            this.addValueToResultSet(string, cacheCurrEntriesIndex, -1.0);
            this.addValueToResultSet(string, cacheHitRatioIndex, -1.0);
            this.addValueToResultSet(string, cacheMaxEntriesIndex, -1.0);
            this.updateAllResultSets();
        } else {
            this.addValueToResultSet(string, cacheCurrEntriesIndex, this.cacheCurrEntries);
            this.addValueToResultSet(string, cacheHitRatioIndex, this.cacheHitRatio);
            this.addValueToResultSet(string, cacheMaxEntriesIndex, this.cacheMaxEntries);
            this.updateAllResultSets();
        }
        return true;
    }

    private long getMeasure(String string) {
        String string2 = null;
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return -1L;
    }
}

