/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class EDirDbCacheTest
extends EgSnmpGenericTest {
    private static String id = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.1";
    private static String dbSize = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.2";
    private static String dbBlockSize = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.3";
    private static String dbEntryCurrentSize = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.6";
    private static String dbBlockCurrentSize = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.7";
    private static String dbEntryItemsCached = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.8";
    private static String dbBlockItemsCached = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.9";
    private static String dbEntryCacheHits = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.14";
    private static String dbBlockCacheHits = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.15";
    private static String dbEntryCacheFaults = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.18";
    private static String dbBlockCacheFaults = ".1.3.6.1.4.1.23.2.98.1.2.1.1.1.19";
    private static int numMeasures = 8;
    private int rediscCount = -1;
    private static int maxRediscPeriod = 4;
    ArrayList idNames = new ArrayList();
    private Hashtable idMap = new Hashtable();
    private Hashtable DbSize;
    private Hashtable DbBlockSize;
    private Hashtable DbEntryCurrentSize;
    private Hashtable DbBlockCurrentSize;
    private Hashtable DbEntryItemsCached;
    private Hashtable DbBlockItemsCached;
    private Hashtable DbEntryCacheHits;
    private Hashtable DbBlockCacheHits;
    private Hashtable DbEntryCacheFaults;
    private Hashtable DbBlockCacheFaults;
    private Hashtable prevDbEntryCacheHits = new Hashtable();
    private Hashtable prevDbBlockCacheHits = new Hashtable();
    private Hashtable prevDbEntryCacheFaults = new Hashtable();
    private Hashtable prevDbBlockCacheFaults = new Hashtable();
    private boolean isFirstTime = true;
    private int numIds = 0;

    public EDirDbCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    public static void main(String[] stringArray) {
        stringArray = new String[]{"-host", "192.168.10.32", "-port", "NULL", "-snmpCommunity", "public", "-snmpPort", "161"};
        EDirDbCacheTest eDirDbCacheTest = new EDirDbCacheTest(stringArray);
        eDirDbCacheTest.computeMeasures(new Hashtable());
    }

    private void initAll() {
        this.DbSize = new Hashtable();
        this.DbBlockSize = new Hashtable();
        this.DbEntryCurrentSize = new Hashtable();
        this.DbBlockCurrentSize = new Hashtable();
        this.DbEntryItemsCached = new Hashtable();
        this.DbBlockItemsCached = new Hashtable();
        this.DbEntryCacheHits = new Hashtable();
        this.DbBlockCacheHits = new Hashtable();
        this.DbEntryCacheFaults = new Hashtable();
        this.DbBlockCacheFaults = new Hashtable();
    }

    private void initPrev() {
    }

    private void discIds() {
        int n;
        ++this.rediscCount;
        if (this.rediscCount >= maxRediscPeriod) {
            this.rediscCount = 0;
        }
        if (this.rediscCount != 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(id);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.idMap = new Hashtable();
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.lhs.length; ++n) {
            this.idMap.put(this.lhs[n], this.rhs[n]);
            arrayList.add(this.rhs[n]);
        }
        if (arrayList.size() != this.idNames.size()) {
            bl2 = true;
        } else {
            String string;
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                if (this.idNames.contains(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                for (n = 0; n < this.idNames.size(); ++n) {
                    string = (String)this.idNames.get(n);
                    if (arrayList.contains(string)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.initPrev();
        }
        this.idNames = arrayList;
        this.numIds = this.lhs.length;
    }

    private double getValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.initAll();
        this.discIds();
        if (this.numIds == 0) {
            return;
        }
        this.runCommand(dbSize, this.DbSize);
        this.runCommand(dbBlockSize, this.DbBlockSize);
        this.runCommand(dbEntryCurrentSize, this.DbEntryCurrentSize);
        this.runCommand(dbBlockCurrentSize, this.DbBlockCurrentSize);
        this.runCommand(dbEntryItemsCached, this.DbEntryItemsCached);
        this.runCommand(dbBlockItemsCached, this.DbBlockItemsCached);
        this.runCommand(dbEntryCacheHits, this.DbEntryCacheHits);
        this.runCommand(dbBlockCacheHits, this.DbBlockCacheHits);
        this.runCommand(dbEntryCacheFaults, this.DbEntryCacheFaults);
        this.runCommand(dbBlockCacheFaults, this.DbBlockCacheFaults);
        Enumeration enumeration = this.idMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.idMap.get(string);
            if (string == null || string2 == null) continue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(this.getValueFromTable(this.DbSize, string) / 1024.0));
            arrayList.add(new Double(this.getValueFromTable(this.DbBlockSize, string) / 1024.0));
            arrayList.add(new Double(this.getValueFromTable(this.DbEntryCurrentSize, string) / 1024.0));
            arrayList.add(new Double(this.getValueFromTable(this.DbBlockCurrentSize, string) / 1024.0));
            arrayList.add(new Double(this.getValueFromTable(this.DbEntryItemsCached, string)));
            arrayList.add(new Double(this.getValueFromTable(this.DbBlockItemsCached, string)));
            double d = this.getValueFromTable(this.DbEntryCacheHits, string);
            double d2 = this.getValueFromTable(this.DbBlockCacheHits, string);
            double d3 = this.getValueFromTable(this.DbEntryCacheFaults, string);
            double d4 = this.getValueFromTable(this.DbBlockCacheFaults, string);
            this.prevDbEntryCacheHits.put(string, new Double(d));
            this.prevDbBlockCacheHits.put(string, new Double(d2));
            this.prevDbEntryCacheFaults.put(string, new Double(d3));
            this.prevDbBlockCacheFaults.put(string, new Double(d4));
            string2 = "Database" + string2;
            if (this.isFirstTime) {
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
            } else {
                double d5 = this.getValueFromTable(this.prevDbEntryCacheHits, string);
                double d6 = this.getValueFromTable(this.prevDbBlockCacheHits, string);
                double d7 = this.getValueFromTable(this.prevDbEntryCacheFaults, string);
                double d8 = this.getValueFromTable(this.prevDbBlockCacheFaults, string);
                double d9 = (d -= d5) + (d3 -= d7) == 0.0 ? 100.0 : d / (d + d3) * 100.0;
                double d10 = d2 + d4 == 0.0 ? 100.0 : (d2 -= d6) / (d2 + (d4 -= d8)) * 100.0;
                arrayList.add(new Double(d9));
                arrayList.add(new Double(d10));
            }
            this.addNewMeasure(string2, arrayList);
        }
        this.isFirstTime = false;
    }

    public double getValueFromTable(Hashtable hashtable, String string) {
        double d = -5.0;
        if (hashtable != null && hashtable.containsKey(string)) {
            d = (Double)hashtable.get(string);
        }
        return d;
    }

    public void runCommand(String string, Hashtable hashtable) {
        if (this.runSnmpCmdForOid(string) && this.lhs != null && this.lhs.length > 0) {
            for (int i = 0; i < this.lhs.length; ++i) {
                double d = this.getValue(this.rhs[i]);
                hashtable.put(this.lhs[i], new Double(d));
            }
        }
    }
}

