/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class EMCECSValidator
extends EgServerValidator {
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String test = "";
    public String reportingName = "";
    public String entity = null;
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String isAgentLess = "";
    public String baseURLString = null;
    public String timeout = "";
    public boolean meAgentLess = false;
    public boolean isFromManager = false;
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    private String strEMCECSValidatorLogSizeLimitInMB = null;
    private static final double MB_TO_BYTES = 1048576.0;
    private static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double emcecsValidatorLogSizeLimitInMB = 1048576.0;
    private static final int j = 124;
    protected static final String ECS_DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/EMCECSValidatorLog";
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public int code = 0;
    String className = this.getClass().getName();
    EgUtilities egutil = EgUtilities.createInstance();

    public EMCECSValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-host")) {
                    this.host = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-port")) {
                    if (this.port == null || this.port.trim().length() == 0 || this.port.equalsIgnoreCase("null") || this.port.equalsIgnoreCase("none")) {
                        this.port = string4.trim();
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-ecs_rest_api_port")) {
                    if (this.port == null || this.port.trim().length() == 0 || this.port.equalsIgnoreCase("null") || this.port.equalsIgnoreCase("none")) {
                        this.port = string4.trim();
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-username")) {
                    this.user = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-password")) {
                    if ((string4 = EgCrypt.decrypt(string4)).indexOf("~EG~") != -1) {
                        string4 = string4.substring(0, string4.indexOf("~EG~"));
                    }
                    this.password = string4;
                } else if (string3 != null && string3.equalsIgnoreCase("-test")) {
                    this.test = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-timeout_seconds")) {
                    this.timeout = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string4;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                    } else {
                        this.isAgentLess = "false";
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-almode")) {
                    this.alMode = string4;
                } else if (string3 != null && string3.equalsIgnoreCase("-aluser")) {
                    this.alUser = string4;
                } else if (string3 != null && string3.equalsIgnoreCase("-alpassword")) {
                    this.alPassword = string4;
                }
                IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
                this.strEMCECSValidatorLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", "EMCECSValidatorLogSizeLimitInMB");
                if (this.strEMCECSValidatorLogSizeLimitInMB != null && this.strEMCECSValidatorLogSizeLimitInMB.length() > 0) {
                    this.strEMCECSValidatorLogSizeLimitInMB = this.strEMCECSValidatorLogSizeLimitInMB.trim();
                    try {
                        this.emcecsValidatorLogSizeLimitInMB = Double.parseDouble(this.strEMCECSValidatorLogSizeLimitInMB);
                        this.emcecsValidatorLogSizeLimitInMB *= 1048576.0;
                        this.printOut(string + "emcecsValidatorLogSizeLimitInMB value in bytes : " + this.emcecsValidatorLogSizeLimitInMB);
                    }
                    catch (Exception exception) {
                        this.printOut(string + "Convertion error for strEMCECSValidatorLogSizeLimitInMB value to bytes : " + this.strEMCECSValidatorLogSizeLimitInMB + " ,exception :" + exception.toString());
                        this.emcecsValidatorLogSizeLimitInMB = 1048576.0;
                    }
                    continue;
                }
                this.emcecsValidatorLogSizeLimitInMB = 1048576.0;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        this.entity = this.className;
        this.baseURLString = "https://" + this.host + ":" + this.port + "/";
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "*******************************************************************************");
        this.printOut(string + "EMCECS host       :" + this.host);
        this.printOut(string + "EMCECS port       :" + this.port);
        this.printOut(string + "EMCECS username   :" + this.user);
        this.printOut(string + "EMCECS password   :**********");
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        int n = 0;
        if (!this.isIPReachable()) {
            this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
            this.validationMsgs.add(1, "Port$#$NA");
        } else if (!this.isSpecificPortReachable(this.port)) {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$Port " + this.port + " is down or listener is down");
        } else {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$OK");
            n = this.getResponseDataFromExe();
            this.checkEMCECSConnectivity(n);
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    public void checkEMCECSConnectivity(int n) {
        String string = "checkEMCECSConnectivity";
        string = this.methodNameTemplate(string);
        int n2 = n;
        this.printOut(string + "Response code :" + n2);
        if (n2 == 200) {
            this.validationErrorMsg = "code 200 - Server is running normal";
            this.validationMsgs.add("User/Password$#$OK");
            this.validationMsgs.add("EMCECS Server Connectivity$#$OK");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 500) {
            this.validationErrorMsg = "Error 500 - No Response from server due to internal server error";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("EMCECS Server Connectivity$#$No Response from server due to internal server error");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 404) {
            this.validationErrorMsg = "Error 404 - No Response from server";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("EMCECS Server Connectivity$#$No Response from server");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 503) {
            this.validationErrorMsg = "Error 503 - The server is currently unavailable or not started";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("EMCECS Server Connectivity$#$The server is currently unavailable or not started");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 401) {
            this.validationErrorMsg = "Error 401 - Unauthorized: Access is denied due to invalid credentials";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("EMCECS Server Connectivity$#$ Access denied. Please check Username/Password");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else {
            this.validationMsgs.add("Test Process error $#$ Error");
            this.printOut(string + "Executional error occured for Response Code :" + n2);
        }
    }

    public int getResponseDataFromExe() {
        Object object;
        String string;
        String string2 = "getResponseDataFromExe";
        string2 = this.methodNameTemplate(string2);
        String string3 = null;
        String string4 = "java";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        boolean bl = false;
        int n = 0;
        ArrayList arrayList = new ArrayList();
        try {
            string = System.getProperty("os.name");
            String string10 = System.getProperty("java.version");
            object = System.getProperty("os.arch");
            if (string10.compareTo("10.0") > 0) {
                string3 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                if (string != null && string.toLowerCase().indexOf("win") >= 0) {
                    string3 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                }
                this.printOut(string2 + "javaVersion 10.0 HeapDumpPath :" + string3);
            } else if (string10.compareTo("1.7") > 0) {
                string3 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
                if (string != null && string.toLowerCase().indexOf("win") >= 0) {
                    string3 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
                this.printOut(string2 + "javaVersion 1.7  HeapDumpPath :" + string3);
            } else if (string10.compareTo("1.6") > 0) {
                string3 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null";
                if (string != null && string.toLowerCase().indexOf("win") >= 0) {
                    string3 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL";
                }
                this.printOut(string2 + "javaVersion 1.6 HeapDumpPath :" + string3);
            }
            if (string3 != null) {
                this.printOut(string2 + " HeapDumpPath :" + string3);
                string4 = string4 + " " + string3;
                this.printOut(string2 + " HeapDumpPath :" + string3 + " java options : " + string4);
            }
        }
        catch (Exception exception) {
            this.printOut(string2 + "Error while set the heapDumpPath to call rexec process  :" + exception);
        }
        this.printOut(string2 + " javaOptions " + string4);
        string8 = "-host " + this.host + " -ecs_rest_api_port " + this.port + " -username " + this.user + " -password " + this.password + " -timeout_seconds " + this.timeout + " -rptname " + this.reportingName + " -entity " + this.entity + " -log_size " + 20;
        this.printOut(string2 + "Arguments :" + string8);
        try {
            boolean bl2;
            string = System.getProperty("os.name").toLowerCase();
            boolean bl3 = bl2 = System.getProperty("java.version").compareTo("1.5") > 0;
            if (string.indexOf("win") >= 0) {
                bl = true;
            }
            if (bl) {
                string6 = EgInstallInfo.getInstallDir() + "\\jre\\bin\\";
                string7 = EgInstallInfo.getInstallDir() + "\\lib\\eg_agent.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\eg_util.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\commons-codec.jar;" + EgInstallInfo.getInstallDir() + "\\agent\\lib\\json-simple-1.1.1.jar";
                string5 = bl2 ? "cmd.exe /c " + string6 + string4 + " -client -cp \"" + string7 + "\" EMCECSValidatorRESTExecutor " + string8 : "cmd.exe /c " + string6 + string4 + " -cp \"" + string7 + "\" EMCECSValidatorRESTExecutor " + string8;
            } else if (string.indexOf("aix") >= 0) {
                string7 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string5 = "/opt/egurkha/jre/bin/" + string4 + " -cp " + string7 + " EMCECSValidatorRESTExecutor " + string8;
            } else if (bl2) {
                string7 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string5 = "/opt/egurkha/jre/bin/" + string4 + " -client -cp " + string7 + " EMCECSValidatorRESTExecutor " + string8;
            } else {
                string7 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string5 = "/opt/egurkha/jre/bin/" + string4 + " -cp " + string7 + " EMCECSValidatorRESTExecutor " + string8;
            }
            this.printOut(string2 + "Inside execute program :" + string5);
            this.printOut(string2 + "Going to call getExecOutputLines to execute  EMCECSValidatorRESTExecutor");
            object = this.egutil.getExecOutputLines(string5);
            this.printOut(string2 + "Completed  getExecOutputLines method call for  EMCECSValidatorRESTExecutor");
            if (object == null || ((ArrayList)object).size() < 2) {
                string9 = string2 + "Rexec process returned null or some exception " + object;
                this.printOut(string9);
                string9 = "";
            } else {
                string9 = string2 + "Rexec process returned Values  :" + object;
                this.printOut(string9);
                string9 = "";
                arrayList = (ArrayList)((ArrayList)object).clone();
                String string11 = arrayList.get(0).toString();
                this.printOut(string2 + "Response Value from exe :" + string11);
                if (string11.equalsIgnoreCase(null) || string11.length() > 0) {
                    String string12 = string11.substring(string11.indexOf(":") + 1, string11.indexOf("]"));
                    try {
                        n = Integer.parseInt(string12);
                    }
                    catch (Exception exception) {
                        string9 = "Error occured while parsing String to Integer";
                        this.printOutStackTrace(string9, exception);
                        string9 = "";
                        n = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.printOut(string2 + "Error while rexec process :" + exception);
        }
        return n;
    }

    public String decrypt(String string) {
        int n;
        if (string != null && string.length() < 2) {
            return string;
        }
        if (string != null && string.indexOf(":") == -1) {
            return string;
        }
        ArrayList arrayList = this.myTokenizer(string, ":");
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n2 = n = arrayList.size();
        byte[] byArray = new byte[n];
        String string2 = null;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayList.get(i);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string;
            }
            int n5 = 124 - n4 + n3 * 3;
            --n3;
            byArray[--n] = (byte)n5;
        }
        String string3 = new String(byArray);
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        EMCECSValidator.debugLogToFile(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + MY_SDF.format(new Date()) + " ] :>> " + string, this.emcecsValidatorLogSizeLimitInMB);
    }

    public void putErrorMessageToLogfile(String string) {
        EMCECSValidator.debugLogToFile("ERROR :" + this.reportingName + " : " + this.entity + " : " + string, this.emcecsValidatorLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        EMCECSValidator.debugLogToFile("INFO :" + this.reportingName + " : " + this.entity + " : " + string, this.emcecsValidatorLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        EMCECSValidator.debugLogToFile("WARNING :" + this.reportingName + " : " + this.entity + " : " + string, this.emcecsValidatorLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = ECS_DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            EMCECSValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        EMCECSValidator eMCECSValidator = new EMCECSValidator(stringArray, new Boolean(false));
        eMCECSValidator.getValidationMsgs();
    }
}

