/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.EgInstallInfo;
import com.eg.IPV6Helper;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ApmDemoInfo;
import com.eg.apm.Container;
import com.eg.apm.ContainerInstanceFactory;
import com.eg.apm.ContainersService;
import com.eg.apm.ContainerzDiscovery;
import com.eg.jtm.BTMConstants;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class EgAPMBTMDiscovery
extends Thread {
    private static EgMainAgent parent = null;
    public static Boolean syncFlag = new Boolean(true);
    String hostName = "";
    String primaryMgrIp;
    String primaryMgrPort;
    String thisMgrIp;
    String thisMgrPort;
    boolean natURLExists = false;
    String primaryNATUrl = "none";
    private long apmIniLastUpdatedTime = 0L;
    private long apmDiscoveryIniLastUpdatedTime = 0L;
    private long lastuploadedTime = 0L;
    private long lastUploadTimeOfAllManagedComponents = 0L;
    private long reuploadTime = 21600000L;
    int responseCode;
    boolean isSuccessfullSent = true;
    boolean autoDelete = true;
    private static int threshForApmDiscovery = 1440;
    private static int threshForDockerApmDiscovery = 5;
    private static int autoDeleteListStartUpdelay = 6;
    private static boolean useKubeServiceNameInAppflow = true;
    public static final long minSleep = 50L;
    Container containerInstance = null;
    private long lastApmIniModifiedTime = -1L;
    private TreeSet markedForDeletion = null;
    private HashMap markedForDeletionFullData = null;
    private static long lastAgentTestsModifiedTime = -1L;
    private static long agentStartUpTime = System.currentTimeMillis();
    private static boolean okToSendAutoDeleteData = false;
    private static boolean agentDiscoverEnabled = true;
    private static HashMap guidMap = new HashMap();
    private static HashMap managedCompCounter = new HashMap();
    private static HashMap deletedCompCounter = new HashMap();
    private static final String loggerDispStr = "[EgAPMBTMDiscovery]";
    String nickNames;
    String[] ipAddresses;
    String discBase = "";
    private long lastRunTime = 0L;

    public EgAPMBTMDiscovery(EgMainAgent egMainAgent) {
        parent = egMainAgent;
        this.hostName = egMainAgent.getHostName();
        this.primaryMgrIp = EgMainAgent.mgrIp;
        this.primaryMgrPort = EgMainAgent.port;
        this.thisMgrIp = EgMainAgent.mgrIp;
        this.thisMgrPort = EgMainAgent.port;
        this.setDaemon(true);
        this.setName("EgAPMBTMDiscovery");
        this.markedForDeletion = new TreeSet();
        this.markedForDeletionFullData = new HashMap();
        ApmDemoInfo.initDemoMode();
        ApmConfigManager.getInstance();
        new ApmDiscoveryContributor();
        APMDiscoveryLogger.discoveryLogger.info("{} EgAPMBTMDiscovery Thread started ", (Object)loggerDispStr);
        try {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_nick.ini");
            this.nickNames = iniFile.getValue("NICKNAME", "Nick");
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to read nickname from eg_nick.ini in EgAPMBTMDiscovery Thread", (Object)loggerDispStr, (Object)exception);
        }
    }

    public void run() {
        this.suspendForPeriod(30000L);
        this.isAgentTestsIniUpdated();
        APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} ", (Object)loggerDispStr, (Object)agentDiscoverEnabled);
        if (APMUtils.isLinux()) {
            this.containerInstance = ContainerInstanceFactory.getInstance().getContainerInstance();
        }
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
        long l = 300000L;
        while (true) {
            String string;
            if ((string = iniFile.getValue("AGENT_SETTINGS", "BTMDiscoveryShortSleepTime")) != null && string.length() != 0) {
                try {
                    int n = Integer.parseInt(string);
                    l = (long)n * 1000L;
                }
                catch (Exception exception) {
                    l = 120000L;
                }
            } else {
                l = 120000L;
            }
            if (new Boolean(iniFile.getValue("MANAGER_SETTINGS", "ClusterSupported")).booleanValue()) {
                this.primaryMgrIp = iniFile.getValue("PRIMARY", "Ip");
                this.primaryMgrPort = iniFile.getValue("PRIMARY", "Port");
                this.primaryNATUrl = iniFile.getValue("PRIMARY", "natUrl");
                this.natURLExists = this.primaryNATUrl != null && this.primaryNATUrl.length() > 0 && !this.primaryNATUrl.equalsIgnoreCase("none");
            }
            this.startContainerPortDiscovery();
            this.startBTMDiscover();
            this.suspendForPeriod(l);
        }
    }

    public void startBTMDiscover() {
        if (!agentDiscoverEnabled) {
            this.suspendForPeriod(180000L);
            this.isAgentTestsIniUpdated();
            if (!agentDiscoverEnabled) {
                APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} , Skipping the process..", (Object)loggerDispStr, (Object)agentDiscoverEnabled);
                return;
            }
        }
        APMDiscoveryHelper.printConfigs();
        if (!APMDiscoveryHelper.isProcessAndTransmitBTMDiscoveryDataViaEgApmBtmDiscovery()) {
            AgentLogger.discoveryLogger.trace("{} Transmit discovery data via EgApmBtmDiscovery is disabled, Skipping the process..", (Object)loggerDispStr);
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.lastRunTime;
        boolean bl = false;
        if (l2 >= 300000L) {
            this.isAgentTestsIniUpdated();
            bl = true;
        } else {
            this.isAgentTestsIniUpdated();
        }
        this.isOkToSendAutoDeleteData();
        ApmDiscoveryContributor apmDiscoveryContributor = new ApmDiscoveryContributor(true);
        apmDiscoveryContributor.findKubernetesServiceNames();
        String string = EgInstallInfo.getInstallDir() + "/agent/config/eg_apmdiscovery.ini";
        String string2 = EgInstallInfo.getInstallDir() + "/agent/config/eg_apm.ini";
        IniFile iniFile = new IniFile(string);
        long l3 = IniFile.getLastModified(string2);
        long l4 = IniFile.getLastModified(string);
        if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
            APMDiscoveryLogger.discoveryLogger.trace("{} managedCompCounter  : {} ", (Object)loggerDispStr, (Object)managedCompCounter);
            APMDiscoveryLogger.discoveryLogger.trace("{} deletedCompCounter  : {} ", (Object)loggerDispStr, (Object)deletedCompCounter);
            APMDiscoveryLogger.discoveryLogger.trace("{} okToSendAutoDeleteData  : {} ", (Object)loggerDispStr, (Object)okToSendAutoDeleteData);
            APMDiscoveryLogger.discoveryLogger.trace("{} doProcess  : {} , reuploadTime  : {}, lastRunTime  : {} ", new Object[]{loggerDispStr, bl, this.reuploadTime, this.lastRunTime});
            APMDiscoveryLogger.discoveryLogger.trace("{} apmIniLastUpdatedTime  : {}, apmDiscoveryIniLastUpdatedTime  : {}, currentApmIniTime  : {} ", new Object[]{loggerDispStr, this.apmIniLastUpdatedTime, this.apmDiscoveryIniLastUpdatedTime, l3});
            APMDiscoveryLogger.discoveryLogger.trace("{} hostName  : {} ", (Object)loggerDispStr, (Object)this.hostName);
        }
        long l5 = System.currentTimeMillis();
        long l6 = l5 - this.lastuploadedTime;
        if (l4 == this.apmDiscoveryIniLastUpdatedTime && l3 == this.apmIniLastUpdatedTime && l6 < this.reuploadTime && !bl) {
            APMDiscoveryLogger.discoveryLogger.trace("{} eg_apmDiscovery.ini not updated, so skipping the discovery data upload process  : {} ", (Object)loggerDispStr);
            return;
        }
        if (this.apmIniUpdated()) {
            this.readFromApmIni();
        }
        this.apmIniLastUpdatedTime = l3;
        this.apmDiscoveryIniLastUpdatedTime = l4;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.getLinesAsMap(iniFile, "JAVA_SERVER_DETAILS_DISCOVERD_TIME");
        HashMap hashMap2 = this.getLinesAsMap(iniFile, "LAST_HEART_BEAT_CHECK_TIME");
        HashMap hashMap3 = this.getLinesAsMap(iniFile, "APPFLOW_SERVICE_AUTO_NAME_MAPPING");
        HashMap hashMap4 = this.getLinesAsMap(iniFile, "KUBERNETES_DETAILS");
        this.markedForDeletion = new TreeSet();
        this.markedForDeletionFullData = new HashMap();
        HashMap hashMap5 = new HashMap();
        HashMap hashMap6 = new HashMap();
        if (okToSendAutoDeleteData) {
            arrayList = this.deleteBtmComponents(iniFile, hashMap, hashMap2, hashMap3);
        } else {
            hashMap5 = this.getLinesAsMap(iniFile, "NEWLY_DISCOVERD_DETAILS_CONTAINER_BASED");
            hashMap6 = this.getLinesAsMap(iniFile, "NEWLY_DISCOVERD_DETAILS");
            guidMap = new HashMap();
            guidMap.putAll(hashMap5);
            guidMap.putAll(hashMap6);
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = this.discoverBtmComponentsNew(iniFile, hashMap, arrayList, hashMap2, arrayList2, hashMap3, hashMap4);
        long l7 = l5 - this.lastUploadTimeOfAllManagedComponents;
        boolean bl2 = l7 >= ApmConfigManager.getInstance().getDiscoveryDataReUploadTime();
        ArrayList arrayList4 = null;
        if (bl2) {
            arrayList4 = this.managedBtmComponents(iniFile, hashMap, arrayList, hashMap2, arrayList2, hashMap3, hashMap4);
            if (arrayList3 != null && arrayList4.size() > 0) {
                arrayList3.addAll(arrayList4);
            }
        }
        if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
            APMDiscoveryLogger.discoveryLogger.trace("{} managedList  : {} ", (Object)loggerDispStr, arrayList4);
            APMDiscoveryLogger.discoveryLogger.trace("{} sendAlreadyManaged  : {} ", (Object)loggerDispStr, (Object)bl2);
            APMDiscoveryLogger.discoveryLogger.trace("{} guidMap  : {} ", (Object)loggerDispStr, (Object)guidMap);
            APMDiscoveryLogger.discoveryLogger.trace("{} heartBeatMap  : {} ", (Object)loggerDispStr, (Object)hashMap2);
            APMDiscoveryLogger.discoveryLogger.trace("{} lastDiscoveredTime  : {} ", (Object)loggerDispStr, (Object)hashMap);
            APMDiscoveryLogger.discoveryLogger.trace("{} appNameMap  : {} ", (Object)loggerDispStr, (Object)hashMap3);
            APMDiscoveryLogger.discoveryLogger.trace("{} serviceNameMap  : {} ", (Object)loggerDispStr, (Object)hashMap4);
        }
        if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
            if (arrayList.size() > 0) {
                APMDiscoveryLogger.discoveryLogger.info("{} Auto Delete List  : {} ", (Object)loggerDispStr, (Object)arrayList);
            }
            if (arrayList3.size() > 0) {
                APMDiscoveryLogger.discoveryLogger.info("{} Auto Manager List : {} ", (Object)loggerDispStr, (Object)arrayList3);
            }
            if (arrayList2.size() > 0) {
                APMDiscoveryLogger.discoveryLogger.info("{} Auto Appname Service List : {} ", (Object)loggerDispStr, arrayList2);
            }
        }
        this.lastRunTime = System.currentTimeMillis();
        if (arrayList3 != null && arrayList3.size() > 0 || arrayList != null && arrayList.size() > 0) {
            this.uploadAgentDiscoveryData(arrayList3, arrayList, arrayList2);
            if (this.responseCode == 200) {
                ArrayList arrayList5 = new ArrayList();
                ArrayList arrayList6 = new ArrayList();
                ArrayList arrayList7 = new ArrayList();
                if (arrayList.size() > 0) {
                    arrayList6 = this.getDeletedDetails(iniFile, arrayList, arrayList5, arrayList7, hashMap2, hashMap, hashMap3, hashMap6, hashMap5);
                }
                if (arrayList3.size() > 0) {
                    this.getManagedDetails(iniFile, arrayList3, hashMap, arrayList5, arrayList7);
                }
                if (arrayList5.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.info("{} addThis to eg_apmdiscovery.ini: {} ", (Object)loggerDispStr, arrayList5);
                }
                if (arrayList7.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.info("{} deleteThis from eg_apmdiscovery.ini: {} ", (Object)loggerDispStr, arrayList7);
                }
                APMDiscoveryHelper.storeToIni(arrayList5, arrayList7);
                if (arrayList6.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.info("{} addThis to trash.ini: {} ", (Object)loggerDispStr, (Object)arrayList6);
                    APMCleanUpUtils aPMCleanUpUtils = new APMCleanUpUtils();
                    aPMCleanUpUtils.addToTempDebugIni(arrayList6);
                }
                if (bl2) {
                    this.lastUploadTimeOfAllManagedComponents = System.currentTimeMillis();
                }
                this.lastuploadedTime = System.currentTimeMillis();
            }
        } else {
            this.clearCounters();
        }
        this.markedForDeletionFullData.clear();
    }

    private void clearCounters() {
        deletedCompCounter.clear();
        managedCompCounter.clear();
    }

    private ArrayList getDeletedDetails(IniFile iniFile, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, HashMap hashMap, HashMap hashMap2, HashMap hashMap3, HashMap hashMap4, HashMap hashMap5) {
        ArrayList<IniHelper> arrayList4 = new ArrayList<IniHelper>();
        try {
            if (this.markedForDeletion != null && this.markedForDeletion.size() > 0) {
                HashMap hashMap6 = this.getLinesAsMap(iniFile, "JAVA_SERVER_DETAILS_CONTAINER_BASED_MANAGED");
                hashMap6.putAll(this.getLinesAsMap(iniFile, "JAVA_SERVER_DETAILS_CONTAINER_BASED"));
                HashMap hashMap7 = this.getLinesAsMap(iniFile, "JAVA_SERVER_DETAILS_MANAGED");
                hashMap7.putAll(this.getLinesAsMap(iniFile, "JAVA_SERVER_DETAILS"));
                if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} [AutoDelete - IniCleanUp] dockerManaged : {} ", (Object)loggerDispStr, (Object)hashMap6);
                    APMDiscoveryLogger.discoveryLogger.trace("{} [AutoDelete - IniCleanUp] standAloneManaged : {} ", (Object)loggerDispStr, (Object)hashMap7);
                    APMDiscoveryLogger.discoveryLogger.trace("{} [AutoDelete - IniCleanUp] markedForDeletionFullData : {} ", (Object)loggerDispStr, (Object)this.markedForDeletionFullData);
                }
                Iterator iterator = this.markedForDeletion.iterator();
                String string = "DELETE_THIS";
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.addToCounter(deletedCompCounter, string2);
                    APMDiscoveryLogger.discoveryLogger.trace("{} [AutoDelete - IniCleanUp] process for : {} ", (Object)loggerDispStr, (Object)string2);
                    if (!this.isReachedToMaximumCounter(deletedCompCounter, string2, 5)) continue;
                    String string3 = (String)this.markedForDeletionFullData.get(string2 + "_Nick");
                    String string4 = (String)this.markedForDeletionFullData.get(string2 + "_Guid");
                    String string5 = string2 + ":" + string3;
                    String string6 = string2 + ":" + string4;
                    if (hashMap7.containsKey(string2)) {
                        arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_MANAGED", string2, string2));
                        arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS", string2, string));
                        arrayList3.add(APMUtils.getIniHelper("APPFLOW_SERVICE_AUTO_NAME_MAPPING", string2, string));
                        arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", string2, string));
                        arrayList3.add(APMUtils.getIniHelper("NEWLY_DISCOVERD_DETAILS", string5, string));
                        arrayList3.add(APMUtils.getIniHelper("LAST_HEART_BEAT_CHECK_TIME", string4, string));
                        arrayList3.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_MAPPING", string2, string));
                        arrayList3.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string4, string));
                        arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_JMX_MAPPING", string2, string));
                        arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_HTTP_PORT_LIST", string6, string));
                        arrayList4.add(APMUtils.getIniHelper("AUTO_DELETED_TIME", string2, new Date().toString()));
                        arrayList4.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS", string2, (String)hashMap7.get(string2)));
                        arrayList4.add(APMUtils.getIniHelper("APPFLOW_SERVICE_AUTO_NAME_MAPPING", string2, (String)hashMap3.get(string2)));
                        arrayList4.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", string2, (String)hashMap2.get(string2)));
                        arrayList4.add(APMUtils.getIniHelper("NEWLY_DISCOVERD_DETAILS", string5, (String)hashMap4.get(string5)));
                        arrayList4.add(APMUtils.getIniHelper("LAST_HEART_BEAT_CHECK_TIME", string4, (String)hashMap.get(string4)));
                        arrayList4.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_MAPPING", string2, iniFile.getValue("JAVA_UNIQUE_GUID_MAPPING", string2)));
                        arrayList4.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string2, iniFile.getValue("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string4)));
                        arrayList4.add(APMUtils.getIniHelper("JAVA_SERVER_JMX_MAPPING", string2, iniFile.getValue("JAVA_SERVER_JMX_MAPPING", string2)));
                        arrayList4.add(APMUtils.getIniHelper("JAVA_SERVER_HTTP_PORT_LIST", string2, iniFile.getValue("JAVA_SERVER_HTTP_PORT_LIST", string6)));
                        deletedCompCounter.remove(string2);
                        managedCompCounter.remove(string2);
                        continue;
                    }
                    if (!hashMap6.containsKey(string2)) continue;
                    arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED_MANAGED", string2, string2));
                    arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED", string2, string));
                    arrayList3.add(APMUtils.getIniHelper("APPFLOW_SERVICE_AUTO_NAME_MAPPING", string2, string));
                    arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", string2, string));
                    arrayList3.add(APMUtils.getIniHelper("NEWLY_DISCOVERD_DETAILS_CONTAINER_BASED", string5, string));
                    arrayList3.add(APMUtils.getIniHelper("LAST_HEART_BEAT_CHECK_TIME", string4, string));
                    arrayList3.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_MAPPING", string2, string));
                    arrayList3.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string4, string));
                    arrayList4.add(APMUtils.getIniHelper("AUTO_DELETED_TIME", string2, new Date().toString()));
                    arrayList4.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED", string2, (String)hashMap6.get(string2)));
                    arrayList4.add(APMUtils.getIniHelper("APPFLOW_SERVICE_AUTO_NAME_MAPPING", string2, (String)hashMap3.get(string2)));
                    arrayList4.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", string2, (String)hashMap2.get(string2)));
                    arrayList4.add(APMUtils.getIniHelper("NEWLY_DISCOVERD_DETAILS_CONTAINER_BASED", string5, (String)hashMap5.get(string5)));
                    arrayList4.add(APMUtils.getIniHelper("LAST_HEART_BEAT_CHECK_TIME", string4, (String)hashMap.get(string4)));
                    arrayList4.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_MAPPING", string2, iniFile.getValue("JAVA_UNIQUE_GUID_MAPPING", string2)));
                    arrayList4.add(APMUtils.getIniHelper("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string2, iniFile.getValue("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string4)));
                    deletedCompCounter.remove(string2);
                    managedCompCounter.remove(string2);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} [AutoDelete - IniCleanUp] Exception occured in getDeletedDetails() : {} ", (Object)loggerDispStr, (Object)exception);
        }
        return arrayList4;
    }

    private ArrayList getManagedDetails(IniFile iniFile, ArrayList arrayList, HashMap hashMap, ArrayList arrayList2, ArrayList arrayList3) {
        HashMap hashMap2 = this.getLinesAsMap(iniFile, "JAVA_SERVER_DETAILS_CONTAINER_BASED");
        HashMap hashMap3 = this.getLinesAsMap(iniFile, "JAVA_SERVER_DETAILS");
        if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
            APMDiscoveryLogger.discoveryLogger.trace("{} [AutoManage - SectionMove] dockerDiscovered : {} ", (Object)loggerDispStr, (Object)hashMap2);
            APMDiscoveryLogger.discoveryLogger.trace("{} [AutoManage - SectionMove] standAloneDiscovered : {} ", (Object)loggerDispStr, (Object)hashMap3);
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                long l2;
                long l3;
                Vector vector = (Vector)arrayList.get(i);
                if (vector == null || vector.size() < 8) continue;
                String string = (String)vector.get(0);
                String string2 = (String)vector.get(1);
                String string3 = (String)vector.get(3);
                String string4 = string2 + ":" + string3 + ":" + string;
                this.addToCounter(managedCompCounter, string4);
                APMDiscoveryLogger.discoveryLogger.trace("{} [AutoManage - SectionMove] process for : {} ", (Object)loggerDispStr, (Object)string4);
                if (!this.isReachedToMaximumCounter(managedCompCounter, string4, 5)) continue;
                String string5 = (String)hashMap.get(string4);
                boolean bl = true;
                if (string5 != null && string5.length() > 0 && (l3 = l - (l2 = Long.parseLong(string5))) < 1800000L) {
                    bl = false;
                }
                APMDiscoveryLogger.discoveryLogger.trace("{} [AutoManage - SectionMove] process for : {}, doThis : {} ", new Object[]{loggerDispStr, string4, bl});
                if (!bl) continue;
                if (hashMap3.containsKey(string4)) {
                    arrayList2.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_MANAGED", string4, (String)hashMap3.get(string4)));
                    arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS", string4, "DELETING"));
                    managedCompCounter.remove(string4);
                    continue;
                }
                if (!hashMap2.containsKey(string4)) continue;
                arrayList2.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED_MANAGED", string4, (String)hashMap2.get(string4)));
                arrayList3.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_CONTAINER_BASED", string4, "DELETING"));
                managedCompCounter.remove(string4);
                continue;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} [AutoManage - SectionMove] Exception occured getManagedDetails() : {} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return arrayList2;
    }

    private void isOkToSendAutoDeleteData() {
        long l;
        long l2;
        if (!okToSendAutoDeleteData && (l2 = (l = System.currentTimeMillis()) - agentStartUpTime) >= (long)(autoDeleteListStartUpdelay * 60 * 1000)) {
            okToSendAutoDeleteData = true;
        }
    }

    private void readFromApmIni() {
        try {
            String string = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
            IniFile iniFile = new IniFile(string);
            String string2 = iniFile.getValue("APM_DISCOVERY_AUTO_DELETE", "Apm_Discovery_Auto_Delete");
            string2 = string2.trim();
            if (string2 != null && string2.length() > 0) {
                this.autoDelete = Boolean.parseBoolean(string2);
            }
            String string3 = iniFile.getValue("BTM_APPFLOW", "UseKubeServiceNameInAppflow");
            if ((string3 = string3.trim()) != null && string3.length() > 0) {
                useKubeServiceNameInAppflow = Boolean.parseBoolean(string3);
            }
            String string4 = iniFile.getValue("APM_DISCOVERY_AUTO_DELETE", "Delete_Duration_For_NonContainer_Apps");
            if ((string4 = string4.trim()) != null && string4.length() > 0) {
                threshForApmDiscovery = Integer.parseInt(string4);
            }
            String string5 = iniFile.getValue("APM_DISCOVERY_AUTO_DELETE", "Delete_Duration_For_Container_Apps");
            if ((string5 = string5.trim()) != null && string5.length() > 0) {
                threshForDockerApmDiscovery = Integer.parseInt(string5);
            }
            String string6 = iniFile.getValue("APM_DISCOVERY_AUTO_DELETE", "Delay_To_Prepare_AutoDelete");
            if ((string6 = string6.trim()) != null && string6.length() > 0) {
                autoDeleteListStartUpdelay = Integer.parseInt(string6);
            }
            if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                APMDiscoveryLogger.discoveryLogger.trace("{} autoDelete  : {} ", (Object)loggerDispStr, (Object)this.autoDelete);
                APMDiscoveryLogger.discoveryLogger.trace("{} autoDeleteListStartUpdelay  : {} ", (Object)loggerDispStr, (Object)autoDeleteListStartUpdelay);
                APMDiscoveryLogger.discoveryLogger.trace("{} useKubeServiceNameInAppflow  : {} ", (Object)loggerDispStr, (Object)useKubeServiceNameInAppflow);
                APMDiscoveryLogger.discoveryLogger.trace("{} Delete_Duration_For_NonContainer_Apps  : {} ", (Object)loggerDispStr, (Object)threshForApmDiscovery);
                APMDiscoveryLogger.discoveryLogger.trace("{} Delete_Duration_For_Container_Apps  : {} ", (Object)loggerDispStr, (Object)threshForDockerApmDiscovery);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred while reading eg_apm.ini :{} ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private boolean isAgentTestsIniUpdated() {
        boolean bl;
        block8: {
            bl = false;
            try {
                long l = IniFile.getLastModified(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
                APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_agentTests.ini file LastModified {}", (Object)loggerDispStr, (Object)l);
                APMDiscoveryLogger.discoveryLogger.trace("{} Previous eg_agentTests.ini lastAgentTestsModifiedTime {}", (Object)loggerDispStr, (Object)lastAgentTestsModifiedTime);
                if (lastAgentTestsModifiedTime > -1L) {
                    if (l != lastAgentTestsModifiedTime) {
                        bl = true;
                        lastAgentTestsModifiedTime = l;
                    }
                } else {
                    lastAgentTestsModifiedTime = l;
                    bl = true;
                }
                if (!bl) break block8;
                try {
                    IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
                    String string = iniFile.getValue("AGENT_SETTINGS", "AgentDiscover");
                    if (string != null && string.length() != 0) {
                        agentDiscoverEnabled = Boolean.parseBoolean(string);
                    }
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred :{} ", (Object)loggerDispStr, (Object)exception);
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred :{} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return bl;
    }

    private boolean apmIniUpdated() {
        boolean bl = false;
        long l = IniFile.getLastModified(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH);
        APMDiscoveryLogger.discoveryLogger.trace("{} Current eg_apm.ini file LastModified {}", (Object)loggerDispStr, (Object)l);
        APMDiscoveryLogger.discoveryLogger.trace("{} Previous eg_apm.ini lastApmIniModifiedTime {}", (Object)loggerDispStr, (Object)this.lastApmIniModifiedTime);
        if (this.lastApmIniModifiedTime > -1L) {
            if (l != this.lastApmIniModifiedTime) {
                bl = true;
                this.lastApmIniModifiedTime = l;
            }
        } else {
            this.lastApmIniModifiedTime = l;
            bl = true;
        }
        return bl;
    }

    private ArrayList deleteBtmComponents(IniFile iniFile, HashMap hashMap, HashMap hashMap2, HashMap hashMap3) {
        ArrayList arrayList = new ArrayList();
        if (!this.autoDelete) {
            return arrayList;
        }
        HashMap hashMap4 = this.getLinesAsMap(iniFile, "NEWLY_DISCOVERD_DETAILS_CONTAINER_BASED");
        HashMap hashMap5 = this.getLinesAsMap(iniFile, "NEWLY_DISCOVERD_DETAILS");
        guidMap = new HashMap();
        guidMap.putAll(hashMap4);
        guidMap.putAll(hashMap5);
        APMDiscoveryLogger.discoveryLogger.trace("{} dockerDiscovered  : {} ", (Object)loggerDispStr, (Object)hashMap4);
        APMDiscoveryLogger.discoveryLogger.trace("{} standAloneDiscovered  : {} ", (Object)loggerDispStr, (Object)hashMap5);
        arrayList = this.processAutoDeleteData(arrayList, hashMap2, hashMap4, true, hashMap, hashMap3);
        arrayList = this.processAutoDeleteData(arrayList, hashMap2, hashMap5, false, hashMap, hashMap3);
        return arrayList;
    }

    private ArrayList processAutoDeleteData(ArrayList arrayList, HashMap hashMap, HashMap hashMap2, boolean bl, HashMap hashMap3, HashMap hashMap4) {
        Iterator iterator = hashMap2.entrySet().iterator();
        long l = System.currentTimeMillis();
        long l2 = 900000L;
        l2 = bl ? (long)(threshForDockerApmDiscovery * 60 * 1000) : (long)(threshForApmDiscovery * 60 * 1000);
        long l3 = 900000L;
        while (iterator.hasNext()) {
            try {
                boolean bl2 = false;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                String string3 = (String)hashMap.get(string2);
                if (string3 != null && string3.length() > 0) {
                    long l4 = Long.parseLong(string3);
                    long l5 = l - l4;
                    APMDiscoveryLogger.discoveryLogger.trace("{} Key : {}, Guid : {}, isDocker : {} ", new Object[]{loggerDispStr, string, string2, bl});
                    APMDiscoveryLogger.discoveryLogger.trace("{} {} Threshold[mins] will be applied on {} ", new Object[]{loggerDispStr, l2 / 60000L, string});
                    if (l5 > l2) {
                        Object object;
                        APMDiscoveryLogger.discoveryLogger.trace("{} Doing auto-delete check for : {} and met auto delete theshold time ", (Object)loggerDispStr, (Object)string);
                        bl2 = true;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.countTokens() <= 3) continue;
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        String string6 = stringTokenizer.nextToken();
                        String string7 = stringTokenizer.nextToken();
                        String string8 = string4 + ":" + string5 + ":" + string6;
                        String string9 = (String)hashMap3.get(string8);
                        if (string9 != null && string9.length() > 0) {
                            long l6 = Long.parseLong(string9);
                            APMDiscoveryLogger.discoveryLogger.trace("{} variable key in auto delete : {} ", (Object)loggerDispStr, (Object)string8);
                            APMDiscoveryLogger.discoveryLogger.trace("{} discovery time   : {} , heartbeat time   : {}", new Object[]{loggerDispStr, l6, l4});
                            if (l6 > l4) {
                                APMDiscoveryLogger.discoveryLogger.trace("{} Discovery time is grater than heartbeat time : {} ", (Object)loggerDispStr, (Object)string8);
                                long l7 = l - l6;
                                APMDiscoveryLogger.discoveryLogger.trace("{} discDiff  : {} ", (Object)loggerDispStr, (Object)l7);
                                if (l7 <= l3) {
                                    bl2 = false;
                                    APMDiscoveryLogger.discoveryLogger.debug("{} {} is newly discovered, Skipping to send for auto delete", (Object)loggerDispStr, (Object)string8);
                                }
                            }
                        }
                        try {
                            object = APMComponentIDRepository.getRepository().getLastPingTimeFromDiscoveryTemp(string8);
                            if (object != null && ((String)object).length() > 0) {
                                long l8 = Long.parseLong((String)object);
                                APMDiscoveryLogger.discoveryLogger.trace("{} {} : last discovery Ping time : {} ", new Object[]{loggerDispStr, string8, l8});
                                if (l8 > l) {
                                    bl2 = false;
                                } else {
                                    long l9 = l - l8;
                                    APMDiscoveryLogger.discoveryLogger.trace("{} pingDiff : {} ", (Object)loggerDispStr, (Object)l9);
                                    if (l9 < 300000L) {
                                        bl2 = false;
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred :{} ", (Object)loggerDispStr, (Object)exception);
                        }
                        APMDiscoveryLogger.discoveryLogger.trace("{} {} - add to auto delete list  : {} ", new Object[]{loggerDispStr, string8, bl2});
                        if (bl2) {
                            String[] stringArray;
                            object = new ArrayList();
                            ((ArrayList)object).add(string7);
                            ((ArrayList)object).add(string5);
                            ((ArrayList)object).add(string6);
                            ((ArrayList)object).add(bl);
                            String string10 = "MyApp";
                            String string11 = "MyTier";
                            String string12 = (String)hashMap4.get(string8.trim());
                            if (string12 != null && string12.length() > 0 && (stringArray = string12.split(":")).length == 2) {
                                String string13 = stringArray[0];
                                String string14 = stringArray[1];
                                if (string13 != null && string13.length() > 0) {
                                    string10 = string13;
                                }
                                if (string14 != null && string14.length() > 0) {
                                    string11 = string14;
                                }
                            }
                            ((ArrayList)object).add(string10);
                            ((ArrayList)object).add(string11);
                            arrayList.add(object);
                            this.markedForDeletion.add(string8);
                            this.markedForDeletionFullData.put(string8 + "_Nick", string7);
                            this.markedForDeletionFullData.put(string8 + "_Guid", string2);
                            continue;
                        }
                        this.markedForDeletion.remove(string8);
                        continue;
                    }
                    APMDiscoveryLogger.discoveryLogger.trace("{} {} - [{}] Not met auto delete threshold, So skipping, auto-delete process", new Object[]{loggerDispStr, string, string2});
                    continue;
                }
                APMDiscoveryLogger.discoveryLogger.trace("{} Skipping auto-delete check for : {} due to time not found in heartbeat map for guid [{}] ", new Object[]{loggerDispStr, string, string2});
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred in processAutoDeleteData() :{} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return arrayList;
    }

    private HashMap getLinesAsMap(IniFile iniFile, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n < 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    hashMap.put(string3, string4);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred in getLinesAsMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    public ArrayList discoverBtmComponentsNew(IniFile iniFile, HashMap hashMap, ArrayList arrayList, HashMap hashMap2, ArrayList arrayList2, HashMap hashMap3, HashMap hashMap4) {
        ArrayList arrayList3 = new ArrayList();
        try {
            String string = EgMainAgent.uaid;
            Vector vector = iniFile.getAllValues("AVAILABLE_APM_DISCOVERY_SECTION");
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    String[] stringArray;
                    String string2 = (String)vector.get(i);
                    if (string2 == null || string2.length() <= 0 || (stringArray = string2.split(",")) == null || stringArray.length <= 0) continue;
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = stringArray[j];
                        if (string3 == null || string3.length() <= 0) continue;
                        arrayList3 = this.prepareData(arrayList3, iniFile, string3, string, hashMap, arrayList, hashMap2, arrayList2, hashMap3, hashMap4);
                    }
                }
            }
            if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                APMDiscoveryLogger.discoveryLogger.trace("{} agentUaid  : {} ", (Object)loggerDispStr, (Object)string);
                APMDiscoveryLogger.discoveryLogger.trace("{} markedForDeletion  : {} ", (Object)loggerDispStr, (Object)this.markedForDeletion);
                APMDiscoveryLogger.discoveryLogger.trace("{} lastDiscoveredTime  : {} ", (Object)loggerDispStr, (Object)hashMap);
                APMDiscoveryLogger.discoveryLogger.trace("{} Last Discovery Ping Time  : {} ", (Object)loggerDispStr, APMComponentIDRepository.getRepository().getDiscoveryPingTimeTable());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred in discoverBtmComponentsNew() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return arrayList3;
    }

    private ArrayList managedBtmComponents(IniFile iniFile, HashMap hashMap, ArrayList arrayList, HashMap hashMap2, ArrayList arrayList2, HashMap hashMap3, HashMap hashMap4) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Preparing to send already managed component list to update timestamp", (Object)loggerDispStr);
        ArrayList arrayList3 = new ArrayList();
        try {
            String string = EgMainAgent.uaid;
            Vector vector = iniFile.getAllValues("AVAILABLE_APM_DISCOVERY_SECTION");
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    String[] stringArray;
                    String string2 = (String)vector.get(i);
                    if (string2 == null || string2.length() <= 0 || (stringArray = string2.split(",")) == null || stringArray.length <= 0) continue;
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = stringArray[j];
                        if (string3 == null || string3.length() <= 0) continue;
                        string3 = string3 + "_MANAGED";
                        arrayList3 = this.prepareData(arrayList3, iniFile, string3, string, hashMap, arrayList, hashMap2, arrayList2, hashMap3, hashMap4);
                    }
                }
            }
            if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
                APMDiscoveryLogger.discoveryLogger.trace("{} agentUaid  : {} ", (Object)loggerDispStr, (Object)string);
                APMDiscoveryLogger.discoveryLogger.trace("{} markedForDeletion  : {} ", (Object)loggerDispStr, (Object)this.markedForDeletion);
                APMDiscoveryLogger.discoveryLogger.trace("{} lastDiscoveredTime  : {} ", (Object)loggerDispStr, (Object)hashMap);
                APMDiscoveryLogger.discoveryLogger.trace("{} Last Discovery Ping Time  : {} ", (Object)loggerDispStr, APMComponentIDRepository.getRepository().getDiscoveryPingTimeTable());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred in discoverBtmComponentsNew() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return arrayList3;
    }

    private ArrayList prepareData(ArrayList arrayList, IniFile iniFile, String string, String string2, HashMap hashMap, ArrayList arrayList2, HashMap hashMap2, ArrayList arrayList3, HashMap hashMap3, HashMap hashMap4) {
        String[] stringArray = iniFile.getLinesUnderSubject(string);
        boolean bl = false;
        if (string.startsWith("JAVA_SERVER_DETAILS_CONTAINER_BASED")) {
            bl = true;
        }
        boolean bl2 = this.containerInstance != null && this.containerInstance.isContainerZ();
        long l = System.currentTimeMillis();
        String string3 = this.getAgentIp();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                APMDiscoveryLogger.discoveryLogger.trace("{} lineString  : {} ", (Object)loggerDispStr, (Object)string4);
                if (string4.indexOf("=") < 0) continue;
                try {
                    long l2;
                    long l3;
                    boolean bl3;
                    String string5;
                    String[] stringArray2;
                    String string6;
                    Object object;
                    String string7 = string4.substring(0, string4.indexOf("="));
                    StringTokenizer stringTokenizer = new StringTokenizer(string7, ":");
                    String string8 = "";
                    String string9 = "";
                    String string10 = "";
                    String string11 = "";
                    int n = stringTokenizer.countTokens();
                    if (n < 3) continue;
                    string9 = stringTokenizer.nextToken();
                    string10 = stringTokenizer.nextToken();
                    string8 = stringTokenizer.nextToken();
                    Vector<Object> vector = new Vector<Object>();
                    ArrayList<Object> arrayList4 = new ArrayList<Object>();
                    vector.add(string8);
                    vector.add(string9);
                    String string12 = "NONE";
                    String string13 = (String)hashMap4.get(string9);
                    if (string13 != null && string13.length() > 0 && ((String[])(object = string13.split(":"))).length == 3 && (string6 = object[2]) != null && string6.length() > 0) {
                        string12 = string6;
                    }
                    object = string9 + "_" + this.hostName;
                    if (!bl) {
                        object = this.hostName;
                    } else if (!string12.equalsIgnoreCase("none") && !string12.equalsIgnoreCase("null") && object != null) {
                        if (string12.length() > 17) {
                            string12 = string12.substring(0, 17);
                        }
                        object = string12 + "_" + (String)object;
                    }
                    if (object != null && ((String)object).length() > 32) {
                        object = ((String)object).substring(0, 32);
                    }
                    if (((String)object).endsWith(".") || ((String)object).endsWith("_")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    if (string9 != null && bl2) {
                        string11 = this.containerInstance.getPodName(string9);
                    }
                    vector.add(object);
                    vector.add(string10);
                    string6 = this.hostName;
                    if (string6.length() > 32) {
                        string6 = string6.substring(0, 32);
                    }
                    vector.add(string3 + "#sep#" + string6);
                    vector.add(string2);
                    vector.add(string11);
                    vector.add(bl);
                    String string14 = "MyApp";
                    String string15 = "MyTier";
                    String string16 = (String)hashMap3.get(string7.trim());
                    if (string16 != null && string16.length() > 0 && (stringArray2 = string16.split(":")).length == 2) {
                        String string17 = stringArray2[0];
                        string5 = stringArray2[1];
                        if (string17 != null && string17.length() > 0) {
                            string14 = string17;
                        }
                        if (string5 != null && string5.length() > 0) {
                            string15 = string5;
                        }
                    }
                    arrayList4.add(string14);
                    if (bl && useKubeServiceNameInAppflow && !string12.equalsIgnoreCase("NONE") && !string12.equalsIgnoreCase("NULL")) {
                        arrayList4.add(string12);
                    } else {
                        arrayList4.add(string15);
                    }
                    arrayList4.addAll(vector);
                    boolean bl4 = this.markedForDeletion.contains(string7);
                    APMDiscoveryLogger.discoveryLogger.trace("{} Doing auto-manage process for : {} ", (Object)loggerDispStr, (Object)string7);
                    APMDiscoveryLogger.discoveryLogger.trace("{} Is this markedAsDeletion  : {} ", (Object)loggerDispStr, (Object)bl4);
                    if (!bl4) {
                        bl3 = false;
                        try {
                            long l4;
                            long l5;
                            boolean bl5 = true;
                            l3 = 0L;
                            l2 = 0L;
                            String string18 = (String)hashMap.get(string7);
                            if (string18 != null && string18.length() > 0) {
                                long l6 = Long.parseLong(string18);
                                l5 = l - l6;
                                if (l5 <= 360000L) {
                                    bl3 = true;
                                    bl5 = false;
                                } else {
                                    bl5 = true;
                                }
                                l2 = l6;
                                APMDiscoveryLogger.discoveryLogger.trace("{} On Discovery time check - Send for auto manage : {} & discoveryTime : {}", new Object[]{loggerDispStr, bl3, l2});
                            }
                            if (bl5) {
                                String string19 = string7 + ":" + (String)object;
                                String string20 = (String)guidMap.get(string19);
                                string20 = string20 != null ? string20 : "";
                                APMDiscoveryLogger.discoveryLogger.trace("{} Guid for {} : {} ", new Object[]{loggerDispStr, string19, string20});
                                if (!hashMap2.containsKey(string20)) {
                                    l5 = l - l2;
                                    if (l5 <= 1800000L) {
                                        bl3 = true;
                                    }
                                } else {
                                    String string21 = (String)hashMap2.get(string20);
                                    if (string21 != null && string21.length() > 0) {
                                        l4 = Long.parseLong(string21);
                                        long l7 = l - l4;
                                        if (l7 <= 360000L) {
                                            bl3 = true;
                                        }
                                        l3 = l4;
                                    }
                                }
                                APMDiscoveryLogger.discoveryLogger.trace("{} On HeartBeat check - Send for auto manage : {}& heartBeatTime : {} ", new Object[]{loggerDispStr, bl3, l3});
                            }
                            if (!bl3) {
                                String string22 = APMComponentIDRepository.getRepository().getLastPingTimeFromDiscoveryTemp(string7);
                                if (string22 != null && string22.length() > 0) {
                                    long l8 = Long.parseLong(string22);
                                    if (l8 > l) {
                                        bl3 = true;
                                    } else {
                                        l4 = l - l8;
                                        if (l4 < 300000L) {
                                            bl3 = true;
                                        }
                                    }
                                }
                                APMDiscoveryLogger.discoveryLogger.trace("{} On Discovery last ping time check - Send for auto manage : {} & Last Discovery Ping Time : {} ", new Object[]{loggerDispStr, bl3, string22});
                            }
                        }
                        catch (Exception exception) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred :{} ", (Object)loggerDispStr, (Object)exception);
                        }
                        APMDiscoveryLogger.discoveryLogger.trace("{} Send for auto manage : {}", (Object)loggerDispStr, (Object)bl3);
                        if (!bl3) continue;
                        arrayList.add(vector);
                        arrayList3.add(arrayList4);
                        continue;
                    }
                    bl3 = false;
                    try {
                        string5 = (String)hashMap.get(string7);
                        APMDiscoveryLogger.discoveryLogger.trace("{} Last discovery ping time  : {} ", (Object)loggerDispStr, (Object)string5);
                        if (string5 != null && string5.length() > 0) {
                            l3 = Long.parseLong(string5);
                            l2 = l - l3;
                            if (l2 >= 900000L) {
                                bl3 = false;
                                APMDiscoveryLogger.discoveryLogger.debug("{} {} is reached maximum discovery wait time, Skipping to send for auto manage", (Object)loggerDispStr, (Object)string7);
                            } else {
                                bl3 = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred :{} ", (Object)loggerDispStr, (Object)exception);
                    }
                    if (!bl3) continue;
                    arrayList.add(vector);
                    arrayList3.add(arrayList4);
                    continue;
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred prepareData() :{} ", (Object)loggerDispStr, (Object)exception);
                }
            }
        }
        return arrayList;
    }

    private int uploadAgentDiscoveryData(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        URL uRL = null;
        try {
            this.thisMgrIp = EgMainAgent.mgrIp;
            this.thisMgrPort = EgMainAgent.port;
            uRL = this.primaryMgrIp.equalsIgnoreCase(this.thisMgrIp) ? new URL(EgInstallInfo.urlPrefix + "//" + this.primaryMgrIp + ":" + this.primaryMgrPort + "/final/servlet/com.eg.EgApmBtmDiscoveryServlet") : new URL(EgInstallInfo.urlPrefix + "//" + this.thisMgrIp + ":" + this.thisMgrPort + "/final/servlet/com.eg.EgApmBtmDiscoveryServlet");
        }
        catch (MalformedURLException malformedURLException) {
            APMDiscoveryLogger.discoveryLogger.warn("{} MalformedURLException  : {} ", (Object)loggerDispStr, (Object)malformedURLException);
        }
        this.responseCode = this.uploadAgentDiscoveryData(uRL, arrayList, arrayList2, arrayList3);
        APMDiscoveryLogger.discoveryLogger.trace("{} after uploadAgentDiscoveryData responseCode  : {} ", (Object)loggerDispStr, (Object)this.responseCode);
        if (!this.isSuccessfullSent && this.natURLExists) {
            try {
                uRL = new URL(this.primaryNATUrl + "com.eg.EgApmBtmDiscoveryServlet");
            }
            catch (MalformedURLException malformedURLException) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred in EgAPMBTMDiscovery.uploadAgentDiscoveryData() in creating URL  : {} ", (Object)loggerDispStr, (Object)malformedURLException);
            }
            this.responseCode = this.uploadAgentDiscoveryData(uRL, arrayList, arrayList2, arrayList3);
        }
        return this.responseCode;
    }

    private int uploadAgentDiscoveryData(URL uRL, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        HttpURLConnection httpURLConnection = null;
        int n = 0;
        APMDiscoveryLogger.discoveryLogger.trace("{} uploading discovery information to the URL   : {} ", (Object)loggerDispStr, (Object)uRL);
        try {
            httpURLConnection = this.getConnection(uRL);
            APMDiscoveryLogger.discoveryLogger.trace("{} uc  : {} ", (Object)loggerDispStr, (Object)httpURLConnection);
            if (httpURLConnection == null) {
                this.isSuccessfullSent = false;
                return n;
            }
            ArrayList<ArrayList> arrayList4 = new ArrayList<ArrayList>();
            arrayList4.add(arrayList);
            arrayList4.add(arrayList2);
            arrayList4.add(arrayList3);
            arrayList4.add(this.getIpAndNickNamesList());
            APMDiscoveryLogger.discoveryLogger.info("{} dataObjectsToBeUploaded  : {} ", (Object)loggerDispStr, arrayList4);
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, true, null, false, (ArrayList)null, arrayList4, true);
            boolean bl = this.checkForTimeout(connectionThread);
            APMDiscoveryLogger.discoveryLogger.trace("{} cflag  : {} ", (Object)loggerDispStr, (Object)bl);
            if (bl) {
                n = connectionThread.code;
            }
            APMDiscoveryLogger.discoveryLogger.info("{} httpResponseCode  : {} ", (Object)loggerDispStr, (Object)n);
            connectionThread = null;
            httpURLConnection = null;
            this.isSuccessfullSent = true;
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Manager could not be contacted  : {} ", (Object)loggerDispStr, (Object)exception);
            this.isSuccessfullSent = false;
        }
        return n;
    }

    private HttpURLConnection getConnection(URL uRL) {
        HttpURLConnection httpURLConnection = null;
        try {
            int n;
            if (EgMainAgent.isProxySet) {
                n = 0;
                try {
                    if (EgMainAgent.proxyPort != null) {
                        n = Integer.parseInt(EgMainAgent.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(EgMainAgent.proxyHost, n);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            n = 0;
            httpURLConnection.setRequestProperty("Content-length", "" + n);
        }
        catch (Exception exception) {
            httpURLConnection = null;
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occurred while getting HTTP connection for the URL : {} ", new Object[]{loggerDispStr, uRL, exception});
        }
        return httpURLConnection;
    }

    public void suspendForPeriod(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout * 10L;
        long l3 = 0L;
        long l4 = 250L;
        do {
            long l5 = System.currentTimeMillis();
            if (l4 < EgAgentCommon.minimumSleep) {
                l4 = EgAgentCommon.minimumSleep;
            } else if (l4 > EgAgentCommon.maxSleep) {
                l4 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connectionThread.done) {
                return true;
            }
            long l6 = System.currentTimeMillis();
            long l7 = l6 - l5;
            if ((l3 += l7) >= l2 || l7 < 0L) {
                connectionThread.interrupt();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connectionThread.stop();
                return false;
            }
            l = l4;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        connectionThread.interrupt();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionThread.stop();
        return false;
    }

    private void addToCounter(HashMap hashMap, String string) {
        try {
            if (hashMap.containsKey(string)) {
                int n = (Integer)hashMap.get(string);
                hashMap.put(string, n + 1);
            } else {
                hashMap.put(string, 1);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception in addToCounter() : ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private boolean isReachedToMaximumCounter(HashMap hashMap, String string, int n) {
        try {
            int n2;
            if (hashMap.containsKey(string) && (n2 = ((Integer)hashMap.get(string)).intValue()) >= n) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception in isReachedToMaximumCounter() : ", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }

    public ArrayList getIpAndNickNamesList() {
        ArrayList arrayList = new ArrayList();
        try {
            Object object;
            Object object2;
            int n;
            int n2;
            int n3;
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
            this.discBase = iniFile.getValue("AGENT_SETTINGS", "DiscBase");
            String[] stringArray = EgMainAgent.ipAddresses;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                String string = stringArray[n3].trim();
                if (string == null || string.startsWith("127.") || string.startsWith("169.254.") || string.startsWith("0:0:0:0:0:0:0:1")) continue;
                boolean bl = IPV6Helper.validateIPV4(string);
                if (bl) {
                    arrayList3.add(string);
                    continue;
                }
                n2 = IPV6Helper.validateIPV6(string);
                if (n2 != 0) {
                    arrayList4.add(string);
                    continue;
                }
                arrayList2.add(string);
            }
            if (arrayList3 != null && arrayList3.size() > 0) {
                arrayList2.addAll(arrayList3);
            } else if (arrayList4 != null && arrayList4.size() > 0) {
                arrayList2.addAll(arrayList4);
            }
            n3 = arrayList2.size();
            this.ipAddresses = new String[n3];
            for (int i = 0; i < n3; ++i) {
                String string;
                this.ipAddresses[i] = string = (String)arrayList2.get(i);
            }
            ArrayList<Object> arrayList5 = new ArrayList<Object>();
            ArrayList<String> arrayList6 = new ArrayList<String>();
            n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(this.nickNames, ":");
            n2 = stringTokenizer.countTokens();
            for (int i = 0; i < n2; ++i) {
                arrayList5.add(stringTokenizer.nextToken(":"));
            }
            String string = InetAddress.getLocalHost().getHostName();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            String string2 = "";
            if (inetAddressArray != null && inetAddressArray.length > 1) {
                for (n = 0; n < inetAddressArray.length; ++n) {
                    object2 = inetAddressArray[n];
                    if (object2 != null && APMUtils.isLoopbackAddress((InetAddress)object2) || (object = ((InetAddress)object2).getHostAddress()) == null || ((String)object).startsWith("169.254.") || ((String)object).indexOf(":") > 0) continue;
                    string2 = object;
                    break;
                }
            }
            for (n = 0; n < this.ipAddresses.length; ++n) {
                arrayList6.add(this.ipAddresses[n]);
                if (arrayList5.size() != 0 && arrayList5.size() > n) continue;
                if (this.discBase.equalsIgnoreCase("IP")) {
                    arrayList5.add(this.ipAddresses[n]);
                    continue;
                }
                object2 = null;
                try {
                    object = InetAddress.getByName(this.ipAddresses[n]);
                    object2 = ((InetAddress)object).getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string != null) {
                    if (((String)object2).indexOf(string + ".") >= 0) {
                        object2 = string;
                    }
                    if (((String)object2).equalsIgnoreCase(this.ipAddresses[n])) {
                        object2 = string;
                    }
                }
                if (object2 != null && ((String)object2).length() > 0) {
                    arrayList5.add(object2);
                    continue;
                }
                arrayList5.add(this.ipAddresses[n]);
            }
            if (arrayList.size() == 0) {
                arrayList.add(arrayList5);
                arrayList.add(arrayList6);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception in assignNickNameForIps() : ", (Object)loggerDispStr, (Object)exception);
        }
        return arrayList;
    }

    public void startContainerPortDiscovery() {
        try {
            if (!agentDiscoverEnabled) {
                this.suspendForPeriod(180000L);
                this.isAgentTestsIniUpdated();
                if (!agentDiscoverEnabled) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} agentDiscoverEnabled  : {} , Skipping the process of ContainerPortDiscovery..", (Object)loggerDispStr, (Object)agentDiscoverEnabled);
                    return;
                }
            }
            boolean bl = this.isContainerzPortDiscoveryEnabled();
            boolean bl2 = ContainersService.getInstance().isContainerZ();
            if (bl && bl2) {
                APMDiscoveryLogger.discoveryLogger.info("{} Doing port discovery in containerized env.. ", (Object)loggerDispStr);
                ContainerzDiscovery containerzDiscovery = new ContainerzDiscovery();
                Hashtable hashtable = containerzDiscovery.getContainerDetails();
                ArrayList arrayList = this.prepareDiscoveryData(hashtable);
                if (arrayList != null && arrayList.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.info("{} discoverList to upload : {} ", (Object)loggerDispStr, (Object)arrayList);
                    int n = this.uploadAgentDiscoveryData(arrayList, new ArrayList(), new ArrayList());
                    if (n == 200) {
                        containerzDiscovery.addToDiscoveredData(hashtable);
                    }
                }
            } else {
                APMDiscoveryLogger.discoveryLogger.debug("{} isPortDiscoveryEnabled: {}, isContainerZ : {} ", new Object[]{loggerDispStr, bl, bl2});
            }
        }
        catch (Throwable throwable) {
            APMDiscoveryLogger.discoveryLogger.info("{} startContainerPortDiscovery() Error occurred {} ", (Object)loggerDispStr, (Object)throwable);
        }
    }

    private ArrayList prepareDiscoveryData(Hashtable hashtable) {
        if (hashtable != null && hashtable.size() > 0) {
            try {
                boolean bl = true;
                String string = EgMainAgent.uaid;
                String string2 = this.hostName;
                if (string2.length() > 32) {
                    string2 = string2.substring(0, 32);
                }
                Iterator iterator = hashtable.entrySet().iterator();
                ArrayList arrayList = new ArrayList();
                String string3 = this.getAgentIp();
                while (iterator.hasNext()) {
                    try {
                        Map.Entry entry = iterator.next();
                        String string4 = (String)entry.getKey();
                        Hashtable hashtable2 = (Hashtable)entry.getValue();
                        if (hashtable2 == null || hashtable2.size() <= 0) continue;
                        Vector<Object> vector = new Vector<Object>();
                        vector.add(hashtable2.get("compType"));
                        vector.add(hashtable2.get("compId"));
                        String string5 = string4 + "_" + this.hostName;
                        String string6 = (String)hashtable2.get("serviceName");
                        if (string6 != null && string6.length() > 0 && !string6.equalsIgnoreCase("none") && !string6.equalsIgnoreCase("null")) {
                            if (string6.length() > 17) {
                                string6 = string6.substring(0, 17);
                            }
                            string5 = string6 + "_" + string5;
                        }
                        if (string5 != null && string5.length() > 32) {
                            string5 = string5.substring(0, 32);
                        }
                        vector.add(string5);
                        vector.add(hashtable2.get("compPort"));
                        vector.add(string3 + "#sep#" + string2);
                        vector.add(string);
                        vector.add(hashtable2.get("podName"));
                        vector.add(bl);
                        arrayList.add(vector);
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} prepareDiscoveryData() Error occurred {} ", (Object)loggerDispStr, (Object)exception);
                    }
                }
                if (arrayList.size() > 0) {
                    return arrayList;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} prepareDiscoveryData() Error occurred {} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return null;
    }

    private boolean isContainerzPortDiscoveryEnabled() {
        boolean bl = false;
        try {
            String string = System.getenv("EG_CONTAINERZ_PORT_DISCOVERY");
            if (string != null && string.trim().equalsIgnoreCase("true")) {
                bl = true;
            }
            if (!bl && (string = System.getProperty("eg.containerz.port.discovery")) != null && string.trim().equalsIgnoreCase("true")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} isContainerzPortDiscoveryEnabled() Error occurred {} ", (Object)loggerDispStr, (Object)exception);
        }
        return bl;
    }

    private String getAgentIp() {
        try {
            String string;
            ArrayList arrayList;
            ArrayList arrayList2 = this.getIpAndNickNamesList();
            if (arrayList2 != null && arrayList2.size() >= 2 && (arrayList = (ArrayList)arrayList2.get(1)) != null && arrayList.size() > 0 && (string = (String)arrayList.get(0)) != null && string.length() > 0) {
                return string;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} getAgentIp() Error occurred {} ", (Object)loggerDispStr, (Object)exception);
        }
        return APMUtils.getAgentIpAddress();
    }

    public static void main(String[] stringArray) {
    }
}

