/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgAgentInfo;
import com.eg.EgTraceRoute;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class EgAgentRoute
extends Thread {
    private EgMainAgent parent;
    private String entity = "Agent";
    private String whoami = "agent";
    private EgConfigInfo configInfo = new EgConfigInfo(this.whoami);
    private long longSleepPeriod = 4L * EgConfigInfo.msecPerHour;
    private long shortSleepPeriod = 2L * EgConfigInfo.msecPerHour;
    private EgDateInfo dateInfo = new EgDateInfo();
    private boolean success = false;
    private String mgrIp;
    private String mgrPort;
    private String agentOS;
    private static boolean isRunning = false;
    private static String syncFlag = "Sync";

    public static void main(String[] stringArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgAgentRoute(EgMainAgent egMainAgent) {
        this.parent = egMainAgent;
        this.mgrIp = EgMainAgent.mgrIp;
        this.mgrPort = EgMainAgent.port;
        this.agentOS = egMainAgent.osType.toLowerCase();
        String string = syncFlag;
        synchronized (string) {
            if (isRunning) {
                return;
            }
            isRunning = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String[] stringArray;
        this.success = false;
        EgAgentInfo egAgentInfo = new EgAgentInfo(this.whoami);
        boolean bl = egAgentInfo.isExternalAgent();
        if (bl) {
            this.suspendUntilPeriod(EgConfigInfo.msecPerMin * 2L);
            stringArray = egAgentInfo.getUniqueHosts();
            long l = this.longSleepPeriod;
            if (stringArray != null && stringArray.length > 0) {
                this.checkRoutes(stringArray);
                if (!this.success) {
                    l = this.shortSleepPeriod;
                }
                int n = stringArray.length / 25;
                if ((l = (long)(++n) * l) > EgConfigInfo.msecPerDay) {
                    l = EgConfigInfo.msecPerDay;
                }
            }
            this.parent.nextRouteTime = System.currentTimeMillis() + l;
        } else {
            this.parent.nextRouteTime = System.currentTimeMillis() + this.longSleepPeriod;
        }
        stringArray = syncFlag;
        synchronized (stringArray) {
            isRunning = false;
        }
    }

    private void checkRoutes(String[] stringArray) {
        EgTraceRoute egTraceRoute = new EgTraceRoute();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
            if (stringTokenizer.countTokens() < 3) continue;
            String string = stringTokenizer.nextToken().trim();
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            Hashtable hashtable = null;
            hashtable = this.agentOS != null && this.agentOS.startsWith("windows") ? egTraceRoute.runTraceForWin(string2, 15, 2) : (this.agentOS != null && (this.agentOS.equalsIgnoreCase("AIX") || this.agentOS.equalsIgnoreCase("HPUX")) ? egTraceRoute.runTrace(string2, 15, 2, 3, "I", false) : egTraceRoute.runTrace(string2, 15, 2, 1, "I", false));
            if (hashtable != null) {
                String string4 = "";
                String string5 = "";
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int j = 1; j <= hashtable.size(); ++j) {
                    String string6 = (String)hashtable.get(Integer.toString(j));
                    if (string6 == null || string6.equals("*") || string6.equals("") || arrayList2.indexOf(string6) >= 0) continue;
                    arrayList2.add(string6);
                    if (this.isIpAddress(string6)) {
                        String string7;
                        if (string2.equals(string6) || string.equals(string7 = EgInstallInfo.getHostName(string6))) continue;
                        string4 = string4 + string6;
                        string5 = string5 + string7;
                    } else {
                        if (string.equals(string6) || string2.equals(string6)) continue;
                        string5 = string5 + string6;
                        String string8 = "";
                        try {
                            InetAddress inetAddress = InetAddress.getByName(string6);
                            string8 = inetAddress.getHostAddress();
                            if (string8.equals(string2)) continue;
                            string4 = string4 + string8;
                        }
                        catch (Exception exception) {
                            string4 = string4 + string6;
                        }
                    }
                    string4 = string4 + ":";
                    string5 = string5 + ":";
                }
                if (string4.equals(":") || string4.equals("")) continue;
                if (string4.endsWith(":")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                String string9 = string + ":" + string3 + "=" + string4;
                arrayList.add(string9);
                if (arrayList.size() > 10) {
                    if (!this.xferToMgr(arrayList)) {
                        return;
                    }
                    arrayList = new ArrayList();
                }
            }
            Thread.yield();
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() > 0) {
            this.xferToMgr(arrayList);
        }
    }

    private boolean xferToMgr(ArrayList arrayList) {
        URL uRL;
        String string = new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.routeupdate");
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            if (EgMainAgent.isProxySet) {
                int n = 0;
                try {
                    if (EgMainAgent.proxyPort != null) {
                        n = Integer.parseInt(EgMainAgent.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(EgMainAgent.proxyHost, n);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/html");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            boolean bl = EgMainAgent.isEncryptionRequired;
            if (bl) {
                arrayList2.add("Encrypted=True");
            } else {
                arrayList2.add("Encrypted=False");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (bl) {
                    arrayList2.add(EgCrypt.encrypt((String)arrayList.get(i)));
                    continue;
                }
                arrayList2.add((String)arrayList.get(i));
            }
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false, arrayList2);
            ArrayList arrayList3 = null;
            int n = 0;
            boolean bl2 = this.checkForTimeout(connectionThread);
            if (bl2) {
                arrayList3 = connectionThread.data;
                n = connectionThread.code;
            }
            connectionThread = null;
            httpURLConnection = null;
            if (!bl2 || n != 200) {
                this.success = false;
                return false;
            }
            this.success = true;
            return true;
        }
        catch (Exception exception) {
            this.success = false;
            return false;
        }
    }

    private void suspendUntilPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < EgAgentCommon.minimumSleep) {
                l = EgAgentCommon.minimumSleep;
            } else if (l > EgAgentCommon.maxSleep) {
                l = EgAgentCommon.maxSleep;
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString(string3);
        return "Basic " + string4;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = EgConfigInfo.getResponseCodeTimeout;
        long l3 = 0L;
        long l4 = 250L;
        do {
            long l5 = System.currentTimeMillis();
            this.suspendUntilPeriod(l4);
            if (connectionThread.done) {
                return true;
            }
            long l6 = System.currentTimeMillis();
            long l7 = l6 - l5;
            if ((l3 += l7) >= l2 || l7 < 0L) {
                connectionThread.interrupt();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l4;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        connectionThread.interrupt();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

