/*
 * Decompiled with CFR 0.152.
 */
import com.eg.HelperThread;
import java.util.ArrayList;
import java.util.Hashtable;

public class EgJavaSSH {
    String hostName = "";
    String userName = "";
    String pass = "";
    String cmd = "";
    int port = 22;
    String encryptType = "";
    String keyFileName = "";
    public long timeOut = EgConfigInfo.msecPerMin * 1L;
    private static Hashtable htFailedHostPortHash = new Hashtable();

    public EgJavaSSH(String string, int n, String string2, String string3) {
        this.hostName = string;
        this.port = n;
        this.userName = string2;
        this.pass = string3;
    }

    public EgJavaSSH(String string, int n, String string2, String string3, long l) {
        this.hostName = string;
        this.port = n;
        this.userName = string2;
        this.pass = string3;
        this.timeOut = l * 1000L;
    }

    public EgJavaSSH(String string, String string2, String string3, String string4, long l) {
        this.hostName = string;
        int n = 22;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.port = n;
        this.userName = string3;
        this.pass = string4;
        this.timeOut = l * 1000L;
    }

    public EgJavaSSH(String string, int n, String string2, String string3, String string4, String string5, long l) {
        this.hostName = string;
        this.port = n;
        this.userName = string2;
        this.pass = string3;
        this.timeOut = l * 1000L;
        this.encryptType = string4;
        this.keyFileName = string5;
    }

    public boolean doesSocketExist(String string, int n) {
        long l;
        HelperThread helperThread = new HelperThread(string, n, (int)this.timeOut);
        long l2 = 0L;
        long l3 = 5L;
        do {
            this.suspendForPeriod(l3);
            if (helperThread.done) {
                return helperThread.status;
            }
            if ((l2 += l3) >= this.timeOut) {
                helperThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                helperThread = null;
                return false;
            }
            l = l3 * 2L;
            if (l > 30L) {
                l = 30L;
            }
            if (this.timeOut - l2 >= l) continue;
            l = this.timeOut - l2;
        } while ((l3 = l) > 0L);
        helperThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        helperThread = null;
        return false;
    }

    public ArrayList executeCommandWithHighSecure(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        SSHThreadUsingJSCH sSHThreadUsingJSCH = new SSHThreadUsingJSCH(this.hostName, this.userName, this.pass, this.port);
        sSHThreadUsingJSCH.setTimeOut(this.timeOut);
        sSHThreadUsingJSCH.executeCommand(string);
        boolean bl = this.checkForTimeout2(sSHThreadUsingJSCH);
        ArrayList arrayList = null;
        if (bl) {
            arrayList = sSHThreadUsingJSCH.data;
        }
        if (arrayList == null || arrayList.size() < 2) {
            return null;
        }
        return arrayList;
    }

    private boolean checkForTimeout2(SSHThreadUsingJSCH sSHThreadUsingJSCH) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (sSHThreadUsingJSCH.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeOut) {
                sSHThreadUsingJSCH.interrupt();
                Thread.currentThread();
                Thread.yield();
                sSHThreadUsingJSCH.stop();
                return false;
            }
            l = l3;
            if (this.timeOut - l2 >= l) continue;
            l = this.timeOut - l2;
        } while ((l3 = l) > 0L);
        sSHThreadUsingJSCH.interrupt();
        Thread.currentThread();
        Thread.yield();
        sSHThreadUsingJSCH.stop();
        return false;
    }

    public ArrayList executeCommand(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        SSHThread sSHThread = new SSHThread(this.hostName, this.userName, this.pass, this.port);
        sSHThread.setTimeOut(this.timeOut);
        sSHThread.setEncryptionType(this.encryptType);
        sSHThread.setKeyFile(this.keyFileName);
        sSHThread.executeCommand(string);
        boolean bl = this.checkForTimeout(sSHThread);
        ArrayList arrayList = null;
        if (bl) {
            arrayList = sSHThread.data;
        }
        if (arrayList == null || arrayList.size() < 2) {
            return null;
        }
        return arrayList;
    }

    public ArrayList executeCommand(String string, boolean bl) {
        int n;
        int[] nArray;
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((nArray = EgMainAgent.Ssh_Port) == null) {
            this.port = 22;
        } else {
            boolean bl2 = false;
            if (nArray.length == 1) {
                this.port = nArray[0];
            } else {
                for (n = 0; n < nArray.length; ++n) {
                    boolean bl3;
                    int n2 = nArray[n];
                    String string2 = this.hostName + ":" + n2;
                    if (nArray.length > 1 && htFailedHostPortHash.containsKey(string2)) {
                        long l;
                        Long l2 = (Long)htFailedHostPortHash.get(string2);
                        long l3 = 0L;
                        if (l2 != null) {
                            l3 = l2;
                        }
                        if ((l = System.currentTimeMillis()) - l3 < EgMainAgent.workingVmIpCachePeriod) continue;
                        htFailedHostPortHash.remove(string2);
                    }
                    if (bl3 = this.doesSocketExist(this.hostName, n2)) {
                        this.port = n2;
                        bl2 = true;
                        break;
                    }
                    if (nArray.length <= 1) continue;
                    htFailedHostPortHash.put(string2, new Long(System.currentTimeMillis()));
                }
                if (!bl2) {
                    this.port = 22;
                }
            }
        }
        SSHThread sSHThread = new SSHThread(this.hostName, this.userName, this.pass, this.port);
        sSHThread.setTimeOut(this.timeOut);
        sSHThread.setEncryptionType(this.encryptType);
        sSHThread.setKeyFile(this.keyFileName);
        sSHThread.executeCommand(string);
        n = this.checkForTimeout(sSHThread) ? 1 : 0;
        ArrayList arrayList = null;
        if (n != 0) {
            arrayList = sSHThread.data;
        }
        if (arrayList == null || arrayList.size() < 2) {
            return null;
        }
        return arrayList;
    }

    private boolean checkForTimeout(SSHThread sSHThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (sSHThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeOut) {
                sSHThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                sSHThread.stop();
                return false;
            }
            l = l3;
            if (this.timeOut - l2 >= l) continue;
            l = this.timeOut - l2;
        } while ((l3 = l) > 0L);
        sSHThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        sSHThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: java EgJavaSSH <ip> <port> <user> <pass>");
            System.exit(-1);
        }
        EgJavaSSH egJavaSSH = new EgJavaSSH(stringArray[0], stringArray[1], stringArray[2], stringArray[3], 60L);
        String string = "hostname";
        ArrayList arrayList = egJavaSSH.executeCommand(string);
        System.out.println(arrayList);
    }
}

