/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgAgentInfo;
import com.eg.EgInstallInfo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public class EgSapGenConfJco3Test
extends AsAbapTblJco3Base {
    private boolean isBapiLoggedIn = false;
    public final SimpleDateFormat MTETimeStampSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Hashtable ht_lastTime = new Hashtable();
    private static Hashtable ht_confLastTime = new Hashtable();
    private static Hashtable ht_minConfTestFreq = new Hashtable();
    protected static Hashtable ht_ht_confValues = new Hashtable();
    protected static Hashtable ht_sapVersion = new Hashtable();
    protected static Hashtable ht_testStatus = new Hashtable();
    protected static Hashtable ht_ht_mteTimeStamps = new Hashtable();
    protected static Hashtable errCodeTbl;
    private static Hashtable syncHash;
    private static final String syncString;
    private static final String syncString2;
    private static final String syncString3;
    private static final ArrayList perfAttrList;
    private static final ArrayList arrCCMSList;
    private String sapVersion = "";
    private static final String MON_SET_NAME = "SAP CCMS Monitor Templates";
    private static String myDatePattern;
    private static SimpleDateFormat mySDF;
    private Properties connProps;
    private boolean isAbapSystemComp = false;
    String SID = null;
    protected static Hashtable ht_ht_TidCache;
    protected static Hashtable ht_TidFlag;
    protected static Hashtable ht_ht_TestRunningFlag;
    Hashtable ht_TidCache = new Hashtable();
    EgAgentInfo egAgent = new EgAgentInfo("agent");
    private long perfCutoff = 0L;
    protected boolean isSapCCMSConfigTest = false;

    public EgSapGenConfJco3Test(String[] stringArray) {
        super(stringArray);
        this.fixedTestPeriod = true;
        this.printOut("INFO : SAP connection identifying string, thisServer = " + this.thisServer);
        this.printOut("INFO : Log name of eG user in SAP, eGSapXMIUser = " + this.eGSapXMIUser);
        this.instanceName = this.getInstanceName();
        this.SID = this.sapsid == null || this.sapsid.equalsIgnoreCase("") || this.sapsid.equalsIgnoreCase("none") || this.sapsid.equalsIgnoreCase("default") || this.sapsid.length() == 0 ? this.getSID() : this.sapsid;
        this.perfCutoff = (long)(0.9 * (double)this.measurePeriod);
    }

    protected void setIsSapCCMSConfigTest() {
        this.isSapCCMSConfigTest = true;
    }

    boolean logonToXMI() {
        JCoDestination jCoDestination = EgSapGenConfJco3Test.getDestination(this.destName);
        if (jCoDestination == null) {
            return false;
        }
        JCoFunction jCoFunction = this.getFunction("BAPI_XMI_LOGON");
        if (jCoFunction == null) {
            return false;
        }
        try {
            jCoFunction.getImportParameterList().setValue("EXTCOMPANY", "eGInnovations");
            jCoFunction.getImportParameterList().setValue("EXTPRODUCT", "eG");
            jCoFunction.getImportParameterList().setValue("INTERFACE", "XAL");
            jCoFunction.getImportParameterList().setValue("VERSION", "1.0");
            this.executeFunction(jCoFunction, true);
            this.printOut("INFO : Logged onto XAL interface");
            return true;
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to logon to XMI interface : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to logon to XMI interface : " + exception.toString());
            this.printOut(EgInstallInfo.getStackTraceAsString(exception));
            return false;
        }
    }

    protected void setDataForSystem(boolean bl) {
        this.isAbapSystemComp = true;
        this.setData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        String string;
        Object object;
        long l = 0L;
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        if (this.isSapCCMSConfigTest) {
            this.printOut("config cutoff " + this.perfCutoff);
            this.printOut("CONF_DEBUG : Config test with measure period " + this.measurePeriod);
            object = (Long)ht_minConfTestFreq.get(this.thisServer);
            if (object == null) {
                string = syncString3;
                synchronized (string) {
                    object = (Long)ht_minConfTestFreq.get(this.thisServer);
                    if (object == null) {
                        this.printOut("CONF_DEBUG : Setting min conf test freq for first time for " + this.thisServer);
                        object = new Long(0L);
                        ht_minConfTestFreq.put(this.thisServer, new Long(this.measurePeriod));
                        this.printOut("CONF_DEBUG : Initialized minConfTestFreq for " + this.thisServer + " to " + ((Long)object).toString());
                    }
                }
            }
            this.printOut("CONF_DEBUG : comparing measurePeriod " + this.measurePeriod + " for " + this.thisServer + " with minConfTestFreq " + ((Long)object).toString());
            if (this.measurePeriod < (Long)object) {
                string = syncString3;
                synchronized (string) {
                    if (this.measurePeriod < (Long)object) {
                        this.printOut("CONF_DEBUG : Updating minConfTestFreq to " + this.measurePeriod + " for " + this.thisServer);
                        object = new Long(this.measurePeriod);
                        ht_minConfTestFreq.put(this.thisServer, object);
                    }
                }
            }
        }
        object = null;
        object = (String)syncHash.get(this.thisServer);
        if (object == null) {
            string = syncString;
            synchronized (string) {
                object = (String)syncHash.get(this.thisServer);
                if (object == null) {
                    syncHash.put(this.thisServer, new String(this.thisServer));
                    object = (String)syncHash.get(this.thisServer);
                }
            }
        }
        this.printOut("syncHash " + syncHash);
        this.printOut("Before Syno block ");
        string = object;
        synchronized (string) {
            Object object2;
            this.isDynamicInfoTest = false;
            long l3 = System.currentTimeMillis();
            Long l4 = null;
            try {
                l4 = (Long)ht_lastTime.get(this.thisServer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l5 = 0L;
            if (l4 != null) {
                l5 = l4;
            }
            long l6 = l3 - l5;
            if (this.isDebugOn) {
                this.printOut(this.entity + " diff " + l6 + " perfCutoff " + this.perfCutoff);
            }
            if (l6 >= this.perfCutoff) {
                bl = true;
                l5 = l3;
                object2 = syncString2;
                synchronized (object2) {
                    try {
                        ht_lastTime.put(this.thisServer, new Long(l5));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.printOut("ERROR : ht_lasttime put exception " + exception.toString());
                        return;
                    }
                }
            }
            bl = false;
            this.printOut("getDataFromSAP = " + bl);
            if (bl) {
                try {
                    l4 = (Long)ht_confLastTime.get(this.thisServer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                l5 = 0L;
                if (l4 != null) {
                    l5 = l4;
                }
                l6 = l3 - l5;
                if (this.isDebugOn) {
                    this.printOut(this.entity + " diff " + l6 + " perfCutoff " + this.perfCutoff);
                }
                object2 = (Long)ht_minConfTestFreq.get(this.thisServer);
                long l7 = 0L;
                if (object2 != null) {
                    l7 = (Long)object2;
                }
                this.printOut("Before getconf flag diff " + l6 + ",minConfTestFreqVal " + 0.9 * (double)l7 + ",isSapCCMSConfigTest " + this.isSapCCMSConfigTest);
                if ((double)l6 >= 0.9 * (double)l7 && this.isSapCCMSConfigTest) {
                    bl2 = true;
                    this.printOut("CONF_DEBUG : get Conf Data From SAP = true");
                }
                long l8 = System.currentTimeMillis();
                if (bl2) {
                    this.printOut("CONF_DEBUG: initializing conf HT");
                    hashtable = new Hashtable();
                }
                try {
                    Object object3;
                    Object object4;
                    int n;
                    int n2;
                    this.isBapiLoggedIn = false;
                    l = System.currentTimeMillis();
                    this.setSessID();
                    this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 1), "Begin Context");
                    if (!this.logonToXMI()) {
                        String string2 = syncString2;
                        synchronized (string2) {
                            try {
                                if (ht_TidFlag != null && ht_TidFlag.size() > 0 && ht_TidFlag.get(this.thisServer + this.instanceName) != null) {
                                    ht_TidFlag.remove(this.thisServer + this.instanceName);
                                }
                                if (ht_ht_TidCache != null && ht_ht_TidCache.size() > 0 && ht_ht_TidCache.get(this.thisServer) != null) {
                                    ht_ht_TidCache.remove(this.thisServer);
                                }
                                if (ht_ht_TestRunningFlag != null && ht_ht_TestRunningFlag.size() > 0 && ht_ht_TestRunningFlag.get(this.thisServer) != null) {
                                    ht_ht_TestRunningFlag.remove(this.thisServer);
                                }
                                this.ht_TidCache = new Hashtable();
                                if (bl2) {
                                    ht_ht_confValues.put(this.thisServer, hashtable);
                                }
                                ht_sapVersion.put(this.thisServer, new String(this.sapVersion));
                                ht_lastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                            }
                            catch (Exception exception) {
                                this.printOut("Exception while setting data values (after logon error) : " + exception.toString());
                                this.logToErrorFile("ERROR", this.entity, "Exception while setting data values (after logon error) : " + exception.toString());
                            }
                        }
                        ht_testStatus.put(this.thisServer, new Boolean(false));
                        this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 2), "End Context");
                        this.endSession();
                        return;
                    }
                    ht_testStatus.put(this.thisServer, new Boolean(true));
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - after export param list " + (System.currentTimeMillis() - l8) + " ms.");
                        this.printOut("Repository creation and BAPI_XMI_LOGON took " + (System.currentTimeMillis() - l) + "ms.");
                    }
                    long l9 = System.currentTimeMillis();
                    String string3 = syncString;
                    synchronized (string3) {
                        if (hashtable2 == null) {
                            hashtable2 = new Hashtable();
                        }
                        if (ht_ht_TestRunningFlag.get(this.thisServer) == null) {
                            ht_ht_TestRunningFlag.put(this.thisServer, hashtable2);
                        } else {
                            hashtable2 = (Hashtable)ht_ht_TestRunningFlag.get(this.thisServer);
                        }
                        boolean bl3 = this.egAgent.checkForUpdate();
                        this.printOut("checkBlnUpd " + bl3);
                        n2 = 0;
                        for (n = 0; n < arrCCMSList.size(); ++n) {
                            object4 = (String)arrCCMSList.get(n);
                            object3 = this.egAgent.getComponentsAssociatedForTest((String)object4);
                            String string4 = this.reportingName + ":" + this.portNo;
                            if (object3 != null && ((ArrayList)object3).size() > 0 && ((ArrayList)object3).contains(string4)) {
                                if (!(hashtable2.get(object4) != null || ht_TidFlag.get(this.thisServer + this.instanceName) != null && ht_TidFlag.get(this.thisServer + this.instanceName).equals("true"))) {
                                    hashtable2.put(object4, "true");
                                    continue;
                                }
                                if (hashtable2.get(object4) == null && (ht_TidFlag.get(this.thisServer + this.instanceName) != null || ht_TidFlag.get(this.thisServer + this.instanceName).equals("true"))) {
                                    n2 = 1;
                                    hashtable2.put(object4, "true");
                                    continue;
                                }
                                hashtable2.remove(object4);
                                hashtable2.put(object4, "true");
                                continue;
                            }
                            if (hashtable2.get(object4) == null) continue;
                            hashtable2.remove(object4);
                        }
                        if (hashtable2 != null && hashtable2.size() > 0) {
                            ht_ht_TestRunningFlag.put(this.thisServer, hashtable2);
                        }
                        if (n2 != 0) {
                            this.printOut("tidRefreshFlagForAddMoreTest: " + (n2 != 0));
                            if (ht_TidFlag != null && ht_TidFlag.size() > 0 && ht_TidFlag.get(this.thisServer + this.instanceName) != null) {
                                ht_TidFlag.remove(this.thisServer + this.instanceName);
                            }
                            if (ht_ht_TidCache != null && ht_ht_TidCache.size() > 0 && ht_ht_TidCache.get(this.thisServer) != null) {
                                ht_ht_TidCache.remove(this.thisServer);
                            }
                            this.ht_TidCache = new Hashtable();
                        }
                        this.printOut("ht_testRunning:" + hashtable2);
                    }
                    long l10 = System.currentTimeMillis();
                    this.printOut("Agent ini reader time taken for " + (l10 - l9) + " ms.");
                    this.printOut("Tracing - - after getMonitors CCMS Monitor set " + (System.currentTimeMillis() - l8) + " ms.");
                    n2 = perfAttrList.size();
                    for (n = 0; n < n2; ++n) {
                        object4 = perfAttrList.get(n).toString();
                        if (object4 == null || ((String)object4).length() <= 0) continue;
                        if (this.isDebugOn) {
                            this.printOut("Trying to get data from monitor  tree root : " + (String)object4);
                        }
                        if (ht_TidFlag.get(this.thisServer + this.instanceName) == null || !ht_TidFlag.get(this.thisServer + this.instanceName).equals("true")) {
                            this.populateMonValuesFromTree((String)object4, bl2);
                            continue;
                        }
                        this.populateMonValuesFromCachedData((String)object4, bl2);
                    }
                    Object object5 = syncString2;
                    synchronized (object5) {
                        if (ht_ht_TidCache != null && ht_ht_TidCache.size() > 0 && ht_ht_TidCache.get(this.thisServer) != null) {
                            object4 = (Hashtable)ht_ht_TidCache.get(this.thisServer);
                            ht_ht_TidCache.remove(this.thisServer);
                            if (ht_ht_TidCache != null && ht_ht_TidCache.size() > 0) {
                                ht_ht_TidCache.put(this.thisServer, this.ht_TidCache);
                            } else {
                                ht_ht_TidCache.put(this.thisServer, object4);
                            }
                        } else {
                            ht_ht_TidCache.put(this.thisServer, this.ht_TidCache);
                        }
                        this.printOut("ht_TidCache " + ht_ht_TidCache);
                        this.ht_TidCache = new Hashtable();
                        if (ht_TidFlag.get(this.thisServer + this.instanceName) == null || !ht_TidFlag.get(this.thisServer + this.instanceName).equals("true")) {
                            ht_TidFlag.put(this.thisServer + this.instanceName, "true");
                        }
                    }
                    this.printOut("Logging off from XMI status : " + this.logoffFromXMI());
                    this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 2), "End Context");
                    this.endSession();
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - after CCMS Monitor set " + (System.currentTimeMillis() - l8));
                    }
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - after release " + (System.currentTimeMillis() - l8));
                        this.printOut("Tracing printing mon values for instance ..." + this.thisServer + " " + this.instanceName);
                    }
                    if (bl2 && (object5 = (Hashtable)ht_ht_confValues.get(this.thisServer)) != null) {
                        object4 = ((Hashtable)object5).keys();
                        while (object4.hasMoreElements()) {
                            object3 = (String)object4.nextElement();
                            this.printOut("Config Values. key ( " + (String)object3 + " ) Value = " + (ArrayList)((Hashtable)object5).get(object3));
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string5 = syncString2;
                synchronized (string5) {
                    try {
                        ht_lastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
            }
            if ((object2 = (Boolean)ht_testStatus.get(this.thisServer)) != null && ((Boolean)object2).booleanValue()) {
                this.isDynamicInfoTest = true;
            }
        }
        this.printOut("After Syno block ");
        if (this.isDebugOn) {
            if (this.isAbapSystemComp) {
                this.printOut("setData took with Config Abap System " + (System.currentTimeMillis() - l2) + "ms.");
            } else {
                this.printOut("setData took with Config Abap instances" + (System.currentTimeMillis() - l2) + "ms.");
            }
        }
    }

    private JCoTable getMonitors() {
        long l = System.currentTimeMillis();
        JCoFunction jCoFunction = null;
        try {
            jCoFunction = this.getFunction("BAPI_SYSTEM_MON_GETLIST");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MON_GETLIST not found in SAP.");
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MON_GETLIST not found in SAP " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("MONI_SET_NAME");
        if (jCoStructure == null) {
            this.printOut("ERROR : MONI_SET_NAME structure null");
            return null;
        }
        jCoStructure.setValue("NAME", MON_SET_NAME);
        try {
            this.executeFunction(jCoFunction, true);
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("MONITOR_NAMES");
            if (jCoTable == null) {
                this.printOut("Could not obtain monitor_names table");
                return null;
            }
            jCoTable.setRow(0);
            if (this.isDebugOn) {
                this.printOut("getMonitorsForSet [MON_GETLIST] for set 'SAP CCMS Monitor Templates' took " + (System.currentTimeMillis() - l) + "ms.");
            }
            this.printOut("got monitor list table");
            return jCoTable;
        }
        catch (Exception exception) {
            this.printOut("Error getting monitors : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error getting monitors : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMonValuesFromTree(String string, boolean bl) {
        int n;
        long l = System.currentTimeMillis();
        ArrayList arrayList = null;
        ArrayList<String> arrayList2 = null;
        String string2 = "BAPI_SYSTEM_MON_GETTREE not found in SAP.";
        JCoFunction jCoFunction = null;
        try {
            jCoFunction = this.getFunction("BAPI_SYSTEM_MON_GETTREE");
        }
        catch (Exception exception) {
            this.printOut("Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            exception.printStackTrace();
            return;
        }
        if (jCoFunction == null) {
            this.printOut("Error : Could not create function BAPI_SYSTEM_MON_GETTREE");
            return;
        }
        arrayList = new ArrayList();
        if (bl) {
            arrayList2 = new ArrayList<String>();
        }
        ArrayList arrayList3 = new ArrayList();
        JCoTable jCoTable = null;
        Object var12_12 = null;
        String string3 = new String();
        String string4 = "";
        String string5 = "";
        boolean bl2 = false;
        Hashtable hashtable = new Hashtable();
        try {
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("MONITOR_NAME");
            jCoStructure.setValue("MONI_NAME", string);
            jCoStructure.setValue("MS_NAME", MON_SET_NAME);
            this.executeFunction(jCoFunction, true);
            jCoTable = jCoFunction.getTableParameterList().getTable("TREE_NODES");
            this.printOut("populateMonValuesFromTree Called  ,Time taken to get monitor tree [MON_GETTREE] for monitor " + string + " is " + (System.currentTimeMillis() - l) + "ms.");
            bl2 = perfAttrList.contains(string);
            n = jCoTable.getNumRows();
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to get monitor tree: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get monitor tree: " + exception.toString());
            exception.printStackTrace();
            n = 0;
        }
        if (ht_ht_TestRunningFlag.get(this.thisServer) == null) {
            ht_ht_TestRunningFlag.put(this.thisServer, hashtable);
        }
        hashtable = (Hashtable)ht_ht_TestRunningFlag.get(this.thisServer);
        for (int i = 0; i < n; ++i) {
            Object object;
            string5 = jCoTable.getString("MSEGNAME");
            boolean bl3 = false;
            if (string5 == null) {
                jCoTable.nextRow();
                continue;
            }
            if ((string5 = string5.trim()) == null || string5.length() < 10) {
                jCoTable.nextRow();
                continue;
            }
            if (!this.isAbapSystemComp && !string4.equalsIgnoreCase(this.instanceName)) {
                jCoTable.nextRow();
                continue;
            }
            string4 = string5.substring(9);
            String string6 = jCoTable.getString("OBJECTNAME");
            String string7 = jCoTable.getString("MTCLASS");
            String string8 = jCoTable.getString("MTNAMESHRT");
            String string9 = jCoTable.getString("MTMCNAME");
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            JCoRecordFieldIterator jCoRecordFieldIterator = jCoTable.getRecordFieldIterator();
            while (jCoRecordFieldIterator.hasNextField()) {
                object = jCoRecordFieldIterator.nextField();
                String string10 = object.getName();
                if (!string10.equalsIgnoreCase("MTSYSID") && !string10.equalsIgnoreCase("MTMCNAME") && !string10.equalsIgnoreCase("MTNUMRANGE") && !string10.equalsIgnoreCase("MTUID") && !string10.equalsIgnoreCase("MTCLASS") && !string10.equalsIgnoreCase("MTINDEX") && !string10.equalsIgnoreCase("EXTINDEX") && !string10.equalsIgnoreCase("MTNAMESHRT") && !string10.equalsIgnoreCase("OBJECTNAME") && !string10.equalsIgnoreCase("MSEGNAME") || object.getValue() == null) continue;
                hashtable2.put(string10, jCoTable.getString(string10));
            }
            if (string.equalsIgnoreCase("Entire System")) {
                if (hashtable.containsKey("AsAbapIcmCnfTest_cf") && string6.equalsIgnoreCase("General") && (string8.equalsIgnoreCase("Version") || string8.equalsIgnoreCase("MaxNoOfThreads") || string8.equalsIgnoreCase("MaxNoOfConnections") || string8.equalsIgnoreCase("MaxQueueLen") || string8.equalsIgnoreCase("MPISizeTotal") || string8.equalsIgnoreCase("MPIBufferCount"))) {
                    bl3 = true;
                }
                if (hashtable.containsKey("AsAbapSrvCnfTest_cf") && string6.equalsIgnoreCase("Server Configuration") && (string8.equalsIgnoreCase("Server Configuration") || string8.equalsIgnoreCase("Host") || string8.equalsIgnoreCase("Operating System") || string8.equalsIgnoreCase("Machine Type") || string8.equalsIgnoreCase("IP Address") || string8.equalsIgnoreCase("Start time and date") || string8.equalsIgnoreCase("R/3 Kernel Release") || string8.equalsIgnoreCase("R/3 Kernel Database Library") || string8.equalsIgnoreCase("R/3 Kernel Patch Level") || string8.equalsIgnoreCase("Start Profile") || string8.equalsIgnoreCase("Instance Profile") || string8.equalsIgnoreCase("Home Directory") || string8.equalsIgnoreCase("SAP Codepage") || string8.equalsIgnoreCase("Total Number of Work Processes") || string8.equalsIgnoreCase("Parameter Changes"))) {
                    bl3 = true;
                }
                if (hashtable.containsKey("AsAbapSysTest_cf") && string6.equalsIgnoreCase("SAP License") && (string8.equalsIgnoreCase("Installation number") || string8.equalsIgnoreCase("License Expiration Date"))) {
                    bl3 = true;
                }
            }
            if (bl && this.isTextAttribute(string7) && bl3) {
                if (this.ht_TidCache.get(string + "##" + string4 + "#" + string6 + "|" + jCoTable.getString("MTNAMESHRT")) == null) {
                    this.ht_TidCache.put(string + "##" + string4 + "#" + string6 + "|" + jCoTable.getString("MTNAMESHRT"), hashtable2);
                }
                if (this.ht_TidCache.get(string + "##" + string4 + "#" + string6 + "|" + jCoTable.getString("MTNAMESHRT")) != null) {
                    this.ht_TidCache.remove(string + "##" + string4 + "#" + string6 + "|" + jCoTable.getString("MTNAMESHRT"));
                    this.ht_TidCache.put(string + "##" + string4 + "#" + string6 + "|" + jCoTable.getString("MTNAMESHRT"), hashtable2);
                }
                object = this.getTxtPropMessageValue(jCoTable.getString("MTSYSID"), string9, jCoTable.getString("MTNUMRANGE"), jCoTable.getString("MTUID"), jCoTable.getString("MTCLASS"), jCoTable.getString("MTINDEX"), jCoTable.getString("EXTINDEX"), string8, string);
                arrayList2.add(string4 + "#" + string6 + "|" + jCoTable.getString("MTNAMESHRT") + "|" + (String)object);
            }
            jCoTable.nextRow();
        }
        Hashtable<String, ArrayList<String>> hashtable3 = null;
        try {
            hashtable3 = (Hashtable<String, ArrayList<String>>)ht_ht_confValues.get(this.thisServer);
        }
        catch (Exception exception) {
            this.printOut("Exception while setting data values. Resetting to null and initialized shortly : " + exception.toString());
            hashtable3 = null;
        }
        if (hashtable3 == null) {
            this.printOut("CONF_DEBUG : Initialized config values for " + this.thisServer);
            hashtable3 = new Hashtable<String, ArrayList<String>>();
        }
        if (bl) {
            this.printOut("CONF_DEBUG : Setting confValues for monitor " + string);
            this.printOut("CONF_DEBUG : confValues = " + arrayList2);
            HashSet hashSet = new HashSet(arrayList2);
            arrayList2.clear();
            arrayList2.addAll(hashSet);
            hashtable3.put(string, arrayList2);
        }
        String string11 = syncString2;
        synchronized (string11) {
            try {
                if (bl) {
                    ht_confLastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                    ht_ht_confValues.put(this.thisServer, hashtable3);
                }
                if (this.sapVersion != null && this.sapVersion.length() > 0) {
                    ht_sapVersion.put(this.thisServer, this.sapVersion);
                }
            }
            catch (Exception exception) {
                this.printOut("Exception while storing measures for " + this.thisServer + " : " + exception.toString());
                this.logToErrorFile("ERROR", "Exception while storing measures for " + this.thisServer, exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMonValuesFromCachedData(String string, boolean bl) {
        Object object;
        Hashtable<String, ArrayList<String>> hashtable;
        long l = System.currentTimeMillis();
        ArrayList arrayList = null;
        ArrayList<String> arrayList2 = null;
        arrayList = new ArrayList();
        if (bl) {
            arrayList2 = new ArrayList<String>();
        }
        ArrayList arrayList3 = new ArrayList();
        Object var8_7 = null;
        String string2 = new String();
        String string3 = "";
        String string4 = "";
        boolean bl2 = false;
        Hashtable hashtable2 = new Hashtable();
        try {
            bl2 = perfAttrList.contains(string);
            if (ht_ht_TestRunningFlag.get(this.thisServer) == null) {
                ht_ht_TestRunningFlag.put(this.thisServer, hashtable2);
            }
            hashtable2 = (Hashtable)ht_ht_TestRunningFlag.get(this.thisServer);
            this.ht_TidCache = (Hashtable)ht_ht_TidCache.get(this.thisServer);
            hashtable = this.ht_TidCache.keys();
            while (hashtable.hasMoreElements()) {
                object = (String)hashtable.nextElement();
                if (!((String)object).startsWith(string + "##")) continue;
                Hashtable hashtable3 = (Hashtable)this.ht_TidCache.get(object);
                string4 = (String)hashtable3.get("MSEGNAME");
                if (((String)hashtable3.get("MTNAMESHRT")).equalsIgnoreCase("Enqueue Request Errors")) {
                    this.printOut("mtNameShrt=" + (String)hashtable3.get("MTNAMESHRT"));
                }
                boolean bl3 = false;
                boolean bl4 = false;
                if (string4 == null || (string4 = string4.trim()) == null || string4.length() < 10) continue;
                string3 = string4.substring(9);
                if (!this.isAbapSystemComp && !string3.equalsIgnoreCase(this.instanceName)) continue;
                String string5 = (String)hashtable3.get("OBJECTNAME");
                String string6 = (String)hashtable3.get("MTCLASS");
                String string7 = (String)hashtable3.get("MTNAMESHRT");
                String string8 = (String)hashtable3.get("MTMCNAME");
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                hashtable4.put("MTSYSID", (String)hashtable3.get("MTSYSID"));
                hashtable4.put("MTMCNAME", string8);
                hashtable4.put("MTNUMRANGE", (String)hashtable3.get("MTNUMRANGE"));
                hashtable4.put("MTUID", (String)hashtable3.get("MTUID"));
                hashtable4.put("MTCLASS", (String)hashtable3.get("MTCLASS"));
                hashtable4.put("MTINDEX", (String)hashtable3.get("MTINDEX"));
                hashtable4.put("EXTINDEX", (String)hashtable3.get("EXTINDEX"));
                hashtable4.put("MTNAMESHRT", (String)hashtable3.get("MTNAMESHRT"));
                hashtable4.put("OBJECTNAME", (String)hashtable3.get("OBJECTNAME"));
                hashtable4.put("MSEGNAME", (String)hashtable3.get("MSEGNAME"));
                if (string.equalsIgnoreCase("Entire System")) {
                    if (hashtable2.containsKey("AsAbapIcmCnfTest_cf") && string5.equalsIgnoreCase("General") && (string7.equalsIgnoreCase("Version") || string7.equalsIgnoreCase("MaxNoOfThreads") || string7.equalsIgnoreCase("MaxNoOfConnections") || string7.equalsIgnoreCase("MaxQueueLen") || string7.equalsIgnoreCase("MPISizeTotal") || string7.equalsIgnoreCase("MPIBufferCount"))) {
                        bl3 = true;
                    }
                    if (hashtable2.containsKey("AsAbapSrvCnfTest_cf") && string5.equalsIgnoreCase("Server Configuration") && (string7.equalsIgnoreCase("Server Configuration") || string7.equalsIgnoreCase("Host") || string7.equalsIgnoreCase("Operating System") || string7.equalsIgnoreCase("Machine Type") || string7.equalsIgnoreCase("IP Address") || string7.equalsIgnoreCase("Start time and date") || string7.equalsIgnoreCase("R/3 Kernel Release") || string7.equalsIgnoreCase("R/3 Kernel Database Library") || string7.equalsIgnoreCase("R/3 Kernel Patch Level") || string7.equalsIgnoreCase("Start Profile") || string7.equalsIgnoreCase("Instance Profile") || string7.equalsIgnoreCase("Home Directory") || string7.equalsIgnoreCase("SAP Codepage") || string7.equalsIgnoreCase("Total Number of Work Processes") || string7.equalsIgnoreCase("Parameter Changes"))) {
                        bl3 = true;
                    }
                    if (hashtable2.containsKey("AsAbapSysTest_cf") && string5.equalsIgnoreCase("SAP License") && (string7.equalsIgnoreCase("Installation number") || string7.equalsIgnoreCase("License Expiration Date"))) {
                        bl3 = true;
                    }
                }
                if (!bl || !this.isTextAttribute(string6) || !bl3) continue;
                if (this.ht_TidCache.get(string + "##" + string3 + "#" + string5 + "|" + (String)hashtable3.get("MTNAMESHRT")) == null) {
                    this.ht_TidCache.put(string + "##" + string3 + "#" + string5 + "|" + (String)hashtable3.get("MTNAMESHRT"), hashtable4);
                }
                if (this.ht_TidCache.get(string + "##" + string3 + "#" + string5 + "|" + (String)hashtable3.get("MTNAMESHRT")) != null) {
                    this.ht_TidCache.remove(string + "##" + string3 + "#" + string5 + "|" + (String)hashtable3.get("MTNAMESHRT"));
                    this.ht_TidCache.put(string + "##" + string3 + "#" + string5 + "|" + (String)hashtable3.get("MTNAMESHRT"), hashtable4);
                }
                String string9 = this.getTxtPropMessageValue((String)hashtable3.get("MTSYSID"), string8, (String)hashtable3.get("MTNUMRANGE"), (String)hashtable3.get("MTUID"), (String)hashtable3.get("MTCLASS"), (String)hashtable3.get("MTINDEX"), (String)hashtable3.get("EXTINDEX"), string7, string);
                arrayList2.add(string3 + "#" + string5 + "|" + (String)hashtable3.get("MTNAMESHRT") + "|" + string9);
            }
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to get monitor tree: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get monitor tree: " + exception.toString());
            exception.printStackTrace();
        }
        hashtable = null;
        try {
            hashtable = (Hashtable)ht_ht_confValues.get(this.thisServer);
        }
        catch (Exception exception) {
            this.printOut("Exception while setting data values. Resetting to null and initialized shortly : " + exception.toString());
            hashtable = null;
        }
        if (hashtable == null) {
            this.printOut("CONF_DEBUG : Initialized config values for " + this.thisServer);
            hashtable = new Hashtable<String, ArrayList<String>>();
        }
        if (bl) {
            this.printOut("CONF_DEBUG : Setting confValues for monitor " + string);
            this.printOut("CONF_DEBUG : confValues = " + arrayList2);
            object = new HashSet(arrayList2);
            arrayList2.clear();
            arrayList2.addAll((Collection<String>)object);
            hashtable.put(string, arrayList2);
        }
        object = syncString2;
        synchronized (object) {
            try {
                if (bl) {
                    ht_confLastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                    ht_ht_confValues.put(this.thisServer, hashtable);
                }
                if (this.sapVersion != null && this.sapVersion.length() > 0) {
                    ht_sapVersion.put(this.thisServer, this.sapVersion);
                }
            }
            catch (Exception exception) {
                this.printOut("Exception while storing measures for " + this.thisServer + " : " + exception.toString());
                this.logToErrorFile("ERROR", "Exception while storing measures for " + this.thisServer, exception.toString());
            }
        }
    }

    public Hashtable cloneHashtable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                int n2 = string2.indexOf("#");
                if (n2 < 0) {
                    arrayList2.add(string2);
                    continue;
                }
                String string3 = string2.substring(0, n2);
                if (!this.instanceName.equalsIgnoreCase(string3)) continue;
                String string4 = string2.substring(n2 + 1);
                arrayList2.add(string4);
            }
            hashtable2.put(string, arrayList2);
        }
        return hashtable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getConfigData(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_confValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_confValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No config data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + ":" + this.entity, "Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (!this.instanceName.equalsIgnoreCase(string4)) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSapVersion() {
        String string = syncString2;
        synchronized (string) {
            this.printOut("htsapversion: '" + ht_sapVersion + "'");
            if (ht_sapVersion == null) {
                return null;
            }
            return (String)ht_sapVersion.get(this.thisServer);
        }
    }

    private String formatValue(String string, String string2) {
        String string3 = string;
        if (string == null || string2 == null) {
            return null;
        }
        int n = Integer.parseInt(string2);
        if (n > 0) {
            int n2;
            int n3 = string3.length();
            if (n > n3) {
                for (n2 = 0; n2 < n - n3; ++n2) {
                    string3 = "0" + string3;
                }
            }
            string3 = (n2 = string3.length() - n) == 0 ? "0." + string3 : string3.substring(0, n2) + "." + string3.substring(n2);
        }
        return string3;
    }

    private String getTxtPropMessageValue(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        long l = System.currentTimeMillis();
        String string10 = "";
        JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MTE_GETTXTPROP");
        if (jCoFunction == null) {
            return "";
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("TID");
        if (jCoStructure == null) {
            return "";
        }
        jCoStructure.setValue("MTSYSID", string);
        jCoStructure.setValue("MTMCNAME", string2);
        jCoStructure.setValue("MTNUMRANGE", string3);
        jCoStructure.setValue("MTUID", string4);
        jCoStructure.setValue("MTCLASS", string5);
        jCoStructure.setValue("MTINDEX", string6);
        jCoStructure.setValue("EXTINDEX", string7);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing executeFunction : " + exception.toString());
            return "";
        }
        String string11 = "";
        String string12 = "";
        try {
            JCoStructure jCoStructure2 = jCoFunction.getExportParameterList().getStructure("PROPERTIES");
            if (jCoStructure2 == null) {
                return "";
            }
            string12 = jCoStructure2.getString("TEXT");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETTXTPROP : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETTXTPROP : " + exception.toString());
            exception.printStackTrace();
            return "";
        }
        if (this.isDebugOn) {
            this.printOut("getTxtPropMessageValue [BAPITXTPRP] for monitor name " + string9 + " and mtNameShrt " + string8 + " returning " + string12 + " and took " + (System.currentTimeMillis() - l) + "ms.");
        }
        return string12;
    }

    private boolean isTextAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("110") || string.equals("111");
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        EgSapGenConfJco3Test egSapGenConfJco3Test = new EgSapGenConfJco3Test(stringArray);
        egSapGenConfJco3Test.setData();
        egSapGenConfJco3Test.printOut("Getting config data for System Configuration : ");
        ArrayList arrayList = egSapGenConfJco3Test.getConfigData("System Configuration");
        if (arrayList != null) {
            egSapGenConfJco3Test.printOut(arrayList.toString());
        } else {
            egSapGenConfJco3Test.printOut("Null");
        }
    }

    public void addValue(Hashtable hashtable, String string, String string2) {
        ArrayList<String> arrayList = null;
        if (hashtable.containsKey(string)) {
            arrayList = (ArrayList<String>)hashtable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
        } else {
            arrayList = new ArrayList<String>();
            arrayList.add(string2);
        }
        hashtable.put(string, arrayList);
    }

    static {
        syncHash = new Hashtable();
        syncString = new String("SAP");
        syncString2 = new String("SAP2");
        syncString3 = new String("SAP3");
        perfAttrList = new ArrayList();
        arrCCMSList = new ArrayList();
        myDatePattern = "dd/MM/yy hh:mm:ss a";
        mySDF = new SimpleDateFormat(myDatePattern);
        ht_ht_TidCache = new Hashtable();
        ht_TidFlag = new Hashtable();
        ht_ht_TestRunningFlag = new Hashtable();
        perfAttrList.add("Entire System");
        arrCCMSList.add("AsAbapIcmCnfTest_cf");
        arrCCMSList.add("AsAbapSysTest_cf");
        arrCCMSList.add("AsAbapSrvCnfTest_cf");
    }
}

