/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.eg.apm.EgLogbackManager;
import com.eg.org.slf4j.Logger;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ElasticSearchBase
extends GenericTest {
    public ElasticSearchInfo esInfo = null;
    boolean isItAgentLessComp = false;
    private static final int ELASTIC_SEARCH_DEFAULT_PORT = 9200;
    private static final String ELASTIC_SEARCH_DEFAULT_IP = "127.0.0.1";
    private static final String ELASTIC_SEARCH_DEFAULT_PROTOCOL = "http";
    private static final String ELASTICSEARCH_TEST_URL_MAPPING_SUB = "ELASTICSEARCH_TEST_URL_MAPPING";
    public static String installDir = EgInstallInfo.getInstallDir();
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    public static final Logger logger = EgLogbackManager.getInstance().getLogger("ELASTIC_SEARCH_LOGGER");
    protected String logPrefix = " [" + this.reportingName + ":" + this.portNo + "] [" + this.entity + "] ";

    public ElasticSearchBase(String[] stringArray) {
        super(stringArray);
        try {
            logger.info(this.logPrefix + "Initializing ElasticSearchBase ...");
            this.esInfo = new ElasticSearchInfo(this.reportingName);
            if (this.targetHost == null || this.targetHost.length() <= 0 || this.targetHost.equalsIgnoreCase("none")) {
                logger.info(this.logPrefix + " targetHost is null or empty or none : " + this.targetHost);
                logger.info(this.logPrefix + " Using Default targetHost :" + ELASTIC_SEARCH_DEFAULT_IP);
                this.esInfo.setElasticSearchIp(ELASTIC_SEARCH_DEFAULT_IP);
            } else {
                logger.info(this.logPrefix + " Using targetHost :" + this.targetHost);
                this.esInfo.setElasticSearchIp(this.targetHost);
            }
            if (this.portNo == null || this.portNo.length() <= 0 || this.portNo.equalsIgnoreCase("none")) {
                logger.info(this.logPrefix + " portNo is null or empty or none : " + this.portNo);
                logger.info(this.logPrefix + " Using Default portNo :" + 9200);
                this.esInfo.setElasticSearchPort(9200);
            } else {
                try {
                    int n = Integer.parseInt(this.portNo);
                    logger.info(this.logPrefix + " Using portNo :" + n);
                    this.esInfo.setElasticSearchPort(n);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info(this.logPrefix + " Invalid portNo : " + this.portNo + " Using Default portNo :" + 9200);
                    this.esInfo.setElasticSearchPort(9200);
                }
            }
            this.isItAgentLessComp = this.isSSH && this.alos != null && this.alos.equalsIgnoreCase("LINUX");
            String string = this.readInputParameters("elasticsearch_UserName", "Elastic_Search_user", "none");
            String string2 = this.readInputParameters("elasticsearch_Password", "Elastic_Search_password", "none");
            String string3 = this.readInputParameters("ssl_Enabled", "ssl", "false");
            String string4 = this.readInputParameters("elasticsearch_RemoteHost", "Cloud_Instance_URL", "none");
            String string5 = ELASTIC_SEARCH_DEFAULT_PROTOCOL;
            if (string3.trim().equalsIgnoreCase("true") || string3.trim().equalsIgnoreCase("yes")) {
                string5 = "https";
            }
            this.esInfo.setItAgentLessComp(this.isItAgentLessComp);
            this.esInfo.setElasticSearchUser(string);
            this.esInfo.setElasticSearchPass(string2);
            this.esInfo.setElasticSearchProtocol(string5);
            this.esInfo.setElasticSearchRemoteHost(string4);
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing ElasticSearchBase", (Throwable)exception);
        }
    }

    protected String readInputParameters(String string, String string2, String string3) {
        if (string2 == null) {
            return null;
        }
        String string4 = this.getValueForParam(string2);
        if (string4 == null || string4.length() <= 0 || string4.equalsIgnoreCase("none")) {
            logger.debug(this.logPrefix + string + " is null or empty or none or false or disabled : " + string4);
            string4 = string3;
            logger.info(this.logPrefix + "Using default " + string + " as " + string4);
        } else if (string2.contains("pass") || string2.contains("password") || string2.contains("pwd")) {
            logger.info(this.logPrefix + "Given " + string + " is succesfully entered");
        } else {
            logger.info(this.logPrefix + "Given " + string + " is " + string4);
        }
        return string4;
    }

    public ArrayList finalMeasures(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(-5.0));
        }
        logger.debug(this.logPrefix + " [finalMeasures] creating and initializing the measure list ");
        return arrayList;
    }

    public Hashtable getElasticSearchNamesMappingTable(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            IniFile iniFile = new IniFile(installDir + iniFilePath);
            String[] stringArray = iniFile.getVariables(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = iniFile.getValue(string, stringArray[i]);
                if (string2.contains("~!~")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "~!~");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        hashtable.put(string3, stringArray[i]);
                    }
                    continue;
                }
                hashtable.put(string2, stringArray[i]);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [getElasticSearchNamesMappingTable] Exception Occured while mapping the ke value of table for the subject :" + string, (Throwable)exception);
        }
        logger.debug(this.logPrefix + " [getElasticSearchNamesMappingTable] returning the table of Elastic Search key value pair for the " + string + " in keyValueMapingTable : " + hashtable);
        return hashtable;
    }

    public Hashtable getElasticSearchIndexMappingTable(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            IniFile iniFile = new IniFile(installDir + iniFilePath);
            String[] stringArray = iniFile.getVariables(string);
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], iniFile.getValue(string, stringArray[i]));
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [getElasticSearchIndexMappingTable] Exception Occured while mapping the key value of table for the subject :" + string, (Throwable)exception);
        }
        logger.debug(this.logPrefix + " [getElasticSearchIndexMappingTable] returning the table of INI name and index of the Subject " + string + " in indexMappingTable : " + hashtable);
        return hashtable;
    }

    public ArrayList getRestURLs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable hashtable = this.getElasticSearchNamesMappingTable(ELASTICSEARCH_TEST_URL_MAPPING_SUB);
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashtable.get(string2);
            if (!string3.equals(string)) continue;
            arrayList.add(string2);
        }
        logger.debug(this.logPrefix + " [getRestURLs] returning the list of ElasticSearch URL of the Subject " + string + " in ElasticSearchURLList : " + arrayList);
        return arrayList;
    }

    public String formValidElasticsearchRestURL() {
        String string = "";
        String string2 = this.esInfo.getElasticSearchRemoteHost();
        String string3 = this.esInfo.getElasticSearchIp();
        string = string2.equalsIgnoreCase("none") || string2 == null ? this.esInfo.getElasticSearchProtocol() + "://" + this.esInfo.getElasticSearchIp() + ":" + this.esInfo.getElasticSearchPort() : this.esInfo.getElasticSearchProtocol() + "://" + this.esInfo.getElasticSearchRemoteHost();
        logger.debug(this.logPrefix + " [formValidElasticsearchRestURL] The host URL of the component is : " + string);
        return string;
    }

    public String getElasticsearchVersion() {
        String string = "5.0";
        String string2 = this.formValidElasticsearchRestURL();
        String string3 = this.getElasticsearchJSONData(string2);
        try {
            if (string3 == null || string3.equals("") || string3.equalsIgnoreCase("Null")) {
                logger.warn(this.logPrefix + " [getElasticsearchVersion] JSON data is NULL or Empty.  jsonData : " + string3);
                return string;
            }
            string = (String)JsonPath.read((String)string3, (String)"$['version']['number']", (Predicate[])new Predicate[0]);
            string = string.substring(0, string.lastIndexOf("."));
        }
        catch (PathNotFoundException pathNotFoundException) {
            logger.warn(this.logPrefix + " [getElasticsearchVersion] $['version'] not found, Using default version number {}", (Object)string);
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [getElasticsearchVersion] Exception Occured while fetching the version :", (Throwable)exception);
            logger.warn(this.logPrefix + " [getElasticsearchVersion] Using default version number {}", (Object)string);
        }
        logger.debug(this.logPrefix + " [getElasticsearchVersion] The version of the component is : " + string);
        return string;
    }

    public String getElasticSearchRestURLForTest(String string) {
        String string2 = this.formValidElasticsearchRestURL();
        Double d = 5.0;
        try {
            d = Double.parseDouble(this.getElasticsearchVersion()) >= 5.0 ? 5.0 : 2.0;
            logger.debug(this.logPrefix + " [getElasticSearchRestURLForTest] Assigning Version {} API URLs to this component ", (Object)d);
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug(this.logPrefix + " [getElasticSearchRestURLForTest] Unable to parse ElasticsearchVerson due to " + numberFormatException.getMessage());
        }
        String string3 = "v." + d;
        ArrayList arrayList = this.getRestURLs(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string4 = (String)arrayList.get(i);
            String string5 = string4.substring(0, string4.indexOf(":"));
            if (!string5.equals(string3)) continue;
            string = string4.substring(string4.indexOf(":") + 1);
            String string6 = "";
            String string7 = "";
            if (string.contains("(*)")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "(*)");
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                    string7 = string7 + string2 + string6 + "(~!~)";
                }
                string2 = string7;
                continue;
            }
            string2 = string2 + string;
        }
        logger.debug(this.logPrefix + " [getElasticSearchRestURLForTest] The test URL is : " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getElasticsearchJSONData(String string) {
        String string2;
        block18: {
            string2 = null;
            CloseableHttpResponse closeableHttpResponse = null;
            SSLContextBuilder sSLContextBuilder = new SSLContextBuilder();
            String string3 = this.esInfo.getElasticSearchUser() != null ? this.esInfo.getElasticSearchUser() : "";
            String string4 = this.esInfo.getElasticSearchPass() != null ? this.esInfo.getElasticSearchPass() : "";
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            sSLContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContextBuilder.build());
            HttpGet httpGet = new HttpGet(string);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sSLConnectionSocketFactory).build();
            if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(string3, string4);
                basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)usernamePasswordCredentials);
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider).build();
            }
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            Object var13_15 = null;
            try {
                if (closeableHttpResponse != null) {
                    string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity()) + "";
                    closeableHttpResponse.close();
                }
                break block18;
            }
            catch (Exception exception) {
                logger.error(this.logPrefix + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + exception);
            }
            break block18;
            {
                catch (HttpHostConnectException httpHostConnectException) {
                    logger.error(this.logPrefix + " [getElasticsearchJSONData] Unable to connect Elasticsearch server : ", (Throwable)httpHostConnectException);
                    Object var13_16 = null;
                    try {
                        if (closeableHttpResponse != null) {
                            string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity()) + "";
                            closeableHttpResponse.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + exception);
                    }
                    break block18;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    logger.error(this.logPrefix + " [getElasticsearchJSONData] Unable to connect Elasticsearch server due to Socket Timed out ", (Throwable)socketTimeoutException);
                    Object var13_17 = null;
                    try {
                        if (closeableHttpResponse != null) {
                            string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity()) + "";
                            closeableHttpResponse.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + exception);
                    }
                    break block18;
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getElasticsearchJSONData] Exception occured while fetching the connection with the component ", (Throwable)exception);
                    Object var13_18 = null;
                    try {
                        if (closeableHttpResponse != null) {
                            string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity()) + "";
                            closeableHttpResponse.close();
                        }
                        break block18;
                    }
                    catch (Exception exception2) {
                        logger.error(this.logPrefix + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                try {
                    if (closeableHttpResponse != null) {
                        string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity()) + "";
                        closeableHttpResponse.close();
                    }
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getElasticsearchJSONData] Exception occured while fetching the Json values from the component " + exception);
                }
                throw throwable;
            }
        }
        logger.debug(this.logPrefix + " [getElasticsearchJSONData] URL " + string + "\n The JSON data of the component is : " + string2);
        return string2;
    }

    public Hashtable getValueForKeyFromJSON_NonInfoBased(String string, String string2) {
        if (string == null) {
            return null;
        }
        Hashtable hashtable = this.getElasticSearchNamesMappingTable(string2);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        block4: while (true) {
            try {
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    String string4 = (String)hashtable.get(string3);
                    try {
                        Object object = JsonPath.read((String)string, (String)string3, (Predicate[])new Predicate[0]);
                        if (object == null) continue block4;
                        hashtable2.put(string4, object);
                        continue block4;
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        logger.debug(this.logPrefix + " [getValueForKeyFromJSON_NonInfoBased] Path {} not found in JsonData {}", (Object)string3, (Object)string);
                    }
                }
                break;
            }
            catch (Exception exception) {
                logger.error(this.logPrefix + " [getValueForKeyFromJSON_NonInfoBased] Exception occured while mapping the values from testTable ", (Throwable)exception);
                break;
            }
        }
        logger.debug(this.logPrefix + " [getValueForKeyFromJSON_NonInfoBased] The Name and Value table  of the component is : " + hashtable2);
        return hashtable2;
    }

    public Hashtable jsonBuilder(String string, String string2, ArrayList arrayList) {
        Hashtable hashtable = this.getElasticSearchNamesMappingTable(string2);
        Hashtable hashtable2 = new Hashtable();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                String string3 = (String)arrayList.get(i);
                String string4 = null;
                String string5 = null;
                Iterator iterator = (Iterator)((Object)hashtable.keys());
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    string5 = (String)hashtable.get(string4);
                    string4 = string3 + string4;
                    hashtable3.put(string5, string4);
                }
                if (string3.equalsIgnoreCase("$['_all']")) {
                    hashtable2.put("Summary", hashtable3);
                    continue;
                }
                hashtable2.put(string3.substring(string3.indexOf("]") + 3, string3.length() - 2), hashtable3);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [jsonBuilder] Exception occured while mapping the values from testTable ", (Throwable)exception);
        }
        logger.debug(this.logPrefix + " [jsonBuilder] The Name and Value table  of the component is : " + hashtable2);
        return hashtable2;
    }

    public String getMoreThanOneJson(String string) {
        String string2 = "";
        if (string.contains("(~!~)")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(~!~)");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + this.getElasticsearchJSONData(stringTokenizer.nextToken()) + "|*|";
            }
        }
        string2 = string2.substring(0, string2.length() - 3);
        return string2;
    }

    public ArrayList updateMeasureIndex(Hashtable hashtable, String string, int n) {
        ArrayList arrayList = this.finalMeasures(n);
        Hashtable hashtable2 = this.getElasticSearchIndexMappingTable(string);
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = hashtable.get(string2).toString();
            if (!hashtable2.containsKey(string2)) continue;
            int n2 = Integer.parseInt(hashtable2.get(string2).toString());
            try {
                double d = Double.parseDouble(string3);
                arrayList.set(n2, d);
            }
            catch (Exception exception) {
                arrayList.set(n2, string3);
            }
        }
        logger.debug(this.logPrefix + " [updateMeasureIndex] The measure list after filling the values in the respective index : " + this.measures);
        return arrayList;
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }
}

