/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.eg.apm.APMLanguage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public final class GarbageCollectionUtil {
    public static ArrayList parseGCvalues(ArrayList result, APMLanguage language, double timeSinceLastTest, int numOutputFields) {
        return GarbageCollectionUtil.parseGCvalues(result, language, timeSinceLastTest, numOutputFields, null);
    }

    public static ArrayList parseGCvalues(ArrayList result, APMLanguage language, double timeSinceLastTest, int numOutputFields, String workerId) {
        ArrayList resultList = new ArrayList();
        Hashtable<String, ArrayList<ArrayList>> ddHash = null;
        Hashtable metricMap = null;
        if (result != null) {
            double F_numberOfGc = 0.0;
            double F_totalGcTime = 0.0;
            double F_maxGcPause = 0.0;
            double M_numberOfGc = 0.0;
            double M_totalGcTime = 0.0;
            double M_maxGcPause = 0.0;
            String info = null;
            Hashtable M_memory = null;
            Hashtable F_memory = null;
            Object key = null;
            String timeStamp = null;
            ArrayList<ArrayList> fullGc_dd = new ArrayList<ArrayList>();
            ArrayList<ArrayList> minorGc_dd = new ArrayList<ArrayList>();
            ddHash = new Hashtable<String, ArrayList<ArrayList>>();
            metricMap = new Hashtable();
            int i = 0;
            while (i < result.size()) {
                ArrayList ddLine;
                double heapAfter;
                double heapBefore;
                ArrayList individualResult = (ArrayList)result.get(i);
                String gcType = (String)individualResult.get(0);
                timeStamp = (String)individualResult.get(1);
                double gcDuration = (double)((Long)individualResult.get(2)).longValue() / 1000.0;
                Hashtable memAfterGC = (Hashtable)individualResult.get(3);
                Hashtable memBeforeGC = (Hashtable)individualResult.get(4);
                if (gcType.equals("M")) {
                    M_numberOfGc += 1.0;
                    M_memory = GarbageCollectionUtil.memComputation(memBeforeGC, memAfterGC);
                    M_totalGcTime += gcDuration;
                    if (gcDuration > M_maxGcPause) {
                        M_maxGcPause = gcDuration;
                    }
                    heapBefore = GarbageCollectionUtil.hashTableComputation(memBeforeGC);
                    heapAfter = GarbageCollectionUtil.hashTableComputation(memAfterGC);
                    ddLine = GarbageCollectionUtil.getDDLine(timeStamp, heapBefore, heapAfter, gcDuration, numOutputFields);
                    minorGc_dd.add(ddLine);
                }
                if (gcType.equals("F")) {
                    F_numberOfGc += 1.0;
                    F_memory = GarbageCollectionUtil.memComputation(memBeforeGC, memAfterGC);
                    F_totalGcTime += gcDuration;
                    if (gcDuration > F_maxGcPause) {
                        F_maxGcPause = gcDuration;
                    }
                    heapBefore = GarbageCollectionUtil.hashTableComputation(memBeforeGC);
                    heapAfter = GarbageCollectionUtil.hashTableComputation(memAfterGC);
                    ddLine = GarbageCollectionUtil.getDDLine(timeStamp, heapBefore, heapAfter, gcDuration, numOutputFields);
                    fullGc_dd.add(ddLine);
                }
                ++i;
            }
            boolean dataExists = false;
            double[] minorHeap = null;
            double[] majorHeap = null;
            if (M_numberOfGc > 0.0) {
                info = "Minor GC";
                if (workerId != null && !workerId.equals("Standalone")) {
                    info = "Worker_" + workerId + "#" + info;
                }
                double M_averageGcPause = M_totalGcTime / M_numberOfGc;
                double averageGCFrequency = timeSinceLastTest / M_numberOfGc;
                ddHash.put(String.valueOf(info) + ":Total", minorGc_dd);
                minorHeap = GarbageCollectionUtil.addingMeasure(M_memory, M_numberOfGc, M_averageGcPause, averageGCFrequency, M_maxGcPause, M_totalGcTime, info, timeStamp, language, numOutputFields, metricMap);
                dataExists = true;
            }
            if (F_numberOfGc > 0.0) {
                info = "Full GC";
                if (workerId != null && !workerId.equals("Standalone")) {
                    info = "Worker_" + workerId + "#" + info;
                }
                double F_averageGcPause = F_totalGcTime / F_numberOfGc;
                double averageGCFrequency = timeSinceLastTest / F_numberOfGc;
                ddHash.put(String.valueOf(info) + ":Total", fullGc_dd);
                majorHeap = GarbageCollectionUtil.addingMeasure(F_memory, F_numberOfGc, F_averageGcPause, averageGCFrequency, F_maxGcPause, F_totalGcTime, info, timeStamp, language, numOutputFields, metricMap);
                dataExists = true;
            }
            String summaryInfo = "Summary";
            if (workerId != null && !workerId.equals("Standalone")) {
                summaryInfo = "Worker_" + workerId + "#" + summaryInfo;
            }
            if (dataExists) {
                double S_numberOfGc = M_numberOfGc + F_numberOfGc;
                double S_totalGcTime = M_totalGcTime + F_totalGcTime;
                double S_maxGcPause = 0.0;
                double S_averageGcPause = 0.0;
                double averageGCFrequency = 0.0;
                S_maxGcPause = M_maxGcPause > F_maxGcPause ? M_maxGcPause : F_maxGcPause;
                double totalHeapBefore = 0.0;
                double totalHeapAfter = 0.0;
                if (minorHeap != null) {
                    totalHeapBefore = minorHeap[0];
                    totalHeapAfter = minorHeap[1];
                }
                if (majorHeap != null) {
                    totalHeapBefore += majorHeap[0];
                    totalHeapAfter += majorHeap[1];
                }
                if (S_numberOfGc > 0.0) {
                    S_averageGcPause = S_totalGcTime / S_numberOfGc;
                    averageGCFrequency = timeSinceLastTest / S_numberOfGc;
                }
                ArrayList<Double> measures = new ArrayList<Double>();
                measures.add(new Double(S_numberOfGc));
                measures.add(new Double(S_totalGcTime));
                if (averageGCFrequency >= 0.0) {
                    measures.add(new Double(averageGCFrequency));
                } else {
                    measures.add(new Double(-5.0));
                }
                measures.add(new Double(S_averageGcPause));
                if (averageGCFrequency > 0.0) {
                    measures.add(new Double(S_averageGcPause / averageGCFrequency * 100.0));
                } else {
                    measures.add(new Double(-5.0));
                }
                measures.add(new Double(S_maxGcPause));
                measures.add(new Double(GarbageCollectionUtil.changeUnit(totalHeapBefore / S_numberOfGc)));
                measures.add(new Double(GarbageCollectionUtil.changeUnit(totalHeapAfter / S_numberOfGc)));
                if (numOutputFields > 8) {
                    double totReclaimed = totalHeapBefore - totalHeapAfter;
                    double avgReclaimed = 0.0;
                    if (totReclaimed > 0.0) {
                        avgReclaimed = totReclaimed / S_numberOfGc;
                    } else {
                        totReclaimed = 0.0;
                    }
                    measures.add(new Double(GarbageCollectionUtil.changeUnit(totReclaimed)));
                    measures.add(new Double(GarbageCollectionUtil.changeUnit(avgReclaimed)));
                    if (numOutputFields > 10 && language == APMLanguage.NODEJS) {
                        if (S_totalGcTime == 0.0) {
                            measures.add(new Double(0.0));
                        } else {
                            DecimalFormat df = new DecimalFormat("#.####");
                            double totalTimeSpentPercentage = S_totalGcTime / S_numberOfGc * 100.0;
                            measures.add(new Double(df.format(totalTimeSpentPercentage)));
                        }
                    }
                }
                metricMap.put(summaryInfo, measures);
            } else {
                GarbageCollectionUtil.uploadValues("NONE", summaryInfo, 0, numOutputFields, metricMap);
            }
            resultList.add(metricMap);
            resultList.add(ddHash);
        }
        return resultList;
    }

    private static void uploadValues(String label, String descriptor, int i, int numOutputFields, Hashtable metricMap) {
        ArrayList<Double> al = new ArrayList<Double>();
        Double tmp = new Double(i);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        if (numOutputFields > 8) {
            al.add(tmp);
            al.add(tmp);
        }
        if (label.equals("NONE")) {
            metricMap.put(descriptor, al);
        } else {
            metricMap.put(String.valueOf(label) + descriptor, al);
        }
    }

    private static Hashtable memComputation(Hashtable memBeforeDetails, Hashtable memAfterDetails) {
        Hashtable tmpHash = new Hashtable();
        double heapSizeBeforeTmp = 0.0;
        double heapSizeAfterTmp = 0.0;
        if (memBeforeDetails != null && memBeforeDetails.size() > 0 && memAfterDetails != null && memAfterDetails.size() > 0) {
            Set keys = memBeforeDetails.keySet();
            Iterator itr = keys.iterator();
            while (itr.hasNext()) {
                ArrayList<Double> tmpArr = new ArrayList<Double>();
                String str = (String)itr.next();
                double heapSizeBefore = ((Long)memBeforeDetails.get(str)).longValue();
                double heapSizeAfter = ((Long)memAfterDetails.get(str)).longValue();
                heapSizeBeforeTmp = heapSizeBefore;
                heapSizeAfterTmp = heapSizeAfter;
                tmpArr.add(new Double(heapSizeBefore));
                tmpArr.add(new Double(heapSizeAfter));
                if (tmpHash.containsKey(str)) {
                    ArrayList<Double> heapSizeArr = (ArrayList<Double>)tmpHash.get(str);
                    heapSizeBeforeTmp += ((Double)heapSizeArr.get(0)).doubleValue();
                    heapSizeAfterTmp += ((Double)heapSizeArr.get(1)).doubleValue();
                    heapSizeArr = new ArrayList<Double>();
                    heapSizeArr.add(new Double(heapSizeBeforeTmp));
                    heapSizeArr.add(new Double(heapSizeAfterTmp));
                    tmpHash.put(str, heapSizeArr);
                    continue;
                }
                tmpHash.put(str, tmpArr);
            }
        }
        return tmpHash;
    }

    private static double hashTableComputation(Hashtable memDetailsHash) {
        double totalHeapSize = 0.0;
        if (memDetailsHash != null && memDetailsHash.size() > 0) {
            Set keys = memDetailsHash.keySet();
            for (String key : keys) {
                double heapSize = ((Long)memDetailsHash.get(key)).longValue();
                String heapSizetoMB = GarbageCollectionUtil.changeUnit(heapSize);
                double d = Double.parseDouble(heapSizetoMB);
                totalHeapSize += d;
            }
        }
        return totalHeapSize;
    }

    private static ArrayList getDDLine(String timestamp, String heapBefore, String heapAfter, String totalGC, int numOutputFields) {
        ArrayList<String> ddList = new ArrayList<String>();
        ddList.add(timestamp);
        ddList.add(heapBefore);
        ddList.add(heapAfter);
        ddList.add(totalGC);
        if (numOutputFields > 8) {
            double claimed = GarbageCollectionUtil.getClaimedBytes(heapBefore, heapAfter);
            ddList.add(JVMInstrumentation.formatValue(claimed));
        }
        return ddList;
    }

    private static ArrayList getDDLine(String timeStamp, double heapBefore, double heapAfter, double gcDuration, int numOutputFields) {
        ArrayList<String> ddList = new ArrayList<String>();
        ddList.add(timeStamp);
        ddList.add(JVMInstrumentation.formatValue(heapBefore));
        ddList.add(JVMInstrumentation.formatValue(heapAfter));
        ddList.add(JVMInstrumentation.formatValue(gcDuration));
        if (numOutputFields > 8) {
            double claimed = heapBefore - heapAfter;
            if (claimed < 0.0) {
                claimed = 0.0;
            }
            ddList.add(JVMInstrumentation.formatValue(claimed));
        }
        return ddList;
    }

    private static double getClaimedBytes(String heapBefore, String heapAfter) {
        double before = 0.0;
        double after = 0.0;
        double claimed = 0.0;
        try {
            before = Double.parseDouble(heapBefore);
        }
        catch (Exception e) {
            before = 0.0;
        }
        try {
            after = Double.parseDouble(heapAfter);
        }
        catch (Exception e) {
            after = 0.0;
        }
        if (before >= 0.0 && after >= 0.0) {
            claimed = before - after;
        }
        if (claimed < 0.0) {
            claimed = 0.0;
        }
        return claimed;
    }

    private static double[] addingMeasure(Hashtable memDetails, double numberOfGc, double averageGcPause, double averageGCFrequency, double maxGcPause, double totalGcTime, String info, String timeStamp, APMLanguage language, int numOutputFields, Hashtable metricMap) {
        double totalHeapSizeBefore = 0.0;
        double totalHeapSizeAfter = 0.0;
        double[] resultArray = new double[2];
        if (memDetails != null && memDetails.size() > 0) {
            Set keys = memDetails.keySet();
            for (String key : keys) {
                ArrayList heapMemUsed = (ArrayList)memDetails.get(key);
                double M_totalHeapSizeBefore = (Double)heapMemUsed.get(0);
                double M_totalHeapSizeAfter = (Double)heapMemUsed.get(1);
                totalHeapSizeBefore += M_totalHeapSizeBefore;
                totalHeapSizeAfter += M_totalHeapSizeAfter;
                ArrayList<Double> al = new ArrayList<Double>();
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(GarbageCollectionUtil.changeUnit(M_totalHeapSizeBefore / numberOfGc)));
                al.add(new Double(GarbageCollectionUtil.changeUnit(M_totalHeapSizeAfter / numberOfGc)));
                if (numOutputFields > 8) {
                    double totReclaimed = M_totalHeapSizeBefore - M_totalHeapSizeAfter;
                    double avgReclaimed = 0.0;
                    if (totReclaimed > 0.0) {
                        avgReclaimed = totReclaimed / numberOfGc;
                    } else {
                        totReclaimed = 0.0;
                    }
                    al.add(new Double(GarbageCollectionUtil.changeUnit(totReclaimed)));
                    al.add(new Double(GarbageCollectionUtil.changeUnit(avgReclaimed)));
                    if (numOutputFields > 10 && language == APMLanguage.NODEJS) {
                        if (totalGcTime == 0.0) {
                            al.add(new Double(0.0));
                        } else {
                            DecimalFormat df = new DecimalFormat("#.####");
                            double totalTimeSpentPercentage = totalGcTime / numberOfGc * 100.0;
                            al.add(new Double(df.format(totalTimeSpentPercentage)));
                        }
                    }
                }
                if (language.equals((Object)APMLanguage.NODEJS)) continue;
                String infoString = String.valueOf(info) + ":" + key;
                metricMap.put(infoString, al);
            }
            ArrayList<Double> measures = new ArrayList<Double>();
            measures.add(new Double(numberOfGc));
            measures.add(new Double(totalGcTime));
            if (averageGCFrequency >= 0.0) {
                measures.add(new Double(averageGCFrequency));
            } else {
                measures.add(new Double(-5.0));
            }
            measures.add(new Double(averageGcPause));
            if (averageGCFrequency > 0.0) {
                measures.add(new Double(averageGcPause / averageGCFrequency * 100.0));
            } else {
                measures.add(new Double(-5.0));
            }
            measures.add(new Double(maxGcPause));
            measures.add(new Double(GarbageCollectionUtil.changeUnit(totalHeapSizeBefore / numberOfGc)));
            measures.add(new Double(GarbageCollectionUtil.changeUnit(totalHeapSizeAfter / numberOfGc)));
            String infoString = String.valueOf(info) + ":Total";
            if (numOutputFields > 8) {
                double totReclaimed = totalHeapSizeBefore - totalHeapSizeAfter;
                double avgReclaimed = 0.0;
                if (totReclaimed > 0.0) {
                    avgReclaimed = totReclaimed / numberOfGc;
                } else {
                    totReclaimed = 0.0;
                }
                measures.add(new Double(GarbageCollectionUtil.changeUnit(totReclaimed)));
                measures.add(new Double(GarbageCollectionUtil.changeUnit(avgReclaimed)));
                if (numOutputFields > 10 && language == APMLanguage.NODEJS) {
                    if (totalGcTime == 0.0) {
                        measures.add(new Double(0.0));
                    } else {
                        DecimalFormat df = new DecimalFormat("#.####");
                        double totalTimeSpentPercentage = totalGcTime / numberOfGc * 100.0;
                        measures.add(new Double(df.format(totalTimeSpentPercentage)));
                    }
                }
            }
            metricMap.put(infoString, measures);
        }
        resultArray[0] = totalHeapSizeBefore;
        resultArray[1] = totalHeapSizeAfter;
        return resultArray;
    }

    private static String changeUnit(double value) {
        String s1 = Double.toString(value);
        return EgUtils.convertMemoryValues(s1, "B", "MB");
    }
}

