/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HCPNodesTest
extends HCPBase {
    boolean isFirst = true;
    protected double prevUptime = -5.0;
    private String installdir = EgInstallInfo.getInstallDir() + "/agent/logs/HCPNodesUptime_" + this.targetHost + "_" + this.reportingName;
    private File file = new File(this.installdir);
    private DataOutputStream dos = null;
    private DataInputStream dis = null;

    public HCPNodesTest(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        HCPNodesTest hCPNodesTest = new HCPNodesTest(stringArray);
        hCPNodesTest.debugComputeMeasures(new Hashtable(), true);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        try {
            Hashtable hashtable2 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.2");
            Hashtable hashtable3 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.3");
            Hashtable hashtable4 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.5");
            Hashtable hashtable5 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.4");
            Hashtable hashtable6 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.11");
            Hashtable hashtable7 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.7");
            Hashtable hashtable8 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.12");
            Hashtable hashtable9 = this.getMeasures(".1.3.6.1.4.1.116.5.46.1.1.1.6");
            this.printOut("[debugComputeMeasures] :hcpNodesHash  :" + hashtable2);
            this.printOut("[debugComputeMeasures] :hcpLogicalVolumeUsageHash  :" + hashtable3);
            this.printOut("[debugComputeMeasures] :hcpLogicalVolumeTotalHash  :" + hashtable4);
            this.printOut("[debugComputeMeasures] :hcpLogicalVolumeUnusedHash  :" + hashtable5);
            this.printOut("[debugComputeMeasures] :hcpNICFailureHash  :" + hashtable6);
            this.printOut("[debugComputeMeasures] :hcpNodeAvailableStatusHash  :" + hashtable7);
            this.printOut("[debugComputeMeasures] :hcpSANStatusHash  :" + hashtable8);
            this.printOut("[debugComputeMeasures] :hcpSANUptimeHash  :" + hashtable9);
            if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.putWarningMessageToLogfile("[debugComputeMeasures] :There is no nodes configured in given IP address ");
                    this.isFirst = false;
                }
                return;
            }
            Hashtable<String, Double> hashtable10 = new Hashtable<String, Double>();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = "" + hashtable3.get(string);
                String string3 = "" + hashtable4.get(string);
                String string4 = "" + hashtable5.get(string);
                String string5 = "" + hashtable6.get(string);
                String string6 = "" + hashtable7.get(string);
                String string7 = "" + hashtable8.get(string);
                String string8 = "" + hashtable9.get(string);
                double d = this.convertToDouble(string2);
                double d2 = this.convertToDouble(string3);
                double d3 = this.convertToDouble(string4);
                double d4 = this.convertToDouble(string5);
                double d5 = this.convertToDouble(string6);
                double d6 = this.convertToDouble(string7);
                double d7 = d / d2 * 100.0;
                double d8 = d3 / d2 * 100.0;
                string8 = this.removeDoubleQuotes(string8);
                long l = this.getHCPNodeBootTime(string8);
                long l2 = System.currentTimeMillis();
                double d9 = l2 - l;
                double d10 = 0.0;
                this.prevUptime = this.readUpTimeFromFile(string);
                if (d9 != -5.0) {
                    if (this.prevUptime != -5.0) {
                        d10 = d9 < this.prevUptime ? 1.0 : 0.0;
                    }
                } else {
                    this.printOut("[debugComputeMeasures] :SNMP uptime outputs empty data for uptime " + d9 + " prevUptime " + this.prevUptime + "TimesinceLastTest " + this.timeSinceLastTest);
                    if (this.timeSinceLastTest > 0.0 && this.prevUptime > 0.0) {
                        d9 = this.prevUptime + this.timeSinceLastTest;
                        d10 = 0.0;
                    } else {
                        d9 = -5.0;
                        d10 = -5.0;
                    }
                }
                this.printOut("[debugComputeMeasures] :SNMP uptime " + d9 + " ,prevUptime read from log " + this.prevUptime);
                if (d9 != -5.0) {
                    hashtable10.put(new String(string), new Double(d9));
                }
                if (d9 >= 0.0) {
                    d9 /= 60000.0;
                }
                d7 = this.roundDouble(d7);
                d8 = this.roundDouble(d8);
                d = this.getHCPBytesToConverter(d, 1.073741824E9);
                d2 = this.getHCPBytesToConverter(d2, 1.073741824E9);
                d3 = this.getHCPBytesToConverter(d3, 1.073741824E9);
                this.printOut("[debugComputeMeasures] :Node :" + string + " , Volume usage :" + d + ",Volume space used(%) " + d7);
                this.printOut("[debugComputeMeasures] :Node :" + string + " , Volume unused :" + d3 + ",Volume space unused(%) " + d8);
                this.printOut("[debugComputeMeasures] :Node :" + string + " , bootTimeMillis :" + l);
                this.printOut("[debugComputeMeasures] :Node :" + string + " , uptime :" + d9);
                this.printOut("[debugComputeMeasures] :Node :" + string + " , isRebooted :" + d10);
                String string9 = "" + hashtable2.get(string);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d8));
                arrayList.add(new Double(d9));
                arrayList.add(new Double(d10));
                if (!bl) {
                    this.addNewMeasure(string9, arrayList);
                }
                this.printOut("[debugComputeMeasures] :Info :" + string9 + ",MeasureArrayList :" + arrayList);
            }
            this.printOut("[debugComputeMeasures] :uptimeHT " + hashtable10);
            this.writeUpTimeToFile(hashtable10);
        }
        catch (Exception exception) {
            this.printOutStackTrace("[debugComputeMeasures] :Exception occurred ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeUpTimeToFile(Hashtable hashtable) {
        String string = "writeUpTimeToFile";
        string = this.methodNameTemplate(string);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = hashtable.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                double d = (Double)hashtable.get(string2);
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append("" + d);
                stringBuffer.append(",");
            }
            this.printOut(string + "strbuff " + stringBuffer);
            this.dos = new DataOutputStream(new FileOutputStream(this.file));
            this.dos.writeBytes(stringBuffer.toString());
            this.dos.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized double readUpTimeFromFile(String string) {
        String string2 = "readUpTimeFromFile";
        string2 = this.methodNameTemplate(string2);
        double d = -5.0;
        try {
            if (!this.file.exists()) {
                double d2 = d;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.file));
            String string3 = null;
            while ((string3 = this.dis.readLine()) != null) {
                this.printOut(string2 + " info " + string + ", logfile line " + string3);
                String string4 = string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                if (stringTokenizer.countTokens() == 2) {
                    String string5 = stringTokenizer.nextToken();
                    String string6 = stringTokenizer.nextToken();
                    if (string5.indexOf(string) > -1) {
                        d = Double.parseDouble(string5.substring(string5.lastIndexOf("=") + 1));
                    }
                    if (string6.indexOf(string) > -1) {
                        d = Double.parseDouble(string6.substring(string6.lastIndexOf("=") + 1));
                    }
                    continue;
                }
                double d3 = d;
                return d3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.dis != null) {
                    this.dis.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dis = null;
        }
        return d;
    }
}

