/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HostProcessTest
extends EgSnmpGenericTest {
    private static String processOid = ".1.3.6.1.2.1.25.4.2.1.2";
    private static String processPathOid = ".1.3.6.1.2.1.25.4.2.1.4";
    private static String processParamOid = ".1.3.6.1.2.1.25.4.2.1.5";
    private static String cpuOid = ".1.3.6.1.2.1.25.5.1.1.1";
    private static String memOid = ".1.3.6.1.2.1.25.5.1.1.2";
    private static String totalMemOid = ".1.3.6.1.2.1.25.2.2";
    private static String totalProcOID = ".1.3.6.1.2.1.25.3.3.1.2";
    private static int numMeasures = 4;
    private int listLength = 0;
    private Hashtable pidToCpuMap = new Hashtable();
    private long lastTestTime = System.currentTimeMillis();
    ArrayList list = new ArrayList();
    public double[] cpuUtil;
    public double[] memUtil;
    public double[] memSize;
    public int[] countProcesses;
    public double totalMemory = 0.0;
    public String[] names;
    public String[] patterns;
    public int patternCount = 0;
    public Hashtable cpuDetails = new Hashtable();
    public Hashtable memDetails = new Hashtable();
    private boolean useProcessPath = false;

    public HostProcessTest(String[] stringArray) {
        super(stringArray);
        StringTokenizer stringTokenizer;
        int n;
        this.setMeasureCount(numMeasures);
        this.isNewDynamicInfoTest = true;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("-process")) {
                if (++n < stringArray.length) {
                    stringTokenizer = new StringTokenizer(stringArray[n], "|");
                    int n2 = stringTokenizer.countTokens();
                    for (int i = 0; i < n2; ++i) {
                        this.list.add(stringTokenizer.nextToken());
                    }
                    continue;
                }
                System.err.println("Usage: ProcessTest -host <host> -port <portNo> -user <userName> -pwd <passWords>  -process <name:pattern> -method <perfmon/none>");
                return;
            }
            if (!stringArray[n].equalsIgnoreCase("-useProcessPath") || ++n >= stringArray.length || !stringArray[n].equalsIgnoreCase("true") && !stringArray[n].equalsIgnoreCase("yes") && !stringArray[n].equalsIgnoreCase("y")) continue;
            this.useProcessPath = true;
        }
        this.listLength = this.list.size();
        this.names = new String[this.listLength];
        this.patterns = new String[this.listLength];
        this.countProcesses = new int[this.listLength];
        this.cpuUtil = new double[this.listLength];
        this.memUtil = new double[this.listLength];
        this.memSize = new double[this.listLength];
        this.patternCount = 0;
        for (n = 0; n < this.listLength; ++n) {
            stringTokenizer = new StringTokenizer((String)this.list.get(n), ":");
            if (stringTokenizer.countTokens() <= 1) continue;
            this.names[n] = new String(stringTokenizer.nextToken());
            this.patterns[n] = new String(stringTokenizer.nextToken());
            ++this.patternCount;
        }
        this.real_sid = this.getValueForParam("info");
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Object> arrayList;
        int n;
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        this.cpuDetails = new Hashtable();
        this.memDetails = new Hashtable();
        boolean bl = false;
        bl = !this.useProcessPath ? this.runSnmpCmdForOid(processOid) : this.runSnmpCmdForOid(processPathOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        hashtable2 = this.getHashFromResult(this.lhs, this.rhs);
        bl = this.runSnmpCmdForOid(processParamOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        hashtable3 = this.getHashFromResult(this.lhs, this.rhs);
        hashtable4 = this.getUniqueProcess(hashtable2, hashtable3);
        int n2 = hashtable4.size();
        if (n2 == 0) {
            return;
        }
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        Enumeration enumeration = hashtable4.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable4.get(string);
            stringArray[n3] = string;
            stringArray2[n3] = string2;
            ++n3;
        }
        bl = this.runSnmpCmdForOid(totalMemOid);
        double d = -5.0;
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            d = -5.0;
        } else {
            try {
                d = Double.parseDouble(this.rhs[0]);
            }
            catch (Exception exception) {
                d = -5.0;
            }
        }
        if (d == -5.0) {
            return;
        }
        Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
        bl = this.runSnmpCmdForOid(cpuOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            hashtable5.put(this.lhs[i], this.rhs[i]);
        }
        bl = this.runSnmpCmdForOid(memOid);
        Hashtable<String, String> hashtable6 = new Hashtable<String, String>();
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            hashtable6.put(this.lhs[i], this.rhs[i]);
        }
        ArrayList arrayList2 = new ArrayList();
        bl = this.runSnmpCmdForOid(totalProcOID);
        double d2 = 1.0;
        d2 = !bl || this.lhs == null || this.lhs.length == 0 ? 1.0 : (double)this.lhs.length;
        long l = System.currentTimeMillis();
        double d3 = (double)(l - this.lastTestTime) / 10.0;
        this.lastTestTime = l;
        for (n = 0; n < this.patterns.length; ++n) {
            double d4;
            String string;
            String string3;
            String string4;
            int n4;
            this.countProcesses[n] = 0;
            this.cpuUtil[n] = 0.0;
            this.memUtil[n] = 0.0;
            this.memSize[n] = 0.0;
            arrayList = new ArrayList();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (!HostProcessTest.isPatternMatch(stringArray2[n4], this.patterns[n])) continue;
                int n5 = n;
                this.countProcesses[n5] = this.countProcesses[n5] + 1;
                arrayList.add(stringArray[n4]);
                arrayList3.add(stringArray2[n4]);
            }
            n4 = 0;
            double d5 = 0.0;
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                double d6;
                double d7;
                String string5 = (String)arrayList.get(i);
                string4 = (String)arrayList3.get(i);
                string3 = (String)hashtable5.get(string5);
                if (string3 == null || (string = (String)this.pidToCpuMap.get(string5)) == null || (d7 = (d4 = Double.parseDouble(string3)) - (d6 = Double.parseDouble(string))) < 0.0) continue;
                arrayList4.add(string4 + ";" + string5 + ";" + (d7 /= d2) * 100.0 / d3);
                n4 = 1;
                d5 += d7;
            }
            this.cpuDetails.put(this.names[n], arrayList4);
            d5 = n4 == 0 ? -5.0 : d5 * 100.0 / d3;
            this.cpuUtil[n] = d5;
            this.memUtil[n] = -5.0;
            n4 = 0;
            d5 = 0.0;
            ArrayList<String> arrayList5 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                string4 = (String)arrayList.get(i);
                string3 = (String)arrayList3.get(i);
                string = (String)hashtable6.get(string4);
                if (string == null) continue;
                d4 = Double.parseDouble(string);
                arrayList5.add(string3 + ";" + string4 + ";" + d4 / 1024.0);
                n4 = 1;
                d5 += d4;
            }
            this.memDetails.put(this.names[n], arrayList5);
            if (d < 0.0) {
                d = -5.0;
            }
            if (n4 == 0 || d5 < 0.0) {
                d5 = -5.0;
                this.memSize[n] = -5.0;
            } else {
                this.memSize[n] = d5 / 1024.0;
                d5 = d5 * 100.0 / d;
            }
            this.memUtil[n] = d5 <= 0.0 ? -5.0 : d5;
        }
        this.pidToCpuMap = hashtable5;
        for (n = 0; n < this.patterns.length; ++n) {
            arrayList = new ArrayList<Object>();
            arrayList.add(new Double(this.countProcesses[n]));
            arrayList.add(new Double(this.cpuUtil[n]));
            arrayList.add(new Double(this.memUtil[n]));
            arrayList.add(new Double(this.memSize[n]));
            this.addNewMeasure(this.names[n], arrayList);
        }
    }

    private Hashtable getHashFromResult(String[] stringArray, String[] stringArray2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            if (stringArray == null || stringArray.length == 0) {
                return hashtable;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = stringArray2[i];
                hashtable.put(string, string2);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", "[HostProcessTest] Exception occured in getHashFromResult() " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    private Hashtable getUniqueProcess(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        try {
            if (hashtable == null || hashtable.size() == 0) {
                return hashtable3;
            }
            if (hashtable2 == null || hashtable2.size() == 0) {
                return hashtable3;
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                String string3 = (String)hashtable2.get(string);
                if (string3 == null) continue;
                String string4 = string2 + " " + string3;
                hashtable3.put(string, string4);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception", "[HostProcessTest] Exception occured in getUniqueProcess() " + this.targetHost, exception.toString());
        }
        return hashtable3;
    }
}

