/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HwOverviewTest
extends EgSnmpGenericTest {
    private boolean isDell = false;
    private boolean isCpq = true;
    private boolean isIbm = false;
    private static int numMeasures = 5;
    private double numErrors = -1.0;
    private static String mibCondOid = ".1.3.6.1.4.1.232.6.1.3";
    private static String memCondOid = ".1.3.6.1.4.1.232.6.2.3.2";
    private static String errOid = ".1.3.6.1.4.1.232.6.2.3.3";
    private static String asrCondOid = ".1.3.6.1.4.1.232.6.2.5.17";
    private static String driveCondOid = ".1.3.6.1.4.1.232.3.1.3";
    private static String ibmNameOid = ".1.3.6.1.4.1.2.6.159.1.1.30.3.1.9";
    private static String ibmStateOid = ".1.3.6.1.4.1.2.6.159.1.1.30.3.1.2";

    public HwOverviewTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        if (d <= 2.0) {
            return -1.0;
        }
        if (d == 3.0) {
            return 1.0;
        }
        if (d == 4.0) {
            return 2.0;
        }
        if (d == 5.0 || d == 6.0) {
            return 3.0;
        }
        return -5.0;
    }

    private double getIbmValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        } else {
            if (d < 1.0) {
                return 1.0;
            }
            if (d == 1.0) {
                return 2.0;
            }
            if (d == 2.0) {
                return 3.0;
            }
        }
        return -5.0;
    }

    private double getCpqValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        if (d <= 2.0) {
            return 1.0;
        }
        if (d == 3.0) {
            return 2.0;
        }
        return 3.0;
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = true;
        if (!(this.isDell || this.isCpq || this.isIbm)) {
            bl = false;
        }
        if (this.isDell || !bl) {
            this.runDellStatusTest();
        }
        if (!this.isDell && !this.isIbm && this.isCpq || !bl) {
            this.runCpqStatusTest();
        }
        if (!this.isDell && !this.isCpq && this.isIbm || !bl) {
            this.runIbmStatusTest();
        }
    }

    private void runCpqStatusTest() {
        if (this.runSnmpCmdForOid(mibCondOid)) {
            double d;
            this.isCpq = true;
            double d2 = this.getCpqValue(0);
            double d3 = -5.0;
            if (this.runSnmpCmdForOid(memCondOid)) {
                d3 = this.getCpqValue(0);
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            double d4 = -5.0;
            if (this.runSnmpCmdForOid(errOid)) {
                d4 = this.getCpqValue(0);
            }
            if (d4 >= 0.0) {
                if (this.numErrors < 0.0) {
                    this.numErrors = d4;
                    d4 = -5.0;
                } else {
                    d = d4 - this.numErrors;
                    if (d < 0.0) {
                        d = -5.0;
                    }
                    this.numErrors = d4;
                    d4 = d;
                }
            }
            arrayList.add(new Double(d4));
            d = -5.0;
            if (this.runSnmpCmdForOid(asrCondOid)) {
                d = this.getCpqValue(0);
            }
            arrayList.add(new Double(d));
            d = -5.0;
            if (this.runSnmpCmdForOid(driveCondOid)) {
                d = this.getCpqValue(0);
            }
            arrayList.add(new Double(d));
            this.addNewMeasure(arrayList);
        } else {
            this.isCpq = false;
            this.numErrors = -5.0;
        }
    }

    private void runIbmStatusTest() {
        if (this.runSnmpCmdForOid(ibmNameOid)) {
            this.isIbm = true;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < this.lhs.length; ++i) {
                hashtable.put(this.lhs[i], this.rhs[i]);
            }
            if (this.runSnmpCmdForOid(ibmStateOid)) {
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                for (int i = 0; i < this.lhs.length; ++i) {
                    hashtable2.put(this.lhs[i], this.rhs[i]);
                }
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)hashtable2.get(string);
                    String string3 = (String)hashtable.get(string);
                    if (string3 == null) continue;
                    int n = string3.indexOf(".CreationClassName=");
                    String string4 = "";
                    if (n < 0) continue;
                    if (n >= 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                            int n2 = string5.indexOf("=");
                            if (n2 < 0) continue;
                            String string6 = string5.substring(0, n2);
                            String string7 = string5.substring(n2 + 1);
                            if (string7.startsWith("\"")) {
                                string7 = string7.substring(1);
                            }
                            if (string7.endsWith("\"")) {
                                string7 = string7.substring(0, string7.length() - 1);
                            }
                            if (string6.endsWith(".CreationClassName")) {
                                if (string7.startsWith("IBMPSG_")) {
                                    string7 = string7.substring(7);
                                }
                                if (string4.length() == 0) {
                                    string4 = string7;
                                    continue;
                                }
                                string4 = string4 + ":" + string7;
                                continue;
                            }
                            if (!string6.endsWith("DeviceID") && !string6.equals("Tag")) continue;
                            int n3 = string7.lastIndexOf("\\");
                            if (n3 >= 0) {
                                string7 = string7.substring(n3 + 1);
                            }
                            if (string4.length() == 0) {
                                string4 = string7;
                                continue;
                            }
                            string4 = string4 + ":" + string7;
                        }
                        if (string4.length() == 0) {
                            string4 = string3;
                        }
                    }
                    double d = this.getIbmValue(string2);
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    this.addNewMeasure(string4, arrayList);
                }
            }
        } else {
            this.isIbm = false;
            this.numErrors = -5.0;
        }
    }

    private void runDellStatusTest() {
        this.isDell = false;
    }
}

