/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class IBMDb2DbUsgTest
extends GenericTest {
    private String user;
    private String password;
    private String dbName;
    private double bytesToGB = 1.073741824E9;
    private boolean isFirstTime = true;
    private boolean isDB210Pt5AndAbove = false;
    private int msgLogCounter = 0;
    private String includeDB = "";
    private String excludeDB = "";
    private String ssl = "";

    public IBMDb2DbUsgTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.includeDB = this.getValueForParam("include_db");
        this.excludeDB = this.getValueForParam("exclude_db");
        if (this.includeDB == null || this.includeDB.equalsIgnoreCase("NULL") || this.includeDB.equalsIgnoreCase("none")) {
            this.includeDB = "none";
        }
        if (this.excludeDB == null || this.excludeDB.equalsIgnoreCase("NULL") || this.excludeDB.equalsIgnoreCase("none")) {
            this.excludeDB = "none";
        }
        this.ssl = this.getValueForParam("ssl");
        this.ssl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("y") || this.ssl.trim().equalsIgnoreCase("yes")) ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        ArrayList<String> arrayList;
        DB2JdbcHelper dB2JdbcHelper;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block39: {
            block38: {
                block37: {
                    connection = null;
                    statement = null;
                    resultSet = null;
                    dB2JdbcHelper = null;
                    arrayList = new ArrayList<String>();
                    dB2JdbcHelper = this.ssl.equalsIgnoreCase("true") ? new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName, this.ssl) : new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
                    if (!this.isFirstTime) break block37;
                    object = dB2JdbcHelper.getVersion(this.entity, this.targetHost, this.portNo, this.user, this.password, this.dbName, this.reportingName);
                    if (object != null && ((String)object).trim().length() > 0) {
                        double d = 0.0;
                        try {
                            d = Double.parseDouble((String)object);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (d >= 10.5) {
                            this.isDB210Pt5AndAbove = true;
                        }
                        this.isFirstTime = false;
                        break block37;
                    }
                    this.logToErrorFile("INFO", this.entity + " Failed to find the version details: ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    dB2JdbcHelper.closeResultSet(resultSet);
                    dB2JdbcHelper.closeStatement(statement);
                    dB2JdbcHelper.closeConnection(connection);
                    return;
                }
                if (this.isDB210Pt5AndAbove) break block38;
                if (this.msgLogCounter > 4 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO", this.entity + " support from DB2 version 10.5 onwards: ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeConnection(connection);
                return;
            }
            connection = dB2JdbcHelper.getConnection();
            if (connection != null) break block39;
            this.logToErrorFile("Error  :", this.entity, " Connection is null for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeConnection(connection);
            return;
        }
        object = dB2JdbcHelper.getDbSnapshotFunction(connection);
        String string = "SELECT DB_NAME FROM table(" + (String)object + ") DB";
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error  :", this.entity + " Failed to create statement for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
            exception.printStackTrace();
            dB2JdbcHelper.closeConnection(connection);
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeConnection(connection);
            return;
        }
        try {
            String string2 = "";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                if (string2 != null && string2.trim().length() > 0) {
                    string2 = string2.trim();
                }
                arrayList.add(string2);
            }
            dB2JdbcHelper.closeResultSet(resultSet);
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeConnection(connection);
        }
        catch (Exception exception) {
            try {
                this.logToErrorFile("Error  :", this.entity + " while getting database list for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeConnection(connection);
            }
            catch (Throwable throwable) {
                dB2JdbcHelper.closeResultSet(resultSet);
                dB2JdbcHelper.closeStatement(statement);
                dB2JdbcHelper.closeConnection(connection);
                throw throwable;
            }
        }
        System.out.println(this.entity + " :includeDB:" + this.includeDB + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
        System.out.println(this.entity + " :excludeDB:" + this.excludeDB + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
        System.out.println(this.entity + " :From database dbList:" + arrayList + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
        if (arrayList != null && arrayList.size() > 0) {
            if (this.includeDB != null && !this.includeDB.equalsIgnoreCase("none")) {
                arrayList.clear();
                object = new StringTokenizer(this.includeDB, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    string3 = string3.toUpperCase();
                    arrayList.add(string3);
                }
            }
            if (this.excludeDB != null && !this.excludeDB.equalsIgnoreCase("none")) {
                object = new StringTokenizer(this.excludeDB, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object).nextToken();
                    string4 = string4.toUpperCase();
                    arrayList.remove(string4);
                }
            }
            System.out.println(this.entity + " :Finalized dbList:" + arrayList + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            object = "";
            String string5 = "select sum(t.tbsp_usable_pages) usable_pages,sum(t.tbsp_used_pages) used_pages,sum(t.tbsp_free_pages) Free_pages,avg(TBSP_PAGE_SIZE)\"page_size\" from TABLE(MON_GET_TABLESPACE('',-2)) AS t";
            System.out.println(this.entity + " :dbUsgQuery:" + string5 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            boolean bl = false;
            bl = this.ssl.equalsIgnoreCase("true");
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (String)arrayList.get(i);
                System.out.println(this.entity + " :infoDbName:" + (String)object + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                try {
                    dB2JdbcHelper = bl ? new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, (String)object, this.ssl) : new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, (String)object);
                    connection = dB2JdbcHelper.getConnection();
                    if (connection == null) {
                        this.logToErrorFile("Error  :", this.entity, " Connection is null for database:" + (String)object + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                        continue;
                    }
                    try {
                        statement = connection.createStatement();
                    }
                    catch (Exception exception) {
                        this.logToErrorFile("Error  :", this.entity + " Failed to create statement for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                        exception.printStackTrace();
                        dB2JdbcHelper.closeConnection(connection);
                        dB2JdbcHelper.closeResultSet(resultSet);
                        dB2JdbcHelper.closeStatement(statement);
                        dB2JdbcHelper.closeConnection(connection);
                        continue;
                    }
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = -5.0;
                    resultSet = statement.executeQuery(string5);
                    while (resultSet.next()) {
                        d2 = resultSet.getDouble(1);
                        d3 = resultSet.getDouble(2);
                        d4 = resultSet.getDouble(3);
                        d = resultSet.getDouble(4);
                        if (d > 0.0) {
                            d2 = d2 * d / this.bytesToGB;
                            d3 = d3 * d / this.bytesToGB;
                            d4 = d4 * d / this.bytesToGB;
                            if (d2 > 0.0) {
                                d5 = d3 / d2 * 100.0;
                            }
                        } else {
                            d3 = -5.0;
                            d4 = -5.0;
                        }
                        ArrayList<Double> arrayList2 = new ArrayList<Double>();
                        arrayList2.add(new Double(d2));
                        arrayList2.add(new Double(d3));
                        arrayList2.add(new Double(d4));
                        arrayList2.add(new Double(d5));
                        System.out.println(this.entity + " :measureList:" + arrayList2 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                        this.addNewMeasure((String)object, arrayList2);
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error  :", this.entity + " while collecting database usage measures for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    dB2JdbcHelper.closeResultSet(resultSet);
                    dB2JdbcHelper.closeStatement(statement);
                    dB2JdbcHelper.closeConnection(connection);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        IBMDb2DbUsgTest iBMDb2DbUsgTest = new IBMDb2DbUsgTest(stringArray);
        iBMDb2DbUsgTest.computeMeasures(new Hashtable());
    }
}

