/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class IBMDb2ServiceTest
extends GenericTest {
    private String user;
    private String password;
    private String dbName;
    private String queryStmt;
    private String additionalDb = "";
    ArrayList dbList = new ArrayList();
    ArrayList queryList = new ArrayList();
    public Hashtable db2ServiceHash = new Hashtable();
    private static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static final String URL_PREFIX = "jdbc:db2://";
    private String ssl = "";

    public IBMDb2ServiceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.additionalDb = this.getValueForParam("additional_databases");
        String string = this.getValueForParam("query");
        this.queryStmt = "SELECT TABSCHEMA, TABNAME, TYPE, COLCOUNT, KEYCOLUMNS, KEYINDEXID, KEYUNIQUE FROM SYSCAT.TABLES WHERE TYPE = 'T'";
        if (!string.equalsIgnoreCase("none")) {
            this.queryStmt = string;
        }
        if (this.additionalDb == null || this.additionalDb.equalsIgnoreCase("NULL") || this.additionalDb.equalsIgnoreCase("none")) {
            this.additionalDb = "none";
        }
        this.queryStmt = this.queryStmt.replace('|', ',');
        StringTokenizer stringTokenizer = null;
        System.out.println("additionalDb::" + this.additionalDb);
        if (this.additionalDb.indexOf("|") > -1) {
            stringTokenizer = new StringTokenizer(this.additionalDb, "|");
        } else if (this.additionalDb.indexOf(",") > -1) {
            stringTokenizer = new StringTokenizer(this.additionalDb, ",");
        }
        if (stringTokenizer != null) {
            this.dbList.add(this.dbName);
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.trim().length() <= 0) continue;
                this.dbList.add(string2.trim());
            }
        } else {
            this.dbList.add(this.dbName);
            if (!this.additionalDb.equalsIgnoreCase("none")) {
                this.dbList.add(this.additionalDb);
            }
        }
        this.queryStmt = this.findAndReplaceString(this.queryStmt, "~#~", ";");
        stringTokenizer = new StringTokenizer(this.queryStmt, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.queryList.add(stringTokenizer.nextToken());
        }
        int n = this.queryList.size();
        int n2 = this.dbList.size();
        String string3 = "SELECT TABSCHEMA, TABNAME, TYPE, COLCOUNT, KEYCOLUMNS, KEYINDEXID, KEYUNIQUE FROM SYSCAT.TABLES WHERE TYPE = 'T'";
        while (n < n2) {
            this.queryList.add(string3);
            n = this.queryList.size();
        }
        this.ssl = this.getValueForParam("ssl");
        this.ssl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("y") || this.ssl.trim().equalsIgnoreCase("yes")) ? "true" : "false";
        this.needAgentlessDD = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            System.out.println(this.entity + " :dbList:" + this.dbList + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            System.out.println(this.entity + " :queryList:" + this.queryList + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            for (int i = 0; i < this.dbList.size(); ++i) {
                double d = 0.0;
                double d2 = -5.0;
                double d3 = 0.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                double d7 = -5.0;
                double d8 = -5.0;
                this.errorMsg = "";
                String string = (String)this.dbList.get(i);
                string = string.toUpperCase();
                String string2 = (String)this.queryList.get(i);
                long l = 20000L;
                System.out.println(this.entity + " :db2DbName:" + string + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                System.out.println(this.entity + " :query:" + string2 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                System.out.println(this.entity + " :timeoutSecs:" + l / 1000L + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                long l2 = System.currentTimeMillis();
                IbmDb2ServiceHelper ibmDb2ServiceHelper = new IbmDb2ServiceHelper(string, string2);
                System.out.println(this.entity + " :Thread Starttime:" + l2 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                boolean bl = this.checkForTimeout(ibmDb2ServiceHelper, l);
                long l3 = System.currentTimeMillis();
                System.out.println(this.entity + " :Thread Endtime:" + l3 + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                System.out.println(this.entity + " :Duration:" + (l3 - l2) / 1000L + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                ArrayList arrayList = ibmDb2ServiceHelper.measureValList;
                System.out.println(this.entity + " :measureList:" + arrayList + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                System.out.println("b:" + bl);
                if (bl) {
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                System.out.println(this.entity + " :Timeout happened for database  ::" + string + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                System.out.println(this.entity + " :measureList:" + arrayList + " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                this.logToErrorFile("ERROR", this.entity, " Timeout happened for database  :" + string + ":: targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                if (arrayList == null || arrayList.size() == 0) {
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    if (this.measureCount > 2) {
                        arrayList.add(new Double(d3));
                        arrayList.add(new Double(d4));
                        arrayList.add(new Double(d6));
                        arrayList.add(new Double(d7));
                        arrayList.add(new Double(d8));
                    }
                }
                this.addNewMeasure(string, arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean checkForTimeout(IbmDb2ServiceHelper ibmDb2ServiceHelper, long l) {
        long l2;
        long l3 = 0L;
        long l4 = 250L;
        do {
            this.suspendForPeriod(l4);
            if (ibmDb2ServiceHelper.done) {
                return true;
            }
            if ((l3 += l4) >= l) {
                ibmDb2ServiceHelper.interrupt();
                Thread.currentThread();
                Thread.yield();
                ibmDb2ServiceHelper.stop();
                System.out.println(" ====> totalSleepTime is greater than timeout ,thread killed and checkForTimeout returned false ");
                return false;
            }
            l2 = l4;
            if (l - l3 >= l2) continue;
            l2 = l - l3;
        } while ((l4 = l2) > 0L);
        ibmDb2ServiceHelper.interrupt();
        Thread.currentThread();
        Thread.yield();
        ibmDb2ServiceHelper.stop();
        System.out.println(" ====> sleepTime less than zero ,thread killed and checkForTimeout returned false ");
        return false;
    }

    public void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void closeRS(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    public static void main(String[] stringArray) {
        IBMDb2ServiceTest iBMDb2ServiceTest = new IBMDb2ServiceTest(stringArray);
        iBMDb2ServiceTest.computeMeasures(new Hashtable());
    }

    class IbmDb2ServiceHelper
    extends Thread {
        public boolean done = false;
        private String test = "";
        private String dbname = "";
        private String queryStr = "";
        public ArrayList measureValList = null;

        public IbmDb2ServiceHelper(String string, String string2) {
            this.start();
            this.dbname = string;
            this.queryStr = string2;
            this.measureValList = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            block20: {
                Connection connection = null;
                Statement statement = null;
                ResultSet resultSet = null;
                d7 = 0.0;
                d6 = -5.0;
                d5 = -5.0;
                d4 = -5.0;
                d3 = -5.0;
                d2 = -5.0;
                d = -5.0;
                int n = 0;
                try {
                    long l = System.currentTimeMillis();
                    String string = "";
                    System.out.println(" ssl :" + IBMDb2ServiceTest.this.ssl);
                    string = IBMDb2ServiceTest.this.ssl.equalsIgnoreCase("true") ? IBMDb2ServiceTest.URL_PREFIX + IBMDb2ServiceTest.this.targetHost + ":" + IBMDb2ServiceTest.this.portNo + "/" + IBMDb2ServiceTest.this.dbName + ":sslConnection=true;" : IBMDb2ServiceTest.URL_PREFIX + IBMDb2ServiceTest.this.targetHost + ":" + IBMDb2ServiceTest.this.portNo + "/" + this.dbname;
                    try {
                        Class.forName(IBMDb2ServiceTest.DRIVER_CLASS);
                        connection = DriverManager.getConnection(string, IBMDb2ServiceTest.this.user, IBMDb2ServiceTest.this.password);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        IBMDb2ServiceTest.this.logToErrorFile("ERROR", IBMDb2ServiceTest.this.entity + " Inside run() targetHost :" + IBMDb2ServiceTest.this.targetHost + " reportingName :" + IBMDb2ServiceTest.this.reportingName + " Port :" + IBMDb2ServiceTest.this.portNo, exception.toString());
                        String string2 = EgInstallInfo.getStackTraceAsString(exception).toString();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string2);
                        IBMDb2ServiceTest.this.db2ServiceHash.put(this.dbname, arrayList);
                        System.out.println("db2ServiceHash :" + IBMDb2ServiceTest.this.db2ServiceHash);
                        d5 = 0.0;
                        d4 = -5.0;
                    }
                    if (connection == null) {
                        System.out.println("Error in getting database connection");
                        IBMDb2ServiceTest.this.logToErrorFile("ERROR", IBMDb2ServiceTest.this.entity, " Connection is null for URL:" + string + " : targetHost :" + IBMDb2ServiceTest.this.targetHost + " reportingName :" + IBMDb2ServiceTest.this.reportingName + " Port :" + IBMDb2ServiceTest.this.portNo);
                    }
                    if (connection != null) {
                        d5 = 100.0;
                        long l2 = System.currentTimeMillis();
                        try {
                            statement = connection.createStatement();
                        }
                        catch (Exception exception) {
                            IBMDb2ServiceTest.this.logToErrorFile("ERROR:", IBMDb2ServiceTest.this.entity + " Failed to Create Statement targetHost :" + IBMDb2ServiceTest.this.targetHost + " reportingName :" + IBMDb2ServiceTest.this.reportingName + " Port :" + IBMDb2ServiceTest.this.portNo, exception.toString());
                            IBMDb2ServiceTest.this.closeStmt(statement);
                            IBMDb2ServiceTest.this.closeConn(connection);
                            exception.printStackTrace();
                        }
                        resultSet = statement.executeQuery(this.queryStr);
                        if (d5 == 100.0) {
                            d7 = 100.0;
                            long l3 = System.currentTimeMillis();
                            d4 = (double)(l3 - l) / 1000.0;
                        } else {
                            d7 = 0.0;
                        }
                        if (resultSet != null) {
                            try {
                                while (resultSet.next()) {
                                    d3 = 100.0;
                                    ++n;
                                }
                            }
                            catch (Exception exception) {
                                n = 0;
                            }
                            long l4 = System.currentTimeMillis();
                            if (d3 == 100.0) {
                                d2 = (double)(l4 - l2) / 1000.0;
                            }
                        } else {
                            d3 = 0.0;
                            d2 = -5.0;
                        }
                        long l5 = System.currentTimeMillis();
                        d6 = (double)(l5 - l) / 1000.0;
                        d = n;
                    }
                    IBMDb2ServiceTest.this.closeRS(resultSet);
                    IBMDb2ServiceTest.this.closeStmt(statement);
                    IBMDb2ServiceTest.this.closeConn(connection);
                    IBMDb2ServiceTest.this.closeRS(resultSet);
                    IBMDb2ServiceTest.this.closeStmt(statement);
                }
                catch (Exception exception) {
                    String string = EgInstallInfo.getStackTraceAsString(exception).toString();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    IBMDb2ServiceTest.this.db2ServiceHash.put(this.dbname, arrayList);
                    IBMDb2ServiceTest.this.logToErrorFile("ERROR", IBMDb2ServiceTest.this.entity, "Error executing SQL query. " + IBMDb2ServiceTest.this.errorMsg);
                    exception.printStackTrace();
                    break block20;
                }
                finally {
                    IBMDb2ServiceTest.this.closeRS(resultSet);
                    IBMDb2ServiceTest.this.closeStmt(statement);
                    IBMDb2ServiceTest.this.closeConn(connection);
                }
                IBMDb2ServiceTest.this.closeConn(connection);
            }
            this.done = true;
            this.measureValList.add(new Double(d7));
            this.measureValList.add(new Double(d6));
            if (IBMDb2ServiceTest.this.measureCount > 2) {
                this.measureValList.add(new Double(d5));
                this.measureValList.add(new Double(d4));
                this.measureValList.add(new Double(d3));
                this.measureValList.add(new Double(d2));
                this.measureValList.add(new Double(d));
            }
            System.out.println(IBMDb2ServiceTest.this.entity + " :End of method:" + this.measureValList + " targetHost:" + IBMDb2ServiceTest.this.targetHost + " reportingName :" + IBMDb2ServiceTest.this.reportingName + " Port :" + IBMDb2ServiceTest.this.portNo);
        }
    }
}

