/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBCICSStatTest
extends IIBResourceStatisticsBase {
    private static final int CICS_STAT_MEASURE_COUNT = 4;

    public IIBCICSStatTest(String[] args) {
        super(args);
        this.setMeasureCount(4);
        this.fixedTestPeriod = true;
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("CICS");
        if (data == null || data.size() == 0 || data.isEmpty()) {
            return;
        }
        Enumeration enu = data.keys();
        double requestSuccess = 0.0;
        double requestFailures = 0.0;
        double requestSecurityFailures = 0.0;
        double connectionAttemptFailures = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Node name  :" + key);
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            requestSuccess = (Double)tempArrayList.get(0);
            requestFailures = (Double)tempArrayList.get(1);
            requestSecurityFailures = (Double)tempArrayList.get(2);
            connectionAttemptFailures = (Double)tempArrayList.get(2);
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            measureArrayList.add(new Double(requestSuccess));
            measureArrayList.add(new Double(requestFailures));
            measureArrayList.add(new Double(requestSecurityFailures));
            measureArrayList.add(new Double(connectionAttemptFailures));
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBCICSStatTest obj = new IIBCICSStatTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

