/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBFTPStatTest
extends IIBResourceStatisticsBase {
    private static final int FTP_STAT_MEASURE_COUNT = 4;

    public IIBFTPStatTest(String[] args) {
        super(args);
        this.setMeasureCount(4);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("FTP");
        if (data == null || data.size() == 0 || data.isEmpty()) {
            return;
        }
        Enumeration enu = data.keys();
        double ftpGets = 0.0;
        double bytesReceived = 0.0;
        double ftpPuts = 0.0;
        double bytesSent = 0.0;
        double ftpGetsRate = 0.0;
        double bytesReceivedRate = 0.0;
        double ftpPutsRate = 0.0;
        double bytesSentRate = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Node name  :" + key);
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            ftpGets = (Double)tempArrayList.get(0);
            bytesReceived = (Double)tempArrayList.get(1);
            ftpPuts = (Double)tempArrayList.get(2);
            bytesSent = (Double)tempArrayList.get(3);
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            if (this.timeSinceLastTest > 0.0) {
                ftpGetsRate = ftpGets / this.timeSinceLastTest;
                bytesReceivedRate = bytesReceived / this.timeSinceLastTest;
                ftpPutsRate = ftpPuts / this.timeSinceLastTest;
                bytesSentRate = bytesSent / this.timeSinceLastTest;
            } else {
                this.printOut("WARNING : timeSinceLastTest  value less than zero");
                ftpGetsRate = -5.0;
                bytesReceivedRate = -5.0;
                ftpPutsRate = -5.0;
                bytesSentRate = -5.0;
            }
            measureArrayList.add(new Double(ftpGetsRate));
            measureArrayList.add(new Double(bytesReceivedRate));
            measureArrayList.add(new Double(ftpPutsRate));
            measureArrayList.add(new Double(bytesSentRate));
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBFTPStatTest obj = new IIBFTPStatTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

