/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBMsgFloStTest
extends IIBStatisticsAccountingBase {
    private static final int MSG_FLOW_MEASURE_COUNT = 12;

    public IIBMsgFloStTest(String[] args) {
        super(args);
        this.setMeasureCount(12);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("MESSAGE_FLOW");
        if (data == null || data.size() == 0 || data.isEmpty()) {
            return;
        }
        Hashtable intervalData = this.getData("INTERVAL_VALUE");
        Enumeration enu = data.keys();
        double totalElapsedTime = 0.0;
        double maximumElapsedTime = 0.0;
        double totalCPUTime = 0.0;
        double maximumCPUTime = 0.0;
        double totalInputMessages = 0.0;
        double totalSizeOfInputMessages = 0.0;
        double timesMaximumNumberOfThreadsReached = 0.0;
        double totalNumberOfMQErrors = 0.0;
        double totalNumberOfMessagesWithErrors = 0.0;
        double totalNumberOfErrorsProcessingMessages = 0.0;
        double totalNumberOfCommits = 0.0;
        double totalNumberOfBackouts = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Message flow name  :" + key);
            String intervalDataKey = null;
            double measPeriod = 1.0;
            if (key != null && key.trim().length() > 0) {
                if (key.indexOf("/") > -1) {
                    Enumeration enu1 = intervalData.keys();
                    while (enu1.hasMoreElements()) {
                        String key1;
                        String tempKey = key1 = (String)enu1.nextElement();
                        if (key1.indexOf("/") > -1) {
                            key1 = key1.substring(0, key1.indexOf("/"));
                        } else {
                            measPeriod = this.timeSinceLastTest;
                        }
                        String key2 = key.substring(0, key.indexOf("/"));
                        if (!key2.equals(key1)) continue;
                        intervalDataKey = tempKey;
                    }
                    this.printOut("intervalDataKey  :" + intervalDataKey);
                    ArrayList intervalArrayList = (ArrayList)intervalData.get(intervalDataKey);
                    measPeriod = (Double)intervalArrayList.get(0);
                    this.printOut("Execution group name :" + intervalDataKey + "  statistic collection time " + measPeriod);
                } else {
                    measPeriod = this.timeSinceLastTest;
                    this.printOut("Execution group name not found for this  " + intervalDataKey + "  statistic collection time is assigned time since last measure period value ");
                }
            }
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            totalElapsedTime = (Double)tempArrayList.get(0);
            maximumElapsedTime = (Double)tempArrayList.get(1);
            totalCPUTime = (Double)tempArrayList.get(2);
            maximumCPUTime = (Double)tempArrayList.get(3);
            totalInputMessages = (Double)tempArrayList.get(4);
            totalSizeOfInputMessages = (Double)tempArrayList.get(5);
            timesMaximumNumberOfThreadsReached = (Double)tempArrayList.get(6);
            totalNumberOfMQErrors = (Double)tempArrayList.get(7);
            totalNumberOfMessagesWithErrors = (Double)tempArrayList.get(8);
            totalNumberOfErrorsProcessingMessages = (Double)tempArrayList.get(9);
            totalNumberOfCommits = (Double)tempArrayList.get(10);
            totalNumberOfBackouts = (Double)tempArrayList.get(11);
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            if (totalInputMessages > 0.0) {
                this.printOut("DEEP DEBUGS :Node name :" + key + " totalInputMessages  " + totalInputMessages);
                double avgElapsedTime = (totalElapsedTime /= 1000000.0) / totalInputMessages;
                double maxElapsedTime = (maximumElapsedTime /= 1000000.0) / totalInputMessages;
                double avgCPUTime = (totalCPUTime /= 1000000.0) / totalInputMessages;
                double maxCpuTime = (maximumCPUTime /= 1000000.0) / totalInputMessages;
                measureArrayList.add(new Double(avgElapsedTime));
                measureArrayList.add(new Double(maxElapsedTime));
                measureArrayList.add(new Double(avgCPUTime));
                measureArrayList.add(new Double(maxCpuTime));
                if (EgTest.debug) {
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Average ElapsedTime(" + avgElapsedTime + ")is derived from totalElapsedTime(" + totalElapsedTime + ") / totalInputMessages(" + totalInputMessages + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Maximum ElapsedTime(" + maxElapsedTime + ")is derived from maximumElapsedTime(" + maximumElapsedTime + ") / totalInputMessages(" + totalInputMessages + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Average CPUTime(" + avgCPUTime + ")is derived from totalCPUTime(" + totalCPUTime + ") / totalInputMessages(" + totalInputMessages + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Maximum CPU Time(" + maxCpuTime + ")is derived from maximumCPUTime(" + maximumCPUTime + ") / totalInputMessages(" + totalInputMessages + ")");
                }
            } else {
                this.printOut("DEEP DEBUGS :Node name :" + key + " totalInputMessages  is zero ,So assinging default values  ");
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
            }
            if (measPeriod > 0.0) {
                double inputMessageRate = totalInputMessages / measPeriod;
                double messageDataRate = totalSizeOfInputMessages / measPeriod;
                double mqErrors = totalNumberOfMQErrors / measPeriod;
                double errorMessageRate = totalNumberOfMessagesWithErrors / measPeriod;
                double processingErrorRate = totalNumberOfErrorsProcessingMessages / measPeriod;
                double commitsRate = totalNumberOfCommits / measPeriod;
                double backoutRate = totalNumberOfBackouts / measPeriod;
                if (EgTest.debug) {
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Input MessageRate(" + inputMessageRate + ")is derived from totalInputMessages(" + totalInputMessages + ") / Statistics interval(" + measPeriod + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Message DataRate(" + messageDataRate + ")is derived from totalSizeOfInputMessages(" + totalSizeOfInputMessages + ") / Statistics interval(" + measPeriod + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + "MQ  Errors(" + mqErrors + ")is derived from totalNumberOfMQErrors(" + totalNumberOfMQErrors + ") / Statistics interval(" + measPeriod + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Error MessageRate(" + errorMessageRate + ")is derived from totalNumberOfMessagesWithErrors(" + totalNumberOfMessagesWithErrors + ") / Statistics interval(" + measPeriod + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Processing ErrorRate(" + processingErrorRate + ")is derived from totalNumberOfErrorsProcessingMessages(" + totalNumberOfErrorsProcessingMessages + ") / Statistics interval(" + measPeriod + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Commit Rate(" + commitsRate + ")is derived from totalNumberOfCommits(" + totalNumberOfCommits + ") / Statistics interval(" + measPeriod + ")");
                    this.printOut("DEEP DEBUGS :Node name :" + key + " Back Rate(" + backoutRate + ")is derived from totalNumberOfBackouts(" + totalNumberOfBackouts + ") / Statistics interval(" + measPeriod + ")");
                }
                measureArrayList.add(new Double(inputMessageRate));
                measureArrayList.add(new Double(messageDataRate));
                measureArrayList.add(new Double(timesMaximumNumberOfThreadsReached));
                measureArrayList.add(new Double(mqErrors));
                measureArrayList.add(new Double(errorMessageRate));
                measureArrayList.add(new Double(processingErrorRate));
                measureArrayList.add(new Double(commitsRate));
                measureArrayList.add(new Double(backoutRate));
            } else {
                this.printOut("DEEP DEBUGS :Message flow  name :" + key + "measPeriod  is zero ,So assinging default values  ");
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(timesMaximumNumberOfThreadsReached));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
                measureArrayList.add(new Double(0.0));
            }
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBMsgFloStTest obj = new IIBMsgFloStTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

