/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class IPAddressRange {
    public static boolean debug = true;
    private int[] firstIPAddress;
    private int[] lastIP;
    private String firstIpv4Address = null;
    private String lastIpv4Address = null;
    private ArrayList location;
    private String firstIpv6Address = null;
    private String lastIpv6Address = null;
    private String country;
    private String region;
    private String city;
    private int order;
    private boolean isDefault;
    private InetAddress inetAddress;

    private IPAddressRange(String string, String string2, ArrayList arrayList) {
        if (string == null || string2 == null) {
            this.firstIPAddress = IPAddressRange.split2ints(string);
            this.lastIP = IPAddressRange.split2ints(string2);
            this.firstIpv4Address = string;
            this.lastIpv4Address = string2;
        } else if (IPAddressRangeSet.isValidIpv4Address(string) && IPAddressRangeSet.isValidIpv4Address(string2)) {
            this.firstIPAddress = IPAddressRange.split2ints(string);
            this.lastIP = IPAddressRange.split2ints(string2);
            this.firstIpv4Address = string;
            this.lastIpv4Address = string2;
        } else {
            this.firstIpv6Address = string;
            this.lastIpv6Address = string2;
        }
        this.location = arrayList;
    }

    public boolean contains(String string) {
        int[] nArray = IPAddressRange.split2ints(string);
        return this.contains(nArray);
    }

    public boolean containsIpv6(String string) {
        if (string == null || this.firstIpv6Address == null | this.lastIpv6Address == null) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            BigInteger bigInteger = new BigInteger(1, inetAddress.getAddress());
            InetAddress inetAddress2 = InetAddress.getByName(this.firstIpv6Address);
            BigInteger bigInteger2 = new BigInteger(1, inetAddress2.getAddress());
            InetAddress inetAddress3 = InetAddress.getByName(this.lastIpv6Address);
            BigInteger bigInteger3 = new BigInteger(1, inetAddress3.getAddress());
            int n = bigInteger2.compareTo(bigInteger);
            int n2 = bigInteger.compareTo(bigInteger3);
            return !(n != -1 && n != 0 || n2 != -1 && n2 != 0);
        }
        catch (Exception exception) {
            System.out.println("Exception occured while getting the IPv6 ranges...");
            return false;
        }
    }

    public boolean contains(int[] nArray) {
        if (nArray == null || this.firstIPAddress == null || this.lastIP == null) {
            return false;
        }
        if (nArray.length != 4) {
            return false;
        }
        String string = IPAddressRange.convertToString(nArray);
        String string2 = IPAddressRange.convertToString(this.firstIPAddress);
        String string3 = IPAddressRange.convertToString(this.lastIP);
        try {
            long l = IPAddressRange.ipToLong(InetAddress.getByName(string2));
            long l2 = IPAddressRange.ipToLong(InetAddress.getByName(string3));
            long l3 = IPAddressRange.ipToLong(InetAddress.getByName(string));
            if (l3 >= l && l3 <= l2) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured while getting the IPv4 ranges...");
        }
        return false;
    }

    public static IPAddressRange objectWithNetworkConfig(String string, String string2, ArrayList arrayList) throws UnknownHostException {
        int[] nArray = IPAddressRange.split2ints(string);
        int[] nArray2 = IPAddressRange.split2ints(string2);
        if (nArray.length != 4 || nArray2.length != 4) {
            throw new IllegalArgumentException("Wrong ip address or subnet mask");
        }
        int[] nArray3 = new int[]{nArray[0] & nArray2[0], nArray[1] & nArray2[1], nArray[2] & nArray2[2], nArray[3] & nArray2[3]};
        int[] nArray4 = new int[]{nArray2[0] ^ 0xFF, nArray2[1] ^ 0xFF, nArray2[2] ^ 0xFF, nArray2[3] ^ 0xFF};
        int[] nArray5 = new int[]{nArray3[0] | nArray4[0], nArray3[1] | nArray4[1], nArray3[2] | nArray4[2], nArray3[3] | nArray4[3]};
        if (debug) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ip          : ");
            IPAddressRange.printBinary(nArray, stringBuilder);
            stringBuilder = new StringBuilder();
            stringBuilder.append("mask        : ");
            IPAddressRange.printBinary(nArray2, stringBuilder);
            stringBuilder = new StringBuilder();
            stringBuilder.append("reverse mask: ");
            IPAddressRange.printBinary(nArray4, stringBuilder);
            stringBuilder = new StringBuilder();
            stringBuilder.append("first ip    : ");
            IPAddressRange.printBinary(nArray3, stringBuilder);
            stringBuilder = new StringBuilder();
            stringBuilder.append("last  ip    : ");
            IPAddressRange.printBinary(nArray5, stringBuilder);
        }
        return IPAddressRange.createWithIPBounds(IPAddressRange.convertToString(nArray3), IPAddressRange.convertToString(nArray5), arrayList);
    }

    public static IPAddressRange objectWithNetworkConfigForIPv6(String string, String string2, ArrayList arrayList) throws UnknownHostException {
        String string3 = IPAddressRange.getLastIpAddress(string2);
        return IPAddressRange.createWithIPBounds(string, string3, arrayList);
    }

    public static IPAddressRange createWithIPBounds(String string, String string2, ArrayList arrayList) {
        return new IPAddressRange(string, string2, arrayList);
    }

    public static IPAddressRange createDefault(ArrayList arrayList) {
        return new IPAddressRange(null, null, arrayList);
    }

    private static void printBinary(int[] nArray, StringBuilder stringBuilder) {
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(IPAddressRange.bufferZeroes(Integer.toBinaryString(nArray[i]), 8) + ".");
        }
    }

    private static String bufferZeroes(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        while (string.length() != n) {
            string = "0" + string;
        }
        return string;
    }

    private static String convertToString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static int[] split2ints(String string) {
        if (string != null && !string.trim().equals("")) {
            String[] stringArray = string.split("\\.");
            int[] nArray = new int[]{0, 0, 0, 0};
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                nArray[i] = Integer.parseInt(string2);
            }
            return nArray;
        }
        return new int[]{0, 0, 0, 0};
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public int getOrder() {
        return this.order;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getRegion() {
        return this.region;
    }

    public void setCity(String string) {
        this.city = string;
    }

    public void setCountry(String string) {
        this.country = string;
    }

    public void setRegion(String string) {
        this.region = string;
    }

    public ArrayList getLocation() {
        return this.location;
    }

    private static long ipToLong(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        long l = 0L;
        for (byte by : byArray) {
            l <<= 8;
            l |= (long)(by & 0xFF);
        }
        return l;
    }

    public static void main(String[] stringArray) {
        try {
            IPAddressRangeSet iPAddressRangeSet = IPAddressRangeSet.getMasterInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getLastIpAddress(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        if (string.contains("/")) {
            try {
                int n = string.indexOf("/");
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                InetAddress inetAddress = InetAddress.getByName(string3);
                int n2 = Integer.parseInt(string4);
                string2 = IPAddressRange.calculate(inetAddress, n2);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("UnknownHostException occured in getLastIpAddress while getting the IPv6 last ip range...");
            }
            catch (Exception exception) {
                System.err.println("Exception occured in getLastIpAddress while getting the IPv6 last ip range...");
            }
        } else {
            System.err.println("not an valid CIDR format!");
        }
        return string2;
    }

    private static String calculate(InetAddress inetAddress, int n) {
        String string = null;
        try {
            int n2;
            ByteBuffer byteBuffer;
            if (inetAddress.getAddress().length == 4) {
                byteBuffer = ByteBuffer.allocate(4).putInt(-1);
                n2 = 4;
            } else {
                byteBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
                n2 = 16;
            }
            BigInteger bigInteger = new BigInteger(1, byteBuffer.array()).not().shiftRight(n);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(inetAddress.getAddress());
            BigInteger bigInteger2 = new BigInteger(1, byteBuffer2.array());
            BigInteger bigInteger3 = bigInteger2.and(bigInteger);
            BigInteger bigInteger4 = bigInteger3.add(bigInteger.not());
            byte[] byArray = IPAddressRange.toBytes(bigInteger3.toByteArray(), n2);
            byte[] byArray2 = IPAddressRange.toBytes(bigInteger4.toByteArray(), n2);
            InetAddress inetAddress2 = InetAddress.getByAddress(byArray);
            String string2 = inetAddress2.getHostAddress();
            InetAddress inetAddress3 = InetAddress.getByAddress(byArray2);
            string = inetAddress3.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("UnknownHostException occured in calculate while getting the IPv6 last ip range...");
        }
        catch (Exception exception) {
            System.err.println("Exception occured in calculate while getting the IPv6 last ip range...");
        }
        return string;
    }

    private static byte[] toBytes(byte[] byArray, int n) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i = 0; i < n && byArray.length - 1 - i >= 0; ++i) {
            arrayList.add(0, byArray[byArray.length - 1 - i]);
        }
        int n2 = arrayList.size();
        for (int i = 0; i < n - n2; ++i) {
            arrayList.add(0, (byte)0);
        }
        byte[] byArray2 = new byte[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            byArray2[i] = (Byte)arrayList.get(i);
        }
        return byArray2;
    }
}

