/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IPAddressRangeSet {
    private static final Pattern ipv4Matcher = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final String UNKNOWN_STRING = "Unknown";
    private static final String NIL_STRING = "NIL";
    private static final String ZERO_STRING = "0.0";
    static final ThreadLocal threadLocalInstance = new ThreadLocal();
    static final IPAddressRangeSet masterCopy = new IPAddressRangeSet();
    private volatile IPAddressRange[] ranges = null;
    private long lastModifiedTime;
    private IPAddressRange defaultRange;
    private static final ArrayList defaultGeoList = new ArrayList();

    public static IPAddressRangeSet getMasterInstance() {
        return masterCopy;
    }

    public static IPAddressRangeSet getThreadInstance() {
        IPAddressRangeSet iPAddressRangeSet = (IPAddressRangeSet)threadLocalInstance.get();
        if (iPAddressRangeSet == null) {
            iPAddressRangeSet = new IPAddressRangeSet();
        }
        if (IPAddressRangeSet.masterCopy.lastModifiedTime != iPAddressRangeSet.lastModifiedTime) {
            iPAddressRangeSet.ranges = IPAddressRangeSet.masterCopy.ranges;
            iPAddressRangeSet.defaultRange = IPAddressRangeSet.masterCopy.defaultRange;
            iPAddressRangeSet.lastModifiedTime = IPAddressRangeSet.masterCopy.lastModifiedTime;
        }
        return iPAddressRangeSet;
    }

    public void refresh(String string) {
        this.parseFile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(String string) {
        Document document = null;
        DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
        documentBuilderFactoryImpl.setNamespaceAware(false);
        documentBuilderFactoryImpl.setValidating(false);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactoryImpl.newDocumentBuilder();
        }
        catch (Exception exception) {
            System.out.println("DocumentBuilder cannot be created which satisfies the configuration requested. ");
            exception.printStackTrace();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            if (documentBuilder != null) {
                try {
                    document = documentBuilder.parse(fileInputStream);
                }
                catch (Exception exception) {
                    System.out.println("Exception while parse the file: File Path:" + string);
                    exception.printStackTrace();
                }
            } else {
                System.out.println("DocumentBuilder is null. ");
            }
        }
        catch (Exception exception) {
            System.out.println("File not found. File Path: " + string);
            exception.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    System.out.println("Not able to close the file." + string);
                }
            }
        }
        if (document == null) {
            System.out.println("Document is not created for File Name: " + string);
            return;
        }
        IPAddressRange iPAddressRange = null;
        HashSet<IPAddressRange> hashSet = new HashSet<IPAddressRange>();
        NodeList nodeList = document.getElementsByTagName("location");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            IPAddressRange iPAddressRange2 = null;
            try {
                iPAddressRange2 = this.parseLocation((Element)node);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iPAddressRange2 != null) {
                if (iPAddressRange2.isDefault()) {
                    iPAddressRange = iPAddressRange2;
                    continue;
                }
                hashSet.add(iPAddressRange2);
                continue;
            }
            System.out.println("Invalid location format: " + node);
        }
        IPAddressRange[] iPAddressRangeArray = hashSet.toArray(new IPAddressRange[hashSet.size()]);
        this.ranges = iPAddressRangeArray;
        this.defaultRange = iPAddressRange;
        this.lastModifiedTime = System.currentTimeMillis();
    }

    private IPAddressRange parseLocation(Element element) throws UnknownHostException {
        String string = element.getAttribute("network");
        String string2 = element.getAttribute("subnet-mask");
        String string3 = element.getAttribute("start-ip-address");
        String string4 = element.getAttribute("end-ip-address");
        String string5 = element.getAttribute("order");
        String string6 = element.getAttribute("is-default");
        if (string != null && string.trim().length() > 0 && !IPAddressRangeSet.isValidIpv4Address(string) && !IPAddressRangeSet.isValidIpv6Address(string)) {
            System.out.println(" [IPAddressRangeSet] [parseLocation] Invalid network address configured in the local geo xml file : " + string);
            return null;
        }
        if (!(string3 == null || string3.trim().length() <= 0 || string4 == null || string4.trim().length() <= 0 || IPAddressRangeSet.isValidIpv4Address(string3) && IPAddressRangeSet.isValidIpv4Address(string4) || IPAddressRangeSet.isValidIpv6Address(string3) && IPAddressRangeSet.isValidIpv6Address(string4))) {
            System.out.println(" [IPAddressRangeSet] [parseLocation] Invalid firstIp [" + string3 + "] or lastIp[" + string4 + "] configured in the local geo xml file...");
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string7 = this.getTextForFirstElementByTagName(element, "country", null);
        String string8 = this.getTextForFirstElementByTagName(element, "country-code", null);
        String string9 = this.getTextForFirstElementByTagName(element, "region", null);
        String string10 = this.getTextForFirstElementByTagName(element, "region-code", null);
        String string11 = this.getTextForFirstElementByTagName(element, "city", null);
        String string12 = this.getTextForFirstElementByTagName(element, "longitude", "0");
        String string13 = this.getTextForFirstElementByTagName(element, "latitude", "0");
        arrayList.add(string7);
        arrayList.add(string8);
        arrayList.add(string9);
        arrayList.add(string11);
        arrayList.add(string13);
        arrayList.add(string12);
        arrayList.add(IPAddressRangeSet.getValidBoolean(string6, false));
        IPAddressRange iPAddressRange = null;
        if (IPAddressRangeSet.notNull(string) && IPAddressRangeSet.notNull(string2)) {
            iPAddressRange = IPAddressRangeSet.isValidIpv4Address(string) ? IPAddressRange.objectWithNetworkConfig(string, string2, arrayList) : IPAddressRange.objectWithNetworkConfigForIPv6(string, string2, arrayList);
        } else if (IPAddressRangeSet.notNull(string3) && IPAddressRangeSet.notNull(string4)) {
            iPAddressRange = IPAddressRange.createWithIPBounds(string3, string4, arrayList);
        } else if (IPAddressRangeSet.notNull(string6) && Boolean.parseBoolean(string6)) {
            iPAddressRange = IPAddressRange.createDefault(arrayList);
            iPAddressRange.setDefault(true);
        } else {
            iPAddressRange = null;
        }
        if (iPAddressRange != null && IPAddressRangeSet.notNull(string5)) {
            try {
                iPAddressRange.setOrder(Integer.parseInt(string5));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iPAddressRange;
    }

    public ArrayList getGeoLocDetails(String string) {
        if (string == null) {
            System.out.println(" [IPAddressRangeSet] [getGeoLocDetails] Given ip address is null, returning null.");
        }
        boolean bl = IPAddressRangeSet.isValidIpv4Address(string);
        boolean bl2 = IPAddressRangeSet.isValidIpv6Address(string);
        if (this.ranges == null) {
            return defaultGeoList;
        }
        int[] nArray = null;
        if (bl) {
            nArray = IPAddressRange.split2ints(string);
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            IPAddressRange iPAddressRange = this.ranges[i];
            if (!(bl ? iPAddressRange.contains(nArray) : bl2 && iPAddressRange.containsIpv6(string))) continue;
            return iPAddressRange.getLocation();
        }
        if (this.defaultRange != null) {
            return this.defaultRange.getLocation();
        }
        return null;
    }

    private static boolean notNull(String string) {
        return string != null && !string.trim().equals("");
    }

    private String getTextForFirstElementByTagName(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string3 = element2.getTextContent();
            string3 = string3.replace("\"", "\\\"");
            return string3;
        }
        return string2;
    }

    public static boolean isValidIpv4Address(String string) {
        return ipv4Matcher.matcher(string).matches();
    }

    public static boolean isIPv6StdAddress(String string) {
        return IPV6_STD_PATTERN.matcher(string).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String string) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(string).matches();
    }

    public static boolean isValidIpv6Address(String string) {
        return IPAddressRangeSet.isIPv6StdAddress(string) || IPAddressRangeSet.isIPv6HexCompressedAddress(string);
    }

    public static boolean getValidBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        if (IPAddressRangeSet.notNull(string)) {
            try {
                bl2 = Boolean.parseBoolean(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl2;
    }

    static {
        defaultGeoList.add(UNKNOWN_STRING);
        defaultGeoList.add(NIL_STRING);
        defaultGeoList.add(UNKNOWN_STRING);
        defaultGeoList.add(UNKNOWN_STRING);
        defaultGeoList.add(ZERO_STRING);
        defaultGeoList.add(ZERO_STRING);
        defaultGeoList.add(true);
    }
}

