/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.eg.IniFile;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;

public class JvmMemoryDetailsTest
extends JVMInstrumentation {
    private static String memPoolIndexOID = ".1.3.6.1.4.1.42.2.145.3.163.1.1.2.110.1";
    private static String jvmMemIndexOID = ".1.3.6.1.4.1.42.2.145.3.163.1.1.2";
    private static String pidOID = ".1.3.6.1.4.1.42.2.145.3.163.1.1.4.1";
    private MatHelperThread matHelperThread = null;
    long startTime = 0L;
    boolean jvmType = false;
    private static String heapDumpLocation;
    private ArrayList memPatterns = new ArrayList();
    private boolean isDDSent = false;
    private ArrayList ibm_heap_histo_info = null;

    public JvmMemoryDetailsTest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.jmappath = this.getValueForParam("Java_Home");
        this.heapOnOff = this.getValueForParam("Heap_Analysis");
        this.include = this.getValueForParam("Include_Packages");
        this.exclude = this.getValueForParam("Exclude_Packages");
        this.useSudo = this.getValueForParam("Use_Sudo");
        this.targetProcessUserName = this.getValueForParam("Target_Process_User_Name");
        heapDumpLocation = this.getValueForParam("Heap_Dump_Location");
        IniFile iniTopology = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_tests.ini");
        String descriptors = iniTopology.getValue("THRESHOLD_SUPPRESS_DESCRIPTOR", "JvmMemoryDetailsTest");
        if (descriptors != null && descriptors.length() > 0) {
            StringTokenizer str = new StringTokenizer(descriptors, ",");
            while (str.hasMoreTokens()) {
                String values = str.nextToken();
                this.memPatterns.add(values);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeMeasures(Hashtable params) {
        this.getJvmGuid();
        if (this.mode_type.equalsIgnoreCase("Jmx")) {
            Hashtable memoryInfo = null;
            JvmHelperThread helperThread = new JvmHelperThread(this.entity, this, this.urlStr, this.userName, this.password);
            long totalSleepTime = 0L;
            long tt = this.timeout;
            long sleepTime = 250L;
            int ccount = 0;
            int statusCode = 0;
            long sstime = System.currentTimeMillis();
            boolean statusFlag = false;
            String ibmJVMPid = null;
            while (true) {
                this.suspendForPeriod(sleepTime);
                if (helperThread.isDone()) {
                    statusCode = helperThread.getStatusCode();
                    statusFlag = helperThread.isStatus();
                    memoryInfo = helperThread.getResult();
                    ibmJVMPid = helperThread.getPID();
                    this.jvmType = helperThread.isIBMJVM();
                    break;
                }
                if (++ccount >= 5) {
                    ccount = 0;
                    totalSleepTime = System.currentTimeMillis() - sstime;
                } else {
                    totalSleepTime += sleepTime;
                }
                if (totalSleepTime >= tt || sleepTime <= 0L) {
                    helperThread.closeJVMconnectionWhenInterrupt();
                    break;
                }
                long remain = tt - totalSleepTime;
                if (remain >= sleepTime) continue;
                sleepTime = remain;
            }
            if (this.targetJVMOsName != null && this.jvmType && this.targetJVMOsName.equalsIgnoreCase("aix")) {
                File dir = new File(String.valueOf(EgInstallInfo.getInstallDir()) + "/mat");
                boolean matPluginexists = dir.exists();
                if (matPluginexists) {
                    if (this.matHelperThread != null) {
                        long now = System.currentTimeMillis();
                        long diff = now - this.startTime;
                        System.out.println("Already - MAT Helper Thread is running from past " + diff + " ms" + "for the " + this.reportingName);
                    } else {
                        this.matHelperThread = new MatHelperThread(this.reportingName, this.entity, ibmJVMPid, this.heapOnOff, this.include, this.exclude, this.useSudo, this.targetProcessUserName, this.jmappath, heapDumpLocation);
                        Thread threadObject = new Thread(this.matHelperThread);
                        threadObject.setName("MAT_Helper_Thread_" + this.reportingName);
                        this.startTime = System.currentTimeMillis();
                        System.out.println("MAT Helper Thread is started for the Reporting name : " + this.reportingName + " @ " + new Date());
                        threadObject.start();
                    }
                } else {
                    System.err.println("DD Will Not be captured  for JVMMemoryDetails Test because MAT Plugin not exists in egurkha directory ");
                }
            }
            if (statusCode != 100 || !statusFlag) return;
            try {
                if (memoryInfo == null || memoryInfo.size() <= 0) return;
                Enumeration keys = memoryInfo.keys();
                while (keys.hasMoreElements()) {
                    ArrayList<Double> measures = new ArrayList<Double>();
                    String key = (String)keys.nextElement();
                    String line1 = (String)memoryInfo.get(key);
                    String name = "";
                    boolean memPatterFound = false;
                    StringTokenizer st = new StringTokenizer(line1, "#");
                    if (st.hasMoreTokens()) {
                        name = st.nextToken();
                    }
                    memPatterFound = this.getMemMatchPattern(name);
                    while (st.hasMoreTokens()) {
                        String s = st.nextToken();
                        double d = Double.valueOf(s);
                        measures.add(new Double(d));
                    }
                    if (memPatterFound) {
                        measures.set(5, new Double(-5.0));
                    }
                    this.addNewMeasure(name, measures);
                }
                return;
            }
            catch (Exception e) {
                System.out.println(String.valueOf(e.toString()) + " in " + this.entity + " JMX mode...");
            }
            return;
        }
        if (this.mode_type.equalsIgnoreCase("Jar")) {
            this.heap_histo_info = null;
            boolean isZVM = false;
            boolean measureAdded = false;
            if (this.numOutputFields > 6) {
                measureAdded = true;
            }
            try {
                ArrayList resultInfo = this.getJarModeData();
                Hashtable<String, String> memoryDatas = new Hashtable<String, String>();
                if (resultInfo == null || resultInfo.size() <= 0) return;
                int arraySize = resultInfo.size();
                if (arraySize > 2) {
                    Hashtable memMxBeans;
                    ArrayList memoryDetailsArray;
                    Hashtable memoryInfo = (Hashtable)resultInfo.get(0);
                    Hashtable memMx = (Hashtable)resultInfo.get(1);
                    ArrayList jmapSourceList = (ArrayList)resultInfo.get(2);
                    isZVM = (Boolean)resultInfo.get(3);
                    if (this.heapOnOff != null && this.heapOnOff.equals("true") && jmapSourceList.size() > 0) {
                        this.heap_histo_info = this.processJmapResult(jmapSourceList);
                    }
                    if (memoryInfo != null && memoryInfo.size() > 0) {
                        Set keys = memoryInfo.keySet();
                        for (String thisKey : keys) {
                            try {
                                String memoryDetailString = (String)memoryInfo.get(thisKey);
                                String finalData = this.processData(memoryDetailString, isZVM, measureAdded);
                                memoryDatas.put(thisKey, finalData);
                            }
                            catch (Exception eee) {
                                eee.printStackTrace();
                            }
                        }
                    }
                    if (memMx != null && memMx.size() > 0 && (memoryDetailsArray = (ArrayList)memMx.get("memoryPool_cf")) != null && memoryDetailsArray.size() >= 1 && (memMxBeans = (Hashtable)memoryDetailsArray.get(1)) != null && memMxBeans.size() > 0) {
                        Set keys = memMxBeans.keySet();
                        for (String thisKey : keys) {
                            try {
                                String detailsString = (String)memMxBeans.get(thisKey);
                                String finalData = this.processData(detailsString, isZVM, measureAdded);
                                memoryDatas.put(thisKey, finalData);
                            }
                            catch (Exception eee) {
                                eee.printStackTrace();
                            }
                        }
                    }
                } else if (arraySize == 2) {
                    ArrayList mempoolDetails;
                    DecimalFormat df = new DecimalFormat("#.####");
                    int arrSize = 6;
                    ArrayList memDetails = (ArrayList)resultInfo.get(0);
                    if (memDetails != null && memDetails.size() > 0) {
                        Hashtable memheapDetails = (Hashtable)memDetails.get(0);
                        String isHeap = (String)memDetails.get(1);
                        if (isHeap != null && isHeap.equalsIgnoreCase("true")) {
                            Object nonHeapMemoryValueObj;
                            ArrayList nonHeapList;
                            Object heapMemoryValueObj = memheapDetails.get(memoryAttribute[0]);
                            ArrayList heapList = this.compositeResultList(heapMemoryValueObj);
                            if (heapList != null && heapList.size() == arrSize) {
                                String memTypeString = this.showNewMemoryDescriptor ? "Heap Memory:Total" : "Heap Memory Usage";
                                StringBuffer heapBuffer = this.getHeapBufferDetails(heapList, memTypeString);
                                if (measureAdded) {
                                    String moreThanReservedString;
                                    String poolType = (String)heapList.get(1);
                                    String heapExceeds = "0.0";
                                    Object moreThanReserved = memheapDetails.get(memoryAttribute[2]);
                                    if (moreThanReserved != null && (moreThanReservedString = moreThanReserved.toString().toLowerCase()).equals("true")) {
                                        heapExceeds = "1.0";
                                    }
                                    String heapAfterGC = "-5.0";
                                    Object heapAfterGCObject = memheapDetails.get(memoryAttribute[3]);
                                    if (heapAfterGCObject != null) {
                                        String heapAfterString = heapAfterGCObject.toString();
                                        double heap_percent_after_gc = Double.parseDouble(heapAfterString);
                                        heapAfterGC = df.format(heap_percent_after_gc);
                                    }
                                    String applicationHeapUsed = "-5.0";
                                    Object applicationHeapUsedObject = memheapDetails.get(memoryAttribute[4]);
                                    if (applicationHeapUsedObject != null) {
                                        String appHeapUsed = applicationHeapUsedObject.toString();
                                        long app_heap_used = Long.parseLong(appHeapUsed);
                                        applicationHeapUsed = this.changeUnit(app_heap_used);
                                    }
                                    String applicationHeapUseable = "-5.0";
                                    Object applicationHeapUsableObject = memheapDetails.get(memoryAttribute[5]);
                                    if (applicationHeapUsableObject != null) {
                                        String appHeapUsable = applicationHeapUsableObject.toString();
                                        long app_heap_useable = Long.parseLong(appHeapUsable);
                                        applicationHeapUseable = this.changeUnit(app_heap_useable);
                                    }
                                    String applicationPercentHeap = "-5.0";
                                    Object applicationPercentHeapObject = memheapDetails.get(memoryAttribute[6]);
                                    if (applicationPercentHeapObject != null) {
                                        String appPercent = applicationPercentHeapObject.toString();
                                        double app_percent = Double.parseDouble(appPercent);
                                        applicationPercentHeap = df.format(app_percent);
                                    }
                                    heapBuffer.append("#").append(heapExceeds);
                                    heapBuffer.append("#").append(heapAfterGC);
                                    heapBuffer.append("#").append(applicationHeapUsed);
                                    heapBuffer.append("#").append(applicationHeapUseable);
                                    heapBuffer.append("#").append(applicationPercentHeap);
                                    heapBuffer.append("#").append(poolType);
                                }
                                memoryDatas.put(memTypeString, heapBuffer.toString());
                            }
                            if ((nonHeapList = this.compositeResultList(nonHeapMemoryValueObj = memheapDetails.get(memoryAttribute[1]))) != null && nonHeapList.size() == arrSize) {
                                String memTypeString = this.showNewMemoryDescriptor ? "Non-Heap Memory:Total" : "Non-Heap Memory Usage";
                                StringBuffer nonHeapBuffer = this.getHeapBufferDetails(nonHeapList, memTypeString);
                                if (measureAdded) {
                                    String poolType = (String)nonHeapList.get(1);
                                    nonHeapBuffer.append("#").append("-5.0");
                                    nonHeapBuffer.append("#").append("-5.0");
                                    nonHeapBuffer.append("#").append("-5.0");
                                    nonHeapBuffer.append("#").append("-5.0");
                                    nonHeapBuffer.append("#").append("-5.0");
                                    nonHeapBuffer.append("#").append(poolType);
                                }
                                memoryDatas.put(memTypeString, nonHeapBuffer.toString());
                            }
                        }
                    }
                    if ((mempoolDetails = (ArrayList)resultInfo.get(1)) != null && mempoolDetails.size() > 0) {
                        Hashtable otherMemPoolDetails = (Hashtable)mempoolDetails.get(0);
                        String nonHeapStr = mempoolDetails.get(1).toString();
                        if (nonHeapStr != null && nonHeapStr.equalsIgnoreCase("false")) {
                            try {
                                Set set = otherMemPoolDetails.keySet();
                                for (String memPoolName : set) {
                                    Object currentUseObj;
                                    Object currentSizeObj;
                                    Object memPoolSizeType;
                                    ArrayList detailsList = (ArrayList)otherMemPoolDetails.get(memPoolName);
                                    Object initialReservedObj = detailsList.get(0);
                                    ArrayList valueList = this.getZingMemoryDetails(initialReservedObj, memPoolSizeType = detailsList.get(1), currentSizeObj = detailsList.get(2), currentUseObj = detailsList.get(3));
                                    if (valueList == null || valueList.size() != arrSize) continue;
                                    StringBuffer poolBuffer = this.getHeapBufferDetails(valueList, memPoolName);
                                    if (measureAdded) {
                                        String poolType = (String)valueList.get(1);
                                        poolBuffer.append("#").append("-5.0");
                                        poolBuffer.append("#").append("-5.0");
                                        poolBuffer.append("#").append("-5.0");
                                        poolBuffer.append("#").append("-5.0");
                                        poolBuffer.append("#").append("-5.0");
                                        poolBuffer.append("#").append(poolType);
                                    }
                                    memoryDatas.put(memPoolName, poolBuffer.toString());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if (memoryDatas == null || memoryDatas.size() <= 0) return;
                Enumeration keys = memoryDatas.keys();
                while (keys.hasMoreElements()) {
                    String memoryAreaKey = (String)keys.nextElement();
                    String memoryDetails = (String)memoryDatas.get(memoryAreaKey);
                    StringTokenizer st = new StringTokenizer(memoryDetails, "#");
                    if (!st.hasMoreTokens()) continue;
                    String infoName = st.nextToken();
                    boolean memPatternFound = this.getMemMatchPattern(infoName);
                    ArrayList<Double> measures = new ArrayList<Double>();
                    while (st.hasMoreTokens()) {
                        String tokenString = st.nextToken();
                        try {
                            double memoryValue = Double.parseDouble(tokenString);
                            measures.add(new Double(memoryValue));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (memPatternFound) {
                        measures.set(5, new Double(-5.0));
                    }
                    if (measures.size() == this.numOutputFields) {
                        this.addNewMeasure(infoName, measures);
                        continue;
                    }
                    System.out.println("[ERROR : MisMatch between collected data and numOutputFields (" + this.numOutputFields + ") for the Info " + infoName + " in JAR Mode " + measures);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (!this.mode_type.equalsIgnoreCase("Snmp")) return;
        double usedMem = -5.0;
        double avleMem = -5.0;
        double mxMaxMem = -5.0;
        double mxFrMem = -5.0;
        ArrayList<String> infoList = new ArrayList<String>();
        ArrayList<String> infoTpList = new ArrayList<String>();
        ArrayList<Double> memInit = new ArrayList<Double>();
        ArrayList<Double> memUsed = new ArrayList<Double>();
        ArrayList<Double> memComt = new ArrayList<Double>();
        ArrayList<Double> memMax = new ArrayList<Double>();
        this.heap_histo_info = new ArrayList();
        try {
            int i;
            if (this.runSnmpCmdForOid(jvmMemIndexOID)) {
                String heapDescriptor = "Heap Memory Usage";
                String nonHeapDescriptor = "Non-Heap Memory Usage";
                if (this.showNewMemoryDescriptor) {
                    heapDescriptor = "Heap Memory:Total";
                    nonHeapDescriptor = "Non-Heap Memory:Total";
                }
                infoList.add(heapDescriptor);
                infoTpList.add("2");
                infoList.add(nonHeapDescriptor);
                infoTpList.add("1");
                i = 0;
                while (i < this.lhs.length) {
                    if (!(this.lhs[i].startsWith("1.0") || this.lhs[i].startsWith("2.0") || this.lhs[i].startsWith("3.0"))) {
                        if (this.lhs[i].startsWith("100.1")) break;
                        int j = 1;
                        while (j <= 2) {
                            if (this.lhs[i].startsWith(String.valueOf(String.valueOf(j)) + "0.0")) {
                                memInit.add(new Double(this.getValue(i)));
                            } else if (this.lhs[i].startsWith(String.valueOf(String.valueOf(j)) + "1.0")) {
                                memUsed.add(new Double(this.getValue(i)));
                            } else if (this.lhs[i].startsWith(String.valueOf(String.valueOf(j)) + "2.0")) {
                                memComt.add(new Double(this.getValue(i)));
                            } else if (this.lhs[i].startsWith(String.valueOf(String.valueOf(j)) + "3.0")) {
                                memMax.add(new Double(this.getValue(i)));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            int infoCount = 0;
            if (this.runSnmpCmdForOid(String.valueOf(memPoolIndexOID) + ".2") && this.lhs != null) {
                infoCount = this.lhs.length;
            }
            if (this.runSnmpCmdForOid(memPoolIndexOID)) {
                int i2 = 0;
                while (i2 < this.lhs.length) {
                    if (this.lhs[i2].startsWith("21.")) break;
                    int j = 1;
                    while (j <= infoCount) {
                        if (this.lhs[i2].startsWith("2." + String.valueOf(j))) {
                            infoList.add(this.rhs[i2]);
                        } else if (this.lhs[i2].startsWith("3." + String.valueOf(j))) {
                            infoTpList.add(this.rhs[i2]);
                        } else if (this.lhs[i2].startsWith("10." + String.valueOf(j))) {
                            memInit.add(new Double(this.getValue(i2)));
                        } else if (this.lhs[i2].startsWith("11." + String.valueOf(j))) {
                            memUsed.add(new Double(this.getValue(i2)));
                        } else if (this.lhs[i2].startsWith("12." + String.valueOf(j))) {
                            memComt.add(new Double(this.getValue(i2)));
                        } else if (this.lhs[i2].startsWith("13." + String.valueOf(j))) {
                            memMax.add(new Double(this.getValue(i2)));
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            boolean measureAdded = false;
            if (this.numOutputFields > 6) {
                measureAdded = true;
            }
            i = 0;
            while (i < infoList.size()) {
                ArrayList<Double> measures = new ArrayList<Double>();
                String infoName = (String)infoList.get(i);
                if (i > 1) {
                    String infoType = (String)infoTpList.get(i);
                    infoName = this.showNewMemoryDescriptor ? (infoType.equals("1") ? "Non-Heap Memory:Memory Pool " + infoName : "Heap Memory:Memory Pool " + infoName) : (infoType.equals("1") ? "Memory Pool " + infoName + "(Non-Heap)" : "Memory Pool " + infoName + "(Heap)");
                }
                try {
                    measures.add((Double)memInit.get(i));
                }
                catch (Exception e) {
                    measures.add(new Double(-5.0));
                }
                try {
                    usedMem = (Double)memUsed.get(i);
                }
                catch (Exception e) {
                    usedMem = -5.0;
                }
                measures.add(new Double(usedMem));
                try {
                    avleMem = (Double)memComt.get(i);
                }
                catch (Exception e) {
                    avleMem = -5.0;
                }
                measures.add(new Double(avleMem));
                boolean isMaxUnLimited = false;
                try {
                    mxMaxMem = (Double)memMax.get(i);
                    if (mxMaxMem <= 0.0) {
                        mxMaxMem = -5.0;
                        isMaxUnLimited = true;
                    }
                }
                catch (Exception e) {
                    mxMaxMem = -5.0;
                }
                try {
                    mxFrMem = isMaxUnLimited ? -5.0 : mxMaxMem - usedMem;
                    measures.add(new Double(mxFrMem));
                }
                catch (Exception e) {
                    measures.add(new Double(-5.0));
                }
                measures.add(new Double(mxMaxMem));
                if (usedMem > 0.0) {
                    if (!isMaxUnLimited) {
                        measures.add(new Double(usedMem * 1000000.0 / mxMaxMem / 10000.0));
                    } else {
                        measures.add(new Double(-5.0));
                    }
                } else {
                    measures.add(new Double(-5.0));
                }
                if (measureAdded) {
                    double diff;
                    double heapExceeds = 0.0;
                    if (!isMaxUnLimited && mxMaxMem > 0.0 && usedMem >= 0.0 && (diff = mxMaxMem - usedMem) < 0.0) {
                        heapExceeds = 1.0;
                    }
                    measures.add(new Double(heapExceeds));
                    measures.add(new Double(-5.0));
                    measures.add(new Double(-5.0));
                    measures.add(new Double(-5.0));
                    measures.add(new Double(-5.0));
                    measures.add(new Double(-5.0));
                }
                this.addNewMeasure(infoName, measures);
                ++i;
            }
            if (this.heapOnOff == null || !this.heapOnOff.equals("true") || !this.runSnmpCmdForOid(pidOID)) return;
            String pid = this.rhs[0];
            pid = pid.substring(0, pid.indexOf("@"));
            this.heap_histo_info = this.getJmapResult(pid);
            return;
        }
        catch (Exception e) {
            System.out.println(String.valueOf(e.toString()) + " in " + this.entity + " SNMP mode...");
        }
    }

    private double getValue(int i) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(EgUtils.convertMemoryValues(String.valueOf(this.rhs[i]), "B", "MB"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public ArrayList getHeapHistoInfo() {
        if (this.jvmType && this.targetJVMOsName.equalsIgnoreCase("aix") && this.matHelperThread != null) {
            boolean done = this.matHelperThread.isDone();
            if (done) {
                this.ibm_heap_histo_info = this.matHelperThread.getMatHeapDetails();
                this.matHelperThread = null;
                return this.ibm_heap_histo_info;
            }
            return this.ibm_heap_histo_info;
        }
        return this.heap_histo_info;
    }

    public String processData(String memData, boolean isZVM, boolean measureAdded) {
        String[] splitResult = memData.split("#");
        String resultString = null;
        try {
            if (splitResult != null && splitResult.length == 5) {
                String info = splitResult[0].toString();
                double init = Double.parseDouble(splitResult[1]);
                double used = Double.parseDouble(splitResult[2]);
                double committed = Double.parseDouble(splitResult[3]);
                double max = Double.parseDouble(splitResult[4]);
                double freeMemory = -5.0;
                double precentage = -5.0;
                String maxString = "-5.0";
                String freeString = "-5.0";
                String initString = this.changeUnit(init);
                String usedString = this.changeUnit(used);
                String commString = this.changeUnit(committed);
                StringBuffer resultBuffer = new StringBuffer();
                if (!this.showNewMemoryDescriptor) {
                    StringTokenizer tokens = new StringTokenizer(info, ":");
                    String memoryType = tokens.nextToken();
                    if (memoryType.equalsIgnoreCase("Total")) {
                        info = String.valueOf(memoryType) + " Usage";
                    } else {
                        String memoryName = tokens.nextToken();
                        String memPoolName = memoryName.replace("Pool ", "Pool_");
                        info = String.valueOf(memPoolName) + " (" + memoryType + ")";
                    }
                }
                if (max >= 0.0) {
                    freeMemory = max - used;
                    precentage = used / max * 100.0;
                    freeString = this.changeUnit(freeMemory);
                    maxString = this.changeUnit(max);
                } else {
                    max = -5.0;
                }
                resultBuffer.append(info).append("#");
                resultBuffer.append(initString).append("#");
                resultBuffer.append(usedString).append("#");
                resultBuffer.append(commString).append("#");
                if (isZVM) {
                    resultBuffer.append("-5.0").append("#");
                    resultBuffer.append(maxString).append("#");
                    resultBuffer.append("-5.0");
                } else {
                    resultBuffer.append(freeString).append("#");
                    resultBuffer.append(maxString).append("#");
                    resultBuffer.append(precentage);
                }
                if (measureAdded) {
                    double diff;
                    String heapExceeds = "0.0";
                    if (max >= 0.0 && (diff = max - used) < 0.0) {
                        heapExceeds = "1.0";
                    }
                    resultBuffer.append("#").append(heapExceeds);
                    resultBuffer.append("#").append("-5.0");
                    resultBuffer.append("#").append("-5.0");
                    resultBuffer.append("#").append("-5.0");
                    resultBuffer.append("#").append("-5.0");
                    resultBuffer.append("#").append("-5.0");
                }
                resultString = resultBuffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean patternMatch(String outString, String searchString) {
        if (searchString.equals("*")) {
            return true;
        }
        int ir = searchString.indexOf("*");
        if (ir < 0) {
            return outString.equalsIgnoreCase(searchString);
        }
        boolean flag = false;
        boolean startsWithCond = false;
        boolean endsWithCond = false;
        try {
            int index;
            StringTokenizer st;
            int count;
            if (!searchString.startsWith("*")) {
                startsWithCond = true;
            }
            if (!searchString.endsWith("*")) {
                endsWithCond = true;
            }
            if ((count = (st = new StringTokenizer(searchString, "*")).countTokens()) <= 0) {
                return false;
            }
            String newString = new String(outString);
            String[] patterns = new String[count];
            int i = 0;
            while (true) {
                if (i >= count) {
                    index = 0;
                    if (!startsWithCond || newString.startsWith(patterns[0])) break;
                    return false;
                }
                patterns[i] = st.nextToken();
                ++i;
            }
            if (endsWithCond && !newString.endsWith(patterns[count - 1])) {
                return false;
            }
            String s1 = null;
            int j = 0;
            while (true) {
                if (j >= count) {
                    return flag;
                }
                s1 = patterns[j];
                index = newString.indexOf(s1);
                if (index == -1) return false;
                flag = true;
                newString = new String(newString.substring(index += s1.length()));
                ++j;
            }
        }
        catch (Exception ex) {
            System.out.println("Problem occurred while matching the string patterns");
        }
        return flag;
    }

    protected String changeUnit(double value) {
        String s1 = Double.toString(value);
        return EgUtils.convertMemoryValues(s1, "B", "MB");
    }

    private boolean getMemMatchPattern(String name) {
        boolean patternFound = false;
        if (name != null && name.length() > 0 && this.memPatterns != null && this.memPatterns.size() > 0) {
            int i = 0;
            while (i < this.memPatterns.size()) {
                patternFound = this.patternMatch(name, (String)this.memPatterns.get(i));
                if (patternFound) break;
                ++i;
            }
        }
        return patternFound;
    }

    public void freeTest() {
        this.isDDSent = false;
        this.heap_histo_info = null;
        this.ibm_heap_histo_info = null;
    }

    public boolean isDDSent() {
        return this.isDDSent;
    }

    public void markDDSent() {
        this.isDDSent = true;
    }
}

