/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LnWebServerTest
extends EgSnmpGenericTestNew {
    private static final int MEASURES_COUNT = 7;
    private static final String ALL_STATS_OID = ".1.3.6.1.4.1.334.72.1.1.1.1.2";
    private String oidConnsAccepted = "";
    private String oidCurrentConns = "";
    private String oidWorkers = "";
    private String oidBytesRead = "";
    private String oidBytesWritten = "";
    private String oidReqsProcessed = "";
    private String oidIdleSessionTimeouts = "";
    private double prevConnsAccepted = -5.0;
    private double prevBytesRead = -5.0;
    private double prevBytesWritten = -5.0;
    private double prevReqsProcessed = -5.0;
    private double prevIdleSessionTimeouts = -5.0;
    private boolean isDiscovered = false;

    public LnWebServerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
    }

    private void discoverLnWebOIDs() {
        String string = null;
        if (this.runSnmpCmdForOid(ALL_STATS_OID)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string = this.getOIDForCounter("Http.Accept.ConnectionsAccepted", i);
                if (string != null) {
                    this.oidConnsAccepted = string;
                    continue;
                }
                string = this.getOIDForCounter("Http.CurrentConnections", i);
                if (string != null) {
                    this.oidCurrentConns = string;
                    continue;
                }
                string = this.getOIDForCounter("Http.Workers", i);
                if (string != null) {
                    this.oidWorkers = string;
                    continue;
                }
                string = this.getOIDForCounter("Http.Worker.Total.BytesRead", i);
                if (string != null) {
                    this.oidBytesRead = string;
                    continue;
                }
                string = this.getOIDForCounter("Http.Worker.Total.BytesWritten", i);
                if (string != null) {
                    this.oidBytesWritten = string;
                    continue;
                }
                string = this.getOIDForCounter("Http.Worker.Total.RequestsProcessed", i);
                if (string != null) {
                    this.oidReqsProcessed = string;
                    continue;
                }
                string = this.getOIDForCounter("Http.Worker.Total.IdleSessionTimeouts", i);
                if (string == null) continue;
                this.oidIdleSessionTimeouts = string;
            }
            this.isDiscovered = true;
            this.prevConnsAccepted = -5.0;
            this.prevBytesRead = -5.0;
            this.prevBytesWritten = -5.0;
            this.prevReqsProcessed = -5.0;
            this.prevIdleSessionTimeouts = -5.0;
        } else {
            this.logToErrorFile("ERROR", this.entity, "Error excuting Snmpwalk for the Domino server " + this.targetHost);
            this.isDiscovered = false;
        }
    }

    private double extractMeasure(String string) {
        double d = -5.0;
        int n = 0;
        try {
            n = string.indexOf("=");
            if (n > 0) {
                String string2 = string.substring(n + 1, string.length());
                string2 = string2.trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + stringTokenizer.nextToken();
                }
                d = Double.parseDouble(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    private double calculateRate(double d, double d2) {
        double d3 = -5.0;
        if (d2 >= 0.0) {
            double d4 = d - d2;
            if (this.timeSinceLastTest > 0.0) {
                d3 = d4 / this.timeSinceLastTest;
            }
            if (d3 < 0.0) {
                d3 = -5.0;
            }
        }
        return d3;
    }

    private String getOIDForCounter(String string, int n) {
        String string2 = null;
        try {
            int n2 = 0;
            n2 = this.rhs[n].indexOf(string);
            if (n2 >= 0) {
                string2 = this.lhs[n];
                string2 = ".1.3.6.1.4.1.334.72.1.1.1.1.2." + string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        if (!this.isDiscovered) {
            this.discoverLnWebOIDs();
        }
        if (!this.isDiscovered) {
            return;
        }
        if (this.runSnmpCmdForOid(this.oidReqsProcessed)) {
            d = this.extractMeasure(this.rhs[0]);
            d2 = this.calculateRate(d, this.prevReqsProcessed);
            this.prevReqsProcessed = d;
        } else {
            this.isDiscovered = false;
        }
        if (this.runSnmpCmdForOid(this.oidConnsAccepted)) {
            d = this.extractMeasure(this.rhs[0]);
            d3 = this.calculateRate(d, this.prevConnsAccepted);
            this.prevConnsAccepted = d;
        } else {
            this.isDiscovered = false;
        }
        if (this.runSnmpCmdForOid(this.oidCurrentConns)) {
            d4 = this.extractMeasure(this.rhs[0]);
        } else {
            this.isDiscovered = false;
        }
        if (this.runSnmpCmdForOid(this.oidWorkers)) {
            d7 = this.extractMeasure(this.rhs[0]);
        } else {
            this.isDiscovered = false;
        }
        if (this.runSnmpCmdForOid(this.oidBytesRead)) {
            d = this.extractMeasure(this.rhs[0]);
            d5 = this.calculateRate(d, this.prevBytesRead);
            if (d5 >= 0.0) {
                d5 /= 1000.0;
            }
            this.prevBytesRead = d;
        } else {
            this.isDiscovered = false;
        }
        if (this.runSnmpCmdForOid(this.oidBytesWritten)) {
            d = this.extractMeasure(this.rhs[0]);
            d6 = this.calculateRate(d, this.prevBytesWritten);
            if (d6 >= 0.0) {
                d6 /= 1000.0;
            }
            this.prevBytesWritten = d;
        } else {
            this.isDiscovered = false;
        }
        if (this.runSnmpCmdForOid(this.oidIdleSessionTimeouts)) {
            d = this.extractMeasure(this.rhs[0]);
            d8 = this.calculateRate(d, this.prevIdleSessionTimeouts);
            this.prevIdleSessionTimeouts = d;
        } else {
            this.isDiscovered = false;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(7);
        arrayList.add(new Double(d2));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d4));
        arrayList.add(new Double(d5));
        arrayList.add(new Double(d6));
        arrayList.add(new Double(d7));
        arrayList.add(new Double(d8));
        this.addNewMeasure(arrayList);
    }
}

