/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MariaValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean isConnectivityOk = true;
    public boolean isExternalTest = false;
    public boolean meAgentLess = false;
    private String ssl = "false";
    private String dbName = "mysql";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();

    public MariaValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-database")) {
                    this.dbName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                this.ssl = string3;
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public void validate() {
        try {
            if (!this.checkMariaConnectivity()) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Maria Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("Maria Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect");
                } else {
                    String string = (String)this.validationErrorMap.get("Maria_Connectivity");
                    this.validationMsgs.add("Maria Server Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
            } else {
                this.validationMsgs.add("Maria Server Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkMariaConnectivity() {
        block13: {
            boolean bl = false;
            boolean bl2 = true;
            String string = "";
            ResultSet resultSet = null;
            Statement statement = null;
            Connection connection = null;
            String string2 = "show tables";
            double d = this.getDatabaseVersion();
            if (d <= 0.0) {
                return false;
            }
            string2 = d >= 5.0 ? "show global status" : "show status";
            try {
                this.host = IPV6Helper.getValidIPAddress(this.host);
                Class.forName("com.mysql.cj.jdbc.Driver");
                String string3 = this.ssl != null && "true".equalsIgnoreCase(this.ssl) || "yes".equalsIgnoreCase(this.ssl) ? "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=true&enabledTLSProtocols=TLSv1.2&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=false&serverTimezone=UTC";
                System.out.println(" url ::" + string3);
                String string4 = new String(string3);
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                connection = DriverManager.getConnection(string4, properties);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(1);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    String string5 = resultSet.getString(1);
                }
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (SQLException sQLException) {
                CharSequence charSequence;
                Object object;
                sQLException.printStackTrace();
                int n = sQLException.getErrorCode();
                String string6 = sQLException.getMessage();
                this.isConnectivityOk = false;
                String string7 = this.getStackTraceAsString(sQLException);
                boolean bl3 = true;
                if (d >= 5.0 && (object = this.checkMariaUserPrivilleges()) != null && ((String)object).equalsIgnoreCase("NO")) {
                    bl3 = false;
                    string6 = (String)this.validationErrorMap.get("Maria_User_privileges");
                    charSequence = this.checkDBPrivilleges();
                    if (charSequence != null && ((String)charSequence).equalsIgnoreCase("NO")) {
                        string6 = (String)this.validationErrorMap.get("Maria_DB_privileges");
                    }
                    bl = true;
                }
                string = string7 != null && string7.indexOf("at") > 0 ? string7.substring(0, string7.indexOf("at")) : string7;
                this.validationErrorMsg = bl ? string6.trim() : string;
                if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                    object = new StringTokenizer(this.validationErrorMsg, ":");
                    charSequence = new StringBuffer();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string8 = ((StringTokenizer)object).nextToken();
                        ((StringBuffer)charSequence).append(string8.trim() + " ");
                    }
                    this.validationErrorMsg = ((StringBuffer)charSequence).toString();
                    this.validationErrorMsg = this.validationErrorMsg.trim();
                }
                this.validationErrorMap.put("Maria_Connectivity", this.validationErrorMsg);
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                this.isConnectivityOk = false;
                String string9 = this.getStackTraceAsString(exception);
                string = string9 != null && string9.indexOf("at") > 0 ? string9.substring(0, string9.indexOf("at")) : string9;
                this.validationErrorMsg = string;
                this.validationErrorMap.put("Maria_Connectivity", this.validationErrorMsg);
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
        }
        return this.isConnectivityOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public double getDatabaseVersion() {
        Object object;
        String string;
        Object object2;
        String string2;
        double d;
        block20: {
            Connection connection = null;
            d = 0.0;
            string2 = "";
            boolean bl = false;
            String string3 = "";
            try {
                this.host = IPV6Helper.getValidIPAddress(this.host);
                Class.forName("com.mysql.cj.jdbc.Driver");
                object2 = "";
                object2 = this.ssl != null && "true".equalsIgnoreCase(this.ssl) || "yes".equalsIgnoreCase(this.ssl) ? "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=true&enabledTLSProtocols=TLSv1.2&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=false&serverTimezone=UTC";
                System.out.println(" url :" + (String)object2);
                connection = DriverManager.getConnection((String)object2, this.user, this.password);
                string2 = connection.getMetaData().getDatabaseProductVersion();
                this.closeConn(connection);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                int n = sQLException.getErrorCode();
                string = sQLException.getMessage();
                this.isConnectivityOk = false;
                String string4 = this.getStackTraceAsString(sQLException);
                switch (n) {
                    case 1044: {
                        string = " User '" + this.user + "' doesn't have privilege to access database";
                        bl = true;
                        break;
                    }
                    case 1045: {
                        string = " Invalid username/password; logon denied Or User Permission denied on database";
                        bl = true;
                        break;
                    }
                    case 1049: {
                        string = " Invalid database Or database unavailable";
                        bl = true;
                        break;
                    }
                    case 1146: {
                        string = " User '" + this.user + "' doesn't have privilege to access database";
                        bl = true;
                    }
                }
                string3 = string4 != null && string4.indexOf("at") > 0 ? string4.substring(0, string4.indexOf("at")) : string4;
                this.validationErrorMsg = bl ? string.trim() : string3;
                if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                    object = new StringTokenizer(this.validationErrorMsg, ":");
                    StringBuffer stringBuffer = new StringBuffer();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string5 = ((StringTokenizer)object).nextToken();
                        stringBuffer.append(string5.trim() + " ");
                    }
                    this.validationErrorMsg = stringBuffer.toString();
                    this.validationErrorMsg = this.validationErrorMsg.trim();
                }
                this.validationErrorMap.put("Maria_Connectivity", this.validationErrorMsg);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                String string6 = this.getStackTraceAsString(exception);
                string3 = string6 != null && string6.indexOf("at") > 0 ? string6.substring(0, string6.indexOf("at")) : string6;
                this.validationErrorMsg = string3;
                this.validationErrorMap.put("Maria_Connectivity", this.validationErrorMsg);
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeConn(connection);
            }
        }
        System.out.println("[EGMariaStatTest]-dbversion : " + string2);
        object2 = new StringTokenizer(string2, ".");
        String string7 = "";
        string = "";
        int n = ((StringTokenizer)object2).countTokens();
        if (((StringTokenizer)object2).hasMoreTokens()) {
            string7 = ((StringTokenizer)object2).nextToken();
        }
        if (((StringTokenizer)object2).hasMoreTokens()) {
            string = ((StringTokenizer)object2).nextToken();
        }
        object = "";
        object = n >= 3 ? string7 + "." + string : string7;
        object = ((String)object).trim();
        try {
            if (object != null && ((String)object).length() > 0) {
                d = Double.parseDouble((String)object);
                return d;
            }
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String checkMariaUserPrivilleges() {
        String string;
        block14: {
            String string2 = "";
            ResultSet resultSet = null;
            Statement statement = null;
            Connection connection = null;
            string = "NA";
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string3 = "";
            String string4 = "select PRIVILEGE_TYPE,IS_GRANTABLE from USER_PRIVILEGES where GRANTEE in(\"'" + this.user + "'@'" + this.host + "'\",\"'" + this.user + "'@'localhost'\")";
            try {
                String string5;
                Class.forName("com.mysql.cj.jdbc.Driver");
                string3 = this.ssl != null && "true".equalsIgnoreCase(this.ssl) || "yes".equalsIgnoreCase(this.ssl) ? "jdbc:mysql://" + this.host + ":" + this.port + "/information_schema?useSSL=true&enabledTLSProtocols=TLSv1.2&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/information_schema?useSSL=false&serverTimezone=UTC";
                String string6 = new String(string3);
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                connection = DriverManager.getConnection(string6, properties);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(1);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                while (resultSet.next()) {
                    string5 = resultSet.getString(1);
                    String string7 = resultSet.getString(2);
                    if (string5 == null) continue;
                    if (string5.equalsIgnoreCase("SELECT")) {
                        if (!string7.equalsIgnoreCase("YES")) continue;
                        bl = true;
                        continue;
                    }
                    if (string5.equalsIgnoreCase("PROCESS")) {
                        if (!string7.equalsIgnoreCase("YES")) continue;
                        bl2 = true;
                        continue;
                    }
                    if (!string5.equalsIgnoreCase("RELOAD") || !string7.equalsIgnoreCase("YES")) continue;
                    bl3 = true;
                }
                string5 = "";
                if (!bl) {
                    string5 = "User lacks in  Select ";
                }
                if (!bl2) {
                    string5 = !bl ? string5 + ",Process" : "User lacks in Process Privilege";
                }
                if (!bl3) {
                    string5 = !bl || bl2 ? string5 + ",Reload" : "User lacks in  Reload Privilege";
                }
                if (!(bl && bl2 && bl3)) {
                    string5 = string5 + " Privileges";
                    this.validationErrorMap.put("Maria_User_privileges", string5);
                    string = "NO";
                }
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                String string8 = sQLException.getMessage();
                String string9 = this.getStackTraceAsString(sQLException);
                string = "NA";
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                string = "NA";
                String string10 = this.getStackTraceAsString(exception);
                break block14;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String checkDBPrivilleges() {
        String string;
        block9: {
            String string2 = "";
            ResultSet resultSet = null;
            Statement statement = null;
            Connection connection = null;
            string = "NA";
            boolean bl = false;
            String string3 = "";
            String string4 = "select select_priv from db where db='" + this.dbName + "' and user+':'+host in (\"'" + this.user + "'+':'+'" + this.host + "'\",\"'" + this.user + "'+':'+'localhost'\")";
            try {
                String string5;
                Class.forName("com.mysql.cj.jdbc.Driver");
                string3 = this.ssl != null && "true".equalsIgnoreCase(this.ssl) || "yes".equalsIgnoreCase(this.ssl) ? "jdbc:mysql://" + this.host + ":" + this.port + "/mysql?useSSL=true&enabledTLSProtocols=TLSv1.2&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/mysql?useSSL=false&serverTimezone=UTC";
                String string6 = new String(string3);
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                connection = DriverManager.getConnection(string6, properties);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(1);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                while (resultSet.next()) {
                    string5 = resultSet.getString(1);
                    if (string5 == null || !string5.equalsIgnoreCase("YES")) continue;
                    bl = true;
                    string = "YES";
                }
                if (!bl) {
                    string5 = "User doesn't  Select Privilege on '" + this.dbName + "' database ";
                    this.validationErrorMap.put("Maria_DB_privileges", string5);
                    string = "NO";
                }
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                String string7 = sQLException.getMessage();
                String string8 = this.getStackTraceAsString(sQLException);
                string = "NA";
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                string = "NA";
                String string9 = this.getStackTraceAsString(exception);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeRset(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
        }
        return string;
    }

    private void closeRset(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    private void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    public ArrayList getValidationMsgs() {
        System.out.println("########getting Validation Hashtable---->" + this.validationMsgs);
        return this.validationMsgs;
    }
}

