/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MySqlValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean isConnectivityOk = true;
    public boolean isExternalTest = false;
    public boolean meAgentLess = false;
    private String ssl = "false";
    private String dbName = "mysql";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    private String trustCertificate = "";
    private String trustCertificatePassword = "";
    private String verifyCA = "";
    private boolean isVerifyCA = false;
    private String keyCertificate = "";
    private String keyCertificatePassword = "";
    private boolean isSSL = false;
    private String allowPublicKey = "";
    private boolean isAllowPublicKey = false;

    public MySqlValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-db")) {
                    this.dbName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-userName")) {
                    this.user = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                    } else {
                        this.isAgentLess = "false";
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                    this.ssl = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-truststore_password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.trustCertificatePassword = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-keystore_password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.keyCertificatePassword = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-verify_ca")) {
                    this.verifyCA = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-allow_public_key")) {
                    this.allowPublicKey = string3;
                }
                if (this.ssl != null && "true".equalsIgnoreCase(this.ssl) || "yes".equalsIgnoreCase(this.ssl)) {
                    this.isSSL = true;
                }
                if (this.verifyCA != null && "true".equalsIgnoreCase(this.verifyCA) || "yes".equalsIgnoreCase(this.verifyCA)) {
                    this.isVerifyCA = true;
                }
                if (this.allowPublicKey != null && "true".equalsIgnoreCase(this.allowPublicKey) || "yes".equalsIgnoreCase(this.allowPublicKey)) {
                    this.isAllowPublicKey = true;
                }
                if (!this.isSSL || !this.isVerifyCA) continue;
                String string4 = System.getProperty("os.name");
                if ((string4 = string4.toLowerCase()).indexOf("win") > -1) {
                    this.trustCertificate = EgInstallInfo.getInstallDir() + "\\JRE\\lib\\security\\" + "cacerts";
                    this.keyCertificate = EgInstallInfo.getInstallDir() + "\\JRE\\lib\\security\\" + "keystore";
                    continue;
                }
                if (string4.indexOf("nix") <= -1 && string4.indexOf("nux") <= -1 && string4.indexOf("aix") <= -1) continue;
                this.trustCertificate = EgInstallInfo.getInstallDir() + "/JRE/lib/security/" + "cacerts";
                this.keyCertificate = EgInstallInfo.getInstallDir() + "/JRE/lib/security/" + "keystore";
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public void validate() {
        try {
            if (!this.checkMySqlConnectivity()) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("MySQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("MySQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect");
                } else {
                    String string = (String)this.validationErrorMap.get("MySql_Connectivity");
                    this.validationMsgs.add("MySQL Server Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
            } else {
                this.validationMsgs.add("MySQL Server Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMySqlConnectivity() {
        boolean bl = false;
        boolean bl2 = true;
        String string = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string2 = "show tables";
        double d = this.getDatabaseVersion();
        if (d <= 0.0) {
            return false;
        }
        string2 = d >= 5.0 ? "show global status" : "show status";
        try {
            this.host = IPV6Helper.getValidIPAddress(this.host);
            Class.forName("com.mysql.cj.jdbc.Driver");
            String string3 = this.isSSL ? (this.isVerifyCA ? "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?verifyServerCertificate=true&useSSL=true&requireSSL=true&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?verifyServerCertificate=false&useSSL=true&requireSSL=true&serverTimezone=UTC") : "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=false&serverTimezone=UTC";
            string3 = this.isAllowPublicKey ? string3 + "&allowPublicKeyRetrieval=true" : string3 + "&allowPublicKeyRetrieval=false";
            String string4 = new String(string3);
            System.out.println(" MySQL Validator.. url :" + string3);
            Properties properties = new Properties();
            properties.put("user", this.user);
            properties.put("password", this.password);
            if (this.isSSL && this.isVerifyCA) {
                properties.setProperty("trustCertificateKeyStoreUrl", "file:" + this.trustCertificate + "");
                properties.setProperty("trustCertificateKeyStorePassword", this.trustCertificatePassword);
                if (this.keyCertificatePassword != null && !this.keyCertificatePassword.equalsIgnoreCase("none") && this.keyCertificate != null) {
                    properties.setProperty("clientCertificateKeyStoreUrl", "file:" + this.keyCertificate);
                    properties.setProperty("clientCertificateKeyStorePassword", this.keyCertificatePassword);
                }
            }
            connection = DriverManager.getConnection(string4, properties);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                String string5 = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sQLException) {
            CharSequence charSequence;
            Object object;
            sQLException.printStackTrace();
            int n = sQLException.getErrorCode();
            String string6 = sQLException.getMessage();
            this.isConnectivityOk = false;
            String string7 = this.getStackTraceAsString(sQLException);
            boolean bl3 = true;
            if (d >= 5.0 && (object = this.checkMySqlUserPrivilleges()) != null && ((String)object).equalsIgnoreCase("NO")) {
                bl3 = false;
                string6 = (String)this.validationErrorMap.get("MySql_User_privileges");
                charSequence = this.checkDBPrivilleges();
                if (charSequence != null && ((String)charSequence).equalsIgnoreCase("NO")) {
                    string6 = (String)this.validationErrorMap.get("MySql_DB_privileges");
                }
                bl = true;
            }
            string = string7 != null && string7.indexOf("at") > 0 ? string7.substring(0, string7.indexOf("at")) : string7;
            this.validationErrorMsg = bl ? string6.trim() : string;
            if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                object = new StringTokenizer(this.validationErrorMsg, ":");
                charSequence = new StringBuffer();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string8 = ((StringTokenizer)object).nextToken();
                    ((StringBuffer)charSequence).append(string8.trim() + " ");
                }
                this.validationErrorMsg = ((StringBuffer)charSequence).toString();
                this.validationErrorMsg = this.validationErrorMsg.trim();
            }
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            this.isConnectivityOk = false;
            String string9 = this.getStackTraceAsString(exception);
            string = string9 != null && string9.indexOf("at") > 0 ? string9.substring(0, string9.indexOf("at")) : string9;
            this.validationErrorMsg = string;
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.isConnectivityOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDatabaseVersion() {
        Object object;
        Object object2;
        String string;
        Object object3;
        Connection connection = null;
        double d = 0.0;
        String string2 = "";
        boolean bl = false;
        String string3 = "";
        try {
            this.host = IPV6Helper.getValidIPAddress(this.host);
            Class.forName("com.mysql.cj.jdbc.Driver");
            object3 = "";
            object3 = this.isSSL ? (this.isVerifyCA ? "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?verifyServerCertificate=true&useSSL=true&requireSSL=true&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?verifyServerCertificate=false&useSSL=true&requireSSL=true&serverTimezone=UTC") : "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?useSSL=false&serverTimezone=UTC";
            object3 = this.isAllowPublicKey ? (String)object3 + "&allowPublicKeyRetrieval=true" : (String)object3 + "&allowPublicKeyRetrieval=false";
            string = new String((String)object3);
            object2 = new Properties();
            ((Properties)object2).put("user", this.user);
            ((Properties)object2).put("password", this.password);
            if (this.isSSL && this.isVerifyCA) {
                ((Properties)object2).setProperty("trustCertificateKeyStoreUrl", "file:" + this.trustCertificate + "");
                ((Properties)object2).setProperty("trustCertificateKeyStorePassword", this.trustCertificatePassword);
                if (this.keyCertificatePassword != null && !this.keyCertificatePassword.equalsIgnoreCase("none") && this.keyCertificate != null) {
                    ((Properties)object2).setProperty("clientCertificateKeyStoreUrl", "file:" + this.keyCertificate);
                    ((Properties)object2).setProperty("clientCertificateKeyStorePassword", this.keyCertificatePassword);
                }
            }
            connection = DriverManager.getConnection(string, (Properties)object2);
            string2 = connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            int n = sQLException.getErrorCode();
            object2 = sQLException.getMessage();
            this.isConnectivityOk = false;
            String string4 = this.getStackTraceAsString(sQLException);
            switch (n) {
                case 1044: {
                    object2 = " User '" + this.user + "' doesn't have privilege to access database";
                    bl = true;
                    break;
                }
                case 1045: {
                    object2 = " Invalid username/password; logon denied Or User Permission denied on database";
                    bl = true;
                    break;
                }
                case 1049: {
                    object2 = " Invalid database Or database unavailable";
                    bl = true;
                    break;
                }
                case 1146: {
                    object2 = " User '" + this.user + "' doesn't have privilege to access database";
                    bl = true;
                }
            }
            string3 = string4 != null && string4.indexOf("at") > 0 ? string4.substring(0, string4.indexOf("at")) : string4;
            this.validationErrorMsg = bl ? ((String)object2).trim() : string3;
            if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                object = new StringTokenizer(this.validationErrorMsg, ":");
                StringBuffer stringBuffer = new StringBuffer();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string5 = ((StringTokenizer)object).nextToken();
                    stringBuffer.append(string5.trim() + " ");
                }
                this.validationErrorMsg = stringBuffer.toString();
                this.validationErrorMsg = this.validationErrorMsg.trim();
            }
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            String string6 = this.getStackTraceAsString(exception);
            string3 = string6 != null && string6.indexOf("at") > 0 ? string6.substring(0, string6.indexOf("at")) : string6;
            this.validationErrorMsg = string3;
            this.validationErrorMap.put("MySql_Connectivity", this.validationErrorMsg);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        System.out.println("[EGMySqlStatTest]-dbversion : " + string2);
        object3 = new StringTokenizer(string2, ".");
        string = "";
        object2 = "";
        int n = ((StringTokenizer)object3).countTokens();
        if (((StringTokenizer)object3).hasMoreTokens()) {
            string = ((StringTokenizer)object3).nextToken();
        }
        if (((StringTokenizer)object3).hasMoreTokens()) {
            object2 = ((StringTokenizer)object3).nextToken();
        }
        object = "";
        object = n >= 3 ? string + "." + (String)object2 : string;
        object = ((String)object).trim();
        try {
            if (object != null && ((String)object).length() > 0) {
                d = Double.parseDouble((String)object);
                return d;
            }
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkMySqlUserPrivilleges() {
        String string = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string2 = "NA";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = "";
        String string4 = "select PRIVILEGE_TYPE,IS_GRANTABLE from USER_PRIVILEGES where GRANTEE in(\"'" + this.user + "'@'" + this.host + "'\",\"'" + this.user + "'@'localhost'\")";
        try {
            String string5;
            Class.forName("com.mysql.cj.jdbc.Driver");
            string3 = this.isSSL ? (this.isVerifyCA ? "jdbc:mysql://" + this.host + ":" + this.port + "/information_schema?verifyServerCertificate=true&useSSL=true&requireSSL=true&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/information_schema?verifyServerCertificate=false&useSSL=true&requireSSL=true&serverTimezone=UTC") : "jdbc:mysql://" + this.host + ":" + this.port + "/information_schema?useSSL=false&serverTimezone=UTC";
            string3 = this.isAllowPublicKey ? string3 + "&allowPublicKeyRetrieval=true" : string3 + "&allowPublicKeyRetrieval=false";
            String string6 = new String(string3);
            Properties properties = new Properties();
            properties.put("user", this.user);
            properties.put("password", this.password);
            if (this.isSSL && this.isVerifyCA) {
                properties.setProperty("trustCertificateKeyStoreUrl", "file:" + this.trustCertificate + "");
                properties.setProperty("trustCertificateKeyStorePassword", this.trustCertificatePassword);
                if (this.keyCertificatePassword != null && !this.keyCertificatePassword.equalsIgnoreCase("none") && this.keyCertificate != null) {
                    properties.setProperty("clientCertificateKeyStoreUrl", "file:" + this.keyCertificate);
                    properties.setProperty("clientCertificateKeyStorePassword", this.keyCertificatePassword);
                }
            }
            connection = DriverManager.getConnection(string6, properties);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                string5 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                if (string5 == null) continue;
                if (string5.equalsIgnoreCase("SELECT")) {
                    if (!string7.equalsIgnoreCase("YES")) continue;
                    bl = true;
                    continue;
                }
                if (string5.equalsIgnoreCase("PROCESS")) {
                    if (!string7.equalsIgnoreCase("YES")) continue;
                    bl2 = true;
                    continue;
                }
                if (!string5.equalsIgnoreCase("RELOAD") || !string7.equalsIgnoreCase("YES")) continue;
                bl3 = true;
            }
            string5 = "";
            if (!bl) {
                string5 = "User lacks in  Select ";
            }
            if (!bl2) {
                string5 = !bl ? string5 + ",Process" : "User lacks in Process Privilege";
            }
            if (!bl3) {
                string5 = !bl || bl2 ? string5 + ",Reload" : "User lacks in  Reload Privilege";
            }
            if (!(bl && bl2 && bl3)) {
                string5 = string5 + " Privileges";
                this.validationErrorMap.put("MySql_User_privileges", string5);
                string2 = "NO";
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string8 = sQLException.getMessage();
            String string9 = this.getStackTraceAsString(sQLException);
            string2 = "NA";
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            string2 = "NA";
            String string10 = this.getStackTraceAsString(exception);
            return string10;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkDBPrivilleges() {
        String string = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string2 = "NA";
        boolean bl = false;
        String string3 = "";
        String string4 = "select select_priv from db where db='" + this.dbName + "' and user+':'+host in (\"'" + this.user + "'+':'+'" + this.host + "'\",\"'" + this.user + "'+':'+'localhost'\")";
        try {
            String string5;
            Class.forName("com.mysql.cj.jdbc.Driver");
            string3 = this.isSSL ? (this.isVerifyCA ? "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?verifyServerCertificate=true&useSSL=true&requireSSL=true&serverTimezone=UTC" : "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.dbName + "?verifyServerCertificate=false&useSSL=true&requireSSL=true&serverTimezone=UTC") : "jdbc:mysql://" + this.host + ":" + this.port + "/mysql?useSSL=false&serverTimezone=UTC";
            string3 = this.isAllowPublicKey ? string3 + "&allowPublicKeyRetrieval=true" : string3 + "&allowPublicKeyRetrieval=false";
            String string6 = new String(string3);
            Properties properties = new Properties();
            properties.put("user", this.user);
            properties.put("password", this.password);
            if (this.isSSL && this.isVerifyCA) {
                properties.setProperty("trustCertificateKeyStoreUrl", "file:" + this.trustCertificate + "");
                properties.setProperty("trustCertificateKeyStorePassword", this.trustCertificatePassword);
                if (this.keyCertificatePassword != null && !this.keyCertificatePassword.equalsIgnoreCase("none") && this.keyCertificate != null) {
                    properties.setProperty("clientCertificateKeyStoreUrl", "file:" + this.keyCertificate);
                    properties.setProperty("clientCertificateKeyStorePassword", this.keyCertificatePassword);
                }
            }
            connection = DriverManager.getConnection(string6, properties);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                string5 = resultSet.getString(1);
                if (string5 == null || !string5.equalsIgnoreCase("YES")) continue;
                bl = true;
                string2 = "YES";
            }
            if (!bl) {
                string5 = "User doesn't  Select Privilege on '" + this.dbName + "' database ";
                this.validationErrorMap.put("MySql_DB_privileges", string5);
                string2 = "NO";
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            String string7 = sQLException.getMessage();
            String string8 = this.getStackTraceAsString(sQLException);
            string2 = "NA";
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            string2 = "NA";
            String string9 = this.getStackTraceAsString(exception);
            return string9;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
    }

    public ArrayList getValidationMsgs() {
        System.out.println("########getting Validation Hashtable---->" + this.validationMsgs);
        return this.validationMsgs;
    }
}

