/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class NAUSDDiskTest
extends NAUSDDiskBase {
    private String userbusy = new String("");
    private String readlat = new String("");
    private String writelat = new String("");
    private static final int measureCount = 12;
    double userbusyval = -1.0;
    double readlatval = -1.0;
    double writelatval = -1.0;
    public Hashtable busy_dd = new Hashtable();
    public Hashtable read = new Hashtable();
    public Hashtable write = new Hashtable();

    public NAUSDDiskTest(String[] stringArray) {
        super(stringArray);
        this.userbusy = this.getValueForParam("Disk_busy_threshold(%)");
        this.readlat = this.getValueForParam("read_latency_threshold(Millisecs)");
        this.writelat = this.getValueForParam("write_latency_threshold(Millisecs)");
        this.printOut("DEBUG", "disk busy threshold = " + this.userbusy + " and read latency threshold = " + this.readlat + " and write latency threshold = " + this.writelat);
        if (this.userbusy != null && this.userbusy.length() > 0) {
            try {
                this.userbusyval = Double.parseDouble(this.userbusy);
            }
            catch (Exception exception) {
                this.userbusyval = -1.0;
            }
        }
        if (this.readlat != null && this.readlat.length() > 0) {
            try {
                this.readlatval = Double.parseDouble(this.readlat);
            }
            catch (Exception exception) {
                this.readlatval = -1.0;
            }
        }
        if (this.writelat != null && this.writelat.length() > 0) {
            try {
                this.writelatval = Double.parseDouble(this.writelat);
            }
            catch (Exception exception) {
                this.writelatval = -1.0;
            }
        }
        this.setMeasureCount(12);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.collectMetrics();
        Hashtable hashtable2 = this.getDiskDetails(this.userbusyval, this.readlatval, this.writelatval);
        Hashtable hashtable3 = (Hashtable)ht_FullInf0.get(this.reportingName);
        this.busy_dd = (Hashtable)Diskbusy_dd.get(this.reportingName);
        this.read = (Hashtable)Diskread_dd.get(this.reportingName);
        this.write = (Hashtable)Diskwrite_dd.get(this.reportingName);
        if (hashtable2 != null && hashtable2.size() > 0) {
            Enumeration enumeration = hashtable2.keys();
            String string = "";
            String string2 = "";
            ArrayList arrayList = null;
            arrayList = (ArrayList)hashtable2.get("Busy Disks");
            if (this.userbusyval >= 0.0 && arrayList != null && arrayList.size() > 0) {
                this.printOut("DEBUG", "Adding busy disks measure : " + arrayList.toString());
                this.addNewMeasure("Busy Disks", arrayList);
            }
            arrayList = (ArrayList)hashtable2.get("Slow(read) Disks");
            if (this.readlatval >= 0.0 && arrayList != null && arrayList.size() > 0) {
                this.printOut("DEBUG", "Adding slow read disks measure : " + arrayList.toString());
                this.addNewMeasure("Slow(read) Disks", arrayList);
            }
            arrayList = (ArrayList)hashtable2.get("Slow(write) Disks");
            if (this.writelatval >= 0.0 && arrayList != null && arrayList.size() > 0) {
                this.printOut("DEBUG", "Adding slow write disks measure : " + arrayList.toString());
                this.addNewMeasure("Slow(write) Disks", arrayList);
            }
            int n = 0;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.equalsIgnoreCase("Busy Disks") || string.equalsIgnoreCase("Slow(read) Disks") || string.equalsIgnoreCase("Slow(write) Disks")) continue;
                string2 = (String)hashtable3.get(string);
                arrayList = (ArrayList)hashtable2.get(string);
                this.addNewMeasure(string2, arrayList);
                ++n;
            }
            this.printOut("DEBUG", "Added measures for " + n + " disks.");
        }
    }

    public void freeTest() {
        this.busy_dd = new Hashtable();
        this.read = new Hashtable();
        this.write = new Hashtable();
    }

    public static void main(String[] stringArray) {
        NAUSDDiskTest nAUSDDiskTest = new NAUSDDiskTest(stringArray);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    nAUSDDiskTest.computeMeasures(new Hashtable());
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

