/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaProtocolException;
import netapp.manage.NaServer;

public class NetAppValidator
extends EgServerValidator {
    private String reportingName = "";
    private String host = "";
    private String user = "none";
    private String password = "none";
    private String logMessage = "";
    private String vFilerName = "none";
    private String entity = "NetAppValidator";
    private String strNAUSDValidatorLogSizeLimitInMB = null;
    private boolean isSSL = false;
    private ArrayList validationMsgs = null;
    private int AuthMech;
    private int APIPort;
    private int minorVersion = 0;
    private int timeout = 120;
    private static final int majorVersion = 1;
    private static final double MB_TO_BYTES = 1048576.0;
    private static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    private double nausdValidatorLogSizeLimitInMB = 1048576.0;
    private static final String INFO = "INFO";
    private static final String DEBUG = "DEBUG";
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final String NETAPP_VALIDATOR_DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/NetAppValidatorLog";
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public NetAppValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2;
                    String string3 = stringArray[i];
                    String string4 = string3.substring(0, string3.indexOf(":"));
                    String string5 = string3.substring(string3.indexOf(":") + 1);
                    if ((string4 = string4.trim()) != null && string4.equalsIgnoreCase("-host")) {
                        this.host = string5.trim();
                        this.printOut("HOST  :" + this.host);
                        continue;
                    }
                    if (string4 != null && string4.equalsIgnoreCase("-user")) {
                        this.user = string5.trim();
                        this.printOut("USER :" + this.user);
                        continue;
                    }
                    if (string4 != null && string4.equalsIgnoreCase("-password")) {
                        if ((string5 = EgCrypt.decrypt(string5.trim())).indexOf("~EG~") != -1) {
                            string5 = string5.substring(0, string5.indexOf("~EG~"));
                        }
                        this.password = string5;
                        continue;
                    }
                    if (string4 != null && string4.equalsIgnoreCase("-Authentication_Mechanism")) {
                        string2 = string5.trim();
                        this.AuthMech = 1;
                        if (string2 == null || string2.equalsIgnoreCase("LOGIN_PASSWORD")) {
                            this.printOut("Authentication Mechanism : login/password");
                            continue;
                        }
                        if (string2.equalsIgnoreCase("HOSTS.EQUIV FILE")) {
                            this.AuthMech = 2;
                            this.printOut("Authentication Mechanism : hosts.equiv file");
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("WINDOWS RPC")) continue;
                        this.AuthMech = 3;
                        this.printOut("Authentication Mechanism : Windows RPC authentication");
                        continue;
                    }
                    if (string4 != null && string4.equalsIgnoreCase("-Use_SSL")) {
                        if (string5 != null && string5.equalsIgnoreCase("true")) {
                            this.isSSL = true;
                            this.printOut("Transport type is HTTPS");
                            continue;
                        }
                        this.isSSL = false;
                        this.printOut("Transport type is HTTP");
                        continue;
                    }
                    if (string4 != null && string4.equalsIgnoreCase("-API_Port")) {
                        string2 = string5.trim();
                        if (string2 != null && !string2.equalsIgnoreCase("default")) {
                            try {
                                this.APIPort = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (this.isSSL) {
                                    this.APIPort = 443;
                                    continue;
                                }
                                this.APIPort = 80;
                            }
                            continue;
                        }
                        if (this.isSSL) {
                            this.APIPort = 443;
                            continue;
                        }
                        this.APIPort = 80;
                        continue;
                    }
                    if (string4 != null && string4.equalsIgnoreCase("-timeout(secs)")) {
                        string2 = string5;
                        if (string2 != null && string2.trim().length() > 0) {
                            try {
                                this.timeout = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.timeout = 120;
                            }
                            continue;
                        }
                        this.timeout = 120;
                        continue;
                    }
                    if (string4 != null && string4.equalsIgnoreCase("-vFilerName")) {
                        this.vFilerName = string5;
                        continue;
                    }
                    if (string4 == null || !string4.equalsIgnoreCase("-rptname")) continue;
                    this.reportingName = string5;
                }
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
            this.strNAUSDValidatorLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", "NetAppValidatorLogSizeLimitInMB");
            if (this.strNAUSDValidatorLogSizeLimitInMB != null && this.strNAUSDValidatorLogSizeLimitInMB.length() > 0) {
                this.strNAUSDValidatorLogSizeLimitInMB = this.strNAUSDValidatorLogSizeLimitInMB.trim();
                try {
                    this.nausdValidatorLogSizeLimitInMB = Double.parseDouble(this.strNAUSDValidatorLogSizeLimitInMB);
                    this.nausdValidatorLogSizeLimitInMB *= 1048576.0;
                    this.printOut(string + "nausdValidatorLogSizeLimitInMB value in bytes : " + this.nausdValidatorLogSizeLimitInMB);
                }
                catch (Exception exception) {
                    this.printOut(string + "Converion error for strNAUSDValidatorLogSizeLimitInMB value to bytes : " + this.strNAUSDValidatorLogSizeLimitInMB + " ,exception :" + exception.toString());
                    this.nausdValidatorLogSizeLimitInMB = 1048576.0;
                }
            } else {
                this.nausdValidatorLogSizeLimitInMB = 1048576.0;
            }
            this.validationMsgs = new ArrayList();
            this.validate();
        }
        catch (Exception exception) {
            this.logMessage = string + "Error ";
            this.printOutStackTrace(this.logMessage, exception);
            System.out.println(exception);
        }
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        try {
            if (!this.isIPReachable()) {
                this.validationMsgs.add("NetApp Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                this.validationMsgs.add("Port$#$NA");
            } else if (!this.isSpecificPortReachable("" + this.APIPort)) {
                this.validationMsgs.add("NetApp Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$Port settings is incorrect or NetApp is down");
            } else {
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.execONTAPI();
                this.printOut("final arrayList " + this.getValidationMsgs());
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Error", exception);
            exception.printStackTrace();
        }
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected void execONTAPI() {
        String string = "execONTAPI";
        string = this.methodNameTemplate(string);
        NaElement naElement = new NaElement("system-get-version");
        NaServer naServer = this.getConnection();
        if (naServer == null) {
            return;
        }
        this.printOut("Executing " + naElement.getName() + "." + naElement.getContent());
        NaElement naElement2 = null;
        boolean bl = false;
        String string2 = "";
        try {
            naElement2 = naServer.invokeElem(naElement);
        }
        catch (NaAuthenticationException naAuthenticationException) {
            string2 = "Username/Password is invalid," + naAuthenticationException.getMessage();
            bl = true;
            this.validationMsgs.add("User/Password$#$" + string2);
            this.printOutStackTrace(string + "Error", (Exception)((Object)naAuthenticationException));
        }
        catch (NaAPIFailedException naAPIFailedException) {
            string2 = "Server returned a failure result," + naAPIFailedException.getMessage();
            bl = true;
            this.validationMsgs.add("User/Password$#$" + string2);
            this.printOutStackTrace(string + "Error", (Exception)((Object)naAPIFailedException));
        }
        catch (NaProtocolException naProtocolException) {
            string2 = "Protocol issue encountered," + naProtocolException.getMessage();
            bl = true;
            this.validationMsgs.add("User/Password$#$" + string2);
            this.printOutStackTrace(string + "Error", (Exception)((Object)naProtocolException));
        }
        catch (IOException iOException) {
            string2 = "Communication issue encountered," + iOException.getMessage();
            bl = true;
            this.validationMsgs.add("User/Password$#$" + string2);
            this.printOutStackTrace(string + "Error", iOException);
        }
        catch (Exception exception) {
            string2 = "Exception occurred. Could not execute ," + exception.getMessage();
            bl = true;
            this.validationMsgs.add("User/Password$#$" + string2);
            this.printOutStackTrace(string + "Error", exception);
        }
        if (!bl && naElement2 == null) {
            string2 = "No exceptions but output null while executing ";
            bl = true;
            this.validationMsgs.add("User/Password$#$" + string2);
        }
        if (bl) {
            this.printOut(string + "Error  : " + string2);
            return;
        }
        String string3 = naElement2.getChildContent("version");
        if (string3 != null && string3.trim().length() > 0) {
            this.validationMsgs.add("User/Password$#$OK");
            this.validationMsgs.add("NetApp Connectivity$#$OK");
            this.validationMsgs.add("Specific_Error_Msg$#$Monitoring validated");
        }
        this.printOut(string + "Version  :" + string3);
        this.closeConnection(naServer);
    }

    protected NaServer getConnection() {
        String string = "getConnection";
        string = this.methodNameTemplate(string);
        String string2 = "";
        if (this.AuthMech != 2 && this.user.equalsIgnoreCase("none") && this.password.equalsIgnoreCase("none")) {
            string2 = "Not creating connection due to no user and password being specified";
            this.printOut(string2);
            this.validationMsgs.add("NetApp Connectivity$#$NA" + string2);
            return null;
        }
        NaServer naServer = null;
        try {
            naServer = new NaServer(this.host, 1, this.minorVersion);
            this.printOut("Created NaServer for NA USD at " + this.host + " object with version " + 1 + "." + this.minorVersion);
        }
        catch (UnknownHostException unknownHostException) {
            string2 = "UnknownHostException upon trying to create server connection to " + this.host + " : " + unknownHostException.toString();
            this.printOutStackTrace(string + "Error  :" + string2, unknownHostException);
            this.validationMsgs.add("NetApp Connectivity$#$NA" + string2);
            return null;
        }
        naServer.setStyle(this.AuthMech);
        if (this.AuthMech != 2) {
            naServer.setAdminUser(this.user, this.password);
            this.printOut("set server admin user");
        }
        if (this.isSSL) {
            naServer.setTransportType(2);
        } else {
            naServer.setTransportType(1);
        }
        if (this.minorVersion == 7) {
            naServer.setVfilerTunneling(this.vFilerName);
        }
        naServer.setPort(this.APIPort);
        naServer.setTimeout(this.timeout);
        if (naServer != null) {
            this.printOut("Connection created ");
        }
        return naServer;
    }

    protected void closeConnection(NaServer naServer) {
        if (naServer != null) {
            naServer.close();
            this.printOut("Connection closed");
        }
    }

    public static void main(String[] stringArray) {
        NetAppValidator netAppValidator = new NetAppValidator(stringArray, Boolean.FALSE);
    }

    public ArrayList getValidationMsgs() {
        System.out.println(this.validationMsgs);
        return this.validationMsgs;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        if (this.nausdValidatorLogSizeLimitInMB > 0.0) {
            NetAppValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.nausdValidatorLogSizeLimitInMB);
        }
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        if (this.nausdValidatorLogSizeLimitInMB > 0.0) {
            NetAppValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.nausdValidatorLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        if (this.nausdValidatorLogSizeLimitInMB > 0.0) {
            NetAppValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.nausdValidatorLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        if (this.nausdValidatorLogSizeLimitInMB > 0.0) {
            NetAppValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.nausdValidatorLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = NETAPP_VALIDATOR_DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            NetAppValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }
}

