/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

class NetCluDiskPerfTest
extends NAUSDCluBase {
    Hashtable prevPerfHT;
    ArrayList excludeList = new ArrayList();
    Hashtable currPerfHT = new Hashtable();
    private int maxRecords = 10;

    public NetCluDiskPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(13);
        String string = this.getValueForParam("exclude_disk");
        String string2 = this.getValueForParam("records_per_call");
        this.excludeList = new ArrayList();
        if (string != null && !string.equalsIgnoreCase("none")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string3 = stringTokenizer.nextToken().trim();
                this.excludeList.add(string3);
            }
        }
        if (string2 != null && !string2.equalsIgnoreCase("none")) {
            try {
                this.maxRecords = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.maxRecords = 10;
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = null;
        this.currPerfHT = new Hashtable();
        try {
            naServer = this.getConnection();
            if (naServer == null) {
                this.closeConnection(naServer);
                this.logToErrorFile("Error :", "NetCluDiskPerfTest ", "Connection is null");
                this.printOut("Error", "NetCluDiskPerfTest Connection is null");
                return;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluDiskPerfTest connection is null ", exception.toString());
            this.printOut("Error", "NetCluDiskPerfTest Connection is null:" + exception.toString());
            exception.printStackTrace();
        }
        try {
            int n;
            String[] stringArray = new String[]{"cp_read_latency", "cp_read_blocks", "cp_reads", "disk_busy", "base_for_disk_busy", "io_pending", "io_queued", "total_transfers", "user_read_blocks", "user_read_latency", "user_reads", "user_write_blocks", "user_write_latency", "user_writes", "dlsched_io_time"};
            NaElement naElement = new NaElement("perf-object-instance-list-info-iter");
            NaElement naElement2 = new NaElement("objectname", "disk");
            naElement.addChildElem(naElement2);
            NaElement naElement3 = this.execONTAPI(naServer, naElement);
            if (naElement3 == null) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluDiskPerfTest instance is null");
                return;
            }
            int n2 = naElement3.getChildIntValue("num-records", 0);
            if (n2 <= 0) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluDiskPerfTest noOfRecords is zero ");
                return;
            }
            List list = naElement3.getChildByName("attributes-list").getChildren();
            Iterator iterator = list.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                NaElement naElement4 = (NaElement)iterator.next();
                String string = naElement4.getChildContent("name");
                boolean bl = false;
                if (this.excludeList != null && this.excludeList.size() > 0) {
                    String string2;
                    for (n = 0; n < this.excludeList.size() && !(bl = NetCluDiskPerfTest.isMatch(string, string2 = (String)this.excludeList.get(n))); ++n) {
                    }
                }
                if (bl) continue;
                arrayList.add(string);
            }
            int n3 = arrayList.size();
            if (n3 <= 0) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluDiskPerfTest instance list is zero ");
                return;
            }
            ArrayList arrayList2 = new ArrayList();
            n = 0;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                arrayList2.add(arrayList.get(i));
                if (++n != this.maxRecords && ++n4 != n3) continue;
                this.getOutput(naServer, arrayList2, stringArray);
                n = 0;
                arrayList2 = new ArrayList();
            }
            if (this.currPerfHT == null) {
                this.closeConnection(naServer);
                return;
            }
            if (this.prevPerfHT == null) {
                this.prevPerfHT = (Hashtable)this.currPerfHT.clone();
                this.closeConnection(naServer);
                return;
            }
            Enumeration enumeration = this.currPerfHT.keys();
            String string = null;
            ArrayList arrayList3 = null;
            ArrayList arrayList4 = null;
            ArrayList arrayList5 = null;
            Object var23_27 = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                arrayList3 = (ArrayList)this.currPerfHT.get(string);
                arrayList4 = (ArrayList)this.prevPerfHT.get(string);
                arrayList5 = this.calcPerfMeas(string, arrayList3, arrayList4);
                if (string.length() > 128) {
                    int n5 = string.length();
                    int n6 = n5 - 124;
                    int n7 = string.lastIndexOf(93);
                    int n8 = n7 - n6;
                    String string3 = string.substring(n8, n7);
                    string = this.findAndReplaceString(string, string3, "...");
                }
                this.addNewMeasure(string, arrayList5);
            }
            this.prevPerfHT = (Hashtable)this.currPerfHT.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error :", "NetCluDiskPerfTest error occured in computeMeasure ", exception.toString());
            this.printOut("Error", "NetCluDiskPerfTest error occured in computeMeasure: " + exception.toString());
        }
        this.closeConnection(naServer);
    }

    private void getOutput(NaServer naServer, ArrayList arrayList, String[] stringArray) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        try {
            int n = arrayList.size();
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = (String)arrayList.get(i);
            }
            NaElement naElement = new NaElement("perf-object-get-instances");
            NaElement naElement2 = new NaElement("objectname", "disk");
            naElement.addChildElem(naElement2);
            NaElement naElement3 = new NaElement("instances");
            int n2 = stringArray2.length;
            int n3 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                naElement3.addNewChild("instance", stringArray2[i]);
            }
            naElement.addChildElem(naElement3);
            String string = "";
            Iterator iterator = null;
            Iterator iterator2 = null;
            NaElement naElement4 = this.execONTAPI(naServer, naElement);
            if (naElement4 == null) {
                this.printOut("DEBUG", "Output for NetCluDiskPerfTest is null ");
                return;
            }
            String string2 = naElement4.getChildContent("timestamp");
            List list = naElement4.getChildByName("instances").getChildren();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3;
                NaElement naElement5 = (NaElement)iterator.next();
                String string4 = naElement5.getChildContent("name");
                String string5 = naElement5.getChildContent("uuid");
                List list2 = naElement5.getChildByName("counters").getChildren();
                string4 = string4 + " [" + string5 + "]";
                iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    NaElement naElement6 = (NaElement)iterator2.next();
                    string3 = naElement6.getChildContent("name");
                    long l = naElement6.getChildLongValue("value", 0L);
                    hashtable.put(string3, new Double(l));
                }
                string3 = null;
                ArrayList arrayList2 = new ArrayList();
                arrayList2 = this.getPerfList(hashtable, stringArray, string2, string3);
                this.currPerfHT.put(string4, arrayList2);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluDiskPerfTest error occured in getoutput:", exception.toString());
            this.printOut("Error", "NetCluDiskPerfTest error occured in getoutput: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private ArrayList calcPerfMeas(String string, ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        double d = 1000000.0;
        Double d2 = (Double)arrayList.get(15);
        d2 = this.divide(d2, new Double(1000000.0));
        ArrayList arrayList4 = this.getDiffList(arrayList, arrayList2);
        Object var9_8 = null;
        Object var10_9 = null;
        Double d3 = this.divide(arrayList4.get(3), arrayList4.get(0));
        Double d4 = this.divide(arrayList4.get(1), arrayList4.get(2));
        double d5 = d4 / d;
        Double d6 = this.divide(arrayList4.get(4), arrayList4.get(5));
        double d7 = d6 * 100.0;
        Double d8 = this.divide(arrayList4.get(6), arrayList4.get(5));
        Double d9 = this.divide(arrayList4.get(7), arrayList4.get(5));
        Double d10 = this.divide(arrayList4.get(8), arrayList4.get(0));
        Double d11 = this.divide(arrayList4.get(9), arrayList4.get(0));
        Double d12 = this.divide(arrayList4.get(10), arrayList4.get(9));
        double d13 = d12 / d;
        Double d14 = this.divide(arrayList4.get(11), arrayList4.get(0));
        Double d15 = this.divide(arrayList4.get(12), arrayList4.get(0));
        Double d16 = this.divide(arrayList4.get(13), arrayList4.get(12));
        double d17 = d16 / d;
        Double d18 = this.divide(arrayList4.get(14), arrayList4.get(0));
        arrayList3.add(d3);
        arrayList3.add(new Double(d5));
        arrayList3.add(new Double(d7));
        arrayList3.add(d8);
        arrayList3.add(d9);
        arrayList3.add(d10);
        arrayList3.add(d11);
        arrayList3.add(new Double(d13));
        arrayList3.add(d14);
        arrayList3.add(d15);
        arrayList3.add(new Double(d17));
        arrayList3.add(d18);
        arrayList3.add(d2);
        return arrayList3;
    }

    private ArrayList getPerfList(Hashtable hashtable, String[] stringArray, String string, String string2) {
        Hashtable hashtable2 = new Hashtable();
        int n = stringArray.length;
        Double d = null;
        String string3 = "";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(string));
        for (int i = 0; i < n; ++i) {
            string3 = stringArray[i];
            if (string2 != null && string2.equalsIgnoreCase(string3)) continue;
            d = (Double)hashtable.get(string3);
            if (d == null) {
                d = NADbl;
            }
            arrayList.add(d);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        NetCluDiskPerfTest netCluDiskPerfTest = new NetCluDiskPerfTest(stringArray);
        netCluDiskPerfTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        netCluDiskPerfTest.computeMeasures(new Hashtable());
    }
}

