/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

class NetCluLifPerfTest
extends NAUSDCluBase {
    Hashtable prevPerfHT;

    public NetCluLifPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = null;
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Hashtable<Object, ArrayList> hashtable3 = new Hashtable<Object, ArrayList>();
        try {
            naServer = this.getConnection();
            if (naServer == null) {
                this.closeConnection(naServer);
                this.logToErrorFile("Error :", "NetCluLifPerfTest ", "Connection is null");
                this.printOut("Error", "NetCluLifPerfTest Connection is null ");
                return;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluLifPerfTest connection is null ", exception.toString());
            this.printOut("Error", "NetCluLifPerfTest Connection is null " + exception.toString());
            exception.printStackTrace();
        }
        try {
            List list;
            Object object;
            Object object2;
            Object object3;
            int n;
            String[] stringArray = new String[]{"recv_data", "recv_errors", "recv_packet", "sent_data", "sent_errors", "sent_packet", "up_time"};
            NaElement naElement = new NaElement("perf-object-instance-list-info-iter");
            NaElement naElement2 = new NaElement("objectname", "lif");
            naElement.addChildElem(naElement2);
            NaElement naElement3 = this.execONTAPI(naServer, naElement);
            if (naElement3 == null) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluLifPerfTest instance is null ");
                return;
            }
            int n2 = naElement3.getChildIntValue("num-records", 0);
            if (n2 <= 0) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluLifPerfTest noOfRecords is zero ");
                return;
            }
            List list2 = naElement3.getChildByName("attributes-list").getChildren();
            Iterator iterator = list2.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                NaElement naElement4 = (NaElement)iterator.next();
                String string = naElement4.getChildContent("name");
                arrayList.add(string);
            }
            int n3 = arrayList.size();
            String[] stringArray2 = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray2[i] = (String)arrayList.get(i);
            }
            NaElement naElement5 = new NaElement("perf-object-get-instances");
            NaElement naElement6 = new NaElement("objectname", "lif");
            naElement5.addChildElem(naElement6);
            NaElement naElement7 = new NaElement("instances");
            NaElement naElement8 = new NaElement("counters");
            int n4 = stringArray2.length;
            int n5 = stringArray.length;
            for (n = 0; n < n4; ++n) {
                naElement7.addNewChild("instance", stringArray2[n]);
            }
            for (n = 0; n < n5; ++n) {
                naElement8.addNewChild("counter", stringArray[n]);
            }
            naElement5.addChildElem(naElement7);
            naElement5.addChildElem(naElement8);
            String string = "";
            Iterator iterator2 = null;
            Iterator iterator3 = null;
            NaElement naElement9 = this.execONTAPI(naServer, naElement5);
            if (naElement9 == null) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "Output for NetCluLifPerfTest is null ");
                return;
            }
            Object object4 = naElement9.getChildContent("timestamp");
            Object object5 = naElement9.getChildByName("instances").getChildren();
            iterator2 = object5.iterator();
            while (iterator2.hasNext()) {
                String string2;
                object3 = (NaElement)iterator2.next();
                object2 = object3.getChildContent("name");
                object = object3.getChildContent("uuid");
                list = object3.getChildByName("counters").getChildren();
                iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    NaElement naElement10 = (NaElement)iterator3.next();
                    string2 = naElement10.getChildContent("name");
                    long l = naElement10.getChildLongValue("value", 0L);
                    hashtable2.put(string2, new Double(l));
                }
                string2 = null;
                ArrayList arrayList2 = new ArrayList();
                arrayList2 = this.getPerfList(hashtable2, stringArray, (String)object4, string2);
                hashtable3.put(object2, arrayList2);
            }
            if (hashtable3 == null) {
                this.closeConnection(naServer);
                return;
            }
            if (this.prevPerfHT == null) {
                this.prevPerfHT = (Hashtable)hashtable3.clone();
                this.closeConnection(naServer);
                return;
            }
            object4 = hashtable3.keys();
            object5 = null;
            object3 = null;
            object2 = null;
            object = null;
            list = null;
            while (object4.hasMoreElements()) {
                object5 = (String)object4.nextElement();
                object3 = (ArrayList)hashtable3.get(object5);
                object2 = (ArrayList)this.prevPerfHT.get(object5);
                object = this.calcPerfMeas((String)object5, (ArrayList)object3, (ArrayList)object2);
                this.addNewMeasure((String)object5, (ArrayList)object);
            }
            this.prevPerfHT = (Hashtable)hashtable3.clone();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluLifPerfTest error in computeMeasure ", exception.toString());
            this.printOut("Error", "NetCluLifPerfTest error in computeMeasure " + exception.toString());
            exception.printStackTrace();
        }
        this.closeConnection(naServer);
    }

    private ArrayList calcPerfMeas(String string, ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        Double d = (Double)arrayList.get(7);
        d = this.divide(d, new Double(60000.0));
        double d2 = 1048576.0;
        ArrayList arrayList4 = this.getDiffList(arrayList, arrayList2);
        Object var9_8 = null;
        Object var10_9 = null;
        Double d3 = this.divide(arrayList4.get(1), arrayList4.get(0));
        double d4 = d3 / d2;
        Double d5 = this.divide(arrayList4.get(2), arrayList4.get(0));
        Double d6 = this.divide(arrayList4.get(3), arrayList4.get(0));
        Double d7 = this.divide(arrayList4.get(4), arrayList4.get(0));
        double d8 = d7 / d2;
        Double d9 = this.divide(arrayList4.get(5), arrayList4.get(0));
        Double d10 = this.divide(arrayList4.get(6), arrayList4.get(0));
        Double d11 = this.divide(arrayList4.get(7), new Double(1000.0));
        arrayList3.add(new Double(d4));
        arrayList3.add(d5);
        arrayList3.add(d6);
        arrayList3.add(new Double(d8));
        arrayList3.add(d9);
        arrayList3.add(d10);
        arrayList3.add(d);
        arrayList3.add(d11);
        return arrayList3;
    }

    private ArrayList getPerfList(Hashtable hashtable, String[] stringArray, String string, String string2) {
        Hashtable hashtable2 = new Hashtable();
        int n = stringArray.length;
        Double d = null;
        String string3 = "";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(string));
        for (int i = 0; i < n; ++i) {
            string3 = stringArray[i];
            if (string2 != null && string2.equalsIgnoreCase(string3)) continue;
            d = (Double)hashtable.get(string3);
            if (d == null) {
                d = NADbl;
            }
            arrayList.add(d);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        NetCluLifPerfTest netCluLifPerfTest = new NetCluLifPerfTest(stringArray);
        netCluLifPerfTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        netCluLifPerfTest.computeMeasures(new Hashtable());
    }
}

